/**
 * Adds one biography input field per language in the user profile.
 *
 * @package Polylang
 */

jQuery(
	function ( $ ) {
		// biography
		// FIXME there is probably a more efficient way to do this
		var td = $( '#description' ).parent();
		var d = $( '#description' ).clone();
		var span = td.children( '.description' ).clone();
		td.children().remove();

		$( '.biography' ).each(
			function () {
				lang = $( this ).attr( 'name' ).split( '___' );
				desc = d.clone();
				desc.attr( 'name', 'description_' + lang[0] );
				desc.attr( 'id', 'description_' + lang[0] );
				// Whitelist because description and lang value is already escaped by the side of PHP
				desc.html( $( this ).val() ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.html
				td.append( $( '<div></div>' ).text( lang[1] ) ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.append
				td.append( desc ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.append
			}
		);

		td.append( '<br />' );
		// Whitelist because description come from html code generated by WordPress
		td.append( span ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.append
	}
);
