<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminReports extends pjAdmin
{
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$location_arr = pjLocationModel::factory()
				->select('t1.*, t2.content as name')
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->where('restaurant_id', $this->getForeignId())
				->orderBy("name ASC")
				->findAll()
				->getData();
			
			$date_from = date('Y-m-d', time() - 30 * 86400 );
			$date_to = date('Y-m-d');
			
			$this->set('location_arr', $location_arr);
			$this->set('date_from', $date_from);
			$this->set('date_to', $date_to);
			
			$this->appendJs('pjAdminReports.js');
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionGenerate()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['generate_report']))
			{
				$date_from = pjUtil::formatDate($_POST['date_from'], $this->option_arr['o_date_format']);
				$date_to = pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']);
				$location_id = $_POST['location_id'];
				
				$pjOrderModel = pjOrderModel::factory()->where('restaurant_id', $this->getForeignId());
				
				$pjOrderModel->where("((DATE(p_dt) BETWEEN '$date_from' AND '$date_to') OR (DATE(d_dt) BETWEEN '$date_from' AND '$date_to') OR (DATE(ca_dt) BETWEEN '$date_from' AND '$date_to'))");
				$location_clause = "";
				if((int) $location_id != '' > 0)
				{
					$pjOrderModel->where('t1.location_id', $location_id);
					$location_clause = " AND `TO`.location_id=$location_id";
				}
				
				$total_orders = $pjOrderModel->findCount()->getData();
				
				$pjOrderModel->where('t1.status', 'confirmed');
				$confirmed_orders = $pjOrderModel->findCount()->getData();
				$confirmed_arr = $pjOrderModel->findAll()->getData();
				$order_id_arr = $pjOrderModel->findAll()->getDataPair(null, 'id');
				
				$unique_clients = 0;
				$first_time_clients = 0;
				
				$client_id_arr = array();
				
				$total_amount = 0;
				$delivery_fee = 0;
				$catering_fee = 0;
				$tax = 0;
				$tip_amount = 0;
				$discount = 0;
				foreach($confirmed_arr as $k => $v)
				{
					$total_amount += $v['total'];
					$delivery_fee += $v['price_delivery'];
					$catering_fee += $v['catering_fee'];
					$tax += $v['tax'];
					$discount += $v['discount'];
					$tip_amount += $v['tip_amount'];
					
					$client_id_arr[] = $v['client_id'];
				}
				
				$pickup_orders = $catering_orders = $delivery_orders = 0;
				$order_arr = $pjOrderModel->findAll()->getData();
				foreach ($order_arr as $val) {
				    if ($val['type'] == 'pickup') {
				        $pickup_orders += 1;
				    } elseif ($val['type'] == 'delivery') {
				        $delivery_orders += 1;
				    } elseif ($val['type'] == 'catering') {
				        $catering_orders += 1;
				    }
				}
				
				$unique_id_arr = array_unique($client_id_arr);
				$unique_clients = count($unique_id_arr);
				$duplicated_clients = array_diff_assoc($client_id_arr, $unique_id_arr);
				$first_time_clients = count(array_diff($client_id_arr, $duplicated_clients));
				$more = 0;
				if(!empty($duplicated_clients))
				{
					$pjOrderModel->reset();
					$pjOrderModel->where("( (DATE(p_dt) < '$date_from') OR (DATE(d_dt) < '$date_from') )");
					if((int) $location_id != '' > 0)
					{
						$pjOrderModel->where('t1.location_id', $location_id);
					}
					$previous_id_arr = $pjOrderModel->whereIn('t1.client_id', array_unique($duplicated_clients))->findAll()->getDataPair(null, 'client_id');
					$more = count(array_unique($duplicated_clients)) - count(array_unique($previous_id_arr));
				}
				$first_time_clients = $first_time_clients + $more;

				$total_products = 0;
				if(!empty($order_id_arr))
				{
					$product_arr = pjOrderItemModel::factory()->where('t1.type', 'product')->whereIn('t1.order_id', $order_id_arr)->findAll()->getData();
					foreach($product_arr as $k => $v)
					{
						$total_products += (int)$v['cnt'];
					}
				}
				
				$order_item_tbl = pjOrderItemModel::factory()->getTable();
				$product_category_tbl = pjProductCategoryModel::factory()->getTable();
				
				$category_arr = pjCategoryModel::factory()
					->select("t1.*, t2.content AS name,
							(SELECT SUM(`TOI`.price * `TOI`.cnt) FROM `".$order_item_tbl."` AS `TOI` WHERE `TOI`.`type`='product' AND `TOI`.order_id IN ( SELECT `TO`.id FROM `".$pjOrderModel->getTable()."` AS `TO` WHERE `TO`.status='confirmed' AND ((DATE(p_dt) BETWEEN '$date_from' AND '$date_to') OR (DATE(d_dt) BETWEEN '$date_from' AND '$date_to'))$location_clause ) AND `TOI`.foreign_id IN (SELECT `TPC`.product_id FROM `".$product_category_tbl."` AS `TPC` WHERE TPC.category_id=t1.id ) ) AS total_amount,
							(SELECT SUM(`TOI`.cnt) FROM `".$order_item_tbl."` AS `TOI` WHERE `TOI`.`type`='product' AND `TOI`.order_id IN ( SELECT `TO`.id FROM `".$pjOrderModel->getTable()."` AS `TO` WHERE `TO`.status='confirmed' AND ((DATE(p_dt) BETWEEN '$date_from' AND '$date_to') OR (DATE(d_dt) BETWEEN '$date_from' AND '$date_to'))$location_clause ) AND `TOI`.foreign_id IN (SELECT `TPC`.product_id FROM `".$product_category_tbl."` AS `TPC` WHERE TPC.category_id=t1.id ) ) AS total_products")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjCategory' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('restaurant_id', $this->getForeignId())
					->where('t1.status', 'T')
					->orderBy("`order` ASC")
					->findAll()
					->getData();
				
				$product_arr = pjProductModel::factory()
					->select("t1.*, t2.content AS name,
							(SELECT SUM(`TOI`.cnt) FROM `".$order_item_tbl."` AS `TOI` WHERE `TOI`.`type`='product' AND `TOI`.order_id IN ( SELECT `TO`.id FROM `".$pjOrderModel->getTable()."` AS `TO` WHERE `TO`.status='confirmed' AND ((DATE(p_dt) BETWEEN '$date_from' AND '$date_to') OR (DATE(d_dt) BETWEEN '$date_from' AND '$date_to'))$location_clause ) AND `TOI`.foreign_id=t1.id ) AS total_products,
							(SELECT SUM(`TOI`.price * `TOI`.cnt) FROM `".$order_item_tbl."` AS `TOI` WHERE `TOI`.`type`='product' AND `TOI`.order_id IN ( SELECT `TO`.id FROM `".$pjOrderModel->getTable()."` AS `TO` WHERE `TO`.status='confirmed' AND ((DATE(p_dt) BETWEEN '$date_from' AND '$date_to') OR (DATE(d_dt) BETWEEN '$date_from' AND '$date_to'))$location_clause ) AND `TOI`.foreign_id=t1.id ) AS total_amount")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('restaurant_id', $this->getForeignId())
					->orderBy("total_products DESC")
					->limit(10)
					->findAll()
					->getData();
				
				$this->set('total_orders', $total_orders);
				$this->set('confirmed_orders', $confirmed_orders);
				$this->set('pickup_orders', $pickup_orders);
				$this->set('catering_orders', $catering_orders);
				$this->set('delivery_orders', $delivery_orders);
				
				$this->set('unique_clients', $unique_clients);
				$this->set('first_time_clients', $first_time_clients);
				
				$this->set('total_products', $total_products);
				$this->set('category_arr', $category_arr);
				$this->set('product_arr', $product_arr);
								
				$this->set('price_info', compact('total_amount', 'delivery_fee', 'catering_fee', 'tax', 'discount', 'tip_amount'));
			}
		}
	}
}
?>