<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminRestaurants extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['restaurant_create']))
			{
				$pjRestaurantModel = pjRestaurantModel::factory();
				$data = array();
				$id = $pjRestaurantModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					pjOptionModel::factory()->initOptions($id);
					$err = 'ART03';
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjRestaurant', 'data');
					}
				} else {
					$err = 'ART04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminRestaurants&action=pjActionIndex&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
		
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminRestaurants.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteRestaurant()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if ($_GET['id'] != $this->getForeignId() && $_GET['id'] != 1) {
				if (pjRestaurantModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					pjMultiLangModel::factory()->where('model', 'pjRestaurant')->where('foreign_id', $_GET['id'])->eraseAll();
					pjOptionModel::factory()->where('foreign_id', $_GET['id'])->eraseAll();
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteRestaurantBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjMultiLangModel::factory()
					->where('foreign_id !=', $this->getForeignId())
					->where('foreign_id !=', 1)
					->where('model', 'pjRestaurant')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				
				pjRestaurantModel::factory()
					->where('id !=', $this->getForeignId())
					->where('id !=', 1)
					->whereIn('id', $_POST['record'])->eraseAll();

				pjOptionModel::factory()
					->where('id !=', $this->getForeignId())
					->where('id !=', 1)
					->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetRestaurant()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjRestaurantModel = pjRestaurantModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjRestaurant' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjRestaurantModel->where('(t1.address LIKE "%'.$q.'%" OR t1.phone LIKE "%'.$q.'%" OR t2.content LIKE "%'.$q.'%")');
			}
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjRestaurantModel->where('t1.status', $_GET['status']);
			}

			$column = 'name';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjRestaurantModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjRestaurantModel
				->select('t1.*, t2.content AS name')
				->orderBy("`$column` $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminRestaurants.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveRestaurant()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjRestaurantModel = pjRestaurantModel::factory();
			if (!in_array($_POST['column'], $pjRestaurantModel->getI18n()))
			{
				$pjRestaurantModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjRestaurant', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['restaurant_update']))
			{
				
				pjRestaurantModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjRestaurant', 'data');
				}
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminRestaurants&action=pjActionIndex&err=ART01");
				
			} else {
				$arr = pjRestaurantModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminRestaurants&action=pjActionIndex&err=ART08");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjRestaurant');
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminRestaurants.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	public function pjActionUpdateNewOptions()
	{
		$this->checkLogin();

		if ($this->isAdmin()) {
			$pjOptionModel = pjOptionModel::factory();
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
			foreach ($arr as $item) {
				$sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_allow_catering', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 3, 1, NULL),
					(".$item['id'].", 'o_catering_fee', 2, '10.00', NULL, 'float', 4, 1, NULL),
					(".$item['id'].", 'o_catering_hours_in_advance', 2, '24', NULL, 'int', 5, 1, NULL),
					(".$item['id'].", 'o_delivery_catering_max_distance', 2, '10.00', NULL, 'float', 6, 1, NULL),
					(".$item['id'].", 'o_cf_include_address_1', 8, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
					(".$item['id'].", 'o_cf_include_address_2', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
					(".$item['id'].", 'o_cf_include_city', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
					(".$item['id'].", 'o_cf_include_country', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
					(".$item['id'].", 'o_cf_include_notes', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
					(".$item['id'].", 'o_cf_include_state', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
					(".$item['id'].", 'o_cf_include_zip', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL)	
				;";
				$pjOptionModel->reset()->execute($sql);
			}
			echo 'Options have been updated!!!';
		} else {
			echo 'Access denied!!!';
		}
		exit;
	}		
	
	public function pjActionUpdate11344()	{		
		$this->checkLogin();		
		if ($this->isAdmin()) {			
			$pjOptionModel = pjOptionModel::factory();			
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();			
			foreach ($arr as $item) {				
				$sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES					
				(".$item['id'].", 'o_second_notification_email', 1, '', NULL, 'string', 14, 1, NULL);";				
				$pjOptionModel->reset()->execute($sql);			
			}			
			echo 'Options have been updated!!!';		
		} else {			
			echo 'Access denied!!!';		
		}		
		exit;	
	}
	
	public function pjActionUpdate11700()
	{
		$this->checkLogin();

		if ($this->isAdmin()) {
			$pjOptionModel = pjOptionModel::factory();
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
			foreach ($arr as $item) {
				$sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_minimum_order_catering', 2, '0.00', NULL, 'int', 11, 1, NULL)
				;";
				$pjOptionModel->reset()->execute($sql);
			}
			echo 'Options have been updated!!!';
		} else {
			echo 'Access denied!!!';
		}
		exit;
	}
	
	public function pjActionUpdate11842()
	{
		$this->checkLogin();

		if ($this->isAdmin()) {
			$pjOptionModel = pjOptionModel::factory();
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
			foreach ($arr as $item) {
				$sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_allow_automatic_print', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 30, 1, NULL),
					(".$item['id'].", 'o_printer_ip', 2, '', NULL, 'string', 31, 1, NULL),
					(".$item['id'].", 'o_printer_port', 2, '9100', NULL, 'int', 32, 1, NULL)	
				;";
				$pjOptionModel->reset()->execute($sql);
			}
			echo 'Options have been updated!!!';
		} else {
			echo 'Access denied!!!';
		}
		exit;
	}	

	public function pjActionUpdate13178()
	{
		$this->checkLogin();

		if ($this->isAdmin()) {
			$pjOptionModel = pjOptionModel::factory();
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
			foreach ($arr as $item) {
				$sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_minimum_order_delivery', 2, '0.00', NULL, 'int', 11, 1, NULL),
					(".$item['id'].", 'o_tip_1', 2, '15', NULL, 'int', 33, 1, NULL),
					(".$item['id'].", 'o_tip_2', 2, '18', NULL, 'int', 34, 1, NULL),
					(".$item['id'].", 'o_tip_3', 2, '20', NULL, 'int', 35, 1, NULL),
					(".$item['id'].", 'o_tip_4', 2, '25', NULL, 'int', 36, 1, NULL),
					(".$item['id'].", 'o_tip_5', 2, '28', NULL, 'int', 37, 1, NULL),
					(".$item['id'].", 'o_tip_6', 2, '30', NULL, 'int', 38, 1, NULL)
				;";
				$pjOptionModel->reset()->execute($sql);
			}
			echo 'Options have been updated!!!';
		} else {
			echo 'Access denied!!!';
		}
		exit;
	}
	
	public function pjActionUpdate13692()
	{
		$this->checkLogin();

		if ($this->isAdmin()) {
			$pjOptionModel = pjOptionModel::factory();
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
			foreach ($arr as $item) {
				$sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_printer_copies', 2, '1', NULL, 'int', 30, 1, NULL)
				;";
				$pjOptionModel->reset()->execute($sql);
			}
			echo 'Options have been updated!!!';
		} else {
			echo 'Access denied!!!';
		}
		exit;
	}
	
	public function pjActionUpdate14411()
	{
		$this->checkLogin();

		if ($this->isAdmin()) {
			$pjOptionModel = pjOptionModel::factory();
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
			foreach ($arr as $item) {
				$sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_allow_usaepay', 2, 'Yes|No::No', NULL, 'enum', 30, 1, NULL),
					(".$item['id'].", 'o_usaepay_apikey', 2, NULL, NULL, 'string', 31, 1, NULL),
					(".$item['id'].", 'o_usaepay_apipin', 2, NULL, NULL, 'string', 32, 1, NULL),
					(".$item['id'].", 'o_usaepay_seed', 2, NULL, NULL, 'string', 33, 0, NULL)
				;";
				$pjOptionModel->reset()->execute($sql);
			}
			echo 'Options have been updated!!!';
		} else {
			echo 'Access denied!!!';
		}
		exit;
	}
	
	public function pjActionUpdate14446()
	{
		$this->checkLogin();

		if ($this->isAdmin()) {
			$pjOptionModel = pjOptionModel::factory();
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
			foreach ($arr as $item) {
				$sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_sms_payment_message', 3, '', NULL, 'text', 1, 1, NULL),
					(".$item['id'].", 'o_sms_ready_pickup_message', 3, '', NULL, 'text', 3, 1, NULL),
					(".$item['id'].", 'o_notification_phone_number', 1, '', NULL, 'string', 15, 1, NULL),
					(".$item['id'].", 'o_allow_delivery_doordash', 2, 'Yes|No::No', 'Yes|No', 'enum', 2, 1, NULL),					
					(".$item['id'].", 'o_doordash_developer_id', 2, '', NULL, 'string', 2, 1, NULL),
					(".$item['id'].", 'o_doordash_key_id', 2, '', NULL, 'string', 2, 1, NULL),
					(".$item['id'].", 'o_doordash_signing_secret', 2, '', NULL, 'string', 2, 1, NULL)
				;";
				$pjOptionModel->reset()->execute($sql);
			}
			echo 'Options have been updated!!!';
		} else {
			echo 'Access denied!!!';
		}
		exit;
	}
	
	public function pjActionUpdate14476()
	{
		$this->checkLogin();

		if ($this->isAdmin()) {
			$pjOptionModel = pjOptionModel::factory();
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
			foreach ($arr as $item) {
				$sql = "INSERT IGNORE INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_sms_dasher_confirmed_message', 9, '', NULL, 'text', 1, 1, NULL),
					(".$item['id'].", 'o_sms_dasher_confirmed_pickup_arrival_message', 9, '', NULL, 'text', 2, 1, NULL),
					(".$item['id'].", 'o_sms_dasher_picked_up_message', 9, '', NULL, 'text', 3, 1, NULL),
					(".$item['id'].", 'o_sms_dasher_confirmed_dropoff_arrival_message', 9, '', NULL, 'text', 4, 1, NULL),
					(".$item['id'].", 'o_sms_dasher_dropped_off_message', 9, '', NULL, 'text', 5, 1, NULL),
					(".$item['id'].", 'o_sms_delivery_cancelled_message', 9, '', NULL, 'text', 6, 1, NULL),
					(".$item['id'].", 'o_sms_delivery_abandoned_message', 9, '', NULL, 'text', 7, 1, NULL)
				;";
				$pjOptionModel->reset()->execute($sql);
			}
			echo 'Options have been updated!!!';
		} else {
			echo 'Access denied!!!';
		}
		exit;
	}
	
	public function pjActionUpdate14662()
	{
	    $this->checkLogin();
	    
	    if ($this->isAdmin()) {
	        $pjOptionModel = pjOptionModel::factory();
	        $arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
	        foreach ($arr as $item) {
	            $sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_doordash_dasher_tip_earn', 2, '0', NULL, 'int', 2, 1, NULL),
                    (".$item['id'].", 'o_doordash_num_of_recall_dasher', 2, '1', NULL, 'int', 2, 1, NULL)
				;";
	            $pjOptionModel->reset()->execute($sql);
	        }
	        echo 'Options have been updated!!!';
	    } else {
	        echo 'Access denied!!!';
	    }
	    exit;
	}

    /*Khuetech nmi payment */
    /*run -> https://caffexo.dev/index.php?controller=pjAdminOptions&action=pjActionUpdate14478*/
    public function pjActionUpdate14478()
    {
        $this->checkLogin();

        if ($this->isAdmin()) {
            $pjOptionModel = pjOptionModel::factory();
            $arr = pjRestaurantModel::factory()->where('t1.id > 0')->findAll()->getData();
            foreach ($arr as $item) {
                $sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_allow_nmipay', 2, 'Yes|No::No', NULL, 'enum', 44, 1, NULL),
					(".$item['id'].", 'o_nmipay_apikey', 2, NULL, NULL, 'string', 45, 1, NULL)
				;";
                $pjOptionModel->reset()->execute($sql);
            }

            $pjFieldModel=pjFieldModel::factory();
            $pjMultiLangModel=pjMultiLangModel::factory();
            $sql= "INSERT INTO `".$pjFieldModel->getTable()."` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES (NULL, 'opt_o_allow_nmipay', 'backend', 'Label / Allow payments with NMI', 'script', '2014-07-18 14:21:44')";
            $pjFieldModel->reset()->execute($sql);
            $id=$pjFieldModel->getInsertId();

            $sql= "INSERT INTO `".$pjMultiLangModel->getTable()."` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES (NULL, ".$id.", 'pjField', '1', 'title', 'Allow payments with NMI', 'script')";
            $pjFieldModel->reset()->execute($sql);


            /*-----------*/
            $sql= "INSERT INTO `".$pjFieldModel->getTable()."` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES (NULL, 'opt_o_nmipay_apikey', 'backend', 'Label / Api Key', 'script', '2014-07-18 14:21:44')";
            $pjFieldModel->reset()->execute($sql);
            $id=$pjFieldModel->getInsertId();

            $sql= "INSERT INTO `".$pjMultiLangModel->getTable()."` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES (NULL, ".$id.", 'pjField', '1', 'title', 'Api Key', 'script')";
            $pjFieldModel->reset()->execute($sql);


            /*-----------*/
            $sql= "INSERT INTO `".$pjFieldModel->getTable()."` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES (NULL, 'payment_methods_ARRAY_nmipay', 'arrays', 'Label / Api Key', 'script', '2014-07-18 14:21:44')";
            $pjFieldModel->reset()->execute($sql);
            $id=$pjFieldModel->getInsertId();

            $sql= "INSERT INTO `".$pjMultiLangModel->getTable()."` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES (NULL, ".$id.", 'pjField', '1', 'title', 'NMI Payment', 'script')";
            $pjFieldModel->reset()->execute($sql);

            $pjOrderModel=pjOrderModel::factory();
            $sql="ALTER TABLE `".$pjOrderModel->getTable()."` CHANGE `payment_method` `payment_method` ENUM('nmipay','paypal','authorize','usaepay','creditcard','cash','bank') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;";
            $pjOrderModel->reset()->execute($sql);

            $pjOrderPaymentModel=pjOrderPaymentModel::factory();
            $sql="ALTER TABLE `".$pjOrderPaymentModel->getTable()."` CHANGE `payment_method` `payment_method` ENUM('nmipay','paypal','authorize','usaepay','creditcard','bank','cash') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;";
            $pjOrderPaymentModel->reset()->execute($sql);



            /*------ front end -----*/
            $sql= "INSERT INTO `".$pjFieldModel->getTable()."` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES (NULL, 'front_nmipay_pay_successful', 'frontend', 'Info / Pay successfull', 'script', '2014-07-18 14:21:44')";
            $pjFieldModel->reset()->execute($sql);
            $id=$pjFieldModel->getInsertId();

            $sql= "INSERT INTO `".$pjMultiLangModel->getTable()."` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES (NULL, ".$id.", 'pjField', '1', 'title', 'Your order has been saved and successfully paid.', 'script')";
            $pjFieldModel->reset()->execute($sql);


            $sql= "INSERT INTO `".$pjFieldModel->getTable()."` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES (NULL, 'front_nmipay_pay_failed', 'frontend', 'Info / Pay failed', 'script', '2014-07-18 14:21:44')";
            $pjFieldModel->reset()->execute($sql);
            $id=$pjFieldModel->getInsertId();

            $sql= "INSERT INTO `".$pjMultiLangModel->getTable()."` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES (NULL, ".$id.", 'pjField', '1', 'title', 'Your order has been saved, but your payment failed. Please click [STAG]HERE[ETAG] to reorder.', 'script')";
            $pjFieldModel->reset()->execute($sql);

            echo 'Options have been updated!!!';
        } else {
            echo 'Access denied!!!';
        }
        exit;
    }
}
?>