<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminUsers extends pjAdmin
{
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['email']) || empty($_GET['email']))
			{
				echo 'false';
				exit;
			}
			$pjUserModel = pjUserModel::factory()->where('t1.email', $_GET['email']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjUserModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjUserModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCloneUser()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$MultiLangModel = new pjMultiLangModel();

				$data = pjUserModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
				foreach ($data as $item)
				{
					$item_id = $item['id'];
					unset($item['id']);
					unset($item['email']);

					$id = pjUserModel::factory($item)->insert()->getInsertId();
					if ($id !== false && (int) $id > 0)
					{
						$_data = pjMultiLangModel::factory()->getMultiLang($item_id, 'pjUser');
						$MultiLangModel->saveMultiLang($_data, $id, 'pjUser');
					}
				}
			}
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['user_create']))
			{
				$data = array();
				$data['is_active'] = 'T';
				$data['ip'] = $_SERVER['REMOTE_ADDR'];
				$id = pjUserModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
                                    $pjUserRestaurantModel = pjUserRestaurantModel::factory();
                                    if (isset($_POST['restaurant_id']) && is_array($_POST['restaurant_id']) && count($_POST['restaurant_id']) > 0)
                                    {
                                            $pjUserRestaurantModel->reset()->begin();
                                            foreach ($_POST['restaurant_id'] as $restaurant_id)
                                            {
                                                    $pjUserRestaurantModel
                                                            ->reset()
                                                            ->set('user_id', $id)
                                                            ->set('restaurant_id', $restaurant_id)
                                                            ->insert();
                                            }
                                            $pjUserRestaurantModel->commit();
                                    }
                                    
					$err = 'AU03';
				} else {
					$err = 'AU04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminUsers&action=pjActionIndex&err=$err");
			} else {
				
				$this->set('role_arr', pjRoleModel::factory()->orderBy('t1.id ASC')->findAll()->getData());
		
				$this->set('restaurant_arr', pjRestaurantModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjRestaurant' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`name` ASC')
					->findAll()
					->getData());
                                
                                $this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminUsers.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteUser()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if ($_GET['id'] != $this->getUserId() && $_GET['id'] != 1)
			{
				if (pjUserModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
				{
					$response['code'] = 200;
				} else {
					$response['code'] = 100;
				}
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteUserBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjUserModel::factory()
					->where('id !=', $this->getUserId())
					->where('id !=', 1)
					->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionExportUser()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjUserModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Users-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetUser()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjUserModel = pjUserModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjUserModel->where('t1.email LIKE', "%$q%");
				$pjUserModel->orWhere('t1.name LIKE', "%$q%");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjUserModel->where('t1.status', $_GET['status']);
			}
				
			$column = 'name';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjUserModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			
			$data = $pjUserModel->select('t1.id, t1.email, t1.name, t1.created, t1.status, t1.is_active, t1.role_id, t2.role')
				->join('pjRole', 't2.id=t1.role_id', 'left')
				->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();
			foreach($data as $k => $v)
			{
				$v['created'] = date($this->option_arr['o_date_format'], strtotime($v['created'])) . ', ' . date($this->option_arr['o_time_format'], strtotime($v['created']));
				$data[$k] = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminUsers.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSetActive()
	{
		$this->setAjax(true);

		if ($this->isXHR())
		{
			$pjUserModel = pjUserModel::factory();
			
			$arr = $pjUserModel->find($_POST['id'])->getData();
			
			if (count($arr) > 0)
			{
				switch ($arr['is_active'])
				{
					case 'T':
						$sql_status = 'F';
						break;
					case 'F':
						$sql_status = 'T';
						break;
					default:
						return;
				}
				$pjUserModel->reset()->setAttributes(array('id' => $_POST['id']))->modify(array('is_active' => $sql_status));
			}
		}
		exit;
	}
	
	public function pjActionSaveUser()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjUserModel = pjUserModel::factory();
			
			$pass = true;
			if ((int) $_GET['id'] === 1)
			{
				if(in_array($_POST['column'], array('role_id', 'status', 'is_active')))
				{
					$pass = false;
				}else if(in_array($_POST['column'], array('name', 'email')) && $_POST['value'] == ''){
					$pass = false;
				}else if($_POST['column'] == 'email' && $_POST['value'] != '' && !filter_var($_POST['value'], FILTER_VALIDATE_EMAIL)){
					$pass = false;
				}
			}
			if ($pass)
			{
				$pjUserModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			}
		}
		exit;
	}
	
	public function pjActionStatusUser()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjUserModel::factory()->whereIn('id', $_POST['record'])->where('id <>', 1)->modifyAll(array(
					'status' => ":IF(`status`='F','T','F')"
				));
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
				
			if (isset($_POST['user_update']))
			{
				pjUserModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);

				$pjUserRestaurantModel = pjUserRestaurantModel::factory();
				$pjUserRestaurantModel->where('user_id', $_POST['id'])->eraseAll();
				if (isset($_POST['restaurant_id']) && is_array($_POST['restaurant_id']) && count($_POST['restaurant_id']) > 0)
				{
					$pjUserRestaurantModel->reset()->begin();
					foreach ($_POST['restaurant_id'] as $restaurant_id)
					{
						$pjUserRestaurantModel
							->reset()
							->set('user_id', $_POST['id'])
							->set('restaurant_id', $restaurant_id)
							->insert();
					}
					$pjUserRestaurantModel->commit();
				}
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminUsers&action=pjActionIndex&err=AU01");
				
			} else {
				$arr = pjUserModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminUsers&action=pjActionIndex&err=AU08");
				}
				$this->set('arr', $arr);
				
                                $this->set('restaurant_arr', pjRestaurantModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjRestaurant' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`name` ASC')
					->findAll()
					->getData());
                                $this->set('restaurant_id_arr', pjUserRestaurantModel::factory()
					->where("user_id", $_GET['id'])
					->findAll()
					->getDataPair("restaurant_id", "restaurant_id"));
                                
                                
				$this->set('role_arr', pjRoleModel::factory()->orderBy('t1.id ASC')->findAll()->getData());
				
                                $this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminUsers.js');
			}
		} else {
			$this->set('status', 2);
		}
	}

    /*Khuetech only_kiosk, custom_product_kiosk */
    /*run -> https://caffexo.dev/index.php?controller=pjAdminUsers&action=pjActionUpdate20231027*/
    public function pjActionUpdate20231027()
    {
        $this->checkLogin();

        if ($this->isAdmin()) {

            /*Add field into model*/
            $sql="ALTER TABLE `cfxfood_delivery_users` ADD `only_kiosk` INT NULL DEFAULT '0' AFTER `ip`, ADD `custom_product_kiosk` INT NULL DEFAULT '0' AFTER `only_kiosk`;";
            pjAppModel::factory()->execute($sql);

            /*Add field language*/
            $pjFieldModel=pjFieldModel::factory();
            $pjMultiLangModel=pjMultiLangModel::factory();
            $sql= "INSERT INTO `".$pjFieldModel->getTable()."` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES (NULL, 'lbl_only_kiosk', 'backend', 'Label / Only Kiosk', 'script', NULL)";
            $pjFieldModel->reset()->execute($sql);
            $id=$pjFieldModel->getInsertId();

            $sql= "INSERT INTO `".$pjMultiLangModel->getTable()."` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES (NULL, ".$id.", 'pjField', '1', 'title', 'Only Kiosk', 'script')";
            $pjFieldModel->reset()->execute($sql);

            /*-------------*/
            $pjFieldModel=pjFieldModel::factory();
            $pjMultiLangModel=pjMultiLangModel::factory();
            $sql= "INSERT INTO `".$pjFieldModel->getTable()."` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES (NULL, 'lbl_custom_product_kiosk', 'backend', 'Label / Custom Product Kiosk', 'script', NULL)";
            $pjFieldModel->reset()->execute($sql);
            $id=$pjFieldModel->getInsertId();

            $sql= "INSERT INTO `".$pjMultiLangModel->getTable()."` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES (NULL, ".$id.", 'pjField', '1', 'title', 'Custom Product Kiosk', 'script')";
            $pjFieldModel->reset()->execute($sql);

            echo 'Options have been updated!!!';
        } else {
            echo 'Access denied!!!';
        }
        exit;
    }
}
?>