<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
require  PJ_INSTALL_PATH.'vendor/autoload.php';
require  PJ_INSTALL_PATH.'vendor/usaepay/usaepay-php/vendor/autoload.php';

/*Khuetech [nmi] add lib*/
require PJ_INSTALL_PATH.'vendor/nmipay/gwapi.php';

use Mike42\Escpos\Printer;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;
class pjFront extends pjAppController
{	
	public $defaultCaptcha = 'pjFoodDelivery_Captcha';
	
	public $defaultLocale = 'pjFoodDelivery_LocaleId';
	public $defaultRestaurantId = 'pjFoodDelivery_RestaurantId';
	
	public $defaultClient = 'pjFoodDelivery_Client';
	
	public $defaultLangMenu = 'pjFoodDelivery_LangMenu';
	
	public $defaultStore = 'pjFoodDelivery_Store';	
	public $defaultForm = 'pjFoodDelivery_Form';
	
	public $defaultReorderStore = 'pjFoodDelivery_Reorder_Store';
	public $defaultReorderForm = 'pjFoodDelivery_Reorder_Form';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		
		self::allowCORS();
	}
	
	public function _get($key)
	{
		if ($this->_is($key))
		{
			return $_SESSION[$this->defaultStore][$key];
		}
		return false;
	}
	
	public function _is($key)
	{
		return isset($_SESSION[$this->defaultStore]) && isset($_SESSION[$this->defaultStore][$key]);
	}
	
	public function _set($key, $value)
	{
		$_SESSION[$this->defaultStore][$key] = $value;
		return $this;
	}
	
	public function _unset($key)
	{
		if ($this->_is($key))
		{
			unset($_SESSION[$this->defaultStore][$key]);
		}
	}

	public function isFrontLogged()
    {
        if (isset($_SESSION[$this->defaultClient]) && count($_SESSION[$this->defaultClient]) > 0)
        {
            return true;
	    }
	    return false;
    }
    
    public function getClientId()
    {
    	return isset($_SESSION[$this->defaultClient]) && array_key_exists('id', $_SESSION[$this->defaultClient]) ? $_SESSION[$this->defaultClient]['id'] : FALSE;
    }
	
    function getFrontRestaurantId() {
    	return isset($_SESSION[$this->defaultRestaurantId]) && (int)$_SESSION[$this->defaultRestaurantId] > 0 ? $_SESSION[$this->defaultRestaurantId] : 1;
    }
    
    public function afterFilter()
	{		
		$action_arr = array(
			'pjActionMain', 
			'pjActionTypes', 
			'pjActionLogin', 
			'pjActionProfile', 
			'pjActionForgot', 
			'pjActionVouchers', 
			'pjActionCheckout', 
			'pjActionPreview',
			'pjActionFeatured',
			'pjActionPrevious',
			'pjActionFavorites'
		);
		if (!isset($_GET['hide']) || (isset($_GET['hide']) && (int) $_GET['hide'] !== 1) &&
			in_array($_GET['action'], $action_arr))
		{
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$this->set('locale_arr', $locale_arr);
		}
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		if (isset($_GET['rid']) && (int)$_GET['rid'] > 0) {
			if ($this->getForeignId() != $_GET['rid']) {
				unset($_SESSION[$this->defaultStore]);
				unset($_SESSION[$this->defaultForm]);
				unset($_SESSION[$this->defaultReorderStore]);
				unset($_SESSION[$this->defaultReorderForm]);
				unset($_SESSION[$this->defaultCaptcha]);
			}
			$_SESSION[$this->defaultRestaurantId] = (int)$_GET['rid'];
			
			/*$this->defaultCaptcha = 'pjFoodDelivery_Captcha_'.(int)$_GET['rid'];
			$this->defaultLocale = 'pjFoodDelivery_LocaleId_'.(int)$_GET['rid'];
			$this->defaultRestaurantId = 'pjFoodDelivery_RestaurantId_'.(int)$_GET['rid'];
			$this->defaultClient = 'pjFoodDelivery_Client_'.(int)$_GET['rid'];
			$this->defaultLangMenu = 'pjFoodDelivery_LangMenu_'.(int)$_GET['rid'];
			$this->defaultStore = 'pjFoodDelivery_Store_'.(int)$_GET['rid'];
			$this->defaultForm = 'pjFoodDelivery_Form_'.(int)$_GET['rid'];*/
		}
		$this->option_arr = $OptionModel->getPairs($this->getFrontRestaurantId());
		$o_catering_hours_in_advance = (int)$this->option_arr['o_catering_hours_in_advance'];	
		$cart_info = $this->getCartInfo();
		if (isset($cart_info['product_arr']) && count($cart_info['product_arr']) > 0) {
			foreach ($cart_info['product_arr'] as $product) {
				if ((int)$product['catering_hours_in_advance'] > $o_catering_hours_in_advance) {
					$o_catering_hours_in_advance = (int)$product['catering_hours_in_advance'];
				}
			}
		}
		$this->option_arr['o_catering_hours_in_advance'] = $o_catering_hours_in_advance;
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		$this->loadSetFields();
		
		if ($this->isFrontLogged()) {
			$favorite_product_arr = pjFavoriteModel::factory()
				->where('t1.client_id', $this->getClientId())
				->findAll()->getDataPair(null, 'product_id');
			$this->set('favorite_product_arr', $favorite_product_arr);
		}
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				
				$this->loadSetFields(true);
				
				$day_names = __('day_names', true);
				ksort($day_names, SORT_NUMERIC);
				
				$months = __('months', true);
				ksort($months, SORT_NUMERIC);
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Locale have been changed.', 'opts' => array(
					'day_names' => array_values($day_names),
					'month_names' => array_values($months)
				)));
			}
		}
		exit;
	}
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		/*Khuetech [captcha] bổ sung thêm realpath để lấy được font chữ*/
		$Captcha = new pjCaptcha(realpath('app/web/obj/Anorexia.ttf'), $this->defaultCaptcha, 6);
		$Captcha->setImage('app/web/img/button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
	}
	
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['c_email']) || empty($_GET['c_email']))
			{
				echo 'false';
				exit;
			}
			$pjClientModel = pjClientModel::factory()->where('t1.c_email', $_GET['c_email'])->where('t1.restaurant_id', $_GET['rid']);
			if ($this->isFrontLogged())
			{
				$pjClientModel->where('t1.id !=', $this->getClientId());
			}
			echo $pjClientModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionAddProduct()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			if (isset($_POST['product_id']))
			{
				$extras = array();
				if(isset($_POST['extra_id']))
				{
					foreach ($_POST['extra_id'] as $extra_id => $qty)
					{
						if(intval($qty) > 0)
						{
							$extras[$extra_id] = $qty;
						}
					}
				}
				ksort($extras);
				
				$group_items = array();
				if(isset($_POST['group_item_id']))
				{
					$group_items = $_POST['group_item_id'];
				}
				ksort($group_items);
				
				$modifier_items = array();
				if(isset($_POST['modifier_item_id']))
				{
					$modifier_items = $_POST['modifier_item_id'];
				}
				ksort($modifier_items);
				
				if(isset($_POST['price_id']))
				{
					$hash = md5($_POST['category_id'] . $_POST['product_id'] . $_POST['price_id'] . serialize($extras) . serialize($group_items) . serialize($modifier_items));
				}else{
					$hash = md5($_POST['category_id'] . $_POST['product_id'] . serialize($extras) . serialize($group_items) . serialize($modifier_items));
				}
				
				$cart = $this->_get('cart');
				if ($cart === false)
				{
					$cart = array();
				}
				
				if (!array_key_exists($hash, $cart))
				{
					$cart[$hash] = array(
						'category_id' => $_POST['category_id'],
						'product_id' => $_POST['product_id'],
						'price_id' => isset($_POST['price_id']) ? $_POST['price_id'] : null,
						'cnt' => 0,
						'extras' => $extras,
						'group_items' => $group_items,
						'modifier_items' => $modifier_items
					);
				}
				
				$cart[$hash]['cnt'] += isset($_POST['cnt']) ? (int)$_POST['cnt'] : 1;
				$this->_set('cart', $cart);
			}
		}
	}
	
	function pjActionAddPromo()
	{
		$this->setAjax(true);
			
		if ($this->isXHR())
		{
			$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
			$pre = array(
				'type' => $this->_get('type'),
				'd_date' => $this->_get('d_date'),
				'd_time' => $this->_get('d_time'),
				'p_date' => $this->_get('p_date'),
				'p_time' => $this->_get('p_time'),
				'restaurant_id' => $rid
			);
			$resp = pjAppController::getDiscount(array_merge($_POST, $pre), $this->option_arr);
			$promo_statuses = __('promo_statuses', true, false);
			$resp['text'] = $promo_statuses[$resp['code']];
			if($resp['code'] == 200)
			{
				$this->_set('voucher_code', $resp['voucher_code']);
				$this->_set('voucher_type', $resp['voucher_type']);
				$this->_set('voucher_discount', $resp['voucher_discount']);
			}
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionRemove()
	{
		$this->isAjax = true;
	
		if ($this->isXHR())
		{
			if (isset($_POST['hash']) && isset($_POST['extra_id']))
			{
				$cart = $this->_get('cart');
				if ($cart !== false)
				{
					if (array_key_exists($_POST['hash'], $cart))
					{
						if((int) $_POST['extra_id'] > 0)
						{
							unset($cart[$_POST['hash']]['extras'][$_POST['extra_id']]);
						}else{
							unset($cart[$_POST['hash']]);
						}
						$this->_set('cart', $cart);
					}
				}
			}
			exit;
		}
	}
	public function pjActionUpdateCart()
	{
		$this->isAjax = true;
	
		if ($this->isXHR())
		{
			if (isset($_POST['hash']) && isset($_POST['sign']))
			{
				$cart = $this->_get('cart');
				if ($cart !== false)
				{
					if (array_key_exists($_POST['hash'], $cart))
					{
						$cnt = $cart[$_POST['hash']]['cnt'];
						switch ($_POST['sign']) {
							case '+':
								$cart[$_POST['hash']]['cnt'] = $cnt + 1;
							break;
							
							case '-':
								if($cnt <= 1)
								{
									unset($cart[$_POST['hash']]);
								}else{
									$cart[$_POST['hash']]['cnt'] = $cnt - 1;
								}
							break;
						}
						$this->_set('cart', $cart);
					}
				}
			}
			exit;
		}
	}
	public function pjActionUpdateProfile()
	{
		$this->isAjax = true;
	
		if ($this->isXHR())
		{
			if(isset($_POST['profile']))
			{
				$pjClientModel = pjClientModel::factory();
				$pjClientModel->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				
				$client = $pjClientModel->reset()->find($_POST['id'])->getData();
				$_SESSION[$this->defaultClient] = $client;
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => __('front_profile_updated', true)));
			}
		}
	}
	
	private function getCartInfo()
	{
		$product_arr = array();
		$modifier_arr = $modifier_item_arr = array();
		$items_in_cart = 0;
		$cart = $this->_get('cart');
		if ($cart !== false)
		{
			$ids = array();
			foreach ($cart as $item)
			{
				$ids[] = $item['product_id'];
				$items_in_cart += $item['cnt'];
			}
			if (count($ids) > 0)
			{
				$pjProductModel = pjProductModel::factory();
				$pjProductPriceModel = pjProductPriceModel::factory();
				$pjExtraModel = pjExtraModel::factory();	
				$pjProductGroupItemModel = pjProductGroupItemModel::factory();
				$pjProductModifierModel = pjProductModifierModel::factory();
				
				$product_arr = $pjProductModel
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->select('t1.*, t2.content as name')
					->whereIn('t1.id', $ids)
					->findAll()
					->getData();
				
				$modifier_arr = $pjProductModifierModel->select('t1.*, t2.content AS modifier_name')
					->join('pjMultiLang', "t2.foreign_id = t1.modifier_id AND t2.model = 'pjModifier' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->whereIn('t1.product_id', $ids)
					->orderBy('t2.content ASC')
					->findAll()
					->getDataPair('modifier_id', NULL);
				$modifier_ids_arr = array_keys($modifier_arr);
				if ($modifier_ids_arr) {
					$_modifier_item_arr = pjModifierItemModel::factory()->select('t1.*, t2.content AS modifier_item_name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjModifierItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'item_name'", 'left')
						->whereIn('t1.modifier_id', $modifier_ids_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					foreach ($_modifier_item_arr as $item) {
						$modifier_item_arr[$item['modifier_id']][$item['id']] = $item;
					}
				}
				foreach ($cart as $k => $item)
				{
					$price_arr = array();
					if(!empty($item['price_id']))
					{
						$price_arr = $pjProductPriceModel
							->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
							->select('t1.*, t2.content as size')
							->find($item['price_id'])
							->getData();
						if($price_arr)	
						{		
							$cart[$k]['price'] = $price_arr['price'];
							$cart[$k]['size'] = $price_arr['size'];
						}else{
							$cart[$k]['price'] = 0;
							$cart[$k]['size'] = '';
						}
					}else{
						$price_arr = $pjProductModel->reset()->find($item['product_id'])->getData();
						if(!empty($price_arr))	
						{
							$cart[$k]['price'] = $price_arr['price'];
							$cart[$k]['size'] = '';
						}else{
							$cart[$k]['price'] = 0;
							$cart[$k]['size'] = '';
						}
					}
					
					$extra_arr = array();
					if(isset($item['extras']) && $item['extras'])
					{
						foreach ($item['extras'] as $extra_id => $qty)
						{
							$_arr = $pjExtraModel
								->reset()
								->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
								->select('t1.*, t2.content as name')
								->whereIn('t1.id', $ids)
								->find($extra_id)
								->getData();
							$_arr['qty'] = $qty;
							$extra_arr[$extra_id] = $_arr;
						}
					}
					$cart[$k]['extra_arr'] = $extra_arr;
					
					$group_item_arr = array();
					if(isset($item['group_items']) && $item['group_items'])
					{
						foreach ($item['group_items'] as $group_id => $group_item_id)
						{
							$_arr = $pjProductGroupItemModel
								->reset()
								->join('pjMultiLang', "t2.foreign_id = t1.group_id AND t2.model = 'pjProductGroup' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_name'", 'left')
								->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProductGroupItem' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'group_item_name'", 'left')
								->select('t1.*, t2.content as group_name, t3.content as group_item_name')
								->find($group_item_id)
								->getData();
							$_arr['qty'] = 1;
							$group_item_arr[$_arr['group_id']]['group_name'] = $_arr['group_name'];
							$group_item_arr[$_arr['group_id']]['group_items'][] = $_arr;
						}
					}
					$cart[$k]['group_item_arr'] = $group_item_arr;
				}
			}
		}		
		return compact('cart', 'items_in_cart', 'product_arr', 'modifier_arr', 'modifier_item_arr');
	}
	
	private function getCategories()
	{
		$pjCategoryModel = pjCategoryModel::factory();
		$pjProductModel = pjProductModel::factory();
		$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
		$category_arr = $pjCategoryModel
			->select("t1.*, t2.content as name, (SELECT COUNT(TPC.product_id) FROM `".pjProductCategoryModel::factory()->getTable()."` AS TPC WHERE TPC.category_id=t1.id) AS cnt_products")
			->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjCategory' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
			->where('t1.restaurant_id', $rid)
			->where('t1.status', 'T')
			->orderBy("`order` ASC")
			->findAll()
			->getData();
		
		$category_id_arr = array();
		$product_arr = array();
		
		return compact('category_arr', 'product_arr');
	}
	
	public function pjActionLoadCss()
	{
		$dm = new pjDependencyManager(PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
		
		$theme = $this->option_arr['o_layout'];
		if(isset($_GET['layout']) && in_array($_GET['layout'], array('theme1', 'theme2', 'theme3', 'theme4', 'theme5', 'theme6', 'theme7', 'theme8', 'theme9', 'theme10')))
		{
			$theme = $_GET['layout'];
		}
		$arr = array(
			array('file' => 'font-awesome.min.css', 'path' => $dm->getPath('font_awesome') . 'css/'),
			array('file' => 'datepicker.css', 'path' => $dm->getPath('pj_bootstrap_datepicker')),
			array('file' => 'calendar.css', 'path' => $dm->getPath('calendarjs')),
			array('file' => 'FoodDelivery.css', 'path' => PJ_CSS_PATH),
			array('file' => "$theme.css", 'path' => PJ_CSS_PATH)
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
			
			if ($string !== FALSE)
			{
				echo str_replace(
					array('../img/', '../fonts/glyphicons', '../fonts/fontawesome', '[URL]', "pjWrapper"),
					array(
						PJ_INSTALL_URL . PJ_IMG_PATH,
						PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/fonts/glyphicons',
						PJ_INSTALL_URL . $dm->getPath('font_awesome') . 'fonts/fontawesome',
						PJ_INSTALL_URL,
						"pjWrapperFoodDelivery_" . $theme
					),
					$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
		
		$rid = isset($_GET['rid']) ? (int)$_GET['rid'] : 0;
		$arr = pjRestaurantModel::factory()->find($rid)->getData();
		if (!$arr) {
			$this->set('status', 2);
		} elseif ($arr && $arr['status'] == 'F') {
			$this->set('status', 3);
		} elseif ($arr && $arr['status'] == 'T') {
			$this->set('status', 1);
			if(isset($_GET['locale']) && $_GET['locale'] > 0)
			{
				$_SESSION[$this->defaultLocale] = (int) $_GET['locale'];
				$_SESSION[$this->defaultLangMenu] = 'hide';
			}else{
				$_SESSION[$this->defaultLangMenu] = 'show';
			}

			if (isset($_GET['rid']) && (int)$_GET['rid'] > 0) {
				$_SESSION[$this->defaultRestaurantId] = (int)$_GET['rid'];
			}
			
			$days_off = array();
			
			$w_arr = pjWorkingTimeModel::factory()
				->join('pjLocation', 't1.location_id = t2.id')
				->where('t2.restaurant_id', $this->getFrontRestaurantId())
				->orderBy("t1.location_id ASC")
				->findAll()
				->getData();
			foreach ($w_arr as $w)
			{
				if ($w['p_monday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['pickup'][] = 1;
				}
				if ($w['p_tuesday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['pickup'][] = 2;
				}
				if ($w['p_wednesday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['pickup'][] = 3;
				}
				if ($w['p_thursday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['pickup'][] = 4;
				}
				if ($w['p_friday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['pickup'][] = 5;
				}
				if ($w['p_saturday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['pickup'][] = 6;
				}
				if ($w['p_sunday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['pickup'][] = 0;
				}
			
				if ($w['d_monday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['delivery'][] = 1;
				}
				if ($w['d_tuesday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['delivery'][] = 2;
				}
				if ($w['d_wednesday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['delivery'][] = 3;
				}
				if ($w['d_thursday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['delivery'][] = 4;
				}
				if ($w['d_friday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['delivery'][] = 5;
				}
				if ($w['d_saturday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['delivery'][] = 6;
				}
				if ($w['d_sunday_dayoff'] == 'T')
				{
					$days_off[$w['location_id']]['delivery'][] = 0;
				}
			}
			$this->set('days_off', $days_off);
			
			$dates_off = $dates_on = array();
			$d_arr = pjDateModel::factory()
				->join('pjLocation', 't1.location_id = t2.id')
				->where('t2.restaurant_id', $this->getFrontRestaurantId())
				->where("t1.date >= CURDATE()")
				->findAll()
				->getData();
				
			foreach ($d_arr as $date)
			{
				if ($date['is_dayoff'] == 'T')
				{
					$dates_off[$date['location_id']][$date['type']][] = $date['date'];
				} else {
					$dates_on[$date['location_id']][$date['type']][] = $date['date'];
				}
			}
			$this->set('dates_on', $dates_on);
			$this->set('dates_off', $dates_off);
		}
	}
	
	public function pjActionMain()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			$this->set('main', $this->getCategories());
			$this->set('cart_box', $this->getCartInfo());
		}
	}
	
	public function pjActionCategories()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			$this->set('main', $this->getCategories());
		}
	}
	
	public function pjActionCart()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			$cart_box = $this->getCartInfo();
				
			$price = 0;
			if (isset($cart_box['cart']) && $cart_box['cart']) {
				foreach ($cart_box['cart'] as $hash => $item)
				{
					foreach ($cart_box['product_arr'] as $product)
					{
						if ($product['id'] == $item['product_id'])
						{
							$product_price = 0;
							$product_price = $item['price'] * $item['cnt'];
							$price += $product_price;
							foreach ($item['extra_arr'] as $extra_id => $extra)
							{
								$price += $extra['price'] * $extra['qty'];
							}
							
							if (isset($item['modifier_items'])) {
							    foreach ($item['modifier_items'] as $modifier_id => $modifiers) {
							        $modifier_item_arr = array();
							        foreach ($modifiers as $mid) {
							            $modifier_item = $cart_box['modifier_item_arr'][$modifier_id][$mid];
							            $price += (float)$modifier_item['price'];
							        }
							    }
							}
						}
					}
				}
			}
			
			$type = $this->_get('type');
			$delivery = 0;
			$discount = 0;
			$subtotal = 0.00;
			$tax = 0.00;
			$service_fee = 0.00;
			$total = 0.00;
			$catering_fee = 0.00;	
			
			if ($this->_get('voucher_code') !== false)
			{
			    $voucher_discount = $this->_get('voucher_discount');
			    switch ($this->_get('voucher_type'))
			    {
			        case 'percent':
			            $discount = ($price * $voucher_discount) / 100;
			            break;
			        case 'amount':
			            $discount = $voucher_discount;
			            break;
			    }
			}
			if($discount > $price)
			{
			    $discount = $price;
			}
			$subtotal = $price - $discount;
			
			if ((float)$this->option_arr['o_tax_payment'] > 0) {
			    $tax = ($subtotal * (float)$this->option_arr['o_tax_payment']) / 100;
			}
			if($this->option_arr['o_allow_service_fee'] == 'Yes' && (float)$this->option_arr['o_service_fee'] > 0) {
			    $service_fee = (float)$this->option_arr['o_service_fee'];
			}
			if($type == 'catering' && (float)$this->option_arr['o_catering_fee'] > 0)
			{
			    if ($subtotal >= (float)$this->option_arr['o_catering_total']) {
			        $catering_fee = (float)$this->option_arr['o_catering_fee_percent'] * $subtotal / 100;
			    }
			    else {
			        $catering_fee = (float)$this->option_arr['o_catering_fee'];
			    }
			}
			$total = $subtotal + $tax + $service_fee + $catering_fee;
			$tip_amount = $dasher_tip_amount = 0;
			$tip_option = $this->_get('tip_option');
			if (in_array($tip_option, array(1,2))) {
			    $tip_percentage = $this->_get('tip_percentage');
			    if ($tip_percentage > 0) {
			        if ($tip_option == 1) {
			            $tip_amount = ($total * $tip_percentage) / 100;
			        } else {
			            $tip_amount = $tip_percentage;
			        }
			        $total += $tip_amount;
			    }
			}
			if ($type == 'delivery' && $this->option_arr['o_allow_delivery_doordash'] == 'Yes' && (float)$this->option_arr['o_doordash_dasher_tip_earn'] > 0) {
			    $dasher_tip_amount = ($tip_amount * (float)$this->option_arr['o_doordash_dasher_tip_earn']) / 100;
			}
			
			if ($type == 'delivery' && $this->option_arr['o_allow_delivery_doordash'] == 'Yes') {
				$restaurant_arr = pjRestaurantModel::factory()->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjRestaurant' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->find($this->getFrontRestaurantId())
					->getData();
					
				$dropoff_address_arr = array();
				if ($this->_is('d_address_1')) {
					$dropoff_address_arr[] = $this->_get('d_address_1');
				}
				if ($this->_is('d_address_2')) {
					$dropoff_address_arr[] = $this->_get('d_address_2');
				}
				if ($this->_is('d_city')) {
					$dropoff_address_arr[] = $this->_get('d_city');
				}
				if ($this->_is('d_state')) {
					$dropoff_address_arr[] = $this->_get('d_state');
				}
				if ($this->_is('d_zip')) {
					$dropoff_address_arr[] = $this->_get('d_zip');
				}
				
				$FORM = isset($_SESSION[$this->defaultForm]) ? $_SESSION[$this->defaultForm] : array();
				$CLIENT = $this->isFrontLogged() && isset($_SESSION[$this->defaultClient]) ? $_SESSION[$this->defaultClient] : array();
				
				$data = array(
					"pickup_address"=> $restaurant_arr['address'],
					"pickup_business_name"=> $restaurant_arr['name'],
					"pickup_phone_number"=> $restaurant_arr['phone'],
					"dropoff_address"=> implode(', ', $dropoff_address_arr),
				    "dropoff_business_name"=> isset($FORM['c_name']) ? $FORM['c_name'] : (isset($CLIENT['c_name']) ? $CLIENT['c_name'] : ''),
					"dropoff_phone_number"=> $this->_get('d_phone'),
					"dropoff_instructions"=> $this->_get('d_notes'),
				    "order_value"=> $total * 100,
				    "tip"=> $dasher_tip_amount * 100
				);
				$delivery_quote_arr = pjAppController::doordashDeliveryQuote($data, $this->option_arr);
				if (isset($delivery_quote_arr['external_delivery_id'])) {
					$this->_set('external_delivery_id', $delivery_quote_arr['external_delivery_id']);
					$delivery = $delivery_quote_arr['fee'] > 0 ? ($delivery_quote_arr['fee']/100) : 0;
				}
			} else {
				$arr = pjPriceModel::factory()
					->where('t1.location_id', $this->_get('d_location_id'))
					->where('t1.total_from <= ' . $price)
					->where('t1.total_to >= ' . $price)
					->limit(1)
					->findAll()
					->getData();			
				if (count($arr) === 1)
				{
					$delivery = $arr[0]['price'];
				}
			}
			$this->_set('delivery', $delivery);
			$this->set('cart_box', $cart_box);
		}
	}
	
	public function pjActionTypes()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SESSION[$this->defaultStore]) && count($_SESSION[$this->defaultStore]) > 0)
			{
				$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
				$location_arr = pjLocationModel::factory()
					->select('t1.*, t2.content AS name, t3.content AS address')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjLocation' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'address'", 'left')
					->where('t1.restaurant_id', $rid)
					->orderBy("name ASC")
					->findAll()
					->getData();
				
				$type_allow = NULL;
				$type_allow_arr = array();
				if ($this->option_arr['o_allow_pickup'] == 'Yes') {
					$type_allow_arr[] = 'pickup';
				}
				if($this->option_arr['o_allow_delivery'] == 'Yes' || $this->option_arr['o_allow_delivery_doordash'] == 'Yes'){
					$type_allow_arr[] = 'delivery';
				}
				if($this->option_arr['o_allow_catering'] == 'Yes'){
					$type_allow_arr[] = 'catering';
				}
				if($this->_is('type'))
				{
				    $type = $this->_get('type');
				    if(!in_array($type, $type_allow_arr))
				    {
				        $this->_set('type', @$type_allow_arr[0]);
				    }
				}else{
				    $this->_set('type', @$type_allow_arr[0]);
				}
				$type = $this->_get('type');
				if ($type !== false)
				{
					switch ($type)
					{
						case 'pickup':
							$p_location_id = $this->_get('p_location_id');
							$p_date = $this->_get('p_date');
							if ($p_location_id !== false && $p_date !== false)
							{
								$wt_arr = pjAppController::getWorkingTime(pjUtil::formatDate($p_date, $this->option_arr['o_date_format']), $p_location_id, 'pickup');
								$this->set('wt_arr', $wt_arr);

                                /*Khuetech chỉnh format lại date của mysql*/
                                $date_sql = pjUtil::formatDate($p_date, $this->option_arr['o_date_format']);
								$location_wt_arr = pjAppController::getLocationWT($date_sql, $p_location_id, 'pickup');
                                /*End Khuetech*/

								$this->tpl['location_wt_arr'] = $location_wt_arr;
							}
							break;
						case 'delivery':
							$d_location_id = $this->_get('d_location_id');
							$d_date = $this->_get('d_date');
							if ($d_location_id !== false && $d_date !== false)
							{
								$wt_arr = pjAppController::getWorkingTime(pjUtil::formatDate($d_date, $this->option_arr['o_date_format']), $d_location_id, 'delivery');
								$this->set('wt_arr', $wt_arr);

								/*Khuetech chỉnh format lại date của mysql*/
                                $date_sql = pjUtil::formatDate($d_date, $this->option_arr['o_date_format']);
								$location_wt_arr = pjAppController::getLocationWT($date_sql, $d_location_id, 'delivery');
								/*End Khuetech*/

								$this->tpl['location_wt_arr'] = $location_wt_arr;
							}
							break;
					}
				}
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();

				if($this->isFrontLogged())
				{
					$order_arr = pjOrderModel::factory()
						->select("t1.*")
						->where('t1.restaurant_id', $rid)
						->where('client_id', $this->getClientId())
						->where('type', 'delivery')
						->orderBy("t1.created DESC")
						->findAll()
						->getData();
					
					$this->set('order_arr', $order_arr);
				}	
				
				$this->set('country_arr', $country_arr);
				$this->set('location_arr', $location_arr);
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}	
			$this->set('cart_box', $this->getCartInfo());
		}
	}
	
	public function pjActionLogin()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if($this->isFrontLogged())
			{
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200));
			}else{
				$this->set('cart_box', $this->getCartInfo());
			}
		}
	}
	public function pjActionLogout()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				unset($_SESSION[$this->defaultClient]);
			}
		}
	}
	public function pjActionProfile()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if($this->isFrontLogged())
			{
				$country_arr = pjCountryModel::factory()
				->select('t1.id, t2.content AS country_title')
				->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->orderBy('`country_title` ASC')
				->findAll()
				->getData();
				
				$this->set('country_arr', $country_arr);
				
				$this->set('cart_box', $this->getCartInfo());
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100));
			}
		}
	}
	
	public function pjActionForgot()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			$this->set('cart_box', $this->getCartInfo());	
		}
	}
	
	public function pjActionVouchers()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SESSION[$this->defaultStore]) && count($_SESSION[$this->defaultStore]) > 0)
			{
				if (!$this->_is('tip_option')) {
					$this->_set('tip_option', 1);
				}
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}
			$this->set('cart_box', $this->getCartInfo());
		}
	}
	
	public function pjActionCheckout()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SESSION[$this->defaultStore]) && count($_SESSION[$this->defaultStore]) > 0)
			{
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();
				$this->set('country_arr', $country_arr);
				
				$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
				$terms_conditions = pjMultiLangModel::factory()
					->select('t1.*')
					->where('t1.model','pjOption')
					->where('t1.locale', $this->getLocaleId())
					->where('t1.field', 'o_terms')
					->where('t1.foreign_id', $rid)
					->limit(0, 1)
					->findAll()
					->getData();
				
				$this->set('terms_conditions', @$terms_conditions[0]['content']);
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}	
			$cart_box = $this->getCartInfo();
			
			$price = 0;
			
			foreach ($cart_box['cart'] as $hash => $item)
			{
				foreach ($cart_box['product_arr'] as $product)
				{
					if ($product['id'] == $item['product_id'])
					{
						$product_price = 0;
						$product_price = $item['price'] * $item['cnt'];
						$price += $product_price;
						foreach ($item['extra_arr'] as $extra_id => $extra)
						{
							$price += $extra['price'] * $extra['qty'];
						}
						
						if (isset($item['modifier_items'])) {
						    foreach ($item['modifier_items'] as $modifier_id => $modifiers) {
						        $modifier_item_arr = array();
						        foreach ($modifiers as $mid) {
						            $modifier_item = $cart_box['modifier_item_arr'][$modifier_id][$mid];
						            $price += (float)$modifier_item['price'];
						        }
							}
						}
										
					}
				}
			}
			
			$type = $this->_get('type');
			$delivery = 0;
			$discount = 0;
			$subtotal = 0.00;
			$tax = 0.00;
			$service_fee = 0.00;
			$total = 0.00;
			$catering_fee = 0.00;	
			
			if ($this->_get('voucher_code') !== false)
			{
			    $voucher_discount = $this->_get('voucher_discount');
			    switch ($this->_get('voucher_type'))
			    {
			        case 'percent':
			            $discount = ($price * $voucher_discount) / 100;
			            break;
			        case 'amount':
			            $discount = $voucher_discount;
			            break;
			    }
			}			
			if($discount > $price)
			{
			    $discount = $price;
			}
			$subtotal = $price - $discount;
			
			if ((float)$this->option_arr['o_tax_payment'] > 0) {
			    $tax = ($subtotal * (float)$this->option_arr['o_tax_payment']) / 100;
			}
			if($this->option_arr['o_allow_service_fee'] == 'Yes' && (float)$this->option_arr['o_service_fee'] > 0) {
			    $service_fee = (float)$this->option_arr['o_service_fee'];
			}
			if($type == 'catering' && (float)$this->option_arr['o_catering_fee'] > 0)
			{
			    if ($subtotal >= (float)$this->option_arr['o_catering_total']) {
			        $catering_fee = (float)$this->option_arr['o_catering_fee_percent'] * $subtotal / 100;
			    }
			    else {
			        $catering_fee = (float)$this->option_arr['o_catering_fee'];
			    }
			}
			$total = $subtotal + $tax + $service_fee + $catering_fee;
			$tip_amount = $dasher_tip_amount = 0;
			$tip_option = $this->_get('tip_option');
			if (in_array($tip_option, array(1,2))) {
			    $tip_percentage = $this->_get('tip_percentage');
			    if ($tip_percentage > 0) {
			        if ($tip_option == 1) {
			            $tip_amount = ($total * $tip_percentage) / 100;
			        } else {
			            $tip_amount = $tip_percentage;
			        }
			        $total += $tip_amount;
			    }
			}
			if ($type == 'delivery' && $this->option_arr['o_allow_delivery_doordash'] == 'Yes' && (float)$this->option_arr['o_doordash_dasher_tip_earn'] > 0) {
			    $dasher_tip_amount = ($tip_amount * (float)$this->option_arr['o_doordash_dasher_tip_earn']) / 100;
			}
			
			if ($type == 'delivery' && $this->option_arr['o_allow_delivery_doordash'] == 'Yes') {
				$restaurant_arr = pjRestaurantModel::factory()->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjRestaurant' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->find($this->getFrontRestaurantId())
					->getData();
					
				$dropoff_address_arr = array();
				if ($this->_is('d_address_1')) {
					$dropoff_address_arr[] = $this->_get('d_address_1');
				}
				if ($this->_is('d_address_2')) {
					$dropoff_address_arr[] = $this->_get('d_address_2');
				}
				if ($this->_is('d_city')) {
					$dropoff_address_arr[] = $this->_get('d_city');
				}
				if ($this->_is('d_state')) {
					$dropoff_address_arr[] = $this->_get('d_state');
				}
				if ($this->_is('d_zip')) {
					$dropoff_address_arr[] = $this->_get('d_zip');
				}
				
				$FORM = isset($_SESSION[$this->defaultForm]) ? $_SESSION[$this->defaultForm] : array();
				$CLIENT = $this->isFrontLogged() && isset($_SESSION[$this->defaultClient]) ? $_SESSION[$this->defaultClient] : array();
				
				$data = array(
					"pickup_address"=> $restaurant_arr['address'],
					"pickup_business_name"=> $restaurant_arr['name'],
					"pickup_phone_number"=> $restaurant_arr['phone'],
					"dropoff_address"=> implode(', ', $dropoff_address_arr),
				    "dropoff_business_name"=> isset($FORM['c_name']) ? $FORM['c_name'] : (isset($CLIENT['c_name']) ? $CLIENT['c_name'] : ''),
					"dropoff_phone_number"=> $this->_get('d_phone'),
					"dropoff_instructions"=> $this->_get('d_notes'),
				    "order_value"=> $total * 100,
				    "tip"=> $dasher_tip_amount * 100
				);
				$delivery_quote_arr = pjAppController::doordashDeliveryQuote($data, $this->option_arr);
				if (isset($delivery_quote_arr['external_delivery_id'])) {
					$this->_set('external_delivery_id', $delivery_quote_arr['external_delivery_id']);
					$delivery = $delivery_quote_arr['fee'] > 0 ? ($delivery_quote_arr['fee']/100) : 0;
				}
			} else {
				$arr = pjPriceModel::factory()
					->where('t1.location_id', $this->_get('d_location_id'))
					->where('t1.total_from <= ' . $price)
					->where('t1.total_to >= ' . $price)
					->limit(1)
					->findAll()
					->getData();
				if (count($arr) === 1)
				{
					$delivery = $arr[0]['price'];
				}
			}
			$this->_set('delivery', $delivery);
			
			$this->set('cart_box', $cart_box);
		}
	}
	
	public function pjActionPreview()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (isset($_SESSION[$this->defaultStore]) && count($_SESSION[$this->defaultStore]) > 0)
			{
				$pjLocationModel = pjLocationModel::factory();
				$country_arr = array();
				if(isset($_SESSION[$this->defaultForm]['c_country']) && !empty($_SESSION[$this->defaultForm]['c_country']))
				{
					$country_arr = pjCountryModel::factory()
						->select('t1.id, t2.content AS country_title')
						->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
						->find($_SESSION[$this->defaultForm]['c_country'])->getData();
				}
				if($_SESSION[$this->defaultStore]['type'] == 'delivery' && isset($_SESSION[$this->defaultStore]['d_location_id']) && !empty($_SESSION[$this->defaultStore]['d_location_id']))
				{
					$location_arr = $pjLocationModel
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
						->select('t1.*, t2.content AS name')
						->find($_SESSION[$this->defaultStore]['d_location_id'])
						->getData();
					$this->set('location_arr', $location_arr);
				}
				if($_SESSION[$this->defaultStore]['type'] == 'pickup' && isset($_SESSION[$this->defaultStore]['p_location_id']) && !empty($_SESSION[$this->defaultStore]['p_location_id']))
				{
					$location_arr = $pjLocationModel->reset()
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
						->select('t1.*, t2.content AS name')
						->find($_SESSION[$this->defaultStore]['p_location_id'])
						->getData();
					$this->set('p_location_arr', $location_arr);
				}
				if(isset($_SESSION[$this->defaultStore]['d_country_id']) && !empty($_SESSION[$this->defaultStore]['d_country_id']))
				{
					$d_country_arr = pjCountryModel::factory()
						->select('t1.id, t2.content AS country_title')
						->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
						->find($_SESSION[$this->defaultStore]['d_country_id'])
						->getData();
					$this->set('d_country_arr', $d_country_arr);
				}
				$this->set('country_arr', $country_arr);
				
				$date = null;
				$selected_ts = null;
				$wt_arr = array();
				$type = $this->_get('type');
				if ($type !== false)
				{
					switch ($type)
					{
						case 'pickup':
							$p_location_id = $this->_get('p_location_id');
							$p_date = $this->_get('p_date');
							$date = pjUtil::formatDate($p_date, $this->option_arr['o_date_format']);
							if ($p_location_id !== false && $p_date !== false)
							{
								$wt_arr = pjAppController::getWorkingTime($date, $p_location_id, 'pickup');
							}
							$selected_ts = strtotime($date . ' '. $this->_get('p_time') . ':00');
							break;
						case 'delivery':
							$d_location_id = $this->_get('d_location_id');
							$d_date = $this->_get('d_date');
							$date = pjUtil::formatDate($d_date, $this->option_arr['o_date_format']);
							if ($d_location_id !== false && $d_date !== false)
							{
								$wt_arr = pjAppController::getWorkingTime($date, $d_location_id, 'delivery');
							}
							$selected_ts = strtotime($date . ' '. $this->_get('d_time') . ':00');
							break;
					}
				}
				if($selected_ts != null && $date != null && !empty($wt_arr))
				{
					$start_time = strtotime($date . ' ' . $wt_arr['start_hour'] . ':' . $wt_arr['start_minutes'] . ':00');
					$end_time = strtotime($date . ' ' . $wt_arr['end_hour'] . ':' . $wt_arr['end_minutes'] . ':00');
					
					if($selected_ts < $start_time)
					{
						$selected_ts += 86400;
						$this->_set('next_day', date('Y-m-d H:i:s', $selected_ts));
					}else{
						if($this->_is('next_day'))
						{
							$this->_unset('next_day');
						}
					}
				}else{
					if($this->_is('next_day'))
					{
						$this->_unset('next_day');
					}
				}
				
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}	
			$this->set('cart_box', $this->getCartInfo());
		}
	}
	public function pjActionGetPickupLocations()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
			$arr = pjLocationModel::factory()
				->select('t1.*, t2.content AS name, t3.content AS address')
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjLocation' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'address'", 'left')
				->where('t1.restaurant_id', $rid)
				->findAll()
				->getData();
			pjAppController::jsonResponse($arr);
		}
		exit;
	}
	public function pjActionGetLocation()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
			$arr = pjLocationModel::factory()
				->select('t1.*, t2.content AS name, t3.content AS address')
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjLocation' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'address'", 'left')
				->where('t1.restaurant_id', $rid)
				->find($_GET['id'])
				->getData();
			pjAppController::jsonResponse($arr);
		}
		exit;
	}
	
	public function pjActionGetLocations()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjLocationCoordModel = pjLocationCoordModel::factory();
			$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
			$arr = pjLocationModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjLocation' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjLocation' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'address'", 'left')
				->select('t1.*, t2.content AS name, t3.content AS address')
				->where('t1.restaurant_id', $rid)
				->findAll()
				->getData();
			foreach ($arr as $k => $v)
			{
				$arr[$k]['coords'] = $pjLocationCoordModel->reset()->where('t1.location_id', $v['id'])->findAll()->getData();
			}
			pjAppController::jsonResponse($arr);
		}
		exit;
	}
	
	public function pjActionGetWTime()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['location_id']) && (int) $_GET['location_id'] > 0 && isset($_GET['date']) && !empty($_GET['date']))
			{
				$date = pjUtil::formatDate($_GET['date'], $this->option_arr['o_date_format']);
				$wt_arr = pjAppController::getWorkingTime($date, $_GET['location_id'], $_GET['type']);
				$location_wt_arr = pjAppController::getLocationWT($date, $_GET['location_id'], $_GET['type']);
				$this->tpl['location_wt_arr'] = $location_wt_arr;
			} else {
				$wt_arr = array('start_hour' => 0, 'end_hour' => 23);
				$this->_set('p_time', '00:00');
				$this->_set('d_time', '00:00');
				$this->_set('ca_time', '00:00');
			}
			$this->tpl['date'] = $date;
			$this->tpl['wt_arr'] = $wt_arr;
		}
	}
	
	public function pjActionSetTypes()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['loadTypes']))
			{
				$this->_set('type', $_POST['type']);
				if($this->_is('external_delivery_id'))
				{
					$this->_unset('external_delivery_id');
				}
				if($_POST['type'] == 'delivery')
				{
					$this->_set('d_date', $_POST['d_date']);
					$this->_set('d_time', $_POST['d_time']);
					$this->_set('d_location_id', $_POST['d_location_id']);
					
					$this->_set('d_phone', isset($_POST['d_phone']) ? $_POST['d_phone'] : NULL);
					$this->_set('d_address_1', isset($_POST['d_address_1']) ? $_POST['d_address_1'] : NULL);
					$this->_set('d_address_2', isset($_POST['d_address_2']) ? $_POST['d_address_2'] : NULL);
					$this->_set('d_country_id', isset($_POST['d_country_id']) ? $_POST['d_country_id'] : NULL);
					$this->_set('d_state', isset($_POST['d_state']) ? $_POST['d_state'] : NULL);
					$this->_set('d_city', isset($_POST['d_city']) ? $_POST['d_city'] : NULL);
					$this->_set('d_zip', isset($_POST['d_zip']) ? $_POST['d_zip'] : NULL);
					$this->_set('d_notes', isset($_POST['d_notes']) ? $_POST['d_notes'] : NULL);
					$delivery = 0;
					if ($this->option_arr['o_allow_delivery_doordash'] == 'Yes') {
					    $date = pjUtil::formatDate($_POST['d_date'], $this->option_arr['o_date_format']);
					    $wt_arr = pjAppController::getWorkingTime($date, $_POST['d_location_id'], 'delivery');
					    $type_err = __('type_err', true, false);
					    $ts = time();
					    if (!$wt_arr)
					    {
					        pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $type_err[1]));
					    }
					    $start_time = strtotime($date . ' ' . $wt_arr['start_hour'] . ':' . $wt_arr['start_minutes'] . ':00');
					    $end_time = strtotime($date . ' ' . $wt_arr['end_hour'] . ':' . $wt_arr['end_minutes'] . ':00');					    
					    if($end_time < $start_time)
					    {
					        $end_time += 86400;
					    }
					    if ($ts < $start_time || $ts > $end_time) {
					        pjAppController::jsonResponse(array('status' => 'ERR', 'text' => sprintf($type_err[5], date($this->option_arr['o_time_format'], $start_time), date($this->option_arr['o_time_format'], $end_time))));
                        }
					    if ($end_time < $ts)
					    {
                        	pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $type_err[3]));
                        }
					    
						$restaurant_arr = pjRestaurantModel::factory()->select('t1.*, t2.content AS name')
							->join('pjMultiLang', "t2.model='pjRestaurant' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
							->find($this->getFrontRestaurantId())
							->getData();
							
						$dropoff_address_arr = array();
						if (isset($_POST['d_address_1']) && !empty($_POST['d_address_1'])) {
							$dropoff_address_arr[] = $_POST['d_address_1'];
						}
						if (isset($_POST['d_address_2']) && !empty($_POST['d_address_2'])) {
							$dropoff_address_arr[] = $_POST['d_address_2'];
						}
						if (isset($_POST['d_city']) && !empty($_POST['d_city'])) {
							$dropoff_address_arr[] = $_POST['d_city'];
						}
						if (isset($_POST['d_state']) && !empty($_POST['d_state'])) {
							$dropoff_address_arr[] = $_POST['d_state'];
						}
						if (isset($_POST['d_zip']) && !empty($_POST['d_zip'])) {
							$dropoff_address_arr[] = $_POST['d_zip'];
						}
						
						$FORM = isset($_SESSION[$this->defaultForm]) ? $_SESSION[$this->defaultForm] : array();
						$CLIENT = $this->isFrontLogged() && isset($_SESSION[$this->defaultClient]) ? $_SESSION[$this->defaultClient] : array();
						
						$data = array(
							"pickup_address"=> $restaurant_arr['address'],
							"pickup_business_name"=> $restaurant_arr['name'],
							"pickup_phone_number"=> $restaurant_arr['phone'],
							"dropoff_address"=> implode(', ', $dropoff_address_arr),
						    "dropoff_business_name"=> isset($FORM['c_name']) ? $FORM['c_name'] : (isset($CLIENT['c_name']) ? $CLIENT['c_name'] : ''),
							"dropoff_phone_number"=> $this->_get('d_phone'),
							"dropoff_instructions"=> $this->_get('d_notes'),
							"order_value"=> $this->_get('price') * 100
						);
						$delivery_quote_arr = pjAppController::doordashDeliveryQuote($data, $this->option_arr);
						if (isset($delivery_quote_arr['external_delivery_id'])) {
							$this->_set('external_delivery_id', $delivery_quote_arr['external_delivery_id']);
							$delivery = $delivery_quote_arr['fee'] > 0 ? ($delivery_quote_arr['fee']/100) : 0;
						} else {
							$errors_arr = array();
							if (isset($delivery_quote_arr['field_errors']) && $delivery_quote_arr['field_errors']) {
								foreach ($delivery_quote_arr['field_errors'] as $err) {
									$errors_arr[] = $err['error'];
								}
							} else if (isset($delivery_quote_arr['message'])) {
								$errors_arr[] = $delivery_quote_arr['message'];
							}
							pjAppController::jsonResponse(array('status' => 'ERR', 'text' => implode('<br/>', $errors_arr)));
						}
					} else {
						$arr = pjPriceModel::factory()
							->where('t1.location_id', $this->_get('d_location_id'))
							->where('t1.total_from <= ' . $this->_get('price'))
							->where('t1.total_to >= ' . $this->_get('price'))
							->limit(1)
							->findAll()
							->getData();
						if (count($arr) === 1)
						{
							$delivery = $arr[0]['price'];
						}
					}
					$this->_set('delivery', $delivery);
				} elseif($_POST['type'] == 'catering') {
					$this->_set('ca_date', $_POST['ca_date']);
					$this->_set('ca_time', $_POST['ca_time']);
					$this->_set('ca_location_id', $_POST['ca_location_id']);
					
					$this->_set('ca_address_1', isset($_POST['ca_address_1']) ? $_POST['ca_address_1'] : NULL);
					$this->_set('ca_address_2', isset($_POST['ca_address_2']) ? $_POST['ca_address_2'] : NULL);
					$this->_set('ca_country_id', isset($_POST['ca_country_id']) ? $_POST['ca_country_id'] : NULL);
					$this->_set('ca_state', isset($_POST['ca_state']) ? $_POST['ca_state'] : NULL);
					$this->_set('ca_city', isset($_POST['ca_city']) ? $_POST['ca_city'] : NULL);
					$this->_set('ca_zip', isset($_POST['ca_zip']) ? $_POST['ca_zip'] : NULL);
					$this->_set('ca_notes', isset($_POST['ca_notes']) ? $_POST['ca_notes'] : NULL);
				} else {
					$this->_set('p_location_id', $_POST['p_location_id']);
					$this->_set('p_date', $_POST['p_date']);
					$this->_set('p_time', $_POST['p_time']);
					$this->_set('p_notes', isset($_POST['p_notes']) ? $_POST['p_notes'] : NULL);
					if($this->_is('delivery'))
					{
						$this->_unset('delivery');
					}
				}
			}
			$this->_unset('voucher_code');
			$this->_unset('voucher_discount');
			$this->_unset('voucher_type');
		}
		pjAppController::jsonResponse(array('status' => 'OK', 'text' => ''));
	}
	
	public function pjActionCheckLogin()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjClientModel = pjClientModel::factory();
			
			$client = $pjClientModel
				->where('t1.c_email', $_POST['login_email'])
				->where(sprintf("t1.c_password = AES_ENCRYPT('%s', '%s')", pjObject::escapeString($_POST['login_password']), PJ_SALT))
				->limit(1)
				->findAll()
				->getData();

			$resp = array();	
			if (count($client) != 1)
			{
				$client = $pjClientModel
					->reset()
					->where('t1.c_email', $_POST['login_email'])
					->where('t1.restaurant_id', $_GET['rid'])
					->limit(1)
					->findAll()
					->getData();
				if (count($client) != 1)
				{
					$resp['code'] = 100;
				}else{
					$resp['code'] = 102;
				}
			}else{
				if ($client[0]['status'] != 'T')
				{
					$resp['code'] = 101;
				}else{
					$last_login = date("Y-m-d H:i:s");
	    			$_SESSION[$this->defaultClient] = $client[0];
	    			
	    			$data = array();
	    			$data['last_login'] = $last_login;
	    			$pjClientModel->reset()->setAttributes(array('id' => $client[0]['id']))->modify($data);
					$resp['code'] = 200;
				}
			}
			pjAppController::jsonResponse($resp);
		}
		exit;
	}
	
	public function pjActionSendPassword()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjClientModel = pjClientModel::factory();
			
			$client = $pjClientModel
				->where('t1.c_email', $_POST['email'])
				->where('t1.restaurant_id', $_GET['rid'])
				->limit(1)
				->findAll()
				->getData();

			$resp = array();	
			if (count($client) != 1)
			{
				$resp['code'] = 100;
			}else{
				if ($client[0]['status'] != 'T')
				{
					$resp['code'] = 101;
				}else{
					pjFront::pjActionConfirmSend($this->option_arr, $client[0], PJ_SALT, 'forgot');
					$resp['code'] = 200;
				}
			}
			pjAppController::jsonResponse($resp);
		}
		exit;
	}
	
	public function pjActionSaveForm()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_SESSION[$this->defaultForm]) || count($_SESSION[$this->defaultForm]) === 0)
			{
				$_SESSION[$this->defaultForm] = array();
			}
			$_POST['receive_sms_messages'] = isset($_POST['receive_sms_messages']) ? 1 : 0;
			$_SESSION[$this->defaultForm] = $_POST;
			
			$resp = array('code' => 200);
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionSaveOrder()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$cart = $this->_get('cart');
			
			$pjOrderModel = pjOrderModel::factory();
			
			$STORAGE = $_SESSION[$this->defaultStore];
			$FORM = $_SESSION[$this->defaultForm];
			
			$_SESSION[$this->defaultReorderStore] = $STORAGE;
			$_SESSION[$this->defaultReorderForm] = $FORM;
			
			$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
						
			$data = array();
			$tip_option = $this->_get('tip_option');
			$data['status'] = $this->option_arr['o_booking_status'];
			$data['price'] = $this->_get('price');
			$data['price_delivery'] = $this->_get('delivery');
			$data['discount'] = $this->_get('discount');
			$data['subtotal'] = $this->_get('subtotal');
			$data['tax'] = $this->_get('tax');
			$data['service_fee'] = $this->_is('service_fee') ? $this->_get('service_fee') : 0;
			$data['total'] = $this->_get('total');
			$data['tip_percentage'] = $tip_option == 1 ? $this->_get('tip_percentage') : '0';
			$data['tip_amount'] = $this->_get('tip_amount');
			$data['dasher_tip_amount'] = $this->_get('dasher_tip_amount');
			$data['tip_option'] = $this->_get('tip_option');
			$data['uuid'] = time();
			$data['ip'] = $_SERVER['REMOTE_ADDR'];
			$data['restaurant_id'] = $rid;
			$data['receive_sms_messages'] = isset($FORM['receive_sms_messages']) ? 1 : 0;
				
			switch ($this->_get('type'))
			{
				case 'pickup':
					if($this->_get('p_time') == 'asap')
					{
						$data['p_dt'] = pjUtil::formatDate($this->_get('p_date'), $this->option_arr['o_date_format']) . " " . date('H:i:s');
						$data['p_asap'] = "T";
					}else{
						if($this->_is('next_day'))
						{
							$data['p_dt'] = $this->_get('next_day');
						}else{
							
							$data['p_dt'] = pjUtil::formatDate($this->_get('p_date'), $this->option_arr['o_date_format']) . " " . pjUtil::formatTime($this->_get('p_time'), $this->option_arr['o_time_format']);;
						}
						$data['p_asap'] = "F";
					}
					unset($STORAGE['d_address_1']);
					unset($STORAGE['d_address_2']);
					unset($STORAGE['d_country_id']);
					unset($STORAGE['d_state']);
					unset($STORAGE['d_city']);
					unset($STORAGE['d_zip']);
					unset($STORAGE['d_notes']);
					unset($STORAGE['d_date']);
					unset($STORAGE['d_time']);
					
					unset($STORAGE['ca_address_1']);
					unset($STORAGE['ca_address_2']);
					unset($STORAGE['ca_country_id']);
					unset($STORAGE['ca_state']);
					unset($STORAGE['ca_city']);
					unset($STORAGE['ca_zip']);
					unset($STORAGE['ca_notes']);
					unset($STORAGE['ca_date']);
					unset($STORAGE['ca_time']);
					
					$data['location_id'] = $this->_get('p_location_id');
					break;
				case 'delivery':
				    if ($this->option_arr['o_allow_delivery_doordash'] == 'Yes') {
				        $data['d_dt'] = date('Y-m-d H:i:s');
				        $data['d_asap'] = "T";
				    } else {
    					if($this->_get('d_time') == 'asap')
    					{
    						$data['d_dt'] = pjUtil::formatDate($this->_get('d_date'), $this->option_arr['o_date_format']) . " " . date('H:i:s');
    						$data['d_asap'] = "T";
    					}else{
    						if($this->_is('next_day'))
    						{
    							$data['d_dt'] = $this->_get('next_day');
    						}else{
    							$data['d_dt'] = pjUtil::formatDate($this->_get('d_date'), $this->option_arr['o_date_format']) . " " . pjUtil::formatTime($this->_get('d_time'), $this->option_arr['o_time_format']);;
    						}
    						$data['d_asap'] = "F";
    					}
				    }
					$data['location_id'] = $this->_get('d_location_id');
					unset($STORAGE['p_date']);
					unset($STORAGE['p_time']);
					unset($STORAGE['p_notes']);
					
					unset($STORAGE['ca_address_1']);
					unset($STORAGE['ca_address_2']);
					unset($STORAGE['ca_country_id']);
					unset($STORAGE['ca_state']);
					unset($STORAGE['ca_city']);
					unset($STORAGE['ca_zip']);
					unset($STORAGE['ca_notes']);
					unset($STORAGE['ca_date']);
					unset($STORAGE['ca_time']);
					
					break;
				case 'catering':
					if($this->_get('ca_time') == 'asap')
					{
						$data['ca_dt'] = pjUtil::formatDate($this->_get('ca_date'), $this->option_arr['o_date_format']) . " " . date('H:i:s');
						$data['ca_asap'] = "T";
					}else{
						if($this->_is('next_day'))
						{
							$data['ca_dt'] = $this->_get('next_day');
						}else{
							$data['ca_dt'] = pjUtil::formatDate($this->_get('ca_date'), $this->option_arr['o_date_format']) . " " . pjUtil::formatTime($this->_get('ca_time'), $this->option_arr['o_time_format']);;
						}
						$data['ca_asap'] = "F";
					}
					$data['location_id'] = $this->_get('ca_location_id');
                                        
                                        if ($STORAGE['subtotal'] >= (float) $this->option_arr['o_catering_total']) {
                                            $data['catering_fee'] = (float) $this->option_arr['o_catering_fee_percent'] * $STORAGE['subtotal'] / 100;
                                        }
                                        else {
                                            $data['catering_fee'] = (float) $this->option_arr['o_catering_fee'];
                                        }
                                        
					
					unset($STORAGE['p_date']);
					unset($STORAGE['p_time']);
					unset($STORAGE['p_notes']);
					
					unset($STORAGE['d_address_1']);
					unset($STORAGE['d_address_2']);
					unset($STORAGE['d_country_id']);
					unset($STORAGE['d_state']);
					unset($STORAGE['d_city']);
					unset($STORAGE['d_zip']);
					unset($STORAGE['d_notes']);
					unset($STORAGE['d_date']);
					unset($STORAGE['d_time']);
					
					break;
			}
			
			unset($STORAGE['cart']);
			unset($STORAGE['subtotal']);
			unset($STORAGE['total']);
			unset($STORAGE['delivery']);
			
			$payment = 'none';
			if(isset($FORM['payment_method']))
			{
				if (!$FORM['payment_method'] == 'creditcard')
				{
					unset($FORM['cc_type']);
					unset($FORM['cc_num']);
					unset($FORM['cc_exp']);
					unset($FORM['cc_code']);
				}
				$payment = $FORM['payment_method'];
			}
			
			$recheck_values = array(
				'location_id',
				'type'
			);
			switch ($this->_get('type'))
			{
				case 'pickup':
					$recheck_values[] = 'p_date';
					break;
				case 'delivery':
					$recheck_values[] = 'd_date';
					break;
				case 'catering':
					$recheck_values[] = 'ca_date';
					break;
			}
			$data_check = array_merge($STORAGE, $FORM, $data);
			foreach ($recheck_values as $k) {
				if (!isset($data_check[$k]) || (isset($data_check[$k]) && empty($data_check[$k]))) {
					$front_messages = __('front_messages', true, false);
					$system_msg = str_replace("[STAG]", "<a href='#' class='fdStartOver'>", $front_messages[14]);
					$system_msg = str_replace("[ETAG]", "</a>", $system_msg); 
					pjAppController::jsonResponse(array('code' => 101, 'text' => $system_msg));
				}
			}
			
			$is_new_client = false;
			$update_client = false;
			$pjClientModel = pjClientModel::factory();
			$data['client_id'] = ':NULL';
			if($this->isFrontLogged())
			{
				$cnt = $pjClientModel
					->where('t1.id', $this->getClientId())
					->findCount()
					->getData();
				if($cnt == 0)
				{
					$is_new_client = true;
				}else{
					$update_client = true;
				}
			}else{
				$is_new_client = true;
			}
			if($is_new_client == true)
			{
				$c_data = array();
				$c_data['status'] = 'T';
				$c_data['c_password'] = $FORM['c_password'];
				$c_data['restaurant_id'] = $rid;
				$c_data = array_merge($FORM, $c_data);
				$client_id = $pjClientModel
					->reset()
					->setAttributes($c_data)
					->insert()
					->getInsertId();
				if ($client_id !== false && (int) $client_id > 0)
				{
					$data['client_id'] = $client_id;
					if($this->isFrontLogged())
					{
						$client = $pjClientModel
							->reset()
							->find($client_id)
							->getData();
						unset($_SESSION[$this->defaultClient]);
						$_SESSION[$this->defaultClient] = $client;
					}
					pjFront::pjActionConfirmSend($this->option_arr, $c_data, PJ_SALT, 'account');
				}
			}
			if($update_client == true)
			{
				if(isset($FORM['update_address']))
				{
					$c_data = array();
					if(isset($FORM['c_address_1']))
					{
						$c_data['c_address_1'] = $FORM['c_address_1'];
					}
					if(isset($FORM['c_address_2']))
					{
						$c_data['c_address_1'] = $FORM['c_address_1'];
					}
					if(isset($FORM['c_country']))
					{
						$c_data['c_country'] = $FORM['c_country'];
					}
					if(isset($FORM['c_state']))
					{
						$c_data['c_state'] = $FORM['c_state'];
					}
					if(isset($FORM['c_city']))
					{
						$c_data['c_city'] = $FORM['c_city'];
					}
					if(isset($FORM['c_zip']))
					{
						$c_data['c_zip'] = $FORM['c_zip'];
					}
					$pjClientModel
						->reset()
						->where('id', $this->getClientId())
						->limit(1)
						->modifyAll($c_data);
				}
				if(isset($FORM['update_details']))
				{
					$c_data = array();
					if(isset($FORM['c_title']))
					{
						$c_data['c_title'] = $FORM['c_title'];
					}
					if(isset($FORM['c_name']))
					{
						$c_data['c_name'] = $FORM['c_name'];
					}
					if(isset($FORM['c_email']))
					{
						$c_data['c_email'] = $FORM['c_email'];
					}
					if(isset($FORM['c_phone']))
					{
						$c_data['c_phone'] = $FORM['c_phone'];
					}
					if(isset($FORM['c_company']))
					{
						$c_data['c_company'] = $FORM['c_company'];
					}
					if(isset($FORM['c_notes']))
					{
						$c_data['c_notes'] = $FORM['c_notes'];
					}
					$pjClientModel
						->reset()
						->where('id', $this->getClientId())
						->limit(1)
						->modifyAll($c_data);
				}
									
				$client = $pjClientModel
					->reset()
					->find($this->getClientId())
					->getData();
				unset($_SESSION[$this->defaultClient]);
				$_SESSION[$this->defaultClient] = $client;
				
				$data['client_id'] = $this->getClientId();
			}
			$data = array_merge($STORAGE, $FORM, $data);
			if ($data['type'] == 'delivery' && $this->option_arr['o_allow_delivery_doordash'] == 'Yes') {
				$external_delivery_id = $this->_is('external_delivery_id') ? $this->_get('external_delivery_id') : '';
				if (!empty($external_delivery_id)) {
					$data['is_dashdoor_delivery'] = 1;
					$data['external_delivery_id'] = $external_delivery_id;
				}
			}
			$order_id = $pjOrderModel
				->setAttributes($data)
				->insert()
				->getInsertId();
			if ($order_id !== false && (int) $order_id > 0)
			{
				$pjOrderItemModel = pjOrderItemModel::factory();
				$pjProductPriceModel = pjProductPriceModel::factory();
				$pjProductModel = pjProductModel::factory();
				$pjExtraModel = pjExtraModel::factory();
				$pjModifierItemModel = pjModifierItemModel::factory();
				
				foreach ($cart as $item)
				{
					$price_id = ':NULL';
					$price = 0;
					if(!empty($item['price_id']))
					{
						$price_arr = $pjProductPriceModel->find($item['price_id'])->getData();
						if($price_arr)	
						{		
							$price_id = $price_arr['id'];
							$price = $price_arr['price'];
						}
					}else{
						$price_arr = $pjProductModel->reset()->find($item['product_id'])->getData();
						if(!empty($price_arr))	
						{
							$price = $price_arr['price'];
						}
					}
					
					$hash = md5(uniqid(rand(), true));
					$oid = $pjOrderItemModel
						->reset()
						->setAttributes(array(
							'order_id' => $order_id,
							'foreign_id' => $item['product_id'],
							'type' => 'product',
							'price_id' => $price_id,
							'price' => $price,
							'hash' => $hash,
							'cnt' => $item['cnt']))
						->insert();
					foreach ($item['extras'] as $extra_id => $extra_cnt)
					{
						if ($extra_cnt > 0)
						{
							$extra_price = 0;
							$extra_arr = $pjExtraModel
								->reset()
								->find($extra_id)
								->getData();
							if(!empty($extra_arr) && !empty($extra_arr['price']))
							{
								$extra_price = $extra_arr['price'];
							}
							$pjOrderItemModel
								->reset()
								->setAttributes(array(
									'order_id' => $order_id,
									'foreign_id' => $extra_id,
									'type' => 'extra',
									'price_id' => ':NULL',
									'price' => $extra_price,
									'hash' => $hash,
									'cnt' => $extra_cnt))
								->insert();
						}
					}
					
					if (isset($item['group_items'])) {
						foreach ($item['group_items'] as $group_id => $group_item_id)
						{
							$pjOrderItemModel
									->reset()
									->setAttributes(array(
										'order_id' => $order_id,
										'foreign_id' => $group_item_id,
										'type' => 'group',
										'price_id' => ':NULL',
										'price' => ':NULL',
										'hash' => $hash,
										'cnt' => 1))
									->insert();
						}
					}
					
					if (isset($item['modifier_items'])) {
						foreach ($item['modifier_items'] as $modifier_id => $modifier_items)
						{
							foreach ($modifier_items as $mid) {
								$item_arr = $pjModifierItemModel->reset()->find($mid)->getData();
								$pjOrderItemModel
										->reset()
										->setAttributes(array(
											'order_id' => $order_id,
											'foreign_id' => $mid,
											'type' => 'modifier_item',
											'price_id' => ':NULL',
											'price' => $item_arr['price'],
											'hash' => $hash,
											'cnt' => 1))
										->insert();
							}
						}
					}
				}
				
				$order_arr = $pjOrderModel
					->reset()
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
							AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
							AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
							AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
							AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
					->find($order_id)
					->getData();
				
				$pdata = array();
				$pdata['order_id'] = $order_id;
				$pdata['payment_method'] = $payment;
				$pdata['payment_type'] = 'online';
				$pdata['amount'] = $order_arr['total'];
				$pdata['status'] = 'notpaid'; 
				pjOrderPaymentModel::factory()->setAttributes($pdata)->insert();

				/*Khuetech bổ sung nmipay*/
				if ($order_arr['payment_method'] != 'usaepay' && $order_arr['payment_method'] != 'nmipay') {
    				pjAppController::addOrderDetails($order_arr, $this->getLocaleId());				
    				pjFront::pjActionConfirmSend($this->option_arr, $order_arr, PJ_SALT, 'confirm');
				}
				unset($_SESSION[$this->defaultStore]);
				unset($_SESSION[$this->defaultForm]);
				unset($_SESSION[$this->defaultCaptcha]);
								
				$json = array('code' => 200, 'text' => '', 'order_id' => $order_id, 'payment' => $payment);
			}else{
				$json = array('code' => 100, 'text' => '');
			}
			
			pjAppController::jsonResponse($json);
		}
	}
	
	public function pjActionGetPaymentForm()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$pjOrderModel = pjOrderModel::factory();
			
			$arr = $pjOrderModel
				->select("t1.*,
					AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
					AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
					AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
					AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`
				")
				->find($_GET['order_id'])
				->getData();
			
			$item_arr = pjOrderItemModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.foreign_id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->select('t1.*, t2.content as name')
				->where('t1.order_id', $_GET['order_id'])
				->where('t1.type', 'product')
				->findAll()
				->getData();
			$_arr = array();
			foreach($item_arr as $v)
			{
				$_arr[] = stripslashes($v['name']);
			}
			$arr['product_name'] = !empty($_arr) ? join("; ", $_arr) : null;	
				
			switch ($arr['payment_method'])
			{
				case 'paypal':
					$this->set('params', array(
						'name' => 'fdPaypal',
						'id' => 'fdPaypal',
						'business' => $this->option_arr['o_paypal_address'],
						'item_name' => $arr['product_name'],
						'custom' => $arr['id'],
						'amount' => number_format($arr['total'], 2, '.', ''),
						'currency_code' => $this->option_arr['o_currency'],
						'return' => PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionThankyou&rid='.$arr['restaurant_id'].'&id='.$arr['id'],
						'notify_url' => PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionConfirmPaypal&rid='.$arr['restaurant_id'],
						'target' => '_self',
						'charset' => 'utf-8'
					));
					break;
				case 'authorize':
					$this->set('params', array(
						'name' => 'fdAuthorize',
						'id' => 'fdAuthorize',
						'target' => '_self',
						'timezone' => $this->option_arr['o_authorize_timezone'],
						'public_key' => $this->option_arr['o_authorize_transkey'],
						'private_key' => $this->option_arr['o_authorize_md5_hash'],
						'merchant_id' => $this->option_arr['o_authorize_merchant_id'],
						'is_test_mode' => PJ_TEST_MODE,
						'amount' => number_format($arr['total'], 2, '.', ''),
						'custom' => $arr['uuid'],
						'description' => $arr['product_name'],					
						'currency_code' => $this->option_arr['o_currency'],						
						'cancel_url' => PJ_INSTALL_URL . 'payments_webhook.php?payment_method=authorize|rid='.$arr['restaurant_id'].'|type=cancel|x_invoice_num='.$arr['uuid'],
						'notify_url' => PJ_INSTALL_URL . 'payments_webhook.php?payment_method=authorize|rid='.$arr['restaurant_id'].'|type=notify|x_invoice_num='.$arr['uuid']
					));
					break;
				case 'usaepay':
					$client_arr = pjClientModel::factory()->find($arr['client_id'])->getData();
					USAePay\API::setAuthentication($this->option_arr['o_usaepay_apikey'], $this->option_arr['o_usaepay_apipin']);
					if (PJ_TEST_MODE) {
						$subdomain_value = 'sandbox';
					} else {
						$subdomain_value = 'secure';
					}
					USAePay\API::setSubdomain($subdomain_value);
					if ($arr['type'] == 'pickup') {
						$comments = $arr['p_notes'];
					} elseif ($arr['type'] == 'delivery') {
						$comments = $arr['d_notes'];
					} else {
						$comments = $arr['ca_notes'];
					}
					$admin_email = $this->getAdminEmail();
					$shipping = $arr['price_delivery'] + $arr['catering_fee'] + $arr['service_fee'];
					$request = array(
						"command" => "sale",
					    "invoice" => $arr['uuid'],
					    "ponum" => $arr['id'],
					    "description" => $arr['product_name'],
					    "comments" => $comments,
					    "email" => $client_arr['c_email'],
					    "send_receipt" => "1",
					    "ignore_duplicate" => "1",
					    "merchemailaddr" => $admin_email,
					    "amount" => $arr['total'],
						"amount_detail" => array(
							"subtotal" => $arr['price'],
					        "tax" => $arr['tax'],
					        "tip" => $arr['tip_amount'],
					        "discount" => $arr['discount'],
					        "shipping" => $shipping,
						),
						"creditcard" => array(
							"cardholder" => $client_arr['c_name'],
					        "number" => $arr['cc_num'],
					        "expiration" => str_replace('/', '', $arr['cc_exp']),
					        "cvc" => $arr['cc_code'],
					        "avs_street" => $client_arr['c_address_1'].' '.$client_arr['c_address_2'],
					        "avs_zip" => $client_arr['c_zip']
						)
					);			
					$response = USAePay\Transactions::post($request);
					if (!is_array($response)) {
						$response = json_decode(json_encode($response), true);
					}
					if (isset($response['status']) && $response['status'] == 'ERR') {
						$this->set('status', 'ERR');
					} else {
						if (isset($response['result_code']) && $response['result_code'] == 'A') {
							$this->log('Booking confirmed');
							$pjOrderModel->reset()->setAttributes(array('id' => $arr['id']))->modify(array(
								'status' => $this->option_arr['o_payment_status'],
								'is_paid' => 1,
								'txn_id' => $response['refnum'],
								'processed_on' => ':NOW()'
							));
							pjOrderPaymentModel::factory()
								->where('order_id', $arr['id'])
								->where('payment_type', 'online')
								->limit(1)
								->modifyAll(array('status' => 'paid'));
								
							if ($arr['is_dashdoor_delivery'] == 1 && !empty($arr['external_delivery_id'])) {
								$delivery_status_arr = pjAppController::doordashAcceptDeliveryQuote($arr['external_delivery_id'], $this->option_arr);
								$data_update = array(
									'dasher_name' => @$delivery_status_arr['dasher_name'],
									'dasher_dropoff_phone_number' => @$delivery_status_arr['dasher_dropoff_phone_number'],
									'dasher_pickup_phone_number' => @$delivery_status_arr['dasher_pickup_phone_number'],
									'dasher_vehicle_make' => @$delivery_status_arr['dasher_vehicle_make'],
									'dasher_vehicle_model' => @$delivery_status_arr['dasher_vehicle_model'],
									'dasher_vehicle_year' => @$delivery_status_arr['dasher_vehicle_year']
								);
								$pjOrderModel->reset()->set('id', $arr['id'])->modify($data_update);
							}
							
							$order_arr = $pjOrderModel->reset()
								->join('pjClient', "t2.id=t1.client_id", 'left outer')
								->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
										AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
										AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
										AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
										AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
								->find($arr['id'])
								->getData();
							
							pjAppController::addOrderDetails($order_arr, $this->getLocaleId());
							pjFront::pjActionConfirmSend($this->option_arr, $order_arr, PJ_SALT, 'confirm');
							pjFront::pjActionConfirmSend($this->option_arr, $order_arr, PJ_SALT, 'payment');
							if ($this->option_arr['o_allow_automatic_print'] == 'Yes') {
								pjFront::sendToRemotePrinter($order_arr['id'], $this->getLocaleId(), $this->option_arr);
							}
							
						} else {
							$this->set('status', 'ERR');
						}
					}
					break;

                case 'nmipay': /*Khuetech add case nmipay */
                    $client_arr = pjClientModel::factory()->find($arr['client_id'])->getData();
                    $gw = new gwapi;

                    $gw->setLogin($this->option_arr['o_nmipay_apikey']);
                    $gw->setBilling($client_arr['c_title'],$client_arr['c_name'],$client_arr['c_company'],$client_arr['c_address_1'],$client_arr['c_address_2'], $client_arr['c_city'], $client_arr['c_state'], $client_arr['c_zip'],$client_arr['c_country'],$client_arr['c_phone'],$client_arr['c_phone'],$client_arr['c_email'],"");
                    $gw->setShipping($client_arr['c_title'],$client_arr['c_name'],$client_arr['c_company'],$client_arr['c_address_1'],$client_arr['c_address_2'], $client_arr['c_city'], $client_arr['c_state'], $client_arr['c_zip'],$client_arr['c_country'],$client_arr['c_email']);
                    $gw->setOrder($arr['uuid'], $arr['product_name'],0.00 , 0.00, $arr['id'], $gw->get_client_ip());

                    $status = $gw->doSale($arr['total'],$arr['cc_num'],str_replace('/', '', $arr['cc_exp']), $arr['cc_code']);
                    if($status==1) {
                        $pjOrderModel->reset()->setAttributes(array('id' => $arr['id']))->modify(array(
                            'status' => $this->option_arr['o_payment_status'],
                            'is_paid' => 1,
                            'txn_id' => $gw->responses['transactionid'],
                            'processed_on' => ':NOW()'
                        ));
                        pjOrderPaymentModel::factory()
                            ->where('order_id', $arr['id'])
                            ->where('payment_type', 'online')
                            ->limit(1)
                            ->modifyAll(array('status' => 'paid'));

                        if ($arr['is_dashdoor_delivery'] == 1 && !empty($arr['external_delivery_id'])) {
                            $delivery_status_arr = pjAppController::doordashAcceptDeliveryQuote($arr['external_delivery_id'], $this->option_arr);
                            $data_update = array(
                                'dasher_name' => @$delivery_status_arr['dasher_name'],
                                'dasher_dropoff_phone_number' => @$delivery_status_arr['dasher_dropoff_phone_number'],
                                'dasher_pickup_phone_number' => @$delivery_status_arr['dasher_pickup_phone_number'],
                                'dasher_vehicle_make' => @$delivery_status_arr['dasher_vehicle_make'],
                                'dasher_vehicle_model' => @$delivery_status_arr['dasher_vehicle_model'],
                                'dasher_vehicle_year' => @$delivery_status_arr['dasher_vehicle_year']
                            );
                            $pjOrderModel->reset()->set('id', $arr['id'])->modify($data_update);
                        }

                        $order_arr = $pjOrderModel->reset()
                            ->join('pjClient', "t2.id=t1.client_id", 'left outer')
                            ->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
										AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
										AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
										AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
										AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
                            ->find($arr['id'])
                            ->getData();

                        pjAppController::addOrderDetails($order_arr, $this->getLocaleId());
                        pjFront::pjActionConfirmSend($this->option_arr, $order_arr, PJ_SALT, 'confirm');
                        pjFront::pjActionConfirmSend($this->option_arr, $order_arr, PJ_SALT, 'payment');
                        if ($this->option_arr['o_allow_automatic_print'] == 'Yes') {
                            pjFront::sendToRemotePrinter($order_arr['id'], $this->getLocaleId(), $this->option_arr);
                        }
                    }else{
                        $this->set('status', 'ERR');
                    }
                    break;
                    /*End Khuetech*/
			}
			
			$this->set('arr', $arr);
			$this->set('get', $_GET);
		}
	}
	
	public function log($content, $filename='')
	{
		if (true)
		{
			$filename = 'payment.log';
			file_put_contents($filename, $content . "\n", FILE_APPEND|FILE_TEXT);
		}		
	}	
	
	public function pjActionConfirmAuthorize()
	{
		$this->setAjax(true);
		
		$this->log(''); $this->log(''); $this->log('');
		$this->log('Authorize.net '.date("Y-m-d H:i:s"));
		$req = '';
		foreach ($_REQUEST as $key => $value) {
			$value = urlencode(stripslashes($value));
			$req .= "&$key=$value";
		}
		$this->log($req);
		
		if (pjObject::getPlugin('pjAuthorize') === NULL)
		{
			$this->log('Authorize.NET plugin not installed');
			exit;
		}
		
		$pjOrderModel = pjOrderModel::factory();
		
		$arr = $pjOrderModel
			->join('pjClient', "t2.id=t1.client_id", 'left outer')
			->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
					AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
					AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
					AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
					AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
			->where('t1.uuid', $_REQUEST['x_invoice_num'])
			->limit(1)
			->findAll()
			->getDataIndex(0);							
			
		$this->log(implode(",",$arr));
		if (!$arr)
		{
			$this->log('No such booking');
			echo $this->option_arr['o_thankyou_page'];
	        exit;
		}					
		
		if ($_REQUEST['type'] == 'cancel') {
			echo PJ_INSTALL_URL . 'index.php?controller=pjFront&action=pjActionThankyou&rid='.$arr['restaurant_id'].'&id='.$arr['id'];
	        exit;
		}
		
		$params = array(
			'request' => $_REQUEST,
			'merchant_id' => $this->option_arr['o_authorize_merchant_id'],
			'public_key' => $this->option_arr['o_authorize_transkey'],
			'private_key' => $this->option_arr['o_authorize_md5_hash'],
			'sandbox' => PJ_TEST_MODE,
			'key' => md5(PJ_SALT)
		);
		
		$response = $this->requestAction(array('controller' => 'pjAuthorize', 'action' => 'pjActionConfirm', 'params' => $params), array('return'));
		ob_start();
		var_dump($response);
		$content = ob_get_contents();
		ob_end_clean();
		
		$this->log('Response: '. $content);
		
		if ($response !== FALSE && $response['status'] === 'OK')
		{
			$pjOrderModel->reset()
				->set('id', $arr['id'])
				->modify(array('status' => $this->option_arr['o_payment_status'], 'txn_id' => $response['txn_id'], 'is_paid' => 1, 'processed_on' => ':NOW()'));

			pjOrderPaymentModel::factory()
				->where('order_id', $arr['id'])
				->where('payment_type', 'online')
				->limit(1)
				->modifyAll(array('status' => 'paid'));
				
			if ($arr['is_dashdoor_delivery'] == 1 && !empty($arr['external_delivery_id'])) {
				$delivery_status_arr = pjAppController::doordashAcceptDeliveryQuote($arr['external_delivery_id'], $this->option_arr);
				$data_update = array(
					'dasher_name' => @$delivery_status_arr['dasher_name'],
					'dasher_dropoff_phone_number' => @$delivery_status_arr['dasher_dropoff_phone_number'],
					'dasher_pickup_phone_number' => @$delivery_status_arr['dasher_pickup_phone_number'],
					'dasher_vehicle_make' => @$delivery_status_arr['dasher_vehicle_make'],
					'dasher_vehicle_model' => @$delivery_status_arr['dasher_vehicle_model'],
					'dasher_vehicle_year' => @$delivery_status_arr['dasher_vehicle_year']
				);
				$pjOrderModel->reset()->set('id', $arr['id'])->modify($data_update);
			}
			
			$order_arr = $pjOrderModel->reset()
				->join('pjClient', "t2.id=t1.client_id", 'left outer')
				->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
						AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
						AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
						AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
						AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
				->find($arr['id'])->getData();	
				
			pjAppController::addOrderDetails($order_arr, $this->getLocaleId());
			pjFront::pjActionConfirmSend($this->option_arr, $order_arr, PJ_SALT, 'payment');
			
			$this->log('Payment confirmed '.$order_arr['id']);				
			if ($this->option_arr['o_allow_automatic_print'] == 'Yes') {
				pjFront::sendToRemotePrinter($order_arr['id'], $this->getLocaleId(), $this->option_arr);
			}
		} elseif (!$response) {
			$this->log('Authorization failed');
		} else {
			$this->log('Booking not confirmed. ' . $response['response_reason_text']);
		}
		echo $this->option_arr['o_thankyou_page'];
        exit;
	}

	public function pjActionConfirmPaypal()
	{
		$this->setAjax(true);
		
		if (pjObject::getPlugin('pjPaypal') === NULL)
		{
			$this->log('Paypal plugin not installed');
			exit;
		}
		$pjOrderModel = pjOrderModel::factory();
		
		$arr = $pjOrderModel
			->join('pjClient', "t2.id=t1.client_id", 'left outer')
			->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
					AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
					AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
					AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
					AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
			->find($_REQUEST['custom'])
			->getData();
		if (count($arr) == 0)
		{
			$this->log('No such booking');
			pjUtil::redirect($this->option_arr['o_thankyou_page']);
		}
		$params = array(
			'txn_id' => @$arr['txn_id'],
			'paypal_address' => $this->option_arr['o_paypal_address'],
			'deposit' => @$arr['total'],
			'currency' => $this->option_arr['o_currency'],
			'key' => md5($this->option_arr['private_key'] . PJ_SALT)
		);
		$response = $this->requestAction(array('controller' => 'pjPaypal', 'action' => 'pjActionConfirm', 'params' => $params), array('return'));
		
		if ($response !== FALSE && $response['status'] === 'OK')
		{
			$this->log('Booking confirmed');
			$pjOrderModel->reset()->setAttributes(array('id' => $arr['id']))->modify(array(
				'status' => $this->option_arr['o_payment_status'],
				'is_paid' => 1,
				'txn_id' => $response['transaction_id'],
				'processed_on' => ':NOW()'
			));
			pjOrderPaymentModel::factory()->setAttributes(array('order_id' => $arr['id'], 'payment_type' => 'online'))
											->modify(array('status' => 'paid'));
			
			if ($arr['is_dashdoor_delivery'] == 1 && !empty($arr['external_delivery_id'])) {
				$delivery_status_arr = pjAppController::doordashAcceptDeliveryQuote($arr['external_delivery_id'], $this->option_arr);
				$data_update = array(
					'dasher_name' => @$delivery_status_arr['dasher_name'],
					'dasher_dropoff_phone_number' => @$delivery_status_arr['dasher_dropoff_phone_number'],
					'dasher_pickup_phone_number' => @$delivery_status_arr['dasher_pickup_phone_number'],
					'dasher_vehicle_make' => @$delivery_status_arr['dasher_vehicle_make'],
					'dasher_vehicle_model' => @$delivery_status_arr['dasher_vehicle_model'],
					'dasher_vehicle_year' => @$delivery_status_arr['dasher_vehicle_year']
				);
				$pjOrderModel->reset()->set('id', $arr['id'])->modify($data_update);
			}
											
			$order_arr = $pjOrderModel->reset()
				->join('pjClient', "t2.id=t1.client_id", 'left outer')
				->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
						AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
						AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
						AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
						AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
				->find($arr['id'])
				->getData();
			
			pjAppController::addOrderDetails($order_arr, $this->getLocaleId());
			pjFront::pjActionConfirmSend($this->option_arr, $order_arr, PJ_SALT, 'payment');
			if ($this->option_arr['o_allow_automatic_print'] == 'Yes') {
				pjFront::sendToRemotePrinter($order_arr['id'], $this->getLocaleId(), $this->option_arr);
			}
		} elseif (!$response) {
			$this->log('Authorization failed');
		} else {
			$this->log('Booking not confirmed');
		}
		pjUtil::redirect($this->option_arr['o_thankyou_page']);
	}	

	public function pjActionConfirmSend($option_arr, $data, $salt, $opt)
	{
		$Email = new pjEmail();
		if ($option_arr['o_send_email'] == 'smtp')
		{
			$Email
				->setTransport('smtp')
				->setSmtpHost($option_arr['o_smtp_host'])
				->setSmtpPort($option_arr['o_smtp_port'])
				->setSmtpUser($option_arr['o_smtp_user'])
				->setSmtpPass($option_arr['o_smtp_pass'])
			;
		}
		$Email->setContentType('text/html');
		
		$pjMultiLangModel = pjMultiLangModel::factory();
		
		$admin_email = $this->getAdminEmail();
		if (!empty($option_arr['o_notification_phone_number'])) {
			$admin_phone = $option_arr['o_notification_phone_number'];
		} else {
			$admin_phone = $this->getAdminPhone();
		}
		$from_email = $admin_email;
		if(!empty($option_arr['o_sender_email']))
		{
			$from_email = $option_arr['o_sender_email'];
		}
		
		$locale_id = isset($booking_arr['locale_id']) && (int) $booking_arr['locale_id'] > 0 ? (int) $booking_arr['locale_id'] : $this->getLocaleId();
		
		if($opt == 'account' || $opt == 'forgot')
		{
			$tokens = pjAppController::getClientTokens($option_arr, $data, PJ_SALT, $this->getLocaleId());
			
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_'.$opt.'_message')
				->where('t1.foreign_id', $this->getFrontRestaurantId())
				->limit(0, 1)
				->findAll()
				->getData();
			$lang_subject = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_'.$opt.'_subject')
				->where('t1.foreign_id', $this->getFrontRestaurantId())
				->limit(0, 1)
				->findAll()
				->getData();
				
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
				$Email
					->setTo($data['c_email'])
					->setFrom($from_email)
					->setSubject($lang_subject[0]['content'])
					->send(pjUtil::textToHtml($message));
			}
		}else{
			$tokens = pjAppController::getTokens($option_arr, $data, PJ_SALT, $this->getLocaleId());
			
			if ($opt == 'confirm')
			{
				if ($option_arr['o_email_confirmation'] == 1) {
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_email_confirmation_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					$lang_subject = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_email_confirmation_subject')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
								   
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if ($data['type'] == 'delivery')
						{
							$message = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						} elseif ($data['type'] == 'catering') {
							$message = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $message);
						} else {
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						}
						
						$message = str_replace($tokens['search'], $tokens['replace'], $message);
						
						$Email
							->setTo($data['c_email'])
							->setFrom($from_email)
							->setSubject($lang_subject[0]['content'])
							->send(pjUtil::textToHtml($message));
					}
				}
				if(!empty($data['c_phone']) && $data['receive_sms_messages'] == 1)
				{
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_sms_confirmation_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					if (count($lang_message) === 1)
					{
						$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
						if ($this->smsServiceProvider == 'clicksend') {
							$config = ClickSend\Configuration::getDefaultConfiguration()
							              ->setUsername(@$option_arr['plugin_sms_api_username'])
							              ->setPassword(@$option_arr['plugin_sms_api_password']);							
							$apiInstance = new ClickSend\Api\SMSApi(new GuzzleHttp\Client(),$config);
							$msg = new \ClickSend\Model\SmsMessage();
							$msg->setBody($message); 
							$msg->setTo($data['c_phone']);
							$msg->setSource("sdk");
							$sms_messages = new \ClickSend\Model\SmsMessageCollection(); 
							$sms_messages->setMessages([$msg]);							
							try {
							    $result = $apiInstance->smsSendPost($sms_messages);	
								$resp = json_decode($result, true);
							    pjSmsModel::factory()->reset()->setAttributes(array(
									'number' => $data['c_phone'],
									'text' => $message,
									'provider' => 'clicksend',
							    	'restaurant_id' => @$data['restaurant_id'],
									'status' => @$resp['response_code']
								))->insert();
							} catch (Exception $e) {
							    //echo 'Exception when calling SMSApi->smsSendPost: ', $e->getMessage(), PHP_EOL;
							}
						} else {
							$params = array(
								'text' => $message,
								'type' => 'unicode',
								'restaurant_id' => @$data['restaurant_id'],
								'key' => md5(@$option_arr['private_key'] . PJ_SALT)
							);
							$params['number'] = $data['c_phone'];
							$params['provider'] = $this->smsServiceProvider;
							$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
						}
					}
				}
				
				if ($option_arr['o_admin_email_confirmation'] == 1) {
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_admin_email_confirmation_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					$lang_subject = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_admin_email_confirmation_subject')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
								   
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if ($data['type'] == 'delivery')
						{
							$message = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						} elseif ($data['type'] == 'catering') {
							$message = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $message);
						} else {
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						}
						$message = str_replace($tokens['search'], $tokens['replace'], $message);
						if (!empty($option_arr['o_second_notification_email'])) {						
							$Email->setCc($option_arr['o_second_notification_email']);					
						}
						$Email
							->setTo($admin_email)
							->setFrom($from_email)
							->setSubject($lang_subject[0]['content'])
							->send(pjUtil::textToHtml($message));
					}
				}
				if(!empty($admin_phone))
				{
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_admin_sms_confirmation_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					if (count($lang_message) === 1)
					{
						$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
						if ($this->smsServiceProvider == 'clicksend') {
							$config = ClickSend\Configuration::getDefaultConfiguration()
							              ->setUsername($option_arr['plugin_sms_api_username'])
							              ->setPassword($option_arr['plugin_sms_api_password']);							
							$apiInstance = new ClickSend\Api\SMSApi(new GuzzleHttp\Client(),$config);
							$msg = new \ClickSend\Model\SmsMessage();
							$msg->setBody($message); 
							$msg->setTo($admin_phone);
							$msg->setSource("sdk");
							$sms_messages = new \ClickSend\Model\SmsMessageCollection(); 
							$sms_messages->setMessages([$msg]);							
							try {
							    $result = $apiInstance->smsSendPost($sms_messages);		
							    $resp = json_decode($result, true);
							    pjSmsModel::factory()->reset()->setAttributes(array(
									'number' => $admin_phone,
									'text' => $message,
									'provider' => 'clicksend',
							    	'restaurant_id' => @$data['restaurant_id'],
									'status' => @$resp['response_code']
								))->insert();					    
							} catch (Exception $e) {
							    //echo 'Exception when calling SMSApi->smsSendPost: ', $e->getMessage(), PHP_EOL;
							}
						} else {
							$params = array(
								'text' => $message,
								'type' => 'unicode',
								'restaurant_id' => @$data['restaurant_id'],
								'key' => md5($option_arr['private_key'] . PJ_SALT)
							);
							$params['number'] = $admin_phone;
							$params['provider'] = $this->smsServiceProvider;
							$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
						}
					}
				}
			}
			
			if ($opt == 'payment')
			{
				if ($option_arr['o_email_payment'] == 1) {
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_email_payment_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					$lang_subject = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_email_payment_subject')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
						
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if ($data['type'] == 'delivery')
						{
							$message = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						} elseif ($data['type'] == 'catering') {
							$message = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $message);
						} else {
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						}
						$message = str_replace($tokens['search'], $tokens['replace'], $message);
						
						$Email
							->setTo($data['c_email'])
							->setFrom($from_email)
							->setSubject($lang_subject[0]['content'])
							->send(pjUtil::textToHtml($message));
					}
				}
				
				if(!empty($data['c_phone']) && $data['receive_sms_messages'] == 1)
				{
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_sms_payment_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					if (count($lang_message) === 1)
					{
						$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
						if ($this->smsServiceProvider == 'clicksend') {
							$config = ClickSend\Configuration::getDefaultConfiguration()
							              ->setUsername($option_arr['plugin_sms_api_username'])
							              ->setPassword($option_arr['plugin_sms_api_password']);							
							$apiInstance = new ClickSend\Api\SMSApi(new GuzzleHttp\Client(),$config);
							$msg = new \ClickSend\Model\SmsMessage();
							$msg->setBody($message); 
							$msg->setTo($data['c_phone']);
							$msg->setSource("sdk");
							$sms_messages = new \ClickSend\Model\SmsMessageCollection(); 
							$sms_messages->setMessages([$msg]);							
							try {
							    $result = $apiInstance->smsSendPost($sms_messages);
							    $resp = json_decode($result, true);
							    pjSmsModel::factory()->reset()->setAttributes(array(
									'number' => $data['c_phone'],
									'text' => $message,
									'provider' => 'clicksend',
							    	'restaurant_id' => @$data['restaurant_id'],
									'status' => @$resp['response_code']
								))->insert();							    
							} catch (Exception $e) {
							    //echo 'Exception when calling SMSApi->smsSendPost: ', $e->getMessage(), PHP_EOL;
							}
						} else {
							$params = array(
								'text' => $message,
								'type' => 'unicode',
								'restaurant_id' => @$data['restaurant_id'],
								'key' => md5(@$option_arr['private_key'] . PJ_SALT)
							);
							$params['number'] = $data['c_phone'];
							$params['provider'] = $this->smsServiceProvider;
							$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
						}
					}
				}
				
				if ($option_arr['o_admin_email_payment'] == 1) {
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_admin_email_payment_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					$lang_subject = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_admin_email_payment_subject')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
						
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if ($data['type'] == 'delivery')
						{
							$message = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						} elseif ($data['type'] == 'catering') {
							$message = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $message);
						} else {
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						}
						$message = str_replace($tokens['search'], $tokens['replace'], $message);
						if (!empty($option_arr['o_second_notification_email'])) {						
							$Email->setCc($option_arr['o_second_notification_email']);					
						}
						$Email
							->setTo($admin_email)
							->setFrom($from_email)
							->setSubject($lang_subject[0]['content'])
							->send(pjUtil::textToHtml($message));
					}
				}
				
				if(!empty($admin_phone))
				{
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_admin_sms_payment_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					if (count($lang_message) === 1)
					{
						$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
						if ($this->smsServiceProvider == 'clicksend') {
							$config = ClickSend\Configuration::getDefaultConfiguration()
							              ->setUsername($option_arr['plugin_sms_api_username'])
							              ->setPassword($option_arr['plugin_sms_api_password']);							
							$apiInstance = new ClickSend\Api\SMSApi(new GuzzleHttp\Client(),$config);
							$msg = new \ClickSend\Model\SmsMessage();
							$msg->setBody($message); 
							$msg->setTo($admin_phone);
							$msg->setSource("sdk");
							$sms_messages = new \ClickSend\Model\SmsMessageCollection(); 
							$sms_messages->setMessages([$msg]);							
							try {
							    $result = $apiInstance->smsSendPost($sms_messages);		
							    $resp = json_decode($result, true);
							    pjSmsModel::factory()->reset()->setAttributes(array(
									'number' => $admin_phone,
									'text' => $message,
									'provider' => 'clicksend',
							    	'restaurant_id' => @$data['restaurant_id'],
									'status' => @$resp['response_code']
								))->insert();							    
							} catch (Exception $e) {
							    //echo 'Exception when calling SMSApi->smsSendPost: ', $e->getMessage(), PHP_EOL;
							}
						} else {
							$params = array(
								'text' => $message,
								'type' => 'unicode',
								'restaurant_id' => @$data['restaurant_id'],
								'key' => md5($option_arr['private_key'] . PJ_SALT)
							);
							$params['number'] = $admin_phone;
							$params['provider'] = $this->smsServiceProvider;
							$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
						}
					}
				}
			}
			
			
			if ($opt == 'cancel')
			{
				if ($option_arr['o_email_cancel'] == 1) {
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_email_cancel_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					$lang_subject = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_email_cancel_subject')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
								   
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if ($data['type'] == 'delivery')
						{
							$message = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						} elseif ($data['type'] == 'catering') {
							$message = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $message);
						} else {
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						}
						
						$message = str_replace($tokens['search'], $tokens['replace'], $message);
						
						$Email
							->setTo($data['c_email'])
							->setFrom($from_email)
							->setSubject($lang_subject[0]['content'])
							->send(pjUtil::textToHtml($message));
					}
				}
				
				if ($option_arr['o_admin_email_cancel'] == 1)
				{	
					$lang_message = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_admin_email_cancel_message')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
					$lang_subject = $pjMultiLangModel
						->reset()
						->select('t1.*')
						->where('t1.model','pjOption')
						->where('t1.locale', $locale_id)
						->where('t1.field', 'o_admin_email_cancel_subject')
						->where('t1.foreign_id', $this->getFrontRestaurantId())
						->limit(0, 1)
						->findAll()
						->getData();
								   
					if (count($lang_message) === 1 && count($lang_subject) === 1)
					{
						if ($data['type'] == 'delivery')
						{
							$message = str_replace(array('[Delivery]', '[/Delivery]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						} elseif ($data['type'] == 'catering') {
							$message = str_replace(array('[Catering]', '[/Catering]'), array('', ''), $lang_message[0]['content']);
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $message);
						} else {
							$message = preg_replace('/\[Delivery\].*\[\/Delivery\]/s', '', $lang_message[0]['content']);
							$message = preg_replace('/\[Catering\].*\[\/Catering\]/s', '', $message);
						}
						$message = str_replace($tokens['search'], $tokens['replace'], $message);
											if (!empty($option_arr['o_second_notification_email'])) {						$Email->setCc($option_arr['o_second_notification_email']);					}
						$Email
							->setTo($admin_email)
							->setFrom($from_email)
							->setSubject($lang_subject[0]['content'])
							->send(pjUtil::textToHtml($message));
					}
				}	
			}
		}
	}
	
	public function pjActionCancel()
	{
		$this->setLayout('pjActionCancel');
		
		$pjOrderModel = pjOrderModel::factory();
		
		if (isset($_POST['order_cancel']))
		{
			$order_arr = $pjOrderModel
				->reset()
				->join('pjClient', "t2.id=t1.client_id", 'left outer')
				->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
						AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
						AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
						AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
						AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
				->find($_POST['id'])
				->getData();
			if (count($order_arr) > 0)
			{
				$sql = "UPDATE `".$pjOrderModel->getTable()."` SET status = 'cancelled' WHERE SHA1(CONCAT(`id`, `created`, '".PJ_SALT."')) = '" . $_POST['hash'] . "'";
				
				$pjOrderModel->reset()->execute($sql);

				pjAppController::addOrderDetails($order_arr, $this->getLocaleId());
				
				pjFront::pjActionConfirmSend($this->option_arr, $order_arr, PJ_SALT, 'cancel');
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjFront&action=pjActionCancel&err=200');
			}
		}else{
			if (isset($_GET['hash']) && isset($_GET['id']))
			{
				$arr = $pjOrderModel
					->reset()
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->join('pjMultiLang', "t3.model='pjCountry' AND t3.foreign_id=t1.d_country_id AND t3.field='name' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjMultiLang', "t4.model='pjCountry' AND t4.foreign_id=t1.location_id AND t4.field='name' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjMultiLang', "t5.model='pjCountry' AND t5.foreign_id=t1.ca_country_id AND t5.field='name' AND t5.locale='".$this->getLocaleId()."'", 'left outer')
					->select('t1.*, t3.content as d_country, t4.content as location, t5.content as ca_country, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes')
					->find($_GET['id'])
					->getData();
				if (count($arr) == 0)
				{
					$this->set('status', 2);
				}else{
					if ($arr['status'] == 'cancelled')
					{
						$this->set('status', 4);
					}else{
						$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
						if ($_GET['hash'] != $hash)
						{
							$this->set('status', 3);
						}else{
							pjAppController::addOrderDetails($arr, $this->getLocaleId());
							$this->set('arr', $arr);
						}
					}
				}
			}elseif (!isset($_GET['err'])) {
				$this->set('status', 1);
			}
		}
	}
	
	public function pjActionGetProducts()
	{
		$this->setAjax(true);
		
		if(isset($_GET['category_id']) && (int) $_GET['category_id'])
		{
			$pjProductModel = pjProductModel::factory();
			$arr = $pjProductModel
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProduct' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
				->join('pjProductCategory', 't4.product_id=t1.id', 'left outer')
				->select("t1.*, t2.content AS name, t3.content AS description, t4.category_id")
				->where('t4.category_id', $_GET['category_id'])
				->where('t1.status', 'T')
                /*Khuetech display_type allways Togo ~ 0|2*/
                ->where('t1.display_type IN(0,2)')
				->orderBy("t1.is_featured DESC, t2.content ASC")
				->findAll()
				->getData();
			
			$pjExtraModel = pjExtraModel::factory();
			$pjProductExtraTable = pjProductExtraModel::factory()->getTable();
			$pjProductPriceModel = pjProductPriceModel::factory();
			$pjProductGroupModel = pjProductGroupModel::factory();
			$pjProductGroupItemModel = pjProductGroupItemModel::factory();
			$pjProductModifierModel = pjProductModifierModel::factory();
			
			$group_arr = $group_item_arr = array();
			$price_arr = array();
			$extra_arr = array();
			$product_id_arr = $pjProductModel->findAll()->getDataPair(null, 'id');
			if(!empty($product_id_arr))
			{
				$temp_extra_arr = $pjExtraModel
					->reset()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->join('pjProductExtra', "t3.extra_id = t1.id", 'left')
					->where("(t1.id IN (SELECT TPE.extra_id FROM `".$pjProductExtraTable."` AS TPE WHERE TPE.product_id IN(".join(",", $product_id_arr).") ))")
					->select("t1.*, t2.content AS name, t3.product_id")
					->orderBy("name ASC")
					->findAll()
					->getData();
				foreach($temp_extra_arr as $k => $v)
				{
					$extra_arr[$v['product_id']][] = $v;
				}
				$temp_price_arr = $pjProductPriceModel
					->reset()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
					->whereIn('t1.product_id', $product_id_arr)
					->select("t1.*, t2.content AS price_name")
					->findAll()
					->getData();
				foreach($temp_price_arr as $k => $v)
				{
					$price_arr[$v['product_id']][] = $v;
				}
				
				$_group_arr = $pjProductGroupModel->select('t1.*, t2.content AS group_name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroup' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_name'", 'left')
					->whereIn('t1.product_id', $product_id_arr)
					->orderBy('t2.content ASC')
					->findAll()
					->getData();
				$group_ids_arr = array();		
				foreach ($_group_arr as $item) {
					$group_arr[$item['product_id']][] = $item;
					$group_ids_arr[] = $item['id'];
				}		
				if ($group_ids_arr) {
					$_group_item_arr = $pjProductGroupItemModel->select('t1.*, t2.content AS group_item_name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroupItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_item_name'", 'left')
						->whereIn('t1.group_id', $group_ids_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					foreach ($_group_item_arr as $item) {
						$group_item_arr[$item['group_id']][] = $item;
					}
				}
				
				$modifier_arr = $modifier_item_arr = array();
				$_modifier_arr = $pjProductModifierModel->select('t1.*, t2.content AS modifier_name')
					->join('pjMultiLang', "t2.foreign_id = t1.modifier_id AND t2.model = 'pjModifier' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->whereIn('t1.product_id', $product_id_arr)
					->orderBy('t2.content ASC')
					->findAll()
					->getData();
				$modifier_ids_arr = array();		
				foreach ($_modifier_arr as $item) {
					$modifier_arr[$item['product_id']][] = $item;
					$modifier_ids_arr[] = $item['modifier_id'];
				}		
				if ($modifier_ids_arr) {
					$_modifier_item_arr = pjModifierItemModel::factory()->select('t1.*, t2.content AS modifier_item_name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjModifierItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'item_name'", 'left')
						->whereIn('t1.modifier_id', $modifier_ids_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					foreach ($_modifier_item_arr as $item) {
						$modifier_item_arr[$item['modifier_id']][] = $item;
					}
				}
			}
			foreach($arr as $k => $product)
			{
				$product['price_arr'] = array();
				$product['extra_arr'] = array();
				
				if(isset($extra_arr[$product['id']]))
				{
					$product['extra_arr'] = $extra_arr[$product['id']];
				}
				if($product['set_different_sizes'] == 'T' && isset($price_arr[$product['id']]))
				{
					$product['price_arr'] = $price_arr[$product['id']];
				}
				$arr[$k] = $product;
			}
			
			$this->set('arr', $arr);
			$this->set('group_arr', $group_arr);
			$this->set('group_item_arr', $group_item_arr);
			$this->set('modifier_arr', $modifier_arr);
			$this->set('modifier_item_arr', $modifier_item_arr);
		}
	}
	
	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$install_url = parse_url(PJ_INSTALL_URL);
        if($install_url['scheme'] == 'https'){
            header('Set-Cookie: '.session_name().'='.session_id().'; SameSite=None; Secure');
        }
        $origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
        header('P3P: CP="ALL DSP COR CUR ADM TAI OUR IND COM NAV INT"');
        header("Access-Control-Allow-Origin: $origin");
        header("Access-Control-Allow-Credentials: true");
        header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
        header("Access-Control-Allow-Headers: Origin, X-Requested-With");
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS')
        {
            exit;
        }
	}
	
	public function pjActionGetCountryId()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$arr = pjCountryModel::factory()->where('alpha_2', $_GET['alpha_2'])->findAll()->getData();
			$country_id = $arr ? $arr[0]['id'] : '';
			pjAppController::jsonResponse(compact('country_id'));
		}
		exit;
	}
	
	public function pjActionCheckDistance()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$is_allow_delivery_catering = false;
			if ((int)$_GET['location_id'] > 0 && !empty($_GET['address'])) {
				if ($_GET['type'] == 'delivery' && $this->option_arr['o_allow_delivery_doordash'] == 'Yes') {
					$is_allow_delivery_catering = true;
				} else {
					$location_arr = pjLocationModel::factory()->select('t1.*, t2.content AS `location_address`')
						->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='address' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
						->find($_GET['location_id'])->getData();
					if ($location_arr) {
						$result = $this->pjActionGetDistanceAndDuration($location_arr['location_address'], $_GET['address']);
						if ($result['status'] == 200 && (float)$result['distance'] <= (float)$this->option_arr['o_delivery_catering_max_distance']) {
							$is_allow_delivery_catering = true;
							$catering_fee = (float)$this->option_arr['o_catering_fee'];
						}					
					}
				}
			}
			$this->_set('is_allow_delivery', $is_allow_delivery_catering);
			if ($is_allow_delivery_catering) {
				pjAppController::jsonResponse(array('status' => 'OK', 'text' => ''));
			} else {
				if ($_GET['type'] == 'delivery') {
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => __('front_delivery_error_msg', true)));
				} elseif ($_GET['type'] == 'catering') {
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => __('front_catering_error_msg', true)));
				} else {
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => ''));
				}
			}
		}
		exit;
	}
	
	
	public function pjActionCheckMinOrderAmount()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$price = $this->_get('price');
			$valid = true;
			if ($_GET['type'] == 'catering' && $price < (float)$this->option_arr['o_minimum_order_catering']) {
				$message = __('front_minimum_order_catering_amount', true);
				$min_amount = (float)$this->option_arr['o_minimum_order_catering'];
				$valid = false;
			} elseif($_GET['type'] == 'pickup' && $price < (float)$this->option_arr['o_minimum_order']) {
				$message = __('front_minimum_order_amount', true);
				$min_amount = (float)$this->option_arr['o_minimum_order'];
				$valid = false;
			} elseif($_GET['type'] == 'delivery' && $price < (float)$this->option_arr['o_minimum_order_delivery']) {
				$message = __('front_minimum_order_delivery_amount', true);
				$min_amount = (float)$this->option_arr['o_minimum_order_delivery'];
				$valid = false;
			}
			if ($valid) {
				pjAppController::jsonResponse(array('status' => 'OK', 'text' => ''));
			} else {
				$message = str_replace("{AMOUNT}", pjUtil::formatCurrencySign(number_format($min_amount, 2), $this->option_arr['o_currency']), $message);
				pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $message));
			}
		}
	}
	
	public function pjActionThankyou() {
		$this->setLayout('pjActionEmpty');
		pjUtil::redirect($this->option_arr['o_thankyou_page']);
	}
	
	public static function sendToRemotePrinter($id, $locale_id, $option_arr, $manual_send=false) {
		if ($option_arr['o_allow_automatic_print'] == 'Yes' || $manual_send) {
			if ((int)$id > 0) {
				$arr = pjOrderModel::factory()
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->join('pjRestaurant', "t3.id=t1.restaurant_id", 'left outer')
					->join('pjMultiLang', "t4.foreign_id = t3.id AND t4.model = 'pjRestaurant' AND t4.locale = '".$locale_id."' AND t4.field = 'name'", 'left')
					->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
							t3.address AS restaurant_address, t3.phone AS restaurant_phone, t4.content AS restaurant_name, 
							AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
							AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
							AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
							AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
					->find($id)
					->getData();
					
				if ($arr && ($arr['status'] == 'confirmed' || $manual_send)) {
					pjAppController::addOrderDetails($arr, $locale_id);
					$delivery_address = '';
					if (@$arr['type'] == 'pickup') {
						$ts = strtotime(@$arr['p_dt']);
						$notes = @$arr['p_notes'];
					} elseif (@$arr['type'] == 'delivery') {
						$ts = strtotime(@$arr['d_dt']);
						$notes = @$arr['d_notes'];
						$delivery_address = $arr['d_address_1'];
					} else {
						$ts = strtotime(@$arr['ca_dt']);
						$notes = @$arr['ca_notes'];
						$delivery_address = $arr['ca_address_1'];
					}
					$date_time = date($option_arr['o_date_format'], $ts) . ', ' . date('h:i a', $ts);
					if(@$arr['type'] == 'pickup' &&  @$arr['p_asap'] == 'T')
					{
						$date_time = date($option_arr['o_date_format'], $ts) . ', ' . __('front_asap', true);
					}
					if(@$arr['type'] == 'delivery' &&  @$arr['d_asap'] == 'T')
					{
						$date_time = date($option_arr['o_date_format'], $ts) . ', ' . __('front_asap', true);
					}
					$total_items = 0;
					$has_selected_extras = false;
					if (isset($arr['product_arr']))
					{
						foreach ($arr['product_arr'] as $v)
						{
							$total_items += $v['cnt'];
							if (isset($v['extra_arr']) && count($v['extra_arr']) > 0) {
								$has_selected_extras = true;
							}
						}
					}
				
					try {
						$connector = new NetworkPrintConnector($option_arr['o_printer_ip'], $option_arr['o_printer_port']);
						$printer = new Printer($connector);
						
						$number_of_copies = (int)$option_arr['o_printer_copies'] > 0 ? (int)$option_arr['o_printer_copies'] : 1;
						foreach (range(1, $number_of_copies) as $cnt) {
							$printer->setLineSpacing(30);
							$printer->setJustification(Printer::JUSTIFY_CENTER);							
							$printer->setFont(Printer::FONT_B);
							$printer->setTextSize(2, 2);
							$printer->feed();
							if ($arr['type'] == 'pickup') {
								$printer->text(__('front_printer_customer_pickup', true)."\n");
							} else {
								$printer->text(__('front_printer_customer_delivery', true)."\n");
							}
							$printer->selectPrintMode();
							$printer->feed();
							$printer->text("--------------------------------\n");
							$printer->feed();
							
							$printer->setFont(Printer::FONT_B);
							$printer->setTextSize(1, 1);
							$printer->text(__('front_printer_customer_name', true)."\n");
							$printer->setTextSize(2, 2);
							$printer->text(stripslashes($arr['c_name'])."\n");
							$printer->feed();
							if (!empty($arr['c_phone'])) {
								$printer->setTextSize(1, 1);
								$printer->text(__('front_printer_customer_phone', true)."\n");
								$printer->setTextSize(2, 2);
								$printer->text(stripslashes($arr['c_phone'])."\n");
								$printer->feed();
							}
							
							$printer->setTextSize(1, 1);
							if ($arr['type'] == 'pickup') {								
								$printer->text(__('front_printer_pickup_time', true)."\n");
							} else {
								$printer->text(__('front_printer_delivery_time', true)."\n");
							}
							$printer->setTextSize(2, 2);
							$printer->text($date_time."\n");
							
							if ($arr['type'] != 'pickup') {		
								$printer->feed();
								$printer->setTextSize(1, 1);						
								$printer->text(__('front_printer_delivery_address', true)."\n");
								$printer->setTextSize(2, 2);
								$printer->text($delivery_address."\n");
							}
							
							if ($arr['type'] == 'delivery' && (int)$arr['is_dashdoor_delivery'] == 1) {		
								$printer->feed();
								$printer->setFont(Printer::FONT_B);
								$printer->setTextSize(1, 1);
								$printer->text(__('front_printer_doordash_delivery', true)."\n");
								
								$printer->feed();
								$printer->setTextSize(1, 1);						
								$printer->text(__('front_printer_doordash_delivery_name', true)."\n");
								$printer->setTextSize(2, 2);
								$printer->text($arr['dasher_name']."\n");
								
								$printer->feed();
								$printer->setTextSize(1, 1);						
								$printer->text(__('front_printer_doordash_delivery_phone', true)."\n");
								$printer->setTextSize(2, 2);
								$printer->text($arr['dasher_dropoff_phone_number']."\n");
							}
							
							$printer->feed();
							$printer->setTextSize(1, 1);						
							$printer->text(__('front_printer_order_number', true)."\n");
							$printer->setTextSize(2, 2);
							$printer->text($arr['uuid']."\n");
							
							$printer->feed();
							$printer->setTextSize(1, 1);						
							$printer->text(__('front_printer_total_items', true)."\n");
							$printer->setTextSize(2, 2);
							if ($total_items > 1) {
								$printer->text(sprintf(__('front_printer_plural_items', true), $total_items)."\n");
							} else {
								$printer->text(sprintf(__('front_printer_single_items', true), $total_items)."\n");
							}
							if ($has_selected_extras) {
								$printer->feed();
								$printer->setTextSize(4, 1);
								$printer->text(strtoupper(__('front_attention_modifiers_added', true))."\n");
							}
							if (!empty($notes)) {
								$printer->feed();
								$printer->setTextSize(1, 1);						
								$printer->text(__('front_printer_notes', true)."\n");
								$printer->setTextSize(2, 2);
								$printer->text($notes."\n");
							}
							$printer->feed();
														
							/* Items */
							$printer->selectPrintMode();
							$printer->text("--------------------------------\n");
							if (isset($arr['product_arr']))
							{
								foreach ($arr['product_arr'] as $v)
								{
									$price = $v['price'] * $v['cnt'];
									$extra = array();
									$modifier = array();
									foreach ($v['extra_arr'] as $e)
									{
										$extra[] = stripslashes(sprintf("%u x %s", $e['cnt'], $e['name']));
										$price += $e['price'] * $e['cnt'];
									}
									foreach ($v['modifier_item_arr'] as $mi)
									{
										if ((float)$mi['price'] > 0) {
											$modifier[] = stripslashes(sprintf("%s (+%s)", $mi['item_name'], pjUtil::formatCurrencySign(number_format($mi['price'], 2), $option_arr['o_currency'])));
											$price += (float)$mi['price'];
										} else {
											$modifier[] = stripslashes($mi['item_name']);
										}
									}
									
									$group_items = array();
									foreach ($v['group_item_arr'] as $pgi)
									{
										$group_items[] = stripslashes($pgi['group_item_name']);
									}
									$printer->setFont(Printer::FONT_B);
									$printer->setTextSize(2, 2);
									$printer->setJustification(Printer::JUSTIFY_LEFT);
									if(!empty($v['size']))
									{
										$printer->text(stripslashes(sprintf("%u x %s (%s)", $v['cnt'], $v['name'], $v['size'])));
									}else{
										$printer->text(stripslashes(sprintf("%u x %s", $v['cnt'], $v['name'])));
									}
									$printer->setJustification(Printer::JUSTIFY_RIGHT);
									$printer->text(" ".pjUtil::formatCurrencySign(number_format($price, 2), $option_arr['o_currency']));
									$printer->text("\n");
									$printer->setJustification();
									
									$printer->selectPrintMode(Printer::MODE_EMPHASIZED);
									$printer->setFont(Printer::FONT_B);
									$printer->setTextSize(2, 2);
									if (count($extra) > 0) {
										$printer->text("\n");
										foreach ($extra as $ex) {
											$printer->text($ex."\n");
										}
									}
									if (count($group_items) > 0) {
										$printer->text("\n");
										foreach ($group_items as $gi) {
											$printer->text($gi."\n");	
										}
									}
									if (count($modifier) > 0) {
										$printer->text("\n");
										foreach ($modifier as $mi) {
											$printer->text($mi."\n");
										}
									}
									
									$printer->selectPrintMode();
									$printer->text("---------------------------------------\n");
								}
							}
							$printer->setLineSpacing(3);
							$printer->selectPrintMode();
							$printer->setJustification();
							$printer->setFont(Printer::FONT_B);
							$printer->setTextSize(2, 2);	
							if ($total_items > 1) {
								$printer->text(sprintf(__('front_printer_plural_total_items', true), $total_items)."\n");
							} else {
								$printer->text(sprintf(__('front_printer_single_total_items', true), $total_items)."\n");
							}
							
							$printer->feed();
							$printer->setJustification(Printer::JUSTIFY_LEFT);
							$printer->text(__('front_printer_subtotal', true));
							$printer->setJustification(Printer::JUSTIFY_RIGHT);
							$printer->text(" ".pjUtil::formatCurrencySign(number_format($arr['subtotal'], 2), $option_arr['o_currency']));
							$printer->text("\n");
							$printer->setJustification();
							
							$printer->feed();
							$printer->setJustification(Printer::JUSTIFY_LEFT);
							$printer->text(__('front_printer_tax', true));
							$printer->setJustification(Printer::JUSTIFY_RIGHT);
							$printer->text(" ".pjUtil::formatCurrencySign(number_format($arr['tax'], 2), $option_arr['o_currency']));
							$printer->text("\n");
							$printer->setJustification();
							
							$printer->feed();
							$printer->setJustification(Printer::JUSTIFY_LEFT);
							$printer->text(__('front_printer_tip', true));
							$printer->setJustification(Printer::JUSTIFY_RIGHT);
							$printer->text(" ".pjUtil::formatCurrencySign(number_format($arr['tip_amount'], 2), $option_arr['o_currency']));
							$printer->text("\n");
							$printer->setJustification();
							
							$printer->feed();
							$printer->selectPrintMode(Printer::MODE_EMPHASIZED);
							$printer->setTextSize(2, 2);
							$printer->setJustification(Printer::JUSTIFY_LEFT);
							$printer->text(__('front_printer_total', true));
							$printer->setJustification(Printer::JUSTIFY_RIGHT);
							$printer->text(" ".pjUtil::formatCurrencySign(number_format($arr['total'], 2), $option_arr['o_currency']));
							$printer->text("\n");
							$printer->setJustification();
							
							$printer->cut();
							$printer->release();
						}
						$printer->close();						
					} catch (Exception $e) {
						//$this->log($e->getMessage());
						//$printer->close();
					}
				}
			}
		}
	}
	
	public function pjActionSetTipOption()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$this->_set('tip_option', $_GET['tip_option']);
		}
		exit;
	}
	
	public function pjActionSetTipPercentage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$this->_set('tip_percentage', $_GET['tip_percentage']);
		}
		exit;
	}
	
	public function pjActionFeatured()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			$pjProductModel = pjProductModel::factory();
			
			$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
			$arr = $pjProductModel->select("t1.*, t2.content AS name, t3.content AS description")
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProduct' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
				->where('t1.is_featured', 1)
				->where('t1.restaurant_id', $rid)
				->orderBy("t1.is_featured DESC, t2.content ASC")
				->findAll()
				->getData();
			
			$pjExtraModel = pjExtraModel::factory();
			$pjProductExtraTable = pjProductExtraModel::factory()->getTable();
			$pjProductPriceModel = pjProductPriceModel::factory();
			$pjProductGroupModel = pjProductGroupModel::factory();
			$pjProductGroupItemModel = pjProductGroupItemModel::factory();
			
			$group_arr = $group_item_arr = array();
			$price_arr = array();
			$extra_arr = array();
			$product_id_arr = $pjProductModel->findAll()->getDataPair(null, 'id');
			if(!empty($product_id_arr))
			{
				$temp_extra_arr = $pjExtraModel
					->reset()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->join('pjProductExtra', "t3.extra_id = t1.id", 'left')
					->where("(t1.id IN (SELECT TPE.extra_id FROM `".$pjProductExtraTable."` AS TPE WHERE TPE.product_id IN(".join(",", $product_id_arr).") ))")
					->select("t1.*, t2.content AS name, t3.product_id")
					->orderBy("name ASC")
					->findAll()
					->getData();
				foreach($temp_extra_arr as $k => $v)
				{
					$extra_arr[$v['product_id']][] = $v;
				}
				$temp_price_arr = $pjProductPriceModel
					->reset()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
					->whereIn('t1.product_id', $product_id_arr)
					->select("t1.*, t2.content AS price_name")
					->findAll()
					->getData();
				foreach($temp_price_arr as $k => $v)
				{
					$price_arr[$v['product_id']][] = $v;
				}
				
				$_group_arr = $pjProductGroupModel->select('t1.*, t2.content AS group_name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroup' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_name'", 'left')
					->whereIn('t1.product_id', $product_id_arr)
					->orderBy('t2.content ASC')
					->findAll()
					->getData();
				$group_ids_arr = array();		
				foreach ($_group_arr as $item) {
					$group_arr[$item['product_id']][] = $item;
					$group_ids_arr[] = $item['id'];
				}		
				if ($group_ids_arr) {
					$_group_item_arr = $pjProductGroupItemModel->select('t1.*, t2.content AS group_item_name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroupItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_item_name'", 'left')
						->whereIn('t1.group_id', $group_ids_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					foreach ($_group_item_arr as $item) {
						$group_item_arr[$item['group_id']][] = $item;
					}
				}
			}
			foreach($arr as $k => $product)
			{
				$product['price_arr'] = array();
				$product['extra_arr'] = array();
				
				if(isset($extra_arr[$product['id']]))
				{
					$product['extra_arr'] = $extra_arr[$product['id']];
				}
				if($product['set_different_sizes'] == 'T' && isset($price_arr[$product['id']]))
				{
					$product['price_arr'] = $price_arr[$product['id']];
				}
				$arr[$k] = $product;
			}
			
			$this->set('arr', $arr);
			$this->set('group_arr', $group_arr);
			$this->set('group_item_arr', $group_item_arr);
			$this->set('cart_box', $this->getCartInfo());
		}
	}
	
	public function pjActionFavorites()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if($this->isFrontLogged())
			{
				$pjProductModel = pjProductModel::factory();
				
				$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
				$arr = $pjProductModel->select("t1.*, t2.content AS name, t3.content AS description")
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProduct' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
					->where('t1.id IN (SELECT `product_id` FROM `'.pjFavoriteModel::factory()->getTable().'` WHERE `client_id`='.$this->getClientId().')')
					->where('t1.restaurant_id', $rid)
					->orderBy("t1.is_featured DESC, t2.content ASC")
					->findAll()
					->getData();
				
				$pjExtraModel = pjExtraModel::factory();
				$pjProductExtraTable = pjProductExtraModel::factory()->getTable();
				$pjProductPriceModel = pjProductPriceModel::factory();
				$pjProductGroupModel = pjProductGroupModel::factory();
				$pjProductGroupItemModel = pjProductGroupItemModel::factory();
				
				$group_arr = $group_item_arr = array();
				$price_arr = array();
				$extra_arr = array();
				$product_id_arr = $pjProductModel->findAll()->getDataPair(null, 'id');
				if(!empty($product_id_arr))
				{
					$temp_extra_arr = $pjExtraModel
						->reset()
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
						->join('pjProductExtra', "t3.extra_id = t1.id", 'left')
						->where("(t1.id IN (SELECT TPE.extra_id FROM `".$pjProductExtraTable."` AS TPE WHERE TPE.product_id IN(".join(",", $product_id_arr).") ))")
						->select("t1.*, t2.content AS name, t3.product_id")
						->orderBy("name ASC")
						->findAll()
						->getData();
					foreach($temp_extra_arr as $k => $v)
					{
						$extra_arr[$v['product_id']][] = $v;
					}
					$temp_price_arr = $pjProductPriceModel
						->reset()
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
						->whereIn('t1.product_id', $product_id_arr)
						->select("t1.*, t2.content AS price_name")
						->findAll()
						->getData();
					foreach($temp_price_arr as $k => $v)
					{
						$price_arr[$v['product_id']][] = $v;
					}
					
					$_group_arr = $pjProductGroupModel->select('t1.*, t2.content AS group_name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroup' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_name'", 'left')
						->whereIn('t1.product_id', $product_id_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					$group_ids_arr = array();		
					foreach ($_group_arr as $item) {
						$group_arr[$item['product_id']][] = $item;
						$group_ids_arr[] = $item['id'];
					}		
					if ($group_ids_arr) {
						$_group_item_arr = $pjProductGroupItemModel->select('t1.*, t2.content AS group_item_name')
							->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroupItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_item_name'", 'left')
							->whereIn('t1.group_id', $group_ids_arr)
							->orderBy('t2.content ASC')
							->findAll()
							->getData();
						foreach ($_group_item_arr as $item) {
							$group_item_arr[$item['group_id']][] = $item;
						}
					}
				}
				foreach($arr as $k => $product)
				{
					$product['price_arr'] = array();
					$product['extra_arr'] = array();
					
					if(isset($extra_arr[$product['id']]))
					{
						$product['extra_arr'] = $extra_arr[$product['id']];
					}
					if($product['set_different_sizes'] == 'T' && isset($price_arr[$product['id']]))
					{
						$product['price_arr'] = $price_arr[$product['id']];
					}
					$arr[$k] = $product;
				}
				
				$this->set('arr', $arr);
				$this->set('group_arr', $group_arr);
				$this->set('group_item_arr', $group_item_arr);
				$this->set('cart_box', $this->getCartInfo());
			} else {
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100));
			}
		}
	}
	
	public function pjActionProcessFavorite()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if (isset($_POST['id']) && (int)$_POST['id'] > 0 && isset($_POST['type'])) {
				$client_id = $this->getClientId();
				if ($_POST['type'] == 'add') {
					pjFavoriteModel::factory()->setAttributes(array('client_id' => $client_id, 'product_id' => $_POST['id']))->insert();
				} else {
					pjFavoriteModel::factory()->where('client_id', $client_id)->where('product_id', $_POST['id'])->eraseAll();
				}
			}
		}
	}
	
	public function pjActionPrevious()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if($this->isFrontLogged())
			{
				$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
				$pjOrderModel = pjOrderModel::factory();
				$pjOrderModel
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->where('t1.client_id', $this->getClientId())
					->where('t1.restaurant_id', $rid);
				$column = 'created';
				$direction = 'DESC';
				$total = $pjOrderModel->findCount()->getData();
				$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
				$pages = ceil($total / $rowCount);
				$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
				$offset = ((int) $page - 1) * $rowCount;
				if ($page > $pages)
				{
					$page = $pages;
				}
				
				$arr = $pjOrderModel
					->select("t1.*, t2.c_name as client_name")
					->orderBy("$column $direction")
					->limit($rowCount, $offset)
					->findAll()
					->getData();
				foreach ($arr as $i => $v) {
					pjAppController::addOrderDetails($arr[$i], $this->getLocaleId());
				}
				$this->set('arr', $arr);
				$this->set('paginator', array('pages' => $pages, 'total' => $total));
				$this->set('cart_box', $this->getCartInfo());
			} else {
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100));
			}
		}
	}
	
	public function pjActionAddToCart() {
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$order_item_arr = pjOrderItemModel::factory()->find($_GET['id'])->getData();
			$arr = pjOrderItemModel::factory()->reset()->where('t1.hash', $order_item_arr['hash'])->findAll()->getData();
			$oi_arr = array();
			foreach ($arr as $k => $v) {
				$oi_arr[$v['type']][$v['foreign_id']] = $v['cnt'];
			}
			$this->set('order_item_arr', $order_item_arr)
				->set('oi_arr', $oi_arr);
			
			$pjProductModel = pjProductModel::factory();
			
			$rid = isset($_GET['rid']) && (int)$_GET['rid'] > 0 ? $_GET['rid'] : $this->getFrontRestaurantId();
			$arr = $pjProductModel->select("t1.*, t2.content AS name, t3.content AS description")
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjProduct' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
				->where('t1.id', $order_item_arr['foreign_id'])
				->where('t1.restaurant_id', $rid)
				->limit(1)
				->findAll()
				->getData();
			
			$pjExtraModel = pjExtraModel::factory();
			$pjProductExtraTable = pjProductExtraModel::factory()->getTable();
			$pjProductPriceModel = pjProductPriceModel::factory();
			$pjProductGroupModel = pjProductGroupModel::factory();
			$pjProductGroupItemModel = pjProductGroupItemModel::factory();
			
			$group_arr = $group_item_arr = array();
			$price_arr = array();
			$extra_arr = array();
			$product_id_arr = $pjProductModel->findAll()->getDataPair(null, 'id');
			if(!empty($product_id_arr))
			{
				$temp_extra_arr = $pjExtraModel
					->reset()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjExtra' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->join('pjProductExtra', "t3.extra_id = t1.id", 'left')
					->where("(t1.id IN (SELECT TPE.extra_id FROM `".$pjProductExtraTable."` AS TPE WHERE TPE.product_id IN(".join(",", $product_id_arr).") ))")
					->select("t1.*, t2.content AS name, t3.product_id")
					->orderBy("name ASC")
					->findAll()
					->getData();
				foreach($temp_extra_arr as $k => $v)
				{
					$extra_arr[$v['product_id']][] = $v;
				}
				$temp_price_arr = $pjProductPriceModel
					->reset()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
					->whereIn('t1.product_id', $product_id_arr)
					->select("t1.*, t2.content AS price_name")
					->findAll()
					->getData();
				foreach($temp_price_arr as $k => $v)
				{
					$price_arr[$v['product_id']][] = $v;
				}
				
				$_group_arr = $pjProductGroupModel->select('t1.*, t2.content AS group_name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroup' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_name'", 'left')
					->whereIn('t1.product_id', $product_id_arr)
					->orderBy('t2.content ASC')
					->findAll()
					->getData();
				$group_ids_arr = array();		
				foreach ($_group_arr as $item) {
					$group_arr[$item['product_id']][] = $item;
					$group_ids_arr[] = $item['id'];
				}		
				if ($group_ids_arr) {
					$_group_item_arr = $pjProductGroupItemModel->select('t1.*, t2.content AS group_item_name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductGroupItem' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'group_item_name'", 'left')
						->whereIn('t1.group_id', $group_ids_arr)
						->orderBy('t2.content ASC')
						->findAll()
						->getData();
					foreach ($_group_item_arr as $item) {
						$group_item_arr[$item['group_id']][] = $item;
					}
				}
			}
			foreach($arr as $k => $product)
			{
				$product['price_arr'] = array();
				$product['extra_arr'] = array();
				
				if(isset($extra_arr[$product['id']]))
				{
					$product['extra_arr'] = $extra_arr[$product['id']];
				}
				if($product['set_different_sizes'] == 'T' && isset($price_arr[$product['id']]))
				{
					$product['price_arr'] = $price_arr[$product['id']];
				}
				$arr[$k] = $product;
			}
			
			$this->set('arr', $arr);
			$this->set('group_arr', $group_arr);
			$this->set('group_item_arr', $group_item_arr);
			$this->set('cart_box', $this->getCartInfo());
		}
	}
	
	public function pjActionLoadStickyButtons() {
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			$this->set('cart_box', $this->getCartInfo());
		}
	}
	
	public function pjActionReorderProduct()
	{
		$this->setAjax(true);
		
		if ($this->isXHR())
		{
			if (isset($_POST['id']))
			{
				$order_item_arr = pjOrderItemModel::factory()
					->join('pjOrder', 't2.id=t1.order_id', 'inner')
					->where('t1.type', 'product')
					->where('t1.order_id', $_POST['id'])
					->findAll()->getData();
				foreach ($order_item_arr as $order_item) {	
					$arr = pjOrderItemModel::factory()->reset()->where('t1.hash', $order_item['hash'])->findAll()->getData();
					$product_id = (int)$order_item['foreign_id'];
					$cnt = (int)$order_item['cnt'];
					$price_id = NULL;
					
					$extras = $group_items = $group_item_ids = array();
					foreach ($arr as $item) {
						if ($item['type'] == 'extra') {
							$extras[$item['foreign_id']] = $item['cnt'];
						}
						if ($item['type'] == 'group') {
							$group_item_ids[] = $item['foreign_id'];
						}
					}
					ksort($extras);
					if ($group_item_ids) {
						$pgi_arr = pjProductGroupItemModel::factory()
							->join('pjProductGroup', 't2.id=t1.group_id', 'inner')
							->whereIn('t1.id', $group_item_ids)
							->where('t1.product_id', $product_id)
							->findAll()->getData();
						foreach ($pgi_arr as $pgi) {
							$group_items[$pgi['group_id']] = $pgi['id'];
						}
					}
					ksort($group_items);
					
					if((int)$order_item['price_id'] > 0)
					{
						$price_id = (int)$order_item['price_id'];
						$hash = md5($product_id . $price_id . serialize($extras) . serialize($group_items));
					}else{
						$hash = md5($product_id . serialize($extras) . serialize($group_items));
					}
					
					$cart = $this->_get('cart');
					if ($cart === false)
					{
						$cart = array();
					}
					
					if (!array_key_exists($hash, $cart))
					{
						$cart[$hash] = array(
							'product_id' => $product_id,
							'price_id' => $price_id,
							'cnt' => 0,
							'extras' => $extras,
							'group_items' => $group_items
						);
					}
					
					$cart[$hash]['cnt'] += $cnt;
					$this->_set('cart', $cart);
				}
			}
			pjAppController::jsonResponse(array('status' => 'OK'));
		}
	}
	
	private function checkCategoryHoursInAdvance($iso_datetime) {
		$category_ids = $category_arr = array();
		$cart_info = $this->getCartInfo();
		if (isset($cart_info['cart']) && count($cart_info['cart']) > 0) {
			foreach ($cart_info['cart'] as $hash => $item) {
				$category_ids[] = $item['category_id'];
			}
		}
		if ($category_ids) {
			$category_ids = array_unique($category_ids);
			$arr = pjCategoryModel::factory()
				->select("t1.*, t2.content as name")
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjCategory' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->whereIn('t1.id', $category_ids)
				->where('t1.hours_in_advance > 0')
				->orderBy("`order` ASC")
				->findAll()
				->getData();
			$ts = time();
			foreach ($arr as $cat) {
				if (strtotime($iso_datetime) < $ts + ((int)$cat['hours_in_advance'] * 3600)) {
					$category_arr[$cat['id']] = sprintf(__('front_category_in_advance_msg_2', true), pjSanitize::html($cat['name']), (int)$cat['hours_in_advance']);
				}
			}
		}
		return $category_arr;
	}
	
	public function pjActionCheckCategoryHoursInAdvance()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if($_POST['type'] == 'delivery' && @$_POST['d_time'] != 'asap')
			{
				$date = pjUtil::formatDate($_POST['d_date'], $this->option_arr['o_date_format']);
				$time = @$_POST['d_time'];
			} elseif($_POST['type'] == 'catering' && @$_POST['ca_time'] != 'asap') {
				$date = pjUtil::formatDate($_POST['ca_date'], $this->option_arr['o_date_format']);
				$time = @$_POST['ca_time'];
			} elseif($_POST['type'] == 'pickup' && @$_POST['p_time'] != 'asap') {
				$date = pjUtil::formatDate($_POST['p_date'], $this->option_arr['o_date_format']);
				$time = @$_POST['p_time'];
			}
			if (isset($date) && !empty($date) && isset($time) && !empty($time)) {
				$iso_datetime = $date.' '.$time;
				$category_arr = $this->checkCategoryHoursInAdvance($iso_datetime);
				if ($category_arr) {
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => implode('<br/>', $category_arr)));
				} else {
					pjAppController::jsonResponse(array('status' => 'OK', 'text' => ''));	
				}
			} else {
				pjAppController::jsonResponse(array('status' => 'OK', 'text' => ''));
			}
		}
	}
	
	public function pjActionReorder()
	{
	    $this->setAjax(true);
	    
	    if ($this->isXHR())
	    {
	        if (isset($_POST['reorder']))
	        {
	            if (isset($_SESSION[$this->defaultReorderForm]) && $_SESSION[$this->defaultReorderForm] && isset($_SESSION[$this->defaultReorderStore]) && $_SESSION[$this->defaultReorderStore]) {
	               $_SESSION[$this->defaultForm] = $_SESSION[$this->defaultReorderForm];
	               $_SESSION[$this->defaultStore] = $_SESSION[$this->defaultReorderStore];
	               
	               unset($_SESSION[$this->defaultReorderForm]);
	               unset($_SESSION[$this->defaultReorderStore]);
	               
	               if (pjOrderModel::factory()->setAttributes(array('id' => $_POST['id']))->erase()->getAffectedRows() == 1)
	               {
	                   pjOrderItemModel::factory()->where('order_id', $_POST['id'])->eraseAll();
	                   pjOrderDeliveryStatusModel::factory()->where('order_id', $_POST['id'])->eraseAll();
	               }
	               
	               pjAppController::jsonResponse(array('status' => 'OK'));
	            } else {
	                pjAppController::jsonResponse(array('status' => 'ERR'));
	            }
	        }
	        pjAppController::jsonResponse(array('status' => 'ERR'));
	    }
	}
	
	public function pjActionDoordashDeliveryStatus()
	{
		$this->setLayout('pjActionEmpty');		
		$respsone = file_get_contents("php://input");
		$data = json_decode($respsone, true);
		if (isset($data['external_delivery_id']) && !empty($data['external_delivery_id'])) {
			$pjOrderModel = pjOrderModel::factory();
			$pjOrderDeliveryStatusModel = pjOrderDeliveryStatusModel::factory();
			
			$arr = $pjOrderModel
					->join('pjClient', "t2.id=t1.client_id", 'left outer')
					->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
							AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
							AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
							AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
							AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
					->where('t1.external_delivery_id', $data['external_delivery_id'])
					->limit(1)
					->findAll()
					->getDataIndex(0);
			if ($arr) {
			    $option_arr = pjOptionModel::factory()->getPairs($arr['restaurant_id']);
			    $locale_id = isset($arr['locale_id']) && (int) $arr['locale_id'] > 0 ? (int) $arr['locale_id'] : $this->getLocaleId();
			    if (strtoupper($data['event_name']) == 'DELIVERY_CANCELLED' && (int)$option_arr['o_doordash_num_of_recall_dasher'] > 0 && (int)$arr['num_of_recall_dasher'] < (int)$option_arr['o_doordash_num_of_recall_dasher']) {
				    /* re-call dasher */
				    $restaurant_arr = pjRestaurantModel::factory()->select('t1.*, t2.content AS name')
				    ->join('pjMultiLang', "t2.model='pjRestaurant' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$locale_id."'", 'left outer')
				    ->find($arr['restaurant_id'])
				    ->getData();
				    
				    $dropoff_address_arr = array();
				    if (!empty($arr['d_address_1'])) {
				        $dropoff_address_arr[] = $arr['d_address_1'];
				    }
				    if (!empty($arr['d_address_2'])) {
				        $dropoff_address_arr[] = $arr['d_address_2'];
				    }
				    if (!empty($arr['d_city'])) {
				        $dropoff_address_arr[] = $arr['d_city'];
				    }
				    if (!empty($arr['d_state'])) {
				        $dropoff_address_arr[] = $arr['d_state'];
				    }
				    if (!empty($arr['d_zip'])) {
				        $dropoff_address_arr[] = $arr['d_zip'];
				    }
				    $total = (float)$arr['total'] - (float)$arr['price_delivery'];
				    $dasher_tip_amount = (float)$arr['dasher_tip_amount'];
				    $data_delivery = array(
				        "pickup_address"=> $restaurant_arr['address'],
				        "pickup_business_name"=> $restaurant_arr['name'],
				        "pickup_phone_number"=> $restaurant_arr['phone'],
				        "dropoff_address"=> implode(', ', $dropoff_address_arr),
				        "dropoff_business_name"=> $arr['c_name'],
				        "dropoff_phone_number"=> $arr['c_phone'],
				        "dropoff_instructions"=> $arr['d_notes'],
				        "order_value"=> $total * 100,
				        "tip"=> $dasher_tip_amount * 100
				    );
				    $delivery_arr = pjAppController::doordashCreateDelivery($data_delivery, $option_arr);
				    if (isset($delivery_arr['external_delivery_id'])) {
				        $data_update = array();
				        $data_update['external_delivery_id'] = $delivery_arr['external_delivery_id'];
				        $data_update['dasher_name'] = @$delivery_arr['dasher_name'];
				        $data_update['dasher_dropoff_phone_number'] = @$delivery_arr['dasher_dropoff_phone_number'];
				        $data_update['dasher_pickup_phone_number'] = @$delivery_arr['dasher_pickup_phone_number'];
				        $data_update['dasher_vehicle_make'] = @$delivery_arr['dasher_vehicle_make'];
				        $data_update['dasher_vehicle_model'] = @$delivery_arr['dasher_vehicle_model'];
				        $data_update['dasher_vehicle_year'] = @$delivery_arr['dasher_vehicle_year'];
				        $data_update['num_of_recall_dasher'] = (int)$arr['num_of_recall_dasher'] + 1;
				        $pjOrderModel->reset()->set('id', $arr['id'])->modify($data_update);
				    }
				} else {
				    $pjOrderModel->reset()->set('id', $arr['id'])->modify(array('delivery_status' => $data['event_name']));
				    $data_insert = array(
				        'order_id' => $arr['id'],
				        'restaurant_id' => $arr['restaurant_id'],
				        'external_delivery_id' => $data['external_delivery_id'],
				        'delivery_name' => $data['dasher_name'],
				        'delivery_phone' => $data['dasher_dropoff_phone_number'],
				        'delivery_status' => $data['event_name']
				    );
				    $pjOrderDeliveryStatusModel->setAttributes($data_insert)->insert();
				    
				    /* Sens SMS */
				    if(!empty($arr['c_phone'])) {
				        $field = 'o_sms_'.strtolower($data['event_name']).'_message';
				        $lang_message = pjMultiLangModel::factory()
				        ->reset()
				        ->select('t1.*')
				        ->where('t1.model','pjOption')
				        ->where('t1.locale', $locale_id)
				        ->where('t1.field', $field)
				        ->where('t1.foreign_id', $arr['restaurant_id'])
				        ->limit(0, 1)
				        ->findAll()
				        ->getData();
				        if (count($lang_message) === 1)
				        {
				            $search = array('{OrderID}', '{Name}', '{Email}', '{Phone}', '{DeliveryName}', '{DeliveryPhone}', '{DeliveryStatus}');
				            $replace = array($arr['uuid'], $arr['c_name'], $arr['c_email'], $arr['c_phone'], $data['dasher_name'], $data['dasher_dropoff_phone_number'], $data['event_name']);
				            $message = str_replace($search, $replace, $lang_message[0]['content']);
				            if ($this->smsServiceProvider == 'clicksend') {
				                $config = ClickSend\Configuration::getDefaultConfiguration()
				                ->setUsername($option_arr['plugin_sms_api_username'])
				                ->setPassword($option_arr['plugin_sms_api_password']);
				                $apiInstance = new ClickSend\Api\SMSApi(new GuzzleHttp\Client(),$config);
				                $msg = new \ClickSend\Model\SmsMessage();
				                $msg->setBody($message);
				                $msg->setTo($arr['c_phone']);
				                $msg->setSource("sdk");
				                $sms_messages = new \ClickSend\Model\SmsMessageCollection();
				                $sms_messages->setMessages([$msg]);
				                try {
				                    $result = $apiInstance->smsSendPost($sms_messages);
				                    $resp = json_decode($result, true);
				                    pjSmsModel::factory()->reset()->setAttributes(array(
				                        'number' => $arr['c_phone'],
				                        'text' => $message,
				                        'provider' => 'clicksend',
				                        'restaurant_id' => $arr['restaurant_id'],
				                        'status' => @$resp['response_code']
				                    ))->insert();
				                } catch (Exception $e) {
				                    //echo 'Exception when calling SMSApi->smsSendPost: ', $e->getMessage(), PHP_EOL;
				                }
				            } else {
				                $params = array(
				                    'text' => $message,
				                    'type' => 'unicode',
				                    'restaurant_id' => $arr['restaurant_id'],
				                    'key' => md5(@$option_arr['private_key'] . PJ_SALT)
				                );
				                $params['number'] = $arr['c_phone'];
				                $params['provider'] = $this->smsServiceProvider;
				                $this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
				            }
				        }
				    }
				}
			}
		}
		//pjAppController::writeLog(print_r($data, true), 'delivery_statuses.log');
		header("HTTP/1.1 200 OK");
		exit;
	}
	
	public function pjActionSDP()
	{
		$this->setLayout('pjActionEmpty');	
		//pjAppController::writeLog('============ '.date('Y-m-d H:i:s').' ===============', 'ResultPrint.log');
		//pjAppController::writeLog(print_r($_REQUEST, true), 'ResultPrint.log');
		if ($this->option_arr['o_allow_automatic_print'] == 'Yes_SDP' && isset($_REQUEST["ConnectionType"]) && in_array($_REQUEST["ConnectionType"], array('GetRequest', 'SetResponse'))) {
			if ($_REQUEST["ConnectionType"] == 'GetRequest') {
				$locale_id = $this->getLocaleId();		
				$pjOrderModel = pjOrderModel::factory();	
				$booking_arr = $pjOrderModel
						->join('pjClient', "t2.id=t1.client_id", 'left outer')
						->join('pjRestaurant', "t3.id=t1.restaurant_id", 'left outer')
						->join('pjMultiLang', "t4.foreign_id = t3.id AND t4.model = 'pjRestaurant' AND t4.locale = '".$locale_id."' AND t4.field = 'name'", 'left')
						->select("t1.*, t2.c_title, t2.c_email, t2.c_name, t2.c_phone, t2.c_company, t2.c_address_1, t2.c_address_2, t2.c_country, t2.c_state, t2.c_city, t2.c_zip, t2.c_notes,
								t3.address AS restaurant_address, t3.phone AS restaurant_phone, t4.content AS restaurant_name, 
								AES_DECRYPT(t1.cc_type, '".PJ_SALT."') AS `cc_type`,	
								AES_DECRYPT(t1.cc_num, '".PJ_SALT."') AS `cc_num`,
								AES_DECRYPT(t1.cc_exp, '".PJ_SALT."') AS `cc_exp`,
								AES_DECRYPT(t1.cc_code, '".PJ_SALT."') AS `cc_code`")
						->where('t1.restaurant_id', (int)$_REQUEST['rid'])
						->where('t1.status', 'confirmed')
						->where('t1.sent_to_remote_printer', 'F')
                        ->where('sent_to_remote_printer_time >= DATE_SUB(NOW(), INTERVAL 1 HOUR)') //Khuetech thêm điều kiện chỉ in những đơn trong 1 giờ trở lại
						->orderBy('t1.created ASC')
						->limit(1)
						->findAll()
						->getDataIndex(0);						
				if ($booking_arr) {
					$pjOrderModel->reset()->set('id', $booking_arr['id'])->modify(array('sent_to_remote_printer' => 'T'));
					pjAppController::addOrderDetails($booking_arr, $locale_id);
				}
				$this->set('booking_arr', $booking_arr);
			}
			if ($_REQUEST["ConnectionType"] == 'SetResponse') {
				$xml = simplexml_load_string($_REQUEST["ResponseFile"]);
			    if (count($xml->response) != 0) {
			        foreach ($xml->response as $response) {
			        	if ($response['success'] == 'true') {
			        		//pjAppController::writeLog('============ '.date('Y-m-d H:i:s').' ===============', 'ResultPrint.log');
			        		//pjAppController::writeLog('ResponseFile: '.print_r($response, true), 'ResultPrint.log');
			        	}
			        }
			    }
			}
		}
	}
	
	public function testDoodash() {
		$this->setLayout('pjActionEmpty');
		
		$pjOrderModel = pjOrderModel::factory();
		$arr = $pjOrderModel->find(13)->getData();
		
		$delivery_status_arr = pjAppController::doordashAcceptDeliveryQuote($arr['external_delivery_id'], $this->option_arr);
		$data_update = array(
		    'dasher_name' => @$delivery_status_arr['dasher_name'],
		    'dasher_dropoff_phone_number' => @$delivery_status_arr['dasher_dropoff_phone_number'],
		    'dasher_pickup_phone_number' => @$delivery_status_arr['dasher_pickup_phone_number'],
		    'dasher_vehicle_make' => @$delivery_status_arr['dasher_vehicle_make'],
		    'dasher_vehicle_model' => @$delivery_status_arr['dasher_vehicle_model'],
		    'dasher_vehicle_year' => @$delivery_status_arr['dasher_vehicle_year']
		);
		$pjOrderModel->reset()->set('id', $arr['id'])->modify($data_update);
	echo '<pre>';
	print_r($delivery_status_arr);
	echo '</pre>';
	exit;
		
		$data = array(
			"pickup_address"=> '901 Market Street 6th Floor San Francisco, CA 94103',
			"pickup_business_name"=> 'R1',
			"pickup_phone_number"=> '+16505555555',
			"dropoff_address"=> '901 Market Street 6th floor, San Francisco, CA 94103, USA, San Francisco County, CA, 94103',
			"dropoff_business_name"=> '',
			"dropoff_phone_number"=> '+16505555555',
			"dropoff_instructions"=> '',
			"order_value"=> 1500
		);
		$delivery_quote_arr = pjAppController::doordashDeliveryQuote($data, $this->option_arr);
		echo "<pre>";
		print_r($delivery_quote_arr);
		echo "</pre>";
		
		exit;
	}
}
?>