<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAuthorize extends pjAuthorizeAppController
{
	private $currencies = array(
		'AUD',
		'GBP',
		'CAD',
		'DKK',
		'EUR',
		'NZD',
		'NOK',
		'PLN',
		'SEK',
		'CHF',
		'USD',
	);
	
	protected static $logPrefix = "Payments | pjAuthorize plugin<br>";
	
	protected static $paymentMethod = 'authorize';
	
	public function pjActionGetCustom()
    {
        $request = $this->getParams();
        $custom = isset($request['x_invoice_num']) ? $request['x_invoice_num']: null;
        if (!empty($custom))
        {
            $this->log(self::$logPrefix . "Start confirmation process for: {$custom}<br>Request Data:<br>" . print_r($request, true));
        } else {
            $this->log(self::$logPrefix . "Missing parameters. Cannot start confirmation process.<br>Request Data:<br>" . print_r($request, true));
        }

        return $custom;
    }
    
	public function pjActionGetCurrencies()
	{
		return $this->currencies;
	}
	
	public function pjActionCheckCurrency()
	{
		$params = $this->getParams();
		
		if (!isset($params['currency']) || empty($params['currency']))
		{
			return array('status' => 'ERR', 'code' => 100, 'text' => 'Missing or empty \'currency\' parameter');
		}
		
		$currency = strtoupper($params['currency']);
		
		if (!in_array($currency, $this->currencies))
		{
			return array(
				'status' => 'ERR', 
				'code' => 101, 
				'text' => sprintf(__('plugin_authorize_currency_not_supported', true), $currency),
				'currency' => $currency,
				'currencies' => $this->currencies,
			);
		}
		
		return array(
			'status' => 'OK', 
			'code' => 200, 
			'text' => sprintf(__('plugin_authorize_currency_supported', true), $currency),
			'currency' => $currency,
			'currencies' => $this->currencies,
		);
	}
   
	public function log($content, $filename='')
	{
		if (true)
		{
			$filename = 'payment.log';
			@file_put_contents($filename, $content . "\n", FILE_APPEND|FILE_TEXT);
		}		
	}
	
	public function pjActionConfirm()
	{
		$params = $this->getParams();
        $request = $params['request'];

		$this->log(''); $this->log(''); $this->log('');
		$this->log('Authorize.net Confirm '.date("Y-m-d H:i:s"));

		/*
		if (!isset($params['key']) || $params['key'] != md5(PJ_SALT))
		{
            $this->log(self::$logPrefix . "Missing or invalid 'key' parameter.");
			return FALSE;
		}
		*/
		
        $response = array('status' => 'FAIL', 'redirect' => true);

        $merchant_id = $params['merchant_id'];
        $public_key  = $params['public_key'];
        $private_key = $params['private_key'];
        $sandbox     = $params['sandbox'];
		
		$sdk = new pjAuthorizeSDK($merchant_id, $public_key, $private_key, $sandbox);
		
		try {
			
			if (array_key_exists('x_trans_id', $request))
			{
				$id = $request['x_trans_id'];
				
			} elseif (array_key_exists('transId', $request)) {
				
				$id = $request['transId'];
				
			} else {
				$id = null;
			}
			
			$transaction = $sdk->getTransactionDetails($id);
			
			ob_start();
			var_dump($transaction);
			$content = ob_get_contents();
			ob_end_clean();		
			$this->log('Transaction: '. $content);
			
			if ((int) $transaction['responseCode'] === 1)
			{
				$response['status'] = 'OK';
				$response['txn_id'] = $transaction['transId'];
				$this->log(self::$logPrefix . "Payment was successful. Transaction ID: {$transaction['transId']}.");
			} else {
				$response['response_reason_code'] = $transaction['responseReasonCode'];
				$response['response_code']        = $transaction['responseCode'];
				$response['response_reason_text'] = $transaction['responseReasonDescription'];
				$this->log(self::$logPrefix . "Payment was not successful. " . sprintf('Reason text: %s | Reason code: %s | Code: %s', $transaction['responseReasonDescription'], $transaction['responseReasonCode'], $transaction['responseCode']));
			}
			
		} catch (Exception $e) {
			$this->log(self::$logPrefix . $e->getMessage());
		}

		return $response;
	}
	
	public function pjActionIframeCommunicator()
	{
		$this->setAjax(true);
		$this->setLayout('pjActionEmpty');
	}
	
	public function pjActionForm()
	{
		$this->setLayout('pjActionEmpty');

        $params = $this->getParams();
        
        $sdk = new pjAuthorizeSDK($params['merchant_id'], $params['public_key'], $params['private_key'], $params['is_test_mode']);
        
        try {        	
        	$params['hostedPaymentToken'] = $sdk->getClientToken(
        		$params['amount'], 
        		$params['custom'], 
        		$params['description'], 
        		$params['notify_url'], 
        		$params['cancel_url'], 
        		PJ_INSTALL_URL .'authorize-iframe-communicator.html',
        		__('authorize_pay_btn_title', true), 
        		__('authorize_continue_btn_title', true), 
        		__('authorize_cancel_btn_title', true)
        	);
        	
        } catch (Exception $e) {
        	echo $e->getMessage();
        }
        
        $this->set('arr', $params);
        /*
		$this->setAjax(true);
		//KEYS:
		//-------------
		//name
		//id
		//timezone
		//transkey
		//x_login
		//x_description
		//x_amount
		//x_invoice_num
		//x_receipt_link_url
		//x_relay_url
		//submit
		//submit_class
		//target
		$this->set('arr', $this->getParams());*/
	}
}
?>