<div class="">
  <p style="padding: 10px 0px; text-align: center; font-weight: bold;">
      REPORT/DASHBOARD<br><i>Approved status</i>
  </p>
  <div class="row">
    <div class="col">
      <div class="panel panel-info">
        <div class="panel-heading" style="background: #f2f3c3;">
          Total Orders (Confirmed)
        </div>
        <div class="panel-body">
          <?php echo $tpl['total_orders_confirmed'].'/'.$tpl['total_orders']?>
        </div>
      </div>
    </div>

    <div class="col">
      <div class="panel panel-danger">
        <div class="panel-heading" style="background: #d3f7d3;">
          Total Discount
        </div>
        <div class="panel-body">
          <?php echo pjUtil::formatCurrencySign(number_format($tpl['total_discount'], 2), $tpl['option_arr']['o_currency']);?>
        </div>
      </div>
    </div>

    <div class="col">
      <div class="panel panel-danger">
        <div class="panel-heading" style="background: #d1e7ff;">
          Total Tax
        </div>
        <div class="panel-body">
          <?php echo pjUtil::formatCurrencySign(number_format($tpl['total_tax'], 2), $tpl['option_arr']['o_currency']);?>
        </div>
      </div>
    </div>

    <div class="col">
      <div class="panel panel-danger">
        <div class="panel-heading" style="background: #ffd1d1;">
          Total Amount (Sales)
        </div>
        <div class="panel-body">
          <?php echo pjUtil::formatCurrencySign(number_format($tpl['total_amount'], 2), $tpl['option_arr']['o_currency']);?>
        </div>
      </div>
    </div>
  </div>

  <br>
  <fieldset class="fieldset white">
    <legend>REPORT TOTAL</legend>
    <div class="row">
      <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">

        <tbody>
          <tr>
            <td>Total orders</td>
            <td><?php echo $tpl['total_orders']?></td>
          </tr>
          <tr>
            <td>Total orders confirmed</td>
            <td><?php echo $tpl['total_orders_confirmed']?></td>
          </tr>
          <tr>
            <td>Total products ordered</td>
            <td><?php echo $tpl['total_products_ordered']?></td>
          </tr>
          <tr>
            <td>Total tax</td>
            <td><?php echo pjUtil::formatCurrencySign(number_format($tpl['total_tax'], 2), $tpl['option_arr']['o_currency']);?></td>
          </tr>
          <tr>
            <td>Total discount</td>
            <td><?php echo pjUtil::formatCurrencySign(number_format($tpl['total_discount'], 2), $tpl['option_arr']['o_currency']);?></td>
          </tr>
          <tr>
            <td>Total tip</td>
            <td><?php echo pjUtil::formatCurrencySign(number_format($tpl['total_tip'], 2), $tpl['option_arr']['o_currency']);?></td>
          </tr>
          <tr>
            <td>Total amount (Sales)</td>
            <td><?php echo pjUtil::formatCurrencySign(number_format($tpl['total_amount'], 2), $tpl['option_arr']['o_currency']);?></td>
          </tr>
        </tbody>
      </table>
    </div>
  </fieldset>


  <br>
  <fieldset class="fieldset white">
    <legend>TRANSACTION REPORT</legend>
    <div class="row">
      <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">
        <thead>
          <th>Status</th>
          <th style="width: 20%;">Total ordered</th>
          <th style="width: 35%;">Total amount</th>
        </thead>
        <tbody>
        <?php
        foreach($tpl['transaction_arr'] as $k => $v)
        {
        ?>
          <tr>
            <td><?php echo pjSanitize::html($v['status']);?></td>
            <td><?php echo (int) $v['total_ordered'];?></td>
            <td><?php echo pjUtil::formatCurrencySign(number_format( (float)$v['total_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
          </tr>
          <?php
        }
        ?>
        </tbody>
      </table>
    </div>
  </fieldset>

  <br>
  <fieldset class="fieldset white">
    <legend>CATEGORY REPORT</legend>
    <div class="row">
      <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">
        <thead>
          <th>Category</th>
          <th style="width: 20%;">Products ordered</th>
          <th style="width: 35%;">Total amount</th>
        </thead>
        <tbody>
        <?php
        foreach($tpl['category_arr'] as $k => $v)
        {
          ?>
          <tr>
            <td><?php echo pjSanitize::html($v['name']);?></td>
            <td><?php echo (int) $v['total_ordered'];?></td>
            <td><?php echo pjUtil::formatCurrencySign(number_format( (float)$v['total_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
          </tr>
          <?php
        }
        ?>
        </tbody>
      </table>
    </div>
  </fieldset>

  <br>
  <fieldset class="fieldset white">
    <legend>PRODUCT REPORT</legend>
    <div class="row">
      <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">
        <thead>
        <th>Product</th>
        <th style="width: 20%;">Quanlity</th>
        <th style="width: 35%;">Total amount</th>
        </thead>
        <tbody>
        <?php
        foreach($tpl['product_arr'] as $k => $v)
        {
          ?>
          <tr>
            <td><?php echo pjSanitize::html($v['name']);?></td>
            <td><?php echo (int) $v['total_ordered'];?></td>
            <td><?php echo pjUtil::formatCurrencySign(number_format( (float)$v['total_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
          </tr>
          <?php
        }
        ?>
        </tbody>
      </table>
    </div>
  </fieldset>

    <br>
    <div align="center">
        <input type="button" value="Export to PDF" class="pj-button" onclick="window.open('<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&action=pjActionExportReport&date_from=<?php echo $tpl['date_from']; ?>&date_to=<?php echo $tpl['date_to']; ?>&hash=<?php echo sha1(date().PJ_SALT)?>')"/>
    </div>
</div>

<style>
  .row{
    width: 100%;
  }

  .col{
    width: 25%;
    float: left;
  }

  .row:after{
    content: "";
    display: table;
    clear: both;
  }

  .panel{
    margin: 10px;
    border: 1px gray solid;
    border-radius: 5px;
  }

  .panel-heading{
    padding: 10px;
    font-weight: bold;
    font-size: 12px;
    border-radius: 5px 5px 0px 0px;
  }

  .panel-body{
    padding: 10px;
    font-size: 20px;
    text-align: center;
  }
</style>

