<?php
if (isset($tpl['status'])) {
    $status = __('status', true);
    switch ($tpl['status']) {
        case 2:
            pjUtil::printNotice(NULL, $status[2]);
            break;
    }
    exit;
}

$date_from = date('m/d/Y', strtotime(date('m-1-Y 0:0')));
$date_to = date("m/d/Y", strtotime("today"));

$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int)$tpl['option_arr']['o_week_start'], range(0, 6)) ? (int)$tpl['option_arr']['o_week_start'] : 0;
$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);

include_once("tabs.php");

?>

<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
        <li class="ui-state-default ui-corner-top ui-tabs-active">
            <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionReport">Stat/Report</a>
        </li>
        <li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active">
            <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionReportSettlement">Batch
                Manager/Settlement Report</a>
        </li>
    </ul>
</div>

<?php
pjUtil::printNotice("Settlement Report", "Select one date that you wan to see the report.");
?>


<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js"></script>
<style>
    #filter {
        display: flex;
        margin-bottom: 10px;
    }

    #filter .ebox {
        display: flex;
        align-items: center;
    }

    #filter .ebox .title {
        margin-right: 5px;
    }

    #filter .ebox .inline_block {

    }

    #filter .ebox .inline_block a {
        padding: 7px 6px;
        background: #eeeeee;
        border-radius: 3px;
        cursor: pointer;
        color: black;
    }
</style>

<div align="center">
<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&action=pjActionReportSettlement" method="post" id="frmReport" autocomplete="off">
    <div align="center" style="width: fit-content;">
    <input type="hidden" name="generate_report" value="1"/>
    <div id="filter">
        <div class="ebox" style="margin-right: 5px;">
        <span class="inline_block">
            <a class="pj-button previous_date">< Previous a day</a>
        </span>
        </div>

        <div class="ebox">
        <span class="inline_block">
    				<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
              <input type="text" name="date_from" id="date_from"
                     value="<?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['date_from'])); ?>"
                     class="pj-form-field pointer w80 datepick date_from" readonly="readonly"
                     rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
              <span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
            </span>
    			</span>
        </div>
        <div class="ebox" style="display: none;">
            <label class="title"><?php __('lblDateTo'); ?></label>
            <span class="inline_block">
    				<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
              <input type="text" name="date_to" id="date_to" value="<?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['date_to']));?>" class="pj-form-field pointer w80 datepick date_to" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
              <span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
            </span>
    			</span>
        </div>

        <div class="ebox">
        <span class="inline_block">
            <a class="pj-button next_date">Next a day ></a>
        </span>
        </div>
    </div>
    </div>

</form>
</div>
<div id="pjFdReportContent"></div>

