<?php
if ($tpl['option_arr']['o_allow_automatic_print'] == 'Yes_SDP') {
	if (isset($_REQUEST["ConnectionType"])) {
	    $http_request = $_REQUEST["ConnectionType"];
	} else {
		$http_request = '';
	}
	if ($http_request == 'GetRequest') {
	    # send print data
	    # ID
	    $shop_id = $_REQUEST["ID"];
	    if ($tpl['booking_arr']) {
	    	$o_printer_copies = (int)$tpl['option_arr']['o_printer_copies'] > 0 ? (int)$tpl['option_arr']['o_printer_copies'] : 1;
		    $PrintRequestInfo = new SimpleXMLElement('<PrintRequestInfo/>');
		    $delivery_address = '';
			if ($tpl['booking_arr']['type'] == 'pickup') {
				$ts = strtotime($tpl['booking_arr']['p_dt']);
				$notes = $tpl['booking_arr']['p_notes'];
			} elseif ($tpl['booking_arr']['type'] == 'delivery') {
				$ts = strtotime($tpl['booking_arr']['d_dt']);
				$notes = $tpl['booking_arr']['d_notes'];
				$delivery_address = $tpl['booking_arr']['d_address_1'];
			} else {
				$ts = strtotime($tpl['booking_arr']['ca_dt']);
				$notes = $tpl['booking_arr']['ca_notes'];
				$delivery_address = $tpl['booking_arr']['ca_address_1'];
			}
			$date_time = date($tpl['option_arr']['o_date_format'], $ts) . ', ' . date('h:i a', $ts);
			if($tpl['booking_arr']['type'] == 'pickup' &&  $tpl['booking_arr']['p_asap'] == 'T')
			{
				$date_time = date($tpl['option_arr']['o_date_format'], $ts) . ', ' . __('front_asap', true);
			}
			if($tpl['booking_arr']['type'] == 'delivery' &&  $tpl['booking_arr']['d_asap'] == 'T')
			{
				$date_time = date($tpl['option_arr']['o_date_format'], $ts) . ', ' . __('front_asap', true);
			}
			$total_items = 0;
			$has_selected_extras = false;
			if (isset($tpl['booking_arr']['product_arr']))
			{
				foreach ($tpl['booking_arr']['product_arr'] as $v)
				{
					$total_items += $v['cnt'];
					if (isset($v['extra_arr']) && count($v['extra_arr']) > 0) {
						$has_selected_extras = true;
					}
				}
			}
			foreach (range(1, $o_printer_copies) as $idx) {
			    $ePOSPrint = $PrintRequestInfo->addChild('ePOSPrint');
			    $Parameter = $ePOSPrint->addChild('Parameter');
			    $Parameter->addChild('devid', $shop_id);
			    $Parameter->addChild('timeout', "10000");
			    
			    $PrintData = $ePOSPrint->addChild('PrintData');
			    $epos_print = $PrintData->addChild('epos-print');
			    $epos_print->addAttribute('xmlns', 'http://www.epson-pos.com/schemas/2011/03/epos-print');
			    $epos_print->addChild('text')->addAttribute('smooth', 'true');
			    $epos_print->addChild('text')->addAttribute('align', 'center');
			    $epos_print->addChild('text')->addAttribute('font', 'font_b');
			    $wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '2');
			    $wh->addAttribute('height', '2');
		    	if ($tpl['booking_arr']['type'] == 'pickup') {
					$epos_print->addChild('text', __('front_printer_customer_pickup', true));
				} else {
					$epos_print->addChild('text', __('front_printer_customer_delivery', true));
				}
				$epos_print->addChild('feed')->addAttribute('line', '1');
				$epos_print->addChild('text', '---------------------------');
				$epos_print->addChild('feed')->addAttribute('line', '1');
				
				$wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '1');
			    $wh->addAttribute('height', '1');
			    $epos_print->addChild('text', __('front_printer_customer_name', true));
			    $epos_print->addChild('feed')->addAttribute('line', '1');

			    $wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '2');
			    $wh->addAttribute('height', '2');
			    $epos_print->addChild('text', htmlspecialchars($tpl['booking_arr']['c_name']));
			    $epos_print->addChild('feed')->addAttribute('line', '1');

				/*Khuetech*/
				$epos_print->addChild('feed')->addAttribute('line', '1');

		    	if (!empty($tpl['booking_arr']['c_phone'])) {
					$wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '1');
				    $wh->addAttribute('height', '1');
				    $epos_print->addChild('text', __('front_printer_customer_phone', true));
				    $epos_print->addChild('feed')->addAttribute('line', '1');
			    
					$wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '2');
				    $wh->addAttribute('height', '2');
				    $epos_print->addChild('text', htmlspecialchars($tpl['booking_arr']['c_phone']));				    
					$epos_print->addChild('feed')->addAttribute('line', '1');

					/*Khuetech*/
					$epos_print->addChild('feed')->addAttribute('line', '1');
				}
				
				$wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '1');
			    $wh->addAttribute('height', '1');
			    if ($tpl['booking_arr']['type'] == 'pickup') {								
			    	$epos_print->addChild('text', __('front_printer_pickup_time', true));
				} else {
					$epos_print->addChild('text', __('front_printer_delivery_time', true));
				}
				$epos_print->addChild('feed')->addAttribute('line', '1');
				
				$wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '2');
			    $wh->addAttribute('height', '2');
			    $epos_print->addChild('text', $date_time);
			    $epos_print->addChild('feed')->addAttribute('line', '1');

				/*Khuetech*/
				$epos_print->addChild('feed')->addAttribute('line', '1');

		    	if ($tpl['booking_arr']['type'] != 'pickup') {		
					$wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '1');
				    $wh->addAttribute('height', '1');				
				    $epos_print->addChild('text', __('front_printer_delivery_address', true));	
				    $epos_print->addChild('feed')->addAttribute('line', '1');
					
				    $wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '2');
				    $wh->addAttribute('height', '2');
				    $epos_print->addChild('text', $delivery_address);
				    $epos_print->addChild('feed')->addAttribute('line', '1');

					/*Khuetech*/
					$epos_print->addChild('feed')->addAttribute('line', '1');
				}
				
		    	if ($tpl['booking_arr']['type'] == 'delivery' && (int)$tpl['booking_arr']['is_dashdoor_delivery'] == 1) {	
		    		$wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '2');
				    $wh->addAttribute('height', '2');				
				    $epos_print->addChild('text', __('front_printer_doordash_delivery', true));	
				    $epos_print->addChild('feed')->addAttribute('line', '1');
				    
				    $wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '1');
				    $wh->addAttribute('height', '1');				
				    $epos_print->addChild('text', __('front_printer_doordash_delivery_name', true));
				    $epos_print->addChild('feed')->addAttribute('line', '1');
	
				    $wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '2');
				    $wh->addAttribute('height', '2');
				    $epos_print->addChild('text', $tpl['booking_arr']['dasher_name']);		
				    $epos_print->addChild('feed')->addAttribute('line', '1');						
				    
				    $wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '1');
				    $wh->addAttribute('height', '1');				
				    $epos_print->addChild('text', __('front_printer_doordash_delivery_phone', true));
				    $epos_print->addChild('feed')->addAttribute('line', '1');
	
				    $wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '2');
				    $wh->addAttribute('height', '2');
				    $epos_print->addChild('text', $tpl['booking_arr']['dasher_dropoff_phone_number']);
				    $epos_print->addChild('feed')->addAttribute('line', '1');

					/*Khuetech*/
					$epos_print->addChild('feed')->addAttribute('line', '1');
				}
				
				$wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '1');
			    $wh->addAttribute('height', '1');				
			    $epos_print->addChild('text', __('front_printer_order_number', true));
			    $epos_print->addChild('feed')->addAttribute('line', '1');
	
			    $wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '2');
			    $wh->addAttribute('height', '2');
			    $epos_print->addChild('text', $tpl['booking_arr']['uuid']);
			    $epos_print->addChild('feed')->addAttribute('line', '1');

				/*Khuetech*/
				$epos_print->addChild('feed')->addAttribute('line', '1');

			    $wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '1');
			    $wh->addAttribute('height', '1');				
			    $epos_print->addChild('text', __('front_printer_total_items', true));
			    $epos_print->addChild('feed')->addAttribute('line', '1');
			    
			    $wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '2');
			    $wh->addAttribute('height', '2');
				if ($total_items > 1) {
					$epos_print->addChild('text', sprintf(__('front_printer_plural_items', true), $total_items));
				} else {
					$epos_print->addChild('text', sprintf(__('front_printer_single_items', true), $total_items));
				}
				$epos_print->addChild('feed')->addAttribute('line', '1');

				/*Khuetech*/
				$epos_print->addChild('feed')->addAttribute('line', '1');

		   	 	if ($has_selected_extras) {
		   	 		$wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '4');
				    $wh->addAttribute('height', '1');
				    $epos_print->addChild('text', __('front_attention_modifiers_added', true));
				    $epos_print->addChild('feed')->addAttribute('line', '1');

					/*Khuetech*/
					$epos_print->addChild('feed')->addAttribute('line', '1');
				}

				if (!empty($notes)) {
					$wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '1');
				    $wh->addAttribute('height', '1');				
				    $epos_print->addChild('text', __('front_printer_notes', true));
				    $epos_print->addChild('feed')->addAttribute('line', '1');
		
				    $wh = $epos_print->addChild('text');
				    $wh->addAttribute('width', '2');
				    $wh->addAttribute('height', '2');
				    $epos_print->addChild('text', $notes);
				    $epos_print->addChild('feed')->addAttribute('line', '1');

					/*Khuetech*/
					$epos_print->addChild('feed')->addAttribute('line', '1');
				}				
				
				/* Items */
				$wh = $epos_print->addChild('text');
				$wh->addAttribute('width', '2');
				$wh->addAttribute('height', '2');
				$epos_print->addChild('text')->addAttribute('align', 'left');
			    $epos_print->addChild('text')->addAttribute('font', 'font_a');
			    $epos_print->addChild('text', '-----------------------');
			    $epos_print->addChild('feed')->addAttribute('line', '1');
			    
		    	if (isset($tpl['booking_arr']['product_arr']))
				{
					foreach ($tpl['booking_arr']['product_arr'] as $v)
					{
						$price = $v['price'] * $v['cnt'];
						$extra = array();
						$modifier = array();
						foreach ($v['extra_arr'] as $e)
						{
							$extra[] = htmlspecialchars(sprintf("%u x %s", $e['cnt'], $e['name']));
							$price += $e['price'] * $e['cnt'];
						}
						foreach ($v['modifier_item_arr'] as $mi)
						{
							if ((float)$mi['price'] > 0) {
								$modifier[] = htmlspecialchars(sprintf("%s (+%s)", $mi['item_name'], pjUtil::formatCurrencySign(number_format($mi['price'], 2), $tpl['option_arr']['o_currency'])));
								$price += (float)$mi['price'];
							} else {
								$modifier[] = htmlspecialchars($mi['item_name']);
							}
						}
						
						$group_items = array();
						foreach ($v['group_item_arr'] as $pgi)
						{
							$group_items[] = htmlspecialchars($pgi['group_item_name']);
						}
						
						$wh = $epos_print->addChild('text');
					    $wh->addAttribute('width', '2');
					    $wh->addAttribute('height', '2');	
					    $product_price = pjUtil::formatCurrencySign(number_format($price, 2), $tpl['option_arr']['o_currency']);			    				    
						if(!empty($v['size']))
						{
							$epos_print->addChild('text', htmlspecialchars(sprintf("%u x %s (%s)", $v['cnt'], $v['name'], $v['size'])).' '.$product_price);
						}else{
							$epos_print->addChild('text', htmlspecialchars(sprintf("%u x %s", $v['cnt'], $v['name'])).' '.$product_price);
						}
						$epos_print->addChild('feed')->addAttribute('line', '1');

						/*Khuetech*/
						$epos_print->addChild('feed')->addAttribute('line', '1');

					    /* extras & group items */						
						$wh = $epos_print->addChild('text');
					    $wh->addAttribute('width', '2');
					    $wh->addAttribute('height', '2');
					    
						$em = $epos_print->addChild('text');
					    $em->addAttribute('reverse', 'false');
					    $em->addAttribute('ul', 'false');
					    $em->addAttribute('em', 'false');
						if (count($extra) > 0) {
							foreach ($extra as $ex) {
								$epos_print->addChild('text', $ex);
								$epos_print->addChild('feed')->addAttribute('line', '1');
							}
						}
						if (count($group_items) > 0) {
							foreach ($group_items as $gi) {
								$epos_print->addChild('text', $gi);
								$epos_print->addChild('feed')->addAttribute('line', '1');	
							}
						}
						if (count($modifier) > 0) {
							foreach ($modifier as $mi) {
								$epos_print->addChild('text', $mi);	
								$epos_print->addChild('feed')->addAttribute('line', '1');
							}
						}
						/* end extras & group items */
						
						$wh = $epos_print->addChild('text');
					    $wh->addAttribute('width', '1');
					    $wh->addAttribute('height', '1');
					    
					    $em = $epos_print->addChild('text');
					    $em->addAttribute('reverse', 'false');
					    $em->addAttribute('ul', 'false');
					    $em->addAttribute('em', 'false');
						$epos_print->addChild('text', '-----------------------------------------------');
						$epos_print->addChild('feed')->addAttribute('line', '1');
					}
				}
				$epos_print->addChild('feed')->addAttribute('line', '1');
			    
		     	$epos_print->addChild('text')->addAttribute('font', 'font_b');
			    $wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '2');
			    $wh->addAttribute('height', '2');
		    	if ($total_items > 1) {
					$epos_print->addChild('text', sprintf(__('front_printer_plural_total_items', true), $total_items));
				} else {
					$epos_print->addChild('text', sprintf(__('front_printer_single_total_items', true), $total_items));
				}
				$epos_print->addChild('feed')->addAttribute('line', '1');		
								
				$epos_print->addChild('text', __('front_printer_subtotal', true).': '.pjUtil::formatCurrencySign(number_format($tpl['booking_arr']['subtotal'], 2), $tpl['option_arr']['o_currency']));				
				$epos_print->addChild('feed')->addAttribute('line', '1');			
				
				$epos_print->addChild('text', __('front_printer_tax', true).': '.pjUtil::formatCurrencySign(number_format($tpl['booking_arr']['tax'], 2), $tpl['option_arr']['o_currency']));				
				$epos_print->addChild('feed')->addAttribute('line', '1');			
				
				$epos_print->addChild('text', __('front_printer_tip', true).': '.pjUtil::formatCurrencySign(number_format($tpl['booking_arr']['tip_amount'], 2), $tpl['option_arr']['o_currency']));				
				$epos_print->addChild('feed')->addAttribute('line', '1');		
				
				$wh = $epos_print->addChild('text');
			    $wh->addAttribute('width', '3');
			    $wh->addAttribute('height', '3');
		    	$epos_print->addChild('text', __('front_printer_total', true).': '.pjUtil::formatCurrencySign(number_format($tpl['booking_arr']['total'], 2), $tpl['option_arr']['o_currency']));
		    	$epos_print->addChild('feed')->addAttribute('line', '1');

				/*Khuetech*/
				$epos_print->addChild('feed')->addAttribute('line', '1');

		    	$epos_print->addChild('cut')->addAttribute('type', 'feed');
			}
			echo $PrintRequestInfo->asXML();
	    }
	} elseif ($http_request == 'SetResponse') {
	    # get print result
	    $xml = simplexml_load_string($_REQUEST["ResponseFile"]);
	    if (count($xml->response) != 0) {
	        # save log
	        /*$filename = "ResultPrint.log";
	        foreach ($xml->response as $response) {
	            $strmsg = sprintf("success : %s\ncode : %s\n", @$response['success'], @$response['code']);	            
	            @file_put_contents($filename, $strmsg . "\r\n", FILE_APPEND|FILE_TEXT);
	            @file_put_contents($filename, print_r($response, true) . "\r\n", FILE_APPEND|FILE_TEXT);
	        }*/
	    }
	} else {
	    # Ignore other connectionType than GetRequest and SetResponse.
	}
}
?>
