var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateModifier = $("#frmCreateModifier"),
			$frmUpdateModifier = $("#frmUpdateModifier"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			remove_arr = new Array();
		
		function setItems()
		{
			var index_arr = new Array();				
			$('#fd_item_list').find(".fd-item-row").each(function (index, row) {
				index_arr.push($(row).attr('data-index'));
			});
			$('#index_arr').val(index_arr.join("|"));
		}
		
		if ($frmCreateModifier.length > 0 && validate) {
			$frmCreateModifier.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				},
				submitHandler: function(form){
					var valid = true,
						localeId = null;
					setItems();
					$("#frmCreateModifier .pj-positive-number").each(function() {
						if($.isNumeric($(this).val()) == false)
					    {
					    	valid = false;
					    	$(this).addClass('pj-error-field');
					    }else{
					    	valid = true;
					    	$(this).removeClass('pj-error-field');
					    }
					});
					$("#frmCreateModifier .fdRequired").each(function() {
						if($(this).val() == '')
						{
							valid = false;
					    	$(this).addClass('pj-error-field');
					    	if(localeId == null)
					    	{
					    		localeId = $(this).attr('lang');
					    	}
					    	
						}else{
							$(this).removeClass('pj-error-field');
						}
					});
					if(localeId != null)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
					
					if(valid == true)
					{
						form.submit();
					}
				}
			});
		}
		if ($frmUpdateModifier.length > 0 && validate) {
			$frmUpdateModifier.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				},
				submitHandler: function(form){
					var valid = true,
						localeId = null;
					setItems();
					$("#frmUpdateModifier .pj-positive-number").each(function() {
						if($.isNumeric($(this).val()) == false)
					    {
					    	valid = false;
					    	$(this).addClass('pj-error-field');
					    }else{
					    	valid = true;
					    	$(this).removeClass('pj-error-field');
					    }
					});
					$("#frmUpdateModifier .fdRequired").each(function() {
						if($(this).val() == '')
						{
							valid = false;
					    	$(this).addClass('pj-error-field');
					    	if(localeId == null)
					    	{
					    		localeId = $(this).attr('lang');
					    	}					    	
						}else{
							$(this).removeClass('pj-error-field');
						}
					});
					if(localeId != null)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
					
					if(valid == true)
					{
						form.submit();
					}
				}
			});
		}
		if ($frmCreateModifier.length > 0 || $frmUpdateModifier.length > 0) 
		{
			if(myLabel.locale_array.length > 0)
			{
				var locale_array = myLabel.locale_array;
				for(var i = 0; i < locale_array.length; i++)
				{
					var name = $("#i18n_name_" + locale_array[i]);
					name.rules('add', {
						messages: {
					    	required: myLabel.field_required
					    }
					});
				}
			}
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminModifiers&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminModifiers&action=pjActionDeleteModifier&id={:id}"}
				          ],
				columns: [{text: myLabel.modifier_name, type: "text", sortable: true, editable: true, width: 380, editableWidth: 360},
				          {text: myLabel.products_used, type: "text", sortable: true, editable: false, width: 130, align: 'center'}],
				dataUrl: "index.php?controller=pjAdminModifiers&action=pjActionGetModifier",
				dataType: "json",
				fields: ['name', 'products'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminModifiers&action=pjActionDeleteModifierBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminModifiers&action=pjActionSaveModifier&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminModifiers&action=pjActionGetModifier", "name", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", '.pj-add-item', function(e){
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var clone_text = $('#fd_item_clone').html(),
				index = Math.ceil(Math.random() * 999999),
				number_of_items = $('#fd_item_list').find(".fd-item-row").length,
				order = parseInt(number_of_items, 10) + 1;
			clone_text = clone_text.replace(/\{INDEX\}/g, 'fd_' + index);
			clone_text = clone_text.replace(/\{ORDER\}/g, order);
			$('#fd_item_list').append(clone_text);
		}).on("click", '.pj-remove-item', function(e){
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $item = $(this).parent().parent(),
				id = $item.attr('data-index');
			if(id.indexOf("fd") == -1)
			{
				remove_arr.push(id);
			}
			$('#remove_arr').val(remove_arr.join("|"));
			$item.remove();
			
			$('#fd_item_list').find(".fd-item-row").each(function (order, row) {
				var index = $(row).attr('data-index'),
					title = myLabel.item + " " + (order + 1) + ":";
				$('.fd-title-' + index).html(title);
			});
		}).on("keyup", '.pj-positive-number', function(e){
			if($.isNumeric($(this).val()) == false)
		    {
		    	$(this).addClass('pj-error-field');
		    }else{
		    	$(this).removeClass('pj-error-field');
		    }
		}).on("keyup", '.fdRequired', function(e){
			if($(this).val() == '')
			{
				$(this).addClass('pj-error-field');
			}else{
				$(this).removeClass('pj-error-field');
			}
			
		});
	});
})(jQuery_1_8_2);