var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmTimeCustom = $("#frmTimeCustom"),
			$frmDefaultTime = $("#frmDefaultTime"),
			validate = ($.fn.validate !== undefined),
			datepicker = ($.fn.datepicker !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs");
		
		$('.pj-timepicker').timepicker({
			showPeriod: myLabel.showperiod,
			showPeriodLabels: myLabel.showPeriodLabels,
			amPmText: myLabel.amPmText
		});
		
		if ($frmTimeCustom.length > 0 && validate) {
			$frmTimeCustom.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em"
			});
		}
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminTime&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminTime&action=pjActionDeleteDate&id={:id}"}
				          ],
				columns: [{text: myLabel.date, type: "date", sortable: true, editable: false, renderer: $.datagrid._formatDate, dateFormat: pjGrid.jsDateFormat},
				          {text: myLabel.type, type: "text", sortable: true, editable: false},
				          {text: myLabel.start_time, type: "text", sortable: true, editable: false},
				          {text: myLabel.end_time, type: "date", sortable: true, editable: false},
				          {text: myLabel.is_day_off, type: "text", sortable: true, editable: false}],
				dataUrl: "index.php?controller=pjAdminTime&action=pjActionGetDate" + pjGrid.queryString,
				dataType: "json",
				fields: ['date', 'type', 'start_time', 'end_time', 'is_dayoff'],
				paginator: {
					actions: [
							   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminTime&action=pjActionDeleteDateBulk", render: true, confirmation: myLabel.delete_confirmation}
							],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".pickup-working-day", function () {
			var $this = $(this),
				$tr = $this.closest("tr"),
				day = $tr.attr('data-day');
			if ($this.is(":checked")) {
				$('.pickupWorkingDay_' + day).hide();
			} else {
				$('.pickupWorkingDay_' + day).show();
			}
		}).on("click", ".delivery-working-day", function () {
			var $this = $(this),
				$tr = $this.closest("tr"),
				day = $tr.attr('data-day');
			if ($this.is(":checked")) {
				$('.deliveryWorkingDay_' + day).addClass('fdDayOff');
			} else {
				$('.deliveryWorkingDay_' + day).removeClass('fdDayOff');
			}
		}).on("change", "input[name='is_dayoff']", function () {
			var $this = $(this),
				$form = $this.closest("form");
			if ($this.is(":checked")) {
				$form.find(".business").hide();
			} else {
				$form.find(".business").show();
			}
		}).on("focusin", ".datepick", function (e) {
			var $this = $(this);
			$this.datepicker({
				firstDay: $this.attr("rel"),
				dateFormat: $this.attr("rev")
			});
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
		}).on("click", ".pj-add-hours", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $row = $(this).closest('.rowWT'),
				$day = $row.attr('data-day'),
				$type = $row.attr('data-type'),
				$parent = $row.find('.pjLocationWTWrap'),
				clone_text = $('.pjLocationWTClone').html(),
				$index = Math.ceil(Math.random() * 999999);
			clone_text = clone_text.replace(/\{INDEX\}/g, 'new_' + $index);
			clone_text = clone_text.replace(/\{DAY\}/g, $day);
			clone_text = clone_text.replace(/\{TYPE\}/g, $type);
			if ($type == 'd') {
				clone_text = clone_text.replace(/\{LONG_TYPE\}/g, 'delivery');
			} else {
				clone_text = clone_text.replace(/\{LONG_TYPE\}/g, 'pickup');
			}
			$parent.append(clone_text);
			$('.pj-timepicker_new_' + $index).timepicker({
				showPeriod: myLabel.showperiod,
				showPeriodLabels: myLabel.showPeriodLabels,
				amPmText: myLabel.amPmText
			});
		}).on("click", ".pj-delete-hour", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).closest('.pjLocationWT').remove();
		}).on("click", ".pj-add-custom-hours", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $parent = $('.pjLocationCutomWTWrap'),
				clone_text = $('.pjLocationCustomWTClone').html(),
				$index = Math.ceil(Math.random() * 999999);
			clone_text = clone_text.replace(/\{INDEX\}/g, 'new_' + $index);
			$parent.append(clone_text);
			$('.pj-timepicker_new_' + $index).timepicker({
				showPeriod: myLabel.showperiod,
				showPeriodLabels: myLabel.showPeriodLabels,
				amPmText: myLabel.amPmText
			});
		}).on("click", ".pj-delete-custom-hour", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).closest('.pjLocationCustomWT').remove();
		});
	});
})(jQuery_1_8_2);