<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminOptions extends pjAdmin
{
	public function pjActionIndex()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
			
			$this->set('arr', $arr);
			
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			if (isset($_POST['options_update']))
			{
				$OptionModel = new pjOptionModel();
			
				foreach ($_POST as $key => $value)
				{
					if (preg_match('/value-(string|text|int|float|enum|bool|color)-(.*)/', $key) === 1)
					{
						list(, $type, $k) = explode("-", $key);
						if (!empty($k))
						{
							$OptionModel
								->reset()
								->where('foreign_id', $this->getForeignId())
								->where('`key`', $k)
								->limit(1)
								->modifyAll(array('value' => $value));
						}
					}
				}
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $this->getForeignId(), 'pjOption', 'data');
				}
				
				if (isset($_POST['next_action']))
				{
					switch ($_POST['next_action'])
					{
						case 'pjActionIndex':
							$err = 'AO01';
							break;
						case 'pjActionOrders':
							if ($_POST['value-enum-o_allow_delivery_doordash'] == 'Yes|No::Yes') {
								$OptionModel
									->reset()
									->where('foreign_id', $this->getForeignId())
									->where('`key`', 'o_allow_delivery')
									->limit(1)
									->modifyAll(array('value' => 'Yes|No::No'));
							}
							$err = 'AO02';
							break;
						case 'pjActionClientDetails':
							if($_POST['tab_id'] == 'tabs-1')
							{
								$err = 'AO03&tab_id=' . $_POST['tab_id'];
							}else{
								$err = 'AO06&tab_id=' . $_POST['tab_id'];
							}
							break;
						case 'pjActionNotification':
							if($_POST['tab_id'] == 'tabs-3')
							{
								$err = 'AO07&tab_id=' . $_POST['tab_id'];
							}else{
								$err = 'AO04&tab_id=' . $_POST['tab_id'];
							}
							break;
						case 'pjActionTerm':
							$err = 'AO05';
							break;
						case 'pjActionSmsDeliveryStatus':
							$err = 'AO09';
							break;
					}
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminOptions&action=" . @$_POST['next_action'] . "&err=$err");
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionInstall()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.title')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left outer')
				->orderBy('t1.sort ASC')->findAll()->getData();
			$this->set('locale_arr', $locale_arr);
			
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}

	public function pjActionUpdateTheme()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			pjOptionModel::factory()
				->where('foreign_id', $this->getForeignId())
				->where('`key`', 'o_layout')
				->limit(1)
				->modifyAll(array('value' => 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme' . $_GET['theme']));
			
		}
	}
	
	public function pjActionPreview()
	{
		$this->setLayout('pjActionEmpty');
	}
	
	public function pjActionOrders()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC, t1.key ASC')
				->findAll()
				->getData();
			
			$this->set('arr', $arr);
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionClientDetails()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
			
			$this->set('arr', $arr);
			$this->appendJs('pjAdminOptions.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionNotification()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
			
			$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($this->getForeignId(), 'pjOption');
				
			$this->set('arr', $arr);
			
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$lp_arr = array();
			foreach ($locale_arr as $item)
			{
				$lp_arr[$item['id']."_"] = $item['file'];
			}
			$this->set('lp_arr', $locale_arr);
			$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
			
			$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
			$this->appendJs('pjAdminOptions.js');
		}
	}
	
	public function pjActionTerm()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
			
			$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($this->getForeignId(), 'pjOption');				
			$this->set('arr', $arr);
			
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$lp_arr = array();
			foreach ($locale_arr as $item)
			{
				$lp_arr[$item['id']."_"] = $item['file'];
			}
			$this->set('lp_arr', $locale_arr);
			$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
			
			$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendJs('pjAdminOptions.js');
			
		}
	}

	public function pjActionSmsDeliveryStatus()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			
			$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
			
			$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($this->getForeignId(), 'pjOption');
				
			$this->set('arr', $arr);
			
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$lp_arr = array();
			foreach ($locale_arr as $item)
			{
				$lp_arr[$item['id']."_"] = $item['file'];
			}
			$this->set('lp_arr', $locale_arr);
			$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
			
			$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendJs('pjAdminOptions.js');
			
		}
	}
	
	public function pjActionUpdateOptions()
	{
	    $this->checkLogin();
	    
	    if ($this->isAdmin())
	    {
	        $pjRestaurantModel = pjRestaurantModel::factory();
	        $calendar_arr = $pjRestaurantModel->findAll()->getData();
	        foreach($calendar_arr as $calendar)
	        {
	            $sql = "INSERT INTO `".pjOptionModel::factory()->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
                        (".$calendar['id'].", 'o_allow_pickup', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 1, 2, NULL);";
	            $pjRestaurantModel->execute($sql);
	        }
	    } else {
	        $this->set('status', 2);
	    }
	    exit;
	}
	
	public function pjActionUpdate14583()
	{
	    $this->checkLogin();
	    
	    if ($this->isAdmin())
	    {
	        $pjLocationWTModel = pjLocationWTModel::factory();
	        $pjDateWTModel = pjDateWTModel::factory();
	        
	        $data = array();
	        $type_arr = array(
	        	'p' => 'pickup',
	        	'd' => 'delivery'
	        );
	        $w_days = array(
				'monday',
				'tuesday',
				'wednesday',
				'thursday',
				'friday',
				'saturday',
				'sunday'
			);
	        $arr = pjWorkingTimeModel::factory()->findAll()->getData();	        
	        foreach($arr as $val)
	        {
	        	foreach ($type_arr as $k => $v) {
	        		foreach ($w_days as $day) {
			            if ($val[$k.'_'.$day.'_dayoff'] == 'F') {
			            	$data[$val['location_id']][$v][$day] = array(
				            	'start_time' => $val[$k.'_'.$day.'_from'],
				            	'end_time' => $val[$k.'_'.$day.'_to']
			            	);
			            }
	        		}
	        	}
	        }
	        if ($data) {
	        	$pjLocationWTModel->begin();
		        foreach ($data as $location_id => $val) {
		        	foreach ($val as $type => $days){
		        		foreach ($days as $day => $time) {
		        			$pjLocationWTModel
								->reset()
								->set('location_id', $location_id)
								->set('day', $day)
								->set('start_time', $time['start_time'])
								->set('end_time', $time['end_time'])
								->set('type', $type)
								->insert();
		        		}
		        	}
		        }
		        $pjLocationWTModel->commit();
	        }
	        
	        $_date_arr = pjDateModel::factory()->where('t1.is_dayoff', 'F')->findAll()->getData();
	        if ($_date_arr) {
	        	$date_arr = array();
	        	foreach ($_date_arr as $val) {
	        		$date_arr[$val['location_id']][] = $val;
	        	}
	        	
	        	$pjDateWTModel->begin();
	        	foreach ($date_arr as $location_id => $times) {
	        		foreach ($times as $time) {
	        			$pjDateWTModel
								->reset()
								->set('location_id', $location_id)
								->set('date_id', $time['id'])
								->set('type', $time['type'])
								->set('date', $time['date'])
								->set('start_time', $time['start_time'])
								->set('end_time', $time['end_time'])
								->insert();
	        		}
	        	}
	        	$pjDateWTModel->commit();
	        }
	        
	    	$pjOptionModel = pjOptionModel::factory();
			$arr = pjRestaurantModel::factory()->where('t1.id <> 1')->findAll()->getData();
			foreach ($arr as $item) {
				$sql = "INSERT INTO `".$pjOptionModel->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
					(".$item['id'].", 'o_printer_printer_id', 2, '', NULL, 'string', 37, 1, NULL)	
				;";
				$pjOptionModel->reset()->execute($sql);
			}
	    } else {
	        $this->set('status', 2);
	    }
	    echo 'Data updated!!!';
	    exit;
	}
	
	public function pjActionPrinterStatusNotification()
	{
		$this->checkLogin();

		if ($this->isAdmin())
		{
			$content = @file_get_contents('app/web/upload/printers/ResultStatus_'.$this->getForeignId().'.log');			
			$this->set('content', $content);
		} else {
			$this->set('status', 2);
		}
	}
}
?>