<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminProducts extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminProducts&action=pjActionIndex&err=AP05");
			}
			if (isset($_POST['product_create']))
			{
				$pjProductModel = pjProductModel::factory();
				
				$data = array();
				if(isset($_POST['is_featured']))
				{
					$data['is_featured'] = 1;
					unset($_POST['is_featured']);
				}else{
					$data['is_featured'] = 0;
				}
				
				$data['restaurant_id'] = $this->getForeignId();
				$id = $pjProductModel->setAttributes(array_merge($_POST,$data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AP03';
					
					$pjMultiLangModel = pjMultiLangModel::factory();
					$pjProductPriceModel = pjProductPriceModel::factory();
					if (isset($_POST['i18n']))
					{
						$pjMultiLangModel->saveMultiLang($_POST['i18n'], $id, 'pjProduct', 'data');
						
						if($_POST['set_different_sizes'] == 'T')
						{
							if(isset($_POST['index_arr']) && $_POST['index_arr'] != '')
							{
								$index_arr = explode("|", $_POST['index_arr']);
								foreach($index_arr as $k => $v)
								{
									if(strpos($v, 'fd') !== false)
									{
										$p_data = array();
										$p_data['product_id'] = $id;
										$p_data['price'] = $_POST['product_price'][$v];
										$price_id = $pjProductPriceModel->reset()->setAttributes($p_data)->insert()->getInsertId();
										if ($price_id !== false && (int) $price_id > 0)
										{
											foreach ($_POST['i18n'] as $locale => $locale_arr)
											{
												foreach ($locale_arr as $field => $content)
												{
													if(is_array($content))
													{
														$insert_id = $pjMultiLangModel->reset()->setAttributes(array(
															'foreign_id' => $price_id,
															'model' => 'pjProductPrice',
															'locale' => $locale,
															'field' => $field,
															'content' => $content[$v],
															'source' => 'data'
														))->insert()->getInsertId();
													}
												}
											}
										}
									}
								}
							}
						}
					}
					if (isset($_FILES['image']))
					{
						if($_FILES['image']['error'] == 0)
						{
							if(getimagesize($_FILES['image']["tmp_name"]) != false)
							{
								$Image = new pjImage();
								if ($Image->getErrorCode() !== 200)
								{
									$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
									if ($Image->load($_FILES['image']))
									{
										$resp = $Image->isConvertPossible();
										if ($resp['status'] === true)
										{
											$hash = md5(uniqid(rand(), true));
											$image_path = PJ_UPLOAD_PATH . 'products/' . $id . '_' . $hash . '.' . $Image->getExtension();
											
											$Image->loadImage($_FILES['image']["tmp_name"]);
                                            /*Khuetech chỉnh size image*/
                                            //$Image->resizeSmart(116, 87);
                                            $Image->resizeSmart(580, 435);

											$Image->saveImage($image_path);
												
											$pjProductModel->reset()->where('id', $id)->limit(1)->modifyAll(array('image'=>$image_path));
											
										}
									}
								}
							}else{
								$err = 'AP09';
							}
						}else if($_FILES['image']['error'] != 4){
							$err = 'AP09';
						}
					}
					$pjProductCategoryModel = pjProductCategoryModel::factory();
					if (isset($_POST['category_id']) && is_array($_POST['category_id']) && count($_POST['category_id']) > 0)
					{
						$pjProductCategoryModel->begin();
						foreach ($_POST['category_id'] as $category_id)
						{
							$pjProductCategoryModel
								->reset()
								->set('product_id', $id)
								->set('category_id', $category_id)
								->insert();
						}
						$pjProductCategoryModel->commit();
					}
					$pjProductExtraModel = pjProductExtraModel::factory();
					if (isset($_POST['extra_id']) && is_array($_POST['extra_id']) && count($_POST['extra_id']) > 0)
					{
						$pjProductExtraModel->begin();
						foreach ($_POST['extra_id'] as $extra_id)
						{
							$pjProductExtraModel
								->reset()
								->set('product_id', $id)
								->set('extra_id', $extra_id)
								->insert();
						}
						$pjProductExtraModel->commit();
					}	
					$pjProductModifierModel = pjProductModifierModel::factory();
					if (isset($_POST['modifier_id']) && is_array($_POST['modifier_id']) && count($_POST['modifier_id']) > 0)
					{
						$pjProductModifierModel->begin();
						foreach ($_POST['modifier_id'] as $modifier_id)
						{
							$pjProductModifierModel
								->reset()
								->set('product_id', $id)
								->set('modifier_id', $modifier_id)
								->insert();
						}
						$pjProductModifierModel->commit();
					}					
					
					/* Groups */
					$pjProductGroupModel = pjProductGroupModel::factory();
					$pjProductGroupItemModel = pjProductGroupItemModel::factory();
					if (isset($_POST['product_group']) && count($_POST['product_group']) > 0)
					{	
						foreach ($_POST['product_group'] as $k) {
							if(strpos($k, 'fd') !== false)
							{
								$pt_data = array();
								$pt_data['product_id'] = $id;
								$group_id = $pjProductGroupModel->reset()->setAttributes($pt_data)->insert()->getInsertId();
								if ($group_id !== false && (int) $group_id > 0)
								{
									foreach ($_POST['i18n'] as $locale => $locale_arr)
									{
										foreach ($locale_arr as $field => $content)
										{
											if(is_array($content) && !in_array($field, array('price_name', 'group_item_name')))
											{
												$pjMultiLangModel->reset()->setAttributes(array(
													'foreign_id' => $group_id,
													'model' => 'pjProductGroup',
													'locale' => $locale,
													'field' => $field,
													'content' => $content[$k],
													'source' => 'data'
												))->insert()->getInsertId();
											}
										}
									}
									
									if (isset($_POST['product_group_item'][$k]) && count($_POST['product_group_item'][$k]) > 0) {
										foreach ($_POST['product_group_item'][$k] as $val) {
											$pti_data = array();
											$pti_data['product_id'] = $id;
											$pti_data['group_id'] = $group_id;
											$group_item_id = $pjProductGroupItemModel->reset()->setAttributes($pti_data)->insert()->getInsertId();
											if ($group_item_id !== false && (int) $group_item_id > 0) {
												foreach ($_POST['i18n'] as $locale => $locale_arr)
												{
													foreach ($locale_arr as $field => $content)
													{
														if(is_array($content) && !in_array($field, array('price_name', 'group_name')))
														{
															$pjMultiLangModel->reset()->setAttributes(array(
																'foreign_id' => $group_item_id,
																'model' => 'pjProductGroupItem',
																'locale' => $locale,
																'field' => $field,
																'content' => $content[$k][$val],
																'source' => 'data'
															))->insert()->getInsertId();
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					/* End Groups */

                    /* Khuetech Combos */
                    $pjProductComboModel = pjProductComboModel::factory();
                    $pjProductComboItemModel = pjProductComboItemModel::factory();
                    if (isset($_POST['product_combo']) && count($_POST['product_combo']) > 0)
                    {
                        foreach ($_POST['product_combo'] as $k) {
                            if(strpos($k, 'fd') !== false)
                            {
                                $pt_data = array();
                                $pt_data['product_id'] = $id;
                                $pt_data['condition'] = $_POST['combo_condition'][$k];
                                $combo_id = $pjProductComboModel->reset()->setAttributes($pt_data)->insert()->getInsertId();
                                if ($combo_id !== false && (int) $combo_id > 0)
                                {
                                    foreach ($_POST['i18n'] as $locale => $locale_arr)
                                    {
                                        foreach ($locale_arr as $field => $content)
                                        {
                                            if(is_array($content) && !in_array($field, array('price_name', 'combo_item_name')))
                                            {
                                                $pjMultiLangModel->reset()->setAttributes(array(
                                                    'foreign_id' => $combo_id,
                                                    'model' => 'pjProductCombo',
                                                    'locale' => $locale,
                                                    'field' => $field,
                                                    'content' => $content[$k],
                                                    'source' => 'data'
                                                ))->insert()->getInsertId();
                                            }
                                        }
                                    }

                                    if (isset($_POST['product_combo_item'][$k]) && is_array($_POST['product_combo_item'][$k]) && count($_POST['product_combo_item'][$k]) > 0) {
                                        foreach ($_POST['product_combo_item'][$k] as $product_id) {
                                            $pti_data = array();
                                            $pti_data['product_id'] = $id;
                                            $pti_data['combo_id'] = $combo_id;
                                            $pti_data['product_combo_id'] = $product_id;
                                            $pjProductComboItemModel->reset()->setAttributes($pti_data)->insert()->getInsertId();
                                        }
                                    }
                                }
                            }
                        }
                    }
                    /* End Khuetech Combos */

					if (isset($_POST['save_clone'])) {
						$new_product_id = $this->cloneProduct($id);
						if ($new_product_id !== false && (int)$new_product_id > 0) {
							pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminProducts&action=pjActionUpdate&id=$new_product_id&err=".$err);
						}
					}
					
					if($err != 'AP03')
					{
						pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminProducts&action=pjActionUpdate&id=$id&err=AP09");
					}
				} else {
					$err = 'AP04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminProducts&action=pjActionIndex&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
		
				$this->set('category_arr', pjCategoryModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjCategory' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.restaurant_id', $this->getForeignId())
					->where('t1.status', 'T')
					->orderBy('`order` ASC')
					->findAll()
					->getData());

				/*Khuetech product_arr cho product combo*/
                $this->set('product_arr', $demo=pjProductModel::factory()
                    ->select('t1.*, t2.content AS name')
                    ->join('pjMultiLang', "t2.model='pjProduct' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
                    ->where('t1.restaurant_id', $this->getForeignId())
                    ->where('t1.status', 'T')
                    ->orderBy('`order` ASC')
                    ->findAll()
                    ->getData());
                /*End Khuetech*/

				$this->set('extra_arr', pjExtraModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjExtra' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.restaurant_id', $this->getForeignId())
					->orderBy('name ASC')
					->findAll()
					->getData());
				$this->set('modifier_arr', pjModifierModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjModifier' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.restaurant_id', $this->getForeignId())
					->orderBy('name ASC')
					->findAll()
					->getData());
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('pjAdminProducts.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteProduct()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			$pjProductModel = pjProductModel::factory();
			$arr = $pjProductModel->find($_GET['id'])->getData();
			
			if ($pjProductModel->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				if (file_exists(PJ_INSTALL_PATH . $arr['image'])) {
					@unlink(PJ_INSTALL_PATH . $arr['image']);
				}
				
				pjMultiLangModel::factory()->where('model', 'pjProduct')->where('foreign_id', $_GET['id'])->eraseAll();
				pjProductCategoryModel::factory()->where('product_id', $_GET['id'])->eraseAll();
				pjProductExtraModel::factory()->where('product_id', $_GET['id'])->eraseAll();
				pjProductModifierModel::factory()->where('product_id', $_GET['id'])->eraseAll();
				pjProductPriceModel::factory()->where('product_id', $_GET['id'])->eraseAll();
				
				$pjProductGroupModel = pjProductGroupModel::factory();
				$pjProductGroupItemModel = pjProductGroupItemModel::factory();
				
				$product_group_ids = $pjProductGroupModel->where('product_id', $_GET['id'])->findAll()->getDataPair("id", "id");
				$product_group_item_ids = $pjProductGroupItemModel->where('product_id', $_GET['id'])->findAll()->getDataPair("id", "id");
				$pjProductGroupModel->reset()->where('product_id', $_GET['id'])->eraseAll();
				$pjProductGroupItemModel->reset()->where('product_id', $_GET['id'])->eraseAll();
				if ($product_group_ids) {
					pjMultiLangModel::factory()->reset()->where('model', 'pjProductGroup')->whereIn('foreign_id', $product_group_ids)->eraseAll();
				}
				if ($product_group_item_ids) {
					pjMultiLangModel::factory()->reset()->where('model', 'pjProductGroupItem')->whereIn('foreign_id', $product_group_item_ids)->eraseAll();
				}
				
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteProductBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjProductModel = pjProductModel::factory();
				$arr = $pjProductModel->whereIn('id', $_POST['record'])->findAll()->getData();
				foreach($arr as $v)
				{
					if (file_exists(PJ_INSTALL_PATH . $v['image'])) {
						@unlink(PJ_INSTALL_PATH . $v['image']);
					}
				}
				
				$pjProductModel->reset()->whereIn('id', $_POST['record'])->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjProduct')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				
				pjProductCategoryModel::factory()->whereIn('product_id', $_POST['record'])->eraseAll();
				pjProductExtraModel::factory()->whereIn('product_id', $_POST['record'])->eraseAll();
				pjProductModifierModel::factory()->whereIn('product_id', $_POST['record'])->eraseAll();
				pjProductPriceModel::factory()->whereIn('product_id', $_POST['record'])->eraseAll();
				
				$pjProductGroupModel = pjProductGroupModel::factory();
				$pjProductGroupItemModel = pjProductGroupItemModel::factory();
				
				$product_group_ids = $pjProductGroupModel->whereIn('product_id', $_POST['record'])->findAll()->getDataPair("id", "id");
				$product_group_item_ids = $pjProductGroupItemModel->whereIn('product_id', $_POST['record'])->findAll()->getDataPair("id", "id");
				$pjProductGroupModel->reset()->whereIn('product_id', $_POST['record'])->eraseAll();
				$pjProductGroupItemModel->reset()->whereIn('product_id', $_POST['record'])->eraseAll();
				if ($product_group_ids) {
					pjMultiLangModel::factory()->reset()->where('model', 'pjProductGroup')->whereIn('foreign_id', $product_group_ids)->eraseAll();
				}
				if ($product_group_item_ids) {
					pjMultiLangModel::factory()->reset()->where('model', 'pjProductGroupItem')->whereIn('foreign_id', $product_group_item_ids)->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionGetProduct()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjProductModel = pjProductModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProduct' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left');
			
			$pjProductModel->where('t1.restaurant_id', $this->getForeignId());
				
			if (isset($_GET['status']) && !empty($_GET['status']))
			{
				$pjProductModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjProductModel->where("(t2.content LIKE '%$q%')");
			}
			if (isset($_GET['category_id']) && (int) $_GET['category_id'] > 0)
			{
				$pjProductModel->where("(t1.id IN (SELECT TPC.product_id FROM `".pjProductCategoryModel::factory()->getTable()."` AS TPC WHERE TPC.category_id='".$_GET['category_id']."'))");
			}

			$column = 'is_featured';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjProductModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$pjProductPriceModel = pjProductPriceModel::factory();
			$data = $pjProductModel
				->select("t1.*, t2.content AS name")
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				if($v['set_different_sizes'] == 'T')
				{
					$_arr = $pjProductPriceModel
						->reset()
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjProductPrice' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'price_name'", 'left')
						->select('t1.*, t2.content as price_name')
						->where('product_id', $v['id'])
						->findAll()
						->getData();
					$price_arr = array();
					foreach($_arr as $price)
					{
						$price_arr[] = $price['price_name'] . ': ' . pjUtil::formatCurrencySign($price['price'], $this->option_arr['o_currency']);
					}
					$v['price'] = join("<br/>", $price_arr);
				}else{
					$v['price'] = pjUtil::formatCurrencySign($v['price'], $this->option_arr['o_currency']);
				}
				$data[$k] = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminProducts.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveProduct()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjProductModel = pjProductModel::factory();
			if (!in_array($_POST['column'], $pjRouteModel->i18n))
			{
				$value = $_POST['value'];
				
				$pjProductModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $value));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjProduct', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			$post_max_size = pjUtil::getPostMaxSize();
			if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SERVER['CONTENT_LENGTH']) && (int) $_SERVER['CONTENT_LENGTH'] > $post_max_size)
			{
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminProducts&action=pjActionIndex&err=AP06");
			}
			if (isset($_POST['product_update']))
			{
				$pjProductModel = pjProductModel::factory();
				$pjMultiLangModel = pjMultiLangModel::factory();
				
				$err = 'AP01';
				
				$arr = $pjProductModel->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminProducts&action=pjActionIndex&err=AP08");
				}
				
				$data = array();
				if (isset($_FILES['image']))
				{
					if($_FILES['image']['error'] == 0)
					{
						if(getimagesize($_FILES['image']["tmp_name"]) != false)
						{
							if(!empty($arr['image']))
							{
								@unlink(PJ_INSTALL_PATH . $arr['image']);
							}
							$Image = new pjImage();
							if ($Image->getErrorCode() !== 200)
							{
								$Image->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
								if ($Image->load($_FILES['image']))
								{
									$resp = $Image->isConvertPossible();
									if ($resp['status'] === true)
									{
										$hash = md5(uniqid(rand(), true));
										$image_path = PJ_UPLOAD_PATH . 'products/' . $_POST['id'] . '_' . $hash . '.' . $Image->getExtension();
										
										$Image->loadImage($_FILES['image']["tmp_name"]);

                                        /*Khuetech chỉnh size image*/
                                        //$Image->resizeSmart(116, 87);
                                        $Image->resizeSmart(580, 435);

										$Image->saveImage($image_path);
										$data['image'] = $image_path;
									}
								}
							}
						}else{
							$err = 'AP10';
						}
					}else if($_FILES['image']['error'] != 4){
						$err = 'AP10';
					}
				}
				
				if(isset($_POST['is_featured']))
				{
					$data['is_featured'] = 1;
					unset($_POST['is_featured']);
				}else{
					$data['is_featured'] = 0;
				}
				$pjProductModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjProduct', 'data');
					
					$pjProductPriceModel = pjProductPriceModel::factory();
					
					if($_POST['set_different_sizes'] == 'T')
					{
						if(isset($_POST['index_arr']) && $_POST['index_arr'] != '')
						{
							$index_arr = explode("|", $_POST['index_arr']);
							foreach($index_arr as $k => $v)
							{
								if(strpos($v, 'fd') !== false)
								{
									$p_data = array();
									$p_data['product_id'] = $_POST['id'];
									$p_data['price'] = $_POST['product_price'][$v];
									$price_id = $pjProductPriceModel->reset()->setAttributes($p_data)->insert()->getInsertId();
									if ($price_id !== false && (int) $price_id > 0)
									{
										foreach ($_POST['i18n'] as $locale => $locale_arr)
										{
											foreach ($locale_arr as $field => $content)
											{
												if(is_array($content) && !is_array($content[$v]))
												{
													$insert_id = $pjMultiLangModel->reset()->setAttributes(array(
														'foreign_id' => $price_id,
														'model' => 'pjProductPrice',
														'locale' => $locale,
														'field' => $field,
														'content' => $content[$v],
														'source' => 'data'
													))->insert()->getInsertId();
												}
											}
										}
									}
								}else{
									$p_data = array();
									$p_data['price'] = $_POST['product_price'][$v];
									$pjProductPriceModel->reset()->where('id', $v)->limit(1)->modifyAll($p_data);
									foreach ($_POST['i18n'] as $locale => $locale_arr)
									{
										foreach ($locale_arr as $field => $content)
										{
											if(is_array($content) && !is_array($content[$v]))
											{
												$sql = sprintf("INSERT INTO `%1\$s` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`)
													VALUES (NULL, :foreign_id, :model, :locale, :field, :update_content, :source)
													ON DUPLICATE KEY UPDATE `content` = :update_content, `source` = :source;",
													$pjMultiLangModel->getTable()
												);
												$foreign_id = $v;
												$model = 'pjProductPrice';
												$source = 'data';
												$update_content = $content[$v];
												$modelObj = $pjMultiLangModel->reset()->prepare($sql)->exec(compact('foreign_id', 'model', 'locale', 'field', 'update_content', 'source'));
												if ($modelObj->getAffectedRows() > 0 || $modelObj->getInsertId() > 0)
												{
													
												}
											}
										}
									}
								}
							}
						}
						
						if(isset($_POST['remove_arr']) && $_POST['remove_arr'] != '')
						{
							$remove_arr = explode("|", $_POST['remove_arr']);
							$pjMultiLangModel->reset()->where('model', 'pjProductPrice')->whereIn('foreign_id', $remove_arr)->eraseAll();
							$pjProductPriceModel->reset()->whereIn('id', $remove_arr)->eraseAll();
						}
						$pjProductModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array('price' => ':NULL'));
					}else{
						$id_arr = $pjProductPriceModel->where('product_id', $_POST['id'])->findAll()->getDataPair("id", "id");
						$pjMultiLangModel->reset()->where('model', 'pjProductPrice')->whereIn('foreign_id', $id_arr);
						$pjProductPriceModel->reset()->where('product_id', $_POST['id'])->eraseAll();
					}
				}
				
				$pjProductCategoryModel = pjProductCategoryModel::factory();
				$pjProductCategoryModel->where('product_id', $_POST['id'])->eraseAll();
				if (isset($_POST['category_id']) && is_array($_POST['category_id']) && count($_POST['category_id']) > 0)
				{
					$pjProductCategoryModel->reset()->begin();
					foreach ($_POST['category_id'] as $category_id)
					{
						$pjProductCategoryModel
							->reset()
							->set('product_id', $_POST['id'])
							->set('category_id', $category_id)
							->insert();
					}
					$pjProductCategoryModel->commit();
				}
				$pjProductExtraModel = pjProductExtraModel::factory();
				$pjProductExtraModel->where('product_id', $_POST['id'])->eraseAll();
				if (isset($_POST['extra_id']) && is_array($_POST['extra_id']) && count($_POST['extra_id']) > 0)
				{
					$pjProductExtraModel->reset()->begin();
					foreach ($_POST['extra_id'] as $extra_id)
					{
						$pjProductExtraModel
							->reset()
							->set('product_id', $_POST['id'])
							->set('extra_id', $extra_id)
							->insert();
					}
					$pjProductExtraModel->commit();
				}
				
				$pjProductModifierModel = pjProductModifierModel::factory();
				$pjProductModifierModel->where('product_id', $_POST['id'])->eraseAll();
				if (isset($_POST['modifier_id']) && is_array($_POST['modifier_id']) && count($_POST['modifier_id']) > 0)
				{
					$pjProductModifierModel->reset()->begin();
					foreach ($_POST['modifier_id'] as $modifier_id)
					{
						$pjProductModifierModel
							->reset()
							->set('product_id', $_POST['id'])
							->set('modifier_id', $modifier_id)
							->insert();
					}
					$pjProductModifierModel->commit();
				}
				
				$pjProductGroupModel = pjProductGroupModel::factory();
				$pjProductGroupItemModel = pjProductGroupItemModel::factory();
				
				/* Product Groups */
				$old_product_group_ids_arr = $pjProductGroupModel->where('t1.product_id', $_POST['id'])->findAll()->getDataPair('id', 'id');
				$old_product_group_item_ids_arr = array();
				if ($old_product_group_ids_arr) {
					$old_product_group_item_ids_arr = $pjProductGroupItemModel->whereIn('t1.group_id', $old_product_group_ids_arr)->findAll()->getDataPair('id', 'id');
				}
				$group_ids_arr = $group_item_ids_arr = array();
				if (isset($_POST['product_group']) && count($_POST['product_group']) > 0)
				{	
					foreach ($_POST['product_group'] as $k) {
						if(strpos($k, 'fd') !== false)
						{
							$pg_data = array();
							$pg_data['product_id'] = $_POST['id'];
							$group_id = $pjProductGroupModel->reset()->setAttributes($pg_data)->insert()->getInsertId();
							if ($group_id !== false && (int) $group_id > 0)
							{
								$group_ids_arr[] = $group_id;
								foreach ($_POST['i18n'] as $locale => $locale_arr)
								{
									foreach ($locale_arr as $field => $content)
									{
										if(is_array($content) && !in_array($field, array('price_name', 'group_item_name')))
										{
											$pjMultiLangModel->reset()->setAttributes(array(
												'foreign_id' => $group_id,
												'model' => 'pjProductGroup',
												'locale' => $locale,
												'field' => $field,
												'content' => $content[$k],
												'source' => 'data'
											))->insert()->getInsertId();
										}
									}
								}								
								if (isset($_POST['product_group_item'][$k]) && count($_POST['product_group_item'][$k]) > 0) {
									foreach ($_POST['product_group_item'][$k] as $k1) {
										$pgi_data = array();
										$pgi_data['product_id'] = $_POST['id'];
										$pgi_data['group_id'] = $group_id;
										$group_item_id = $pjProductGroupItemModel->reset()->setAttributes($pgi_data)->insert()->getInsertId();
										if ($group_item_id !== false && (int) $group_item_id > 0) {
											$group_item_ids_arr[] = $group_item_id;
											foreach ($_POST['i18n'] as $locale => $locale_arr)
											{
												foreach ($locale_arr as $field => $content)
												{
													if(is_array($content) && !in_array($field, array('price_name', 'group_name')))
													{
														$pjMultiLangModel->reset()->setAttributes(array(
															'foreign_id' => $group_item_id,
															'model' => 'pjProductGroupItem',
															'locale' => $locale,
															'field' => $field,
															'content' => $content[$k][$k1],
															'source' => 'data'
														))->insert()->getInsertId();
													}
												}
											}
										}
									}
								}
							}
						} else {
							$group_ids_arr[] = $k;
							$pg_data = array();
							$pg_data['product_id'] = $_POST['id'];
							$pjProductGroupModel->reset()->where('id', $k)->limit(1)->modifyAll($pg_data);
							foreach ($_POST['i18n'] as $locale => $locale_arr)
							{
								foreach ($locale_arr as $field => $content)
								{
									if(is_array($content) && !in_array($field, array('price_name', 'group_item_name')))
									{
										$sql = sprintf("INSERT INTO `%1\$s` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`)
											VALUES (NULL, :foreign_id, :model, :locale, :field, :update_content, :source)
											ON DUPLICATE KEY UPDATE `content` = :update_content, `source` = :source;",
											$pjMultiLangModel->getTable()
										);
										$foreign_id = $k;
										$model = 'pjProductGroup';
										$source = 'data';
										$update_content = $content[$k];
										$modelObj = $pjMultiLangModel->reset()->prepare($sql)->exec(compact('foreign_id', 'model', 'locale', 'field', 'update_content', 'source'));
										if ($modelObj->getAffectedRows() > 0 || $modelObj->getInsertId() > 0)
										{
										}
									}
								}
							}
							if (isset($_POST['product_group_item'][$k]) && count($_POST['product_group_item'][$k]) > 0) {
								foreach ($_POST['product_group_item'][$k] as $k1) {
									$pgi_data = array();
									$pgi_data['product_id'] = $_POST['id'];
									$pgi_data['group_id'] = $k;
									if(strpos($k1, 'fd') !== false) {
										$group_item_id = $pjProductGroupItemModel->reset()->setAttributes($pgi_data)->insert()->getInsertId();
										if ($group_item_id !== false && (int) $group_item_id > 0) {
											$group_item_ids_arr[] = $group_item_id;
											foreach ($_POST['i18n'] as $locale => $locale_arr)
											{
												foreach ($locale_arr as $field => $content)
												{
													if(is_array($content) && !in_array($field, array('price_name', 'group_name')))
													{
														$pjMultiLangModel->reset()->setAttributes(array(
															'foreign_id' => $group_item_id,
															'model' => 'pjProductGroupItem',
															'locale' => $locale,
															'field' => $field,
															'content' => $content[$k][$k1],
															'source' => 'data'
														))->insert()->getInsertId();
													}
												}
											}
										}
									} else {
										$group_item_ids_arr[] = $k1;
										$pjProductGroupItemModel->reset()->where('id', $k1)->limit(1)->modifyAll($pgi_data);
										foreach ($_POST['i18n'] as $locale => $locale_arr)
										{
											foreach ($locale_arr as $field => $content)
											{
												if(is_array($content) && !in_array($field, array('price_name', 'group_name')))
												{
													$sql = sprintf("INSERT INTO `%1\$s` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`)
														VALUES (NULL, :foreign_id, :model, :locale, :field, :update_content, :source)
														ON DUPLICATE KEY UPDATE `content` = :update_content, `source` = :source;",
														$pjMultiLangModel->getTable()
													);
													$foreign_id = $k1;
													$model = 'pjProductGroupItem';
													$source = 'data';
													$update_content = $content[$k][$k1];
													$modelObj = $pjMultiLangModel->reset()->prepare($sql)->exec(compact('foreign_id', 'model', 'locale', 'field', 'update_content', 'source'));
													if ($modelObj->getAffectedRows() > 0 || $modelObj->getInsertId() > 0)
													{
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				if (count($group_ids_arr) <= 0) {
					$pjProductGroupModel->reset()->where('product_id', $_POST['id'])->eraseAll();
					$pjProductGroupItemModel->reset()->where('product_id', $_POST['id'])->eraseAll();
					if ($old_product_group_ids_arr) {
						$pjMultiLangModel->reset()->whereIn('foreign_id', $old_product_group_ids_arr)->where('model', 'pjProductGroup')->eraseAll();
					}
					if ($old_product_group_item_ids_arr) {
						$pjMultiLangModel->reset()->whereIn('foreign_id', $old_product_group_item_ids_arr)->where('model', 'pjProductGroupItem')->eraseAll();
					}
				} else {
					if ($group_ids_arr) {
						$_arr = $pjProductGroupModel->reset()->where('t1.product_id', $_POST['id'])->whereNotIn('t1.id', $group_ids_arr)->findAll()->getDataPair('id', 'id');
						if ($_arr) {
							$pjProductGroupModel->reset()->where('product_id', $_POST['id'])->whereIn('id', $_arr)->eraseAll();
							$pjMultiLangModel->reset()->whereIn('foreign_id', $_arr)->where('model', 'pjProductGroup')->eraseAll();
						}
					}
					if ($group_item_ids_arr) {
						$_arr = $pjProductGroupItemModel->reset()->where('t1.product_id', $_POST['id'])->whereNotIn('t1.id', $group_item_ids_arr)->findAll()->getDataPair('id', 'id');
						if ($_arr) {
							$pjProductGroupItemModel->reset()->where('product_id', $_POST['id'])->whereIn('id', $_arr)->eraseAll();
							$pjMultiLangModel->reset()->whereIn('foreign_id', $_arr)->where('model', 'pjProductGroupItem')->eraseAll();
						}
					} else {
						$pjProductGroupItemModel->reset()->where('product_id', $_POST['id'])->eraseAll();
						if ($old_product_group_item_ids_arr) {
							$pjMultiLangModel->reset()->whereIn('foreign_id', $old_product_group_item_ids_arr)->where('model', 'pjProductGroupItem')->eraseAll();
						}
					}
				}
				/* End Product Groups */


                /* Khuetech Product Combos */
                $pjProductComboModel = pjProductComboModel::factory();
                $pjProductComboItemModel = pjProductComboItemModel::factory();

                $old_product_combo_ids_arr = $pjProductComboModel->where('t1.product_id', $_POST['id'])->findAll()->getDataPair('id', 'id');
                $combo_ids_arr = array();

                $pjProductComboItemModel->reset()->where('product_id', $_POST['id'])->eraseAll();
                if (isset($_POST['product_combo']) && count($_POST['product_combo']) > 0)
                {
                    foreach ($_POST['product_combo'] as $k) {
                        if(strpos($k, 'fd') !== false)
                        {
                            $pg_data = array();
                            $pg_data['product_id'] = $_POST['id'];
                            $pg_data['condition'] = $_POST['combo_condition'][$k];
                            $combo_id = $pjProductComboModel->reset()->setAttributes($pg_data)->insert()->getInsertId();
                            if ($combo_id !== false && (int) $combo_id > 0)
                            {
                                $combo_ids_arr[] = $combo_id;
                                foreach ($_POST['i18n'] as $locale => $locale_arr)
                                {
                                    foreach ($locale_arr as $field => $content)
                                    {
                                        if(is_array($content) && !in_array($field, array('price_name', 'combo_item_name')))
                                        {
                                            $pjMultiLangModel->reset()->setAttributes(array(
                                                'foreign_id' => $combo_id,
                                                'model' => 'pjProductCombo',
                                                'locale' => $locale,
                                                'field' => $field,
                                                'content' => $content[$k],
                                                'source' => 'data'
                                            ))->insert()->getInsertId();
                                        }
                                    }
                                }

                                if (isset($_POST['product_combo_item'][$k]) && is_array($_POST['product_combo_item'][$k]) && count($_POST['product_combo_item'][$k]) > 0) {
                                    foreach ($_POST['product_combo_item'][$k] as $product_id) {
                                        $pti_data = array();
                                        $pti_data['product_id'] = $_POST['id'];
                                        $pti_data['combo_id'] = $combo_id;
                                        $pti_data['product_combo_id'] = $product_id;
                                        $pjProductComboItemModel->reset()->setAttributes($pti_data)->insert()->getInsertId();
                                    }
                                }
                            }
                        } else {
                            $combo_ids_arr[] = $k;
                            $pg_data = array();
                            $pg_data['product_id'] = $_POST['id'];
                            $pg_data['condition'] = $_POST['combo_condition'][$k];
                            $pjProductComboModel->reset()->where('id', $k)->limit(1)->modifyAll($pg_data);
                            foreach ($_POST['i18n'] as $locale => $locale_arr)
                            {
                                foreach ($locale_arr as $field => $content)
                                {
                                    if(is_array($content) && !in_array($field, array('price_name', 'combo_item_name')))
                                    {
                                        $sql = sprintf("INSERT INTO `%1\$s` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`)
											VALUES (NULL, :foreign_id, :model, :locale, :field, :update_content, :source)
											ON DUPLICATE KEY UPDATE `content` = :update_content, `source` = :source;",
                                            $pjMultiLangModel->getTable()
                                        );
                                        $foreign_id = $k;
                                        $model = 'pjProductCombo';
                                        $source = 'data';
                                        $update_content = $content[$k];
                                        $modelObj = $pjMultiLangModel->reset()->prepare($sql)->exec(compact('foreign_id', 'model', 'locale', 'field', 'update_content', 'source'));
                                        if ($modelObj->getAffectedRows() > 0 || $modelObj->getInsertId() > 0)
                                        {
                                        }
                                    }
                                }
                            }

                            if (isset($_POST['product_combo_item'][$k]) && is_array($_POST['product_combo_item'][$k]) && count($_POST['product_combo_item'][$k]) > 0) {
                                foreach ($_POST['product_combo_item'][$k] as $product_id) {
                                    $pti_data = array();
                                    $pti_data['product_id'] = $_POST['id'];
                                    $pti_data['combo_id'] = $k;
                                    $pti_data['product_combo_id'] = $product_id;
                                    $pjProductComboItemModel->reset()->setAttributes($pti_data)->insert()->getInsertId();
                                }
                            }
                        }
                    }
                }
                if (count($combo_ids_arr) <= 0) {
                    $pjProductComboModel->reset()->where('product_id', $_POST['id'])->eraseAll();
                    if ($old_product_combo_ids_arr) {
                        $pjMultiLangModel->reset()->whereIn('foreign_id', $old_product_combo_ids_arr)->where('model', 'pjProductCombo')->eraseAll();
                    }
                } else {
                    if ($combo_ids_arr) {
                        $_arr = $pjProductComboModel->reset()->where('t1.product_id', $_POST['id'])->whereNotIn('t1.id', $combo_ids_arr)->findAll()->getDataPair('id', 'id');
                        if ($_arr) {
                            $pjProductComboModel->reset()->where('product_id', $_POST['id'])->whereIn('id', $_arr)->eraseAll();
                            $pjMultiLangModel->reset()->whereIn('foreign_id', $_arr)->where('model', 'pjProductCombo')->eraseAll();
                        }
                    }
                }
                /* End Product Combos */



				if (isset($_POST['save_clone'])) {
					$new_product_id = $this->cloneProduct($_POST['id']);
					if ($new_product_id !== false && (int)$new_product_id > 0) {
						pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminProducts&action=pjActionUpdate&id=$new_product_id&err=".$err);
					}
				}
					
				if($err == 'AP01')
				{
					pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminProducts&action=pjActionIndex&err=AP01");
				}else{
					pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminProducts&action=pjActionUpdate&id=".$_POST['id']."&err=AP10");
				}
			} else {
				$pjMultiLangModel = pjMultiLangModel::factory();
				
				$arr = pjProductModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0 || ($arr && $arr['restaurant_id'] != $this->getForeignId()))
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminProducts&action=pjActionIndex&err=AP08");
				}
				$arr['i18n'] = $pjMultiLangModel->getMultiLang($arr['id'], 'pjProduct');
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$this->set('category_arr', pjCategoryModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjCategory' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.restaurant_id', $this->getForeignId())
					->where('t1.status', 'T')
					->orderBy('`order` ASC')
					->findAll()
					->getData());

                /*Khuetech product_arr cho product combo*/
                $this->set('product_arr', $demo=pjProductModel::factory()
                    ->select('t1.*, t2.content AS name')
                    ->join('pjMultiLang', "t2.model='pjProduct' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
                    ->where('t1.restaurant_id', $this->getForeignId())
                    ->where('t1.status', 'T')
                    ->orderBy('`order` ASC')
                    ->findAll()
                    ->getData());
                /*End Khuetech*/

				$this->set('extra_arr', pjExtraModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjExtra' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.restaurant_id', $this->getForeignId())
					->orderBy('name ASC')
					->findAll()
					->getData());
					
				$this->set('category_id_arr', pjProductCategoryModel::factory()
					->where("product_id", $_GET['id'])
					->findAll()
					->getDataPair("category_id", "category_id"));
				$this->set('extra_id_arr', pjProductExtraModel::factory()
					->where("product_id", $_GET['id'])
					->findAll()
					->getDataPair("extra_id", "extra_id"));
				
				if($arr['set_different_sizes'] == 'T')
				{
					$size_arr = pjProductPriceModel::factory()->where('product_id', $_GET['id'])->findAll()->getData();
					foreach($size_arr as $k => $v)
					{
						$size_arr[$k]['i18n'] = pjMultiLangModel::factory()->getMultiLang($v['id'], 'pjProductPrice');
					}
					$this->set('size_arr', $size_arr);	
				}
					
				$product_group_item_arr = $product_group_ids_arr = array();
				$product_group_arr = pjProductGroupModel::factory()->where('product_id', $_GET['id'])->findAll()->getData();
				foreach($product_group_arr as $k => $v)
				{
					$product_group_ids_arr[] = $v['id'];
					$product_group_arr[$k]['i18n'] = pjMultiLangModel::factory()->getMultiLang($v['id'], 'pjProductGroup');
				}
				$this->set('product_group_arr', $product_group_arr);	
				if ($product_group_ids_arr) {
					$_product_group_item_arr = pjProductGroupItemModel::factory()->whereIn('t1.group_id', $product_group_ids_arr)->findAll()->getData();
					foreach ($_product_group_item_arr as $k => $v) {
						$v['i18n'] = pjMultiLangModel::factory()->getMultiLang($v['id'], 'pjProductGroupItem');
						$product_group_item_arr[$v['group_id']][] = $v;
					}
				}
				$this->set('product_group_item_arr', $product_group_item_arr);


				/*Khuetech combo*/
                $product_combo_id_arr = array();
                $product_combo_arr = pjProductComboModel::factory()->where('product_id', $_GET['id'])->findAll()->getData();
                foreach($product_combo_arr as $k => $v)
                {
                    $product_combo_id_arr[$v['id']] = array();
                    $product_combo_arr[$k]['i18n'] = pjMultiLangModel::factory()->getMultiLang($v['id'], 'pjProductCombo');
                }
                $this->set('product_combo_arr', $product_combo_arr);
                if ($product_combo_id_arr) {
                    foreach ($product_combo_id_arr as $combo_id => $combo_val) {
                        $_product_combo_item_arr = pjProductComboItemModel::factory()->where('t1.combo_id', $combo_id)->findAll()->getData();
                        $combo_product_ids=array();
                        foreach ($_product_combo_item_arr as $k => $v) {
                            $combo_product_ids[] = $v['product_combo_id'];
                        }
                        $product_combo_id_arr[$combo_id]=$combo_product_ids;
                    }
                }
                $this->set('product_combo_id_arr', $product_combo_id_arr);
                /*End Khuetech*/
				
				$this->set('modifier_arr', pjModifierModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjModifier' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.restaurant_id', $this->getForeignId())
					->orderBy('name ASC')
					->findAll()
					->getData());
				$this->set('modifier_id_arr', pjProductModifierModel::factory()
					->where("product_id", $_GET['id'])
					->findAll()
					->getDataPair("modifier_id", "modifier_id"));
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendJs('pjAdminProducts.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale']) && (int) $_GET['locale'] > 0)
			{
				pjAppController::setFields($_GET['locale']);
				
				$this->set('category_arr', pjCategoryModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjCategory' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".pjObject::escapeString($_GET['locale'])."'", 'left outer')
					->where('t1.status', 'T')
					->orderBy('`order` ASC')
					->findAll()
					->getData());
				$this->set('extra_arr', pjExtraModel::factory()
					->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjExtra' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".pjObject::escapeString($_GET['locale'])."'", 'left outer')
					->orderBy('name ASC')
					->findAll()
					->getData());
			}
		}
	}
	
	public function pjActionDeleteImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			
			$pjProductModel = pjProductModel::factory();
			$arr = $pjProductModel->find($_GET['id'])->getData(); 
			
			if(!empty($arr))
			{
				if(!empty($arr['image']))
				{					
					@unlink(PJ_INSTALL_PATH . $arr['image']);
				}
				
				$data = array();
				$data['image'] = ':NULL';
				$pjProductModel->reset()->where(array('id' => $_GET['id']))->limit(1)->modifyAll($data);
				
				$response['code'] = 200;
			}else{
				$response['code'] = 100;
			}
			
			pjAppController::jsonResponse($response);
		}
	}
	
	private function cloneProduct($product_id) {
		$pjProductModel = pjProductModel::factory();
		$pjMultiLangModel = pjMultiLangModel::factory();
		$pjProductPriceModel = pjProductPriceModel::factory();
		$pjProductCategoryModel = pjProductCategoryModel::factory();
		$pjProductExtraModel = pjProductExtraModel::factory();
		$pjProductModifierModel = pjProductModifierModel::factory();
		$pjProductGroupModel = pjProductGroupModel::factory();
		$pjProductGroupItemModel = pjProductGroupItemModel::factory();
		
		$arr = $pjProductModel->find($product_id)->getData();
		$arr['i18n'] = $pjMultiLangModel->getMultiLang($arr['id'], 'pjProduct');
		$new_product_arr = $arr;
		unset($new_product_arr['id']);
		unset($new_product_arr['image']);
		$new_product_id = $pjProductModel->reset()->setAttributes($new_product_arr)->insert()->getInsertId();
		if ($new_product_id !== false && (int)$new_product_id > 0) {
			if ($arr['i18n']) {
				$product_i18n_arr = array();
				foreach ($arr['i18n'] as $locale_id => $fields) {
					foreach ($fields as $k => $v) { 
						if (in_array($k, array('name', 'description'))) {
							if ($k == 'name') {
								$product_i18n_arr[$locale_id][$k] = $v.' (cloned)';
							} else {
								$product_i18n_arr[$locale_id][$k] = $v;
							}
						}
					}
				}
				if ($product_i18n_arr) {
					$pjMultiLangModel->saveMultiLang($product_i18n_arr, $new_product_id, 'pjProduct', 'data');
				}
			}
			
			if (!empty($arr['image']) && is_file($arr['image'])) {
				$hash = md5(uniqid(rand(), true));
				$image_name = basename($arr['image']);
				$image_name_arr = explode('.', $image_name);
				$image_path = PJ_UPLOAD_PATH . 'products/' . $new_product_id . '_' . $hash . '.' . end($image_name_arr);
				if (copy($arr['image'], $image_path)) {
					$pjProductModel->reset()->set('id', $new_product_id)->modify(array('image' => $image_path));
				}
			}
			
			if ($arr['set_different_sizes'] == 'T') {
				$price_arr = $pjProductPriceModel->where('t1.product_id', $product_id)->findAll()->getData();
				foreach ($price_arr as $price) {
					$new_price_arr = array();
					$new_price_arr['product_id'] = $new_product_id;
					$new_price_arr['price'] = $price['price'];
					$new_price_id = $pjProductPriceModel->reset()->setAttributes($new_price_arr)->insert()->getInsertId();
					if ($new_price_id !== false && (int)$new_price_id > 0) {
						$price_i18n = $pjMultiLangModel->reset()->getMultiLang($price['id'], 'pjProductPrice');
						if ($price_i18n) {
							$pjMultiLangModel->saveMultiLang($price_i18n, $new_price_id, 'pjProductPrice', 'data');
						}
					}
				}
			}
			
			$product_category_arr = $pjProductCategoryModel->where('t1.product_id', $product_id)->findAll()->getData();
			if ($product_category_arr) {
				$pjProductCategoryModel->reset()->begin();
				foreach ($product_category_arr as $pc)
				{
					$pjProductCategoryModel
						->reset()
						->set('product_id', $new_product_id)
						->set('category_id', $pc['category_id'])
						->insert();
				}
				$pjProductCategoryModel->commit();
			}
			
			$product_extra_arr = $pjProductExtraModel->where('t1.product_id', $product_id)->findAll()->getData();
			if ($product_extra_arr) {
				$pjProductExtraModel->reset()->begin();
				foreach ($product_extra_arr as $pe)
				{
					$pjProductExtraModel
						->reset()
						->set('product_id', $new_product_id)
						->set('extra_id', $pe['extra_id'])
						->insert();
				}
				$pjProductExtraModel->commit();
			}
			
			$product_modifier_arr = $pjProductModifierModel->where('t1.product_id', $product_id)->findAll()->getData();
			if ($product_modifier_arr) {
				$pjProductModifierModel->reset()->begin();
				foreach ($product_modifier_arr as $pm)
				{
					$pjProductModifierModel
						->reset()
						->set('product_id', $new_product_id)
						->set('modifier_id', $pm['modifier_id'])
						->insert();
				}
				$pjProductModifierModel->commit();
			}
			
			$group_arr = $pjProductGroupModel->where('t1.product_id', $product_id)->findAll()->getData();
			foreach ($group_arr as $group) {
				$new_group_arr = array();
				$new_group_arr['product_id'] = $new_product_id;
				$new_group_id = $pjProductGroupModel->reset()->setAttributes($new_group_arr)->insert()->getInsertId();
				if ($new_group_id !== false && (int)$new_group_id > 0) {
					$group_i18n = $pjMultiLangModel->reset()->getMultiLang($group['id'], 'pjProductGroup');
					if ($group_i18n) {
						$pjMultiLangModel->saveMultiLang($group_i18n, $new_group_id, 'pjProductGroup', 'data');
					}
					
					$group_item_arr = $pjProductGroupItemModel->reset()->where('t1.group_id', $group['id'])->findAll()->getData();
					foreach ($group_item_arr as $gi) {
						$new_group_item_arr = array();
						$new_group_item_arr['product_id'] = $new_product_id;
						$new_group_item_arr['group_id'] = $new_group_id;
						$new_group_item_id = $pjProductGroupItemModel->reset()->setAttributes($new_group_item_arr)->insert()->getInsertId();
						if ($new_group_item_id !== false && (int)$new_group_item_id > 0) {
							$group_item_i18n = $pjMultiLangModel->reset()->getMultiLang($gi['id'], 'pjProductGroupItem');
							if ($group_item_i18n) {
								$pjMultiLangModel->saveMultiLang($group_item_i18n, $new_group_item_id, 'pjProductGroupItem', 'data');
							}
						}
					}
				}
			}
		}
		return $new_product_id;
	}

    /*Khuetech display_type */
    /*run -> https://caffexo.dev/index.php?controller=pjAdminProducts&action=pjActionUpdate14479*/
    public function pjActionUpdate14479()
    {
        $this->checkLogin();

        if ($this->isAdmin()) {

            /*Add field into model*/
            $sql="ALTER TABLE `cfxfood_delivery_products` ADD `display_type` INT NULL DEFAULT '0' AFTER `catering_hours_in_advance`, ADD INDEX (`display_type`)";
            pjAppModel::factory()->execute($sql);

            /*Add field language*/
            $pjFieldModel=pjFieldModel::factory();
            $pjMultiLangModel=pjMultiLangModel::factory();
            $sql= "INSERT INTO `".$pjFieldModel->getTable()."` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES (NULL, 'lbl_display_type', 'backend', 'Label / Display type', 'script', NULL)";
            $pjFieldModel->reset()->execute($sql);
            $id=$pjFieldModel->getInsertId();

            $sql= "INSERT INTO `".$pjMultiLangModel->getTable()."` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES (NULL, ".$id.", 'pjField', '1', 'title', 'Display type', 'script')";
            $pjFieldModel->reset()->execute($sql);

            echo 'Options have been updated!!!';
        } else {
            echo 'Access denied!!!';
        }
        exit;
    }

    /*Khuetech combo */
    /*run -> https://caffexo.dev/index.php?controller=pjAdminProducts&action=pjActionUpdate14480*/
    public function pjActionUpdate14480()
    {
        $this->checkLogin();

        if ($this->isAdmin()) {
            /*Add field language*/
            $keys['lblProductCombos']='Product combos';
            $keys['lblProductCombo']='Combo';
            $keys['btnAddCombo']='Add Combo';
            $keys['btnDeleteCombo']='Delete Combo';
            $keys['lblProductComboName']='Name';
            $keys['lblProductComboCondition']='Condition';
            $keys['lblProductComboProducts']='Products';
            $keys['lblNoProductsFound']='No products found. Add a product';

            foreach($keys as $k=>$v) {
                $pjFieldModel = pjFieldModel::factory();
                $sql = "INSERT INTO `" . $pjFieldModel->getTable() . "` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES (NULL, '".$k."', 'backend', 'Label / ".$v."', 'script', NULL)";
                $pjFieldModel->reset()->execute($sql);
                $id = $pjFieldModel->getInsertId();

                $pjMultiLangModel = pjMultiLangModel::factory();
                $sql = "INSERT INTO `" . $pjMultiLangModel->getTable() . "` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES (NULL, $id, 'pjField', '1', 'title', '".$v."' , 'script')";
                $pjFieldModel->reset()->execute($sql);
            }
            echo 'Options have been updated!!!';
        } else {
            echo 'Access denied!!!';
        }
        exit;
    }
}
?>