<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminTime extends pjAdmin
{
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['working_time']))
			{
				$pjWorkingTimeModel = pjWorkingTimeModel::factory();
				$pjLocationWTModel = pjLocationWTModel::factory();
				
				$pjLocationWTModel->where('location_id', $_POST['location_id'])->eraseAll();
				$arr = $pjWorkingTimeModel->find($_POST['location_id'])->getData();
				
				$data = array();
				$data['location_id'] = $_POST['location_id'];
				
				$types = array('p_' => 'pickup', 'd_' => 'delivery');
				$weekDays = pjUtil::getWeekdays();		
				$pjLocationWTModel->reset()->begin();		
				foreach ($types as $prefix => $type)
				{
					foreach ($weekDays as $day)
					{
						if (!isset($_POST[$prefix . $day . '_dayoff']))
						{
							$data[$prefix . $day . '_dayoff'] = "F";
							if (isset($_POST[$prefix . $day . '_from']) && count($_POST[$prefix . $day . '_from']) > 0) {
								$start_ts = strtotime($_POST[$prefix . $day . '_from'][0]);
								$end_ts = strtotime($_POST[$prefix . $day . '_to'][0]);
						
								foreach ($_POST[$prefix . $day . '_from'] as $idx => $start_time) {
									if (!empty($start_time) && isset($_POST[$prefix . $day . '_to'][$idx]) && !empty($_POST[$prefix . $day . '_to'][$idx])) {
										$start = date('H:i', strtotime($start_time));
										$end = date('H:i', strtotime($_POST[$prefix . $day . '_to'][$idx]));
										
										if ($start_ts > strtotime($start_time)) {
											$start_ts = strtotime($start_time);
										}
										if ($end_ts < strtotime($_POST[$prefix . $day . '_to'][$idx])) {
											$end_ts = strtotime($_POST[$prefix . $day . '_to'][$idx]);
										}
										
										$pjLocationWTModel
											->reset()
											->set('location_id', $_POST['location_id'])
											->set('day', $day)
											->set('start_time', $start)
											->set('end_time', $end)
											->set('type', $type)
											->insert();
									}
								}
								$data[$prefix . $day . '_from'] = date('H:i', $start_ts);
								$data[$prefix . $day . '_to'] = date('H:i', $end_ts);
							}
						}else{
							$data[$prefix . $day . '_dayoff'] = "T";
							$data[$prefix . $day . '_from'] = ":NULL";
							$data[$prefix . $day . '_to'] = ":NULL";
						}
					}
				}
				$pjLocationWTModel->commit();
				
				if (count($arr) > 0)
				{
					
					$pjWorkingTimeModel->reset()->setAttributes(array('location_id' => $_POST['location_id']))->erase();
				}
				$pjWorkingTimeModel->reset()->setAttributes($data)->insert();
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminTime&action=pjActionIndex&id=".$_POST['location_id']."&err=AT01");
			}
			
			if (isset($_POST['custom_time']))
			{
				$date = pjUtil::formatDate($_POST['date'], $this->option_arr['o_date_format']);
				
				$pjDateModel = pjDateModel::factory();
				$pjDateWTModel = pjDateWTModel::factory();
				
				$pjDateModel->where('location_id', $_POST['location_id'])->where('type', $_POST['type'])->where('date', $date)->eraseAll();
				$pjDateWTModel->where('location_id', $_POST['location_id'])->where('type', $_POST['type'])->where('date', $date)->eraseAll();
				
				$data = array();
				$data['location_id'] = $_POST['location_id'];
				$data['date'] = $date;
				$data['type'] = $_POST['type'];
				$data['is_dayoff'] = $_POST['is_dayoff'];
				
				$id = $pjDateModel->reset()->setAttributes($data)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0 && !isset($_POST['is_dayoff'])) {
					if (isset($_POST['start']) && count($_POST['start']) > 0) {
						$start_time = strtotime($_POST['start'][0]);
						$end_time = strtotime($_POST['end'][0]);
						
						$pjDateWTModel->reset()->begin();
						foreach ($_POST['start'] as $k => $v) { 
							if (!empty($v) && isset($_POST['end'][$k]) && !empty($_POST['end'][$k])) {
								$start = date('H:i', strtotime($v));
								$end = date('H:i', strtotime($_POST['end'][$k]));
								if ($start_time > strtotime($v)) {
									$start_time = strtotime($v);
								}
								if ($end_time < strtotime($_POST['end'][$k])) {
									$end_time = strtotime($_POST['end'][$k]);
								}
								$pjDateWTModel
									->reset()
									->set('date_id', $id)
									->set('location_id', $_POST['location_id'])
									->set('date', $date)
									->set('type', $_POST['type'])
									->set('start_time', $start)
									->set('end_time', $end)
									->insert();
							}
						}
						$pjDateWTModel->commit();
						
						$pjDateModel->reset()->set('id', $id)->modify(array(
							'start_time' => date('H:i', $start_time),
							'end_time' => date('H:i', $end_time)
						));
					}
				}
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminTime&action=pjActionIndex&id=".$_POST['location_id']."&err=AT02&tab_id=tabs-2");
			}
			
			$arr = pjLocationModel::factory()->find($_GET['id'])->getData();
			if (count($arr) === 0)
			{
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminLocations&action=pjActionIndex&err=AL08");
			}
			$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjLocation');
			$this->set('arr', $arr);
			$this->set('wt_arr', pjWorkingTimeModel::factory()->find($_GET['id'])->getData());
			
			$lwt_arr = array();
			$_lwt_arr = pjLocationWTModel::factory()->where('t1.location_id', $_GET['id'])->findAll()->getData();
			foreach ($_lwt_arr as $val) {
				$lwt_arr[$val['type']][$val['day']][] = $val;
			}
			$this->set('lwt_arr', $lwt_arr);
			
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('additional-methods.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendCss('jquery.ui.timepicker.css', PJ_THIRD_PARTY_PATH . 'timepicker/');
			$this->appendJs('jquery.ui.timepicker.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
			$this->appendJs('pjAdminTime.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetDate()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjDateModel = pjDateModel::factory();
			
			$column = 'date';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}
			if (isset($_GET['location_id']) && (int) $_GET['location_id'] > 0)
			{
				$pjDateModel->where('location_id', $_GET['location_id']);
			}

			$total = $pjDateModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			
			$data = $pjDateModel->select('t1.*')
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
				
			$yesno = __('_yesno', true, false);
			$types = __('types', true, false);
			foreach($data as $k => $v){
				if($v['is_dayoff'] == 'F')
				{
					$v['start_time'] = date($this->option_arr['o_time_format'], strtotime($v['start_time']));
					$v['end_time'] = date($this->option_arr['o_time_format'], strtotime($v['end_time']));
				}else{
					$v['start_time'] = '';
					$v['end_time'] = '';
				}
				$v['is_dayoff'] = $yesno[$v['is_dayoff']];
				$v['type'] = $types[$v['type']];
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionDeleteDate()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjDateModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjDateWTModel::factory()->where('date_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteDateBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjDateModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjDateWTModel::factory()->whereIn('date_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$arr = pjDateModel::factory()->find($_GET['id'])->getData();
			if (count($arr) === 0)
			{
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminTime&action=pjActionIndex&err=AT09&tab_id=tabs-2");
			}
			
			$this->set('arr', $arr);
			$this->set('wt_arr', pjDateWTModel::factory()->where('t1.date_id', $arr['id'])->orderBy('t1.start_time ASC, t1.end_time ASC')->findAll()->getData());
			
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendCss('jquery.ui.timepicker.css', PJ_THIRD_PARTY_PATH . 'timepicker/');
			$this->appendJs('jquery.ui.timepicker.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
			$this->appendJs('pjAdminTime.js');
			
		} else {
			$this->set('status', 2);
		}
	}
}
?>