<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjOptionModel extends pjAppModel
{
	protected $primaryKey = NULL;
	
	protected $table = 'options';
	
	protected $schema = array(
		array('name' => 'foreign_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'key', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'tab_id', 'type' => 'tinyint', 'default' => ':NULL'),
		array('name' => 'value', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'label', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'type', 'type' => 'varchar', 'default' => 'string'),
		array('name' => 'order', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'is_visible', 'type' => 'tinyint', 'default' => 1),
		array('name' => 'style', 'type' => 'varchar', 'default' => 'string')
	);
	
	public static function factory($attr=array())
	{
		return new pjOptionModel($attr);
	}
	
	public function getAllPairs($foreign_id)
	{
		return $this->where('t1.foreign_id', $foreign_id)->findAll()->getDataPair('key', 'value');
	}
	
	public function getPairs($foreign_id)
	{
		$_arr = $this->where('t1.foreign_id', $foreign_id)->findAll()->getData();
		$arr = array();
		foreach ($_arr as $row)
		{
			switch ($row['type'])
			{
				case 'enum':
				case 'bool':
					list(, $arr[$row['key']]) = explode("::", $row['value']);
					break;
				default:
					$arr[$row['key']] = $row['value'];
					break;
			}
		}
		return $arr;
	}

	public function initOptions($foreign_id) {
		$sql = "INSERT INTO `".$this->getTable()."` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
				(".$foreign_id.", 'o_add_tax', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
				(".$foreign_id.", 'o_admin_email_cancel', 3, '0|1::1', 'No|Yes', 'enum', 8, 1, NULL),
				(".$foreign_id.", 'o_admin_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),
				(".$foreign_id.", 'o_admin_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
				(".$foreign_id.", 'o_admin_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
				(".$foreign_id.", 'o_admin_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
				(".$foreign_id.", 'o_admin_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
				(".$foreign_id.", 'o_admin_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 5, 1, NULL),
				(".$foreign_id.", 'o_admin_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
				(".$foreign_id.", 'o_admin_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
				(".$foreign_id.", 'o_admin_sms_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
				(".$foreign_id.", 'o_admin_sms_payment_message', 3, '', NULL, 'text', 5, 1, NULL),
				(".$foreign_id.", 'o_bf_include_address_1', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
				(".$foreign_id.", 'o_bf_include_address_2', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
				(".$foreign_id.", 'o_bf_include_captcha', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 14, 1, NULL),
				(".$foreign_id.", 'o_bf_include_city', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
				(".$foreign_id.", 'o_bf_include_company', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
				(".$foreign_id.", 'o_bf_include_country', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 13, 1, NULL),
				(".$foreign_id.", 'o_bf_include_email', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
				(".$foreign_id.", 'o_bf_include_name', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
				(".$foreign_id.", 'o_bf_include_notes', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
				(".$foreign_id.", 'o_bf_include_phone', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
				(".$foreign_id.", 'o_bf_include_state', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
				(".$foreign_id.", 'o_bf_include_title', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
				(".$foreign_id.", 'o_bf_include_zip', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),
				(".$foreign_id.", 'o_cf_include_address_1', 8, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
				(".$foreign_id.", 'o_cf_include_address_2', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
				(".$foreign_id.", 'o_cf_include_city', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
				(".$foreign_id.", 'o_cf_include_country', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
				(".$foreign_id.", 'o_cf_include_notes', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
				(".$foreign_id.", 'o_cf_include_state', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
				(".$foreign_id.", 'o_cf_include_zip', 8, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
				(".$foreign_id.", 'o_datetime_format', 1, 'd.m.Y, H:i|d.m.Y, H:i:s|m.d.Y, H:i|m.d.Y, H:i:s|Y.m.d, H:i|Y.m.d, H:i:s|j.n.Y, H:i|j.n.Y, H:i:s|n.j.Y, H:i|n.j.Y, H:i:s|Y.n.j, H:i|Y.n.j, H:i:s|d/m/Y, H:i|d/m/Y, H:i:s|m/d/Y, H:i|m/d/Y, H:i:s|Y/m/d, H:i|Y/m/d, H:i:s|j/n/Y, H:i|j/n/Y, H:i:s|n/j/Y, H:i|n/j/Y, H:i:s|Y/n/j, H:i|Y/n/j, H:i:s|d-m-Y, H:i|d-m-Y, H:i:s|m-d-Y, H:i|m-d-Y, H:i:s|Y-m-d, H:i|Y-m-d, H:i:s|j-n-Y, H:i|j-n-Y, H:i:s|n-j-Y, H:i|n-j-Y, H:i:s|Y-n-j, H:i|Y-n-j, H:i:s::m-d-Y, H:i', 'd.m.Y, H:i (25.09.2010, 09:51)|d.m.Y, H:i:s (25.09.2010, 09:51:47)|m.d.Y, H:i (09.25.2010, 09:51)|m.d.Y, H:i:s (09.25.2010, 09:51:47)|Y.m.d, H:i (2010.09.25, 09:51)|Y.m.d, H:i:s (2010.09.25, 09:51:47)|j.n.Y, H:i (25.9.2010, 09:51)|j.n.Y, H:i:s (25.9.2010, 09:51:47)|n.j.Y, H:i (9.25.2010, 09:51)|n.j.Y, H:i:s (9.25.2010, 09:51:47)|Y.n.j, H:i (2010.9.25, 09:51)|Y.n.j, H:i:s (2010.9.25, 09:51:47)|d/m/Y, H:i (25/09/2010, 09:51)|d/m/Y, H:i:s (25/09/2010, 09:51:47)|m/d/Y, H:i (09/25/2010, 09:51)|m/d/Y, H:i:s (09/25/2010, 09:51:47)|Y/m/d, H:i (2010/09/25, 09:51)|Y/m/d, H:i:s (2010/09/25, 09:51:47)|j/n/Y, H:i (25/9/2010, 09:51)|j/n/Y, H:i:s (25/9/2010, 09:51:47)|n/j/Y, H:i (9/25/2010, 09:51)|n/j/Y, H:i:s (9/25/2010, 09:51:47)|Y/n/j, H:i (2010/9/25, 09:51)|Y/n/j, H:i:s (2010/9/25, 09:51:47)|d-m-Y, H:i (25-09-2010, 09:51)|d-m-Y, H:i:s (25-09-2010, 09:51:47)|m-d-Y, H:i (09-25-2010, 09:51)|m-d-Y, H:i:s (09-25-2010, 09:51:47)|Y-m-d, H:i (2010-09-25, 09:51)|Y-m-d, H:i:s (2010-09-25, 09:51:47)|j-n-Y, H:i (25-9-2010, 09:51)|j-n-Y, H:i:s (25-9-2010, 09:51:47)|n-j-Y, H:i (9-25-2010, 09:51)|n-j-Y, H:i:s (9-25-2010, 09:51:47)|Y-n-j, H:i (2010-9-25, 09:51)|Y-n-j, H:i:s (2010-9-25, 09:51:47)', 'enum', 3, 1, NULL),
				(".$foreign_id.", 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::m-d-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
				(".$foreign_id.", 'o_df_include_address_1', 6, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
				(".$foreign_id.", 'o_df_include_address_2', 6, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
				(".$foreign_id.", 'o_df_include_city', 6, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
				(".$foreign_id.", 'o_df_include_country', 6, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
				(".$foreign_id.", 'o_df_include_notes', 6, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
				(".$foreign_id.", 'o_df_include_state', 6, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
				(".$foreign_id.", 'o_df_include_zip', 6, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
				(".$foreign_id.", 'o_email_account_message', 3, '', NULL, 'text', 15, 1, NULL),
				(".$foreign_id.", 'o_email_account_subject', 3, '', NULL, 'string', 14, 1, NULL),
				(".$foreign_id.", 'o_email_cancel', 3, '0|1::1', 'No|Yes', 'enum', 8, 1, NULL),
				(".$foreign_id.", 'o_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),
				(".$foreign_id.", 'o_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
				(".$foreign_id.", 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
				(".$foreign_id.", 'o_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
				(".$foreign_id.", 'o_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
				(".$foreign_id.", 'o_email_forgot_message', 3, '', NULL, 'text', 17, 1, NULL),
				(".$foreign_id.", 'o_email_forgot_subject', 3, '', NULL, 'string', 16, 1, NULL),
				(".$foreign_id.", 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 5, 1, NULL),
				(".$foreign_id.", 'o_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
				(".$foreign_id.", 'o_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
				(".$foreign_id.", 'o_fields_index', 99, '5dc07612bbe1dc3a3fae35fe10cc6f42', NULL, 'string', NULL, 0, NULL),
				(".$foreign_id.", 'o_layout', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 10, 0, NULL),
				(".$foreign_id.", 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
				(".$foreign_id.", 'o_pf_include_notes', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),
				(".$foreign_id.", 'o_print_order', 7, '', NULL, 'text', 1, 1, NULL),
				(".$foreign_id.", 'o_print_order_normal', 7, '', NULL, 'text', 2, 1, NULL),
				(".$foreign_id.", 'o_sender_email', 1, 'info@caffexo.com', NULL, 'string', 13, 1, NULL),								
				(".$foreign_id.", 'o_second_notification_email', 1, '', NULL, 'string', 14, 1, NULL),
				(".$foreign_id.", 'o_notification_phone_number', 1, '', NULL, 'string', 15, 1, NULL),
				(".$foreign_id.", 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
				(".$foreign_id.", 'o_sms_payment_message', 3, '', NULL, 'text', 1, 1, NULL),
				(".$foreign_id.", 'o_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
				(".$foreign_id.", 'o_sms_ready_pickup_message', 3, '', NULL, 'text', 3, 1, NULL),
				(".$foreign_id.", 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
				(".$foreign_id.", 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
				(".$foreign_id.", 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
				(".$foreign_id.", 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),
				(".$foreign_id.", 'o_terms', 5, '', NULL, 'text', 1, 1, NULL),
				(".$foreign_id.", 'o_google_map_api', 1, '', NULL, 'string', 16, 1, NULL),
				(".$foreign_id.", 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
				(".$foreign_id.", 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
				(".$foreign_id.", 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
				(".$foreign_id.", 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::USD', NULL, 'enum', 1, 1, NULL),
				(".$foreign_id.", 'o_allow_delivery', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 2, 1, NULL),
				(".$foreign_id.", 'o_allow_delivery_doordash', 2, 'Yes|No::No', 'Yes|No', 'enum', 2, 1, NULL),
				(".$foreign_id.", 'o_doordash_developer_id', 2, '', NULL, 'string', 2, 1, NULL),
				(".$foreign_id.", 'o_doordash_key_id', 2, '', NULL, 'string', 2, 1, NULL),
				(".$foreign_id.", 'o_doordash_signing_secret', 2, '', NULL, 'string', 2, 1, NULL),
                (".$foreign_id.", 'o_doordash_dasher_tip_earn', 2, '0', NULL, 'int', 2, 1, NULL),
                (".$foreign_id.", 'o_doordash_num_of_recall_dasher', 2, '1', NULL, 'int', 2, 1, NULL),
				(".$foreign_id.", 'o_allow_pickup', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 3, 1, NULL),
				(".$foreign_id.", 'o_allow_catering', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 4, 1, NULL),
				(".$foreign_id.", 'o_catering_fee', 2, '10.00', NULL, 'float', 5, 1, NULL),
				(".$foreign_id.", 'o_catering_fee_percent', 2, '', NULL, 'float', 6, 1, NULL),
				(".$foreign_id.", 'o_catering_total', 2, '', NULL, 'float', 7, 1, NULL),
				(".$foreign_id.", 'o_catering_hours_in_advance', 2, '24', NULL, 'int', 8, 1, NULL),
				(".$foreign_id.", 'o_delivery_catering_max_distance', 2, '10.00', NULL, 'float', 9, 1, NULL),
				(".$foreign_id.", 'o_minimum_order', 2, '0.00', NULL, 'int', 10, 1, NULL),
				(".$foreign_id.", 'o_minimum_order_catering', 2, '0.00', NULL, 'int', 11, 1, NULL),
				(".$foreign_id.", 'o_minimum_order_delivery', 2, '0.00', NULL, 'int', 11, 1, NULL),
				(".$foreign_id.", 'o_allow_service_fee', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 12, 1, NULL),
				(".$foreign_id.", 'o_service_fee', 2, '10.00', NULL, 'int', 13, 1, NULL),	
				(".$foreign_id.", 'o_tax_payment', 2, '10.00', NULL, 'int', 14, 1, NULL),
				(".$foreign_id.", 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 15, 1, NULL),
				(".$foreign_id.", 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 16, 1, NULL),
				(".$foreign_id.", 'o_thankyou_page', 2, 'https://www.caffexo.com', NULL, 'string', 17, 1, NULL),
				(".$foreign_id.", 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 18, 1, NULL),
				(".$foreign_id.", 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 19, 1, NULL),
				(".$foreign_id.", 'o_paypal_address', 2, 'sales@clsinnovations.com', NULL, 'string', 20, 1, NULL),
				(".$foreign_id.", 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 21, 1, NULL),
				(".$foreign_id.", 'o_authorize_transkey', 2, '', NULL, 'string', 22, 1, NULL),
				(".$foreign_id.", 'o_authorize_merchant_id', 2, '', NULL, 'string', 23, 1, NULL),
				(".$foreign_id.", 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::|-21600|', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 24, 0, NULL),
				(".$foreign_id.", 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 25, 0, NULL),
				(".$foreign_id.", 'o_allow_cash', 2, 'Yes|No::No', 'Yes|No', 'enum', 26, 1, NULL),
				(".$foreign_id.", 'o_allow_creditcard', 2, 'Yes|No::No', 'Yes|No', 'enum', 27, 1, NULL),
				(".$foreign_id.", 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 28, 1, NULL),
				(".$foreign_id.", 'o_bank_account', 2, NULL, NULL, 'text', 29, 1, NULL),
				
				(".$foreign_id.", 'o_allow_usaepay', 2, 'Yes|No::No', NULL, 'enum', 30, 1, NULL),
				(".$foreign_id.", 'o_usaepay_apikey', 2, NULL, NULL, 'string', 31, 1, NULL),
				(".$foreign_id.", 'o_usaepay_apipin', 2, NULL, NULL, 'string', 32, 1, NULL),
				(".$foreign_id.", 'o_usaepay_seed', 2, NULL, NULL, 'string', 33, 0, NULL),
				
				(".$foreign_id.", 'o_allow_automatic_print', 2, 'Yes|Yes_SDP|No::No', 'Remote printer set by IP:Port|Remote printer set by SDP|No', 'enum', 34, 1, NULL),
				(".$foreign_id.", 'o_printer_copies', 2, '1', NULL, 'int', 35, 1, NULL),				
				(".$foreign_id.", 'o_printer_ip', 2, '', NULL, 'string', 36, 1, NULL),
				(".$foreign_id.", 'o_printer_port', 2, '', NULL, 'int', 37, 1, NULL),
				(".$foreign_id.", 'o_printer_printer_id', 2, '', NULL, 'string', 37, 1, NULL),
				(".$foreign_id.", 'o_tip_1', 2, '15', NULL, 'int', 38, 1, NULL),
				(".$foreign_id.", 'o_tip_2', 2, '18', NULL, 'int', 39, 1, NULL),
				(".$foreign_id.", 'o_tip_3', 2, '20', NULL, 'int', 40, 1, NULL),
				(".$foreign_id.", 'o_tip_4', 2, '25', NULL, 'int', 41, 1, NULL),
				(".$foreign_id.", 'o_tip_5', 2, '28', NULL, 'int', 42, 1, NULL),
				(".$foreign_id.", 'o_tip_6', 2, '30', NULL, 'int', 43, 1, NULL),
                (".$foreign_id.", 'o_sms_dasher_confirmed_message', 9, '', NULL, 'text', 1, 1, NULL),
				(".$foreign_id.", 'o_sms_dasher_confirmed_pickup_arrival_message', 9, '', NULL, 'text', 2, 1, NULL),
				(".$foreign_id.", 'o_sms_dasher_picked_up_message', 9, '', NULL, 'text', 3, 1, NULL),
				(".$foreign_id.", 'o_sms_dasher_confirmed_dropoff_arrival_message', 9, '', NULL, 'text', 4, 1, NULL),
				(".$foreign_id.", 'o_sms_dasher_dropped_off_message', 9, '', NULL, 'text', 5, 1, NULL),
				(".$foreign_id.", 'o_sms_delivery_cancelled_message', 9, '', NULL, 'text', 6, 1, NULL),
				(".$foreign_id.", 'o_sms_delivery_abandoned_message', 9, '', NULL, 'text', 7, 1, NULL),

                /*Khuetech add nmipay */
                (".$foreign_id.", 'o_allow_nmipay', 2, 'Yes|No::No', NULL, 'enum', 44, 1, NULL),
				(".$foreign_id.", 'o_nmipay_apikey', 2, NULL, NULL, 'string', 45, 1, NULL);";
		$this->execute($sql);
	}
}
?>