<?php
if (isset($tpl['status'])) {
  $status = __('status', true);
  switch ($tpl['status']) {
    case 2:
      pjUtil::printNotice(NULL, $status[2]);
      break;
  }
  exit;
}

include_once("tabs.php");
pjUtil::printNotice("General Kiosk App", "Setup data information (Note: The updated data will not change the Setting App, only applicable for the Build a new Kiosk App)");
?>

<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionConfig" method="post" class="form pj-form" enctype="multipart/form-data">
  <input type="hidden" name="options_update" value="1"/>
  <input type="hidden" name="next_action" value="pjActionConfig"/>

  <fieldset class="fieldset white">
    <legend>Setting Payment (NMI Gateway)</legend>
    <table class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%">
      <thead>
      <tr>
        <th><?php __('lblOption'); ?></th>
        <th><?php __('lblValue'); ?></th>
      </tr>
      </thead>
      <tbody>
      <tr class="pj-table-row-odd" style="">
        <td>API URL</td>
        <td><input type="text" name="usaepay_api_url" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['usaepay_api_url']; ?>" required></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>API Key</td>
        <td><input type="text" name="usaepay_api_key" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['usaepay_api_key']; ?>" required></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>API Pin</td>
        <td><input type="text" name="usaepay_api_pin" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['usaepay_api_pin']; ?>" required></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>Device Key</td>
        <td><input type="text" name="usaepay_api_devicekey" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['usaepay_api_devicekey']; ?>" required></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>Command</td>
        <td><input type="text" name="usaepay_api_command" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['usaepay_api_command']; ?>" required></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>Timeout</td>
        <td><input type="text" name="usaepay_api_timeout" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['usaepay_api_timeout']; ?>" required></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>Prompt Tip</td>
        <td><input type="text" name="usaepay_prompt_tip" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['usaepay_prompt_tip']; ?>" required></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
          <td>Fee Charges (%)</td>
          <td><input type="number" name="usaepay_fee_charges" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config']['usaepay_fee_charges'])) echo $tpl['kiosk_config']['usaepay_fee_charges']; else echo '0.00'; ?>" required min="0.00" max="100.00" step="0.01"></td>
      </tr>
      </tbody>
    </table>
  </fieldset>

  <fieldset class="fieldset white">
    <legend>Setting SMS</legend>
    <table class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%">
      <thead>
      <tr>
        <th><?php __('lblOption'); ?></th>
        <th><?php __('lblValue'); ?></th>
      </tr>
      </thead>
      <tbody>
      <tr class="pj-table-row-odd" style="">
        <td>URL</td>
        <td><input type="text" name="sms_url" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['sms_url']; ?>"></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>From</td>
        <td><input type="text" name="sms_from" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['sms_from']; ?>"></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>Username</td>
        <td><input type="text" name="sms_username" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['sms_username']; ?>"></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>API Key</td>
        <td><input type="text" name="sms_apikey" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['sms_apikey']; ?>"></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>Authorization</td>
        <td><input type="text" name="sms_authorization" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['sms_authorization']; ?>"></td>
      </tr>
      </tbody>
    </table>
  </fieldset>


  <fieldset class="fieldset white">
    <legend>Setting Printers</legend>
    <div id="setting-printers">
      <?php foreach($tpl['kiosk_config']['printers'] as $key=>$value){ ?>
      <table id="setting-printers-table" class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%; margin-bottom: 10px;">
        <thead>
        <tr>
          <th><?php __('lblOption'); ?></th>
          <th><?php __('lblValue'); ?></th>
          <th>Action</th>
        </tr>
        </thead>
        <tbody>
        <tr class="pj-table-row-odd" style="">
          <td>Printer ID</td>
          <td>
            <input type="hidden" name="printer_ids[]" class="pj-form-field w300" value="<?php if(isset($value['id'])) echo $value['id']; ?>">
            <input type="text" class="pj-form-field w300" value="<?php if(isset($value['id'])) echo $value['id']; ?>" disabled="true">
          </td>
          <td rowspan="6" align="center">
            <a class="pj-button setting-printers-table-remove" onclick="removePrinter(this)">x Remove</a>
          </td>
        </tr>
        <tr class="pj-table-row-odd" style="">
          <td>Pre Printer Name</td>
          <td><input type="text" name="printer_pre_names[]" class="pj-form-field w300" value="<?php if(isset($value['pre_name'])) echo $value['pre_name']; ?>"></td>
        </tr>
        <tr class="pj-table-row-odd" style="">
          <td>Printer IP</td>
          <td><input type="text" name="printer_ips[]" class="pj-form-field w300" value="<?php if(isset($value['ip'])) echo $value['ip']; ?>"></td>
        </tr>
        <tr class="pj-table-row-odd" style="">
          <td>Printer Port</td>
          <td><input type="text" name="printer_ports[]" class="pj-form-field w300" value="<?php if(isset($value['port'])) echo $value['port']; ?>"></td>
        </tr>
        <tr class="pj-table-row-odd" style="">
          <td>Location</td>
          <td>
            <select name="printer_locations[]" class="pj-form-field">
              <option value="C" <?php echo ($value['location']==='C')? 'selected': '';?>>Customer</option>
              <option value="K" <?php echo ($value['location']==='K')? 'selected': '';?>>Kitchen</option>
            </select>
          </td>
        </tr>
        <tr class="pj-table-row-odd" style="">
          <td>SDP Link</td>
          <td>
              <div class="sdp-link" id="<?php echo 'copy_'.$tpl['rid'].$tpl['kid'].$value['id']; ?>">
                  <?php echo $tpl['domain'] . 'kiosk-sdp.printer&rid=' . $tpl['rid'] . '&kid=' . $tpl['kid'] . '&printer_id=' . $value['id'] . '&device_id=XXX'; ?>
              </div>
              <div style="display: flex; padding: 5px 0px;">
                  <div class="tooltip-copy">
                      <a class="pj-button" style="background: #e5f9ff;" onclick="copyFunc('<?php echo 'copy_'.$tpl['rid'].$tpl['kid'].$value['id']; ?>', '<?php echo 'tooltip_'.$tpl['rid'].$tpl['kid'].$value['id']; ?>')" onmouseout="outFunc('<?php echo 'tooltip_'.$tpl['rid'].$tpl['kid'].$value['id']; ?>')">
                          <span class="tooltiptext" id="<?php echo 'tooltip_'.$tpl['rid'].$tpl['kid'].$value['id']; ?>">Copy to clipboard</span>
                          Copy link
                      </a>
                  </div>
                  <div style="margin-left: 5px;">
                      <a class="pj-button" style="background: #ddfad7;" onclick="printerTo('<?php echo $value['id']; ?>','0')">Print test</a>
                  </div>
              </div>
              <div>Note: Replace XXX to Device ID of the printer</div>
          </td>
        </tr>
        </tbody>
      </table>
      <?php } ?>
    </div>
    <div align="center"><a class="pj-button" onclick="addPrinter()">+ Add</a></div>
    <script>
      function removePrinter(input){
        input.parentNode.parentNode.parentNode.parentNode.remove();
      }

      function addPrinter(){
        const node = document.getElementById("setting-printers-template");
        const clone = node.cloneNode(true);
        document.getElementById("setting-printers").appendChild(clone);
      }

      function copyFunc(idCopy, idTooltip) {
          var copyText = document.getElementById(idCopy);
          navigator.clipboard.writeText(copyText.innerText);

          var tooltip = document.getElementById(idTooltip);
          tooltip.innerHTML = "Copied";
      }

      function outFunc(idTooltip) {
          var tooltip = document.getElementById(idTooltip);
          tooltip.innerHTML = "Copy to clipboard";
      }

      function printerTo(printer_id, order_id){
          if (confirm("Do you want to print test this printer?") == true) {
              $.ajax({
                  type: 'GET',
                  async: true,
                  url: "index.php?controller=pjKiosk&action=pjAjaxOrderPrintAddQueue",
                  data: {
                      printer_id: printer_id,
                      order_id: order_id
                  },
                  beforeSend: function(){
                      $("body").append("<div class='loading'></div>");
                  },
                  success: function(data){
                      $(".loading").remove();
                      if(data==""){
                          data='error';
                      }
                      alert('Status: '+data);
                  },
                  error: function (data){
                      $(".loading").remove();
                      alert('Status: error');
                  }
              });
          }
      }
    </script>
    <style>
      .setting-printers-table-remove{
        display: inline-block;
        width: 55px;
      }

      .sdp-link{
        word-wrap: break-word;
        background: #f4f4f4;
        padding: 5px;
        font-style: italic;
      }

      .tooltip-copy {
          position: relative;
          display: inline-block;
      }

      .tooltip-copy .tooltiptext {
          visibility: hidden;
          width: 140px;
          background-color: #555;
          color: #fff;
          text-align: center;
          border-radius: 6px;
          padding: 5px;
          position: absolute;
          z-index: 1;
          bottom: 150%;
          left: 50%;
          margin-left: -75px;
          opacity: 0;
          transition: opacity 0.3s;
      }

      .tooltip-copy .tooltiptext::after {
          content: "";
          position: absolute;
          top: 100%;
          left: 50%;
          margin-left: -5px;
          border-width: 5px;
          border-style: solid;
          border-color: #555 transparent transparent transparent;
      }

      .tooltip-copy:hover .tooltiptext {
          visibility: visible;
          opacity: 1;
      }

    </style>
  </fieldset>

  <fieldset class="fieldset white">
    <legend>Setting App Layout</legend>
    <table class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%">
      <thead>
      <tr>
        <th><?php __('lblOption'); ?></th>
        <th><?php __('lblValue'); ?></th>
      </tr>
      </thead>
      <tbody>
      <tr class="pj-table-row-odd" style="">
        <td>Cross Axis Count</td>
        <td><input type="number" name="cross_axis_count" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['cross_axis_count']; ?>" required></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>Cross Axis Cell Count</td>
        <td><input type="number" name="cross_axis_cell_count" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['cross_axis_cell_count']; ?>" required></td>
      </tr>
      <tr class="pj-table-row-odd" style="">
        <td>Main Axis Cell Count</td>
        <td><input type="number" name="main_axis_cell_count" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['main_axis_cell_count']; ?>" required></td>
      </tr>
      </tbody>
    </table>
  </fieldset>

  <fieldset class="fieldset white">
    <legend>Screen Welcome</legend>
    <div id="screen-welcome">
      <?php foreach($tpl['kiosk_config']['welcome'] as $key=>$value){ ?>
      <table id="screen-welcome-table" class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%; margin-bottom: 10px;">
        <thead>
        <tr>
          <th><?php __('lblOption'); ?></th>
          <th><?php __('lblValue'); ?></th>
          <th>Action</th>
        </tr>
        </thead>
        <tbody>
          <tr class="pj-table-row-odd">
            <td>Caption</td>
            <td>
                <input type="text" name="welcome_texts[]" class="pj-form-field w300" value="<?php if(isset($value['text'])) echo $value['text']; ?>" required>
            </td>
            <td rowspan="2" align="center">
              <a class="pj-button screen-welcome-table-remove" onclick="removeWelcome(this)">x Remove</a>
            </td>
          </tr>
          <tr class="pj-table-row-odd">
            <td>Image</td>
            <td>
              <!--<input type="text" name="welcome_imgs[]" class="pj-form-field w300" value="<?php /*if(isset($value['img'])) echo $value['img']; */?>" required>-->
              <input type="file" name="welcome_imgs[]"  class="pj-form-field w300" accept="image/*" onchange="changeImageWelcome(this)">
              <img style="margin-top:5px;" src="<?php if(isset($value['img'])) echo $value['img']; ?>" width="314px" />
              <input type="hidden" name="welcome_imgs_old[]" value="<?php if(isset($value['img'])) echo $value['img']; ?>">
              <br>
              <i><?php if(isset($value['img'])) echo $value['img']; ?></i>
            </td>
          </tr>
        </tbody>
      </table>
      <?php } ?>
    </div>
    <div align="center"><a class="pj-button" onclick="addWelcome()">+ Add</a></div>
    <script>
      function removeWelcome(input){
        input.parentNode.parentNode.parentNode.parentNode.remove();
      }

      function addWelcome(){
        const node = document.getElementById("screen-welcome-template");
        const clone = node.cloneNode(true);
        document.getElementById("screen-welcome").appendChild(clone);
      }

      function changeImageWelcome(input){
          if (input.files.length) {
              const src = URL.createObjectURL(input.files[0]);
              input.parentNode.children[1].src=src;
          }
      }
    </script>
      <style>
          .screen-welcome-table-remove{
              display: inline-block;
              width: 55px;
          }
      </style>
  </fieldset>

  <fieldset class="fieldset white">
    <legend>Option</legend>
    <table class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%">
      <thead>
      <tr>
        <th><?php __('lblOption'); ?></th>
        <th><?php __('lblValue'); ?></th>
      </tr>
      </thead>
      <tbody>
        <tr class="pj-table-row-odd" style="">
          <td>Tax (%)</td>
          <td>
            <input type="text" name="tax" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['tax']; ?>">
          </td>
        </tr>
        <tr class="pj-table-row-odd" style="">
          <td>Tips (%)</td>
          <td>
            <input type="text" name="tips" class="pj-form-field w300" value="<?php if(isset($tpl['kiosk_config'])) echo $tpl['kiosk_config']['tips']; ?>">
            <br><i>Example: 10,12,15,18,20,25,...</i>
          </td>
        </tr>
      </tbody>
    </table>
  </fieldset>

  <span class="inline_block">
    <input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
    <input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjKiosk&action=pjActionKioskIndex';" />
  </span>
</form>



<div style="display: none">
  <table id="setting-printers-template" class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%; margin-bottom: 10px;">
    <thead>
    <tr>
      <th><?php __('lblOption'); ?></th>
      <th><?php __('lblValue'); ?></th>
      <th>Action</th>
    </tr>
    </thead>
    <tbody>
    <tr class="pj-table-row-odd" style="">
      <td>Pre Printer Name</td>
      <td>
        <input type="hidden" name="printer_ids[]" class="pj-form-field w300" value="">
        <input type="text" name="printer_pre_names[]" class="pj-form-field w300" value="">
      </td>
      <td rowspan="4" align="center">
        <a class="pj-button setting-printers-table-remove" onclick="removePrinter(this)">x Remove</a>
      </td>
    </tr>
    <tr class="pj-table-row-odd" style="">
      <td>Printer IP</td>
      <td><input type="text" name="printer_ips[]" class="pj-form-field w300" value="" required></td>
    </tr>
    <tr class="pj-table-row-odd" style="">
      <td>Printer Port</td>
      <td><input type="text" name="printer_ports[]" class="pj-form-field w300" value=""></td>
    </tr>
    <tr class="pj-table-row-odd" style="">
      <td>Location</td>
      <td>
        <select name="printer_locations[]" class="pj-form-field">
          <option value="C" selected>Customer</option>
          <option value="K">Kitchen</option>
        </select>
      </td>
    </tr>
    </tbody>
  </table>

  <table id="screen-welcome-template" class="pj-table" cellpadding="0" cellspacing="0" style="width: 100%; margin-bottom: 10px;">
    <thead>
    <tr>
      <th><?php __('lblOption'); ?></th>
      <th><?php __('lblValue'); ?></th>
      <th>Action</th>
    </tr>
    </thead>
    <tbody>
    <tr class="pj-table-row-odd">
      <td>Caption</td>
      <td>
        <input type="text" name="welcome_texts[]" class="pj-form-field w300" autofocus value="" required>
      </td>
      <td rowspan="2" align="center">
        <a class="pj-button screen-welcome-table-remove" onclick="removeWelcome(this)">x Remove</a>
      </td>
    </tr>
    <tr class="pj-table-row-odd">
      <td>Image</td>
      <td>
        <!--<input type="text" name="welcome_imgs[]" class="pj-form-field w300" value="" required>-->
        <input type="file" name="welcome_imgs[]"  class="pj-form-field w300" accept="image/*" onchange="changeImageWelcome(this)" required>
        <img style="margin-top:5px;" src="" width="314px" />
        <input type="hidden" name="welcome_imgs_old[]" value="">
      </td>
    </tr>
    </tbody>
  </table>
</div>
