<div class="">
    <p style="padding: 10px 0px; text-align: center; background: #f2f9f8; border-radius: 3px; color: #08097b; border: 1px #d0dbda solid; margin-top: 10px;">
        <b style="font-size: 24px;"><?php echo $tpl['restaurant_languages']; ?></b>
        <br><i style="font-size: 16px;">Date from <?php echo $tpl['date_from']; ?> to <?php echo $tpl['date_to']; ?>, exported at time: <?php echo $tpl['date_current']; ?></i>
    </p>
    <br>
    <p style="padding: 10px 0px; text-align: center; font-weight: bold;">REPORT/DASHBOARD<br><i>Approved status</i></p>
    <div class="row">
        <div class="col">
            <div class="panel panel-info">
                <div class="panel-heading" style="background: #f2f3c3;">
                    Total Orders (Confirmed)
                </div>
                <div class="panel-body">
                    <?php echo $tpl['total_orders_confirmed'].'/'.$tpl['total_orders']?>
                </div>
            </div>
        </div>

        <div class="col">
            <div class="panel panel-danger">
                <div class="panel-heading" style="background: #d3f7d3;">
                    Total Discount
                </div>
                <div class="panel-body">
                    <?php echo pjUtil::formatCurrencySign(number_format($tpl['total_discount'], 2), $tpl['option_arr']['o_currency']);?>
                </div>
            </div>
        </div>

        <div class="col">
            <div class="panel panel-danger">
                <div class="panel-heading" style="background: #d1e7ff;">
                    Total Tax
                </div>
                <div class="panel-body">
                    <?php echo pjUtil::formatCurrencySign(number_format($tpl['total_tax'], 2), $tpl['option_arr']['o_currency']);?>
                </div>
            </div>
        </div>

        <div class="col">
            <div class="panel panel-danger">
                <div class="panel-heading" style="background: #ffd1d1;">
                    Total Amount (Sales)
                </div>
                <div class="panel-body">
                    <?php echo pjUtil::formatCurrencySign(number_format($tpl['total_amount'], 2), $tpl['option_arr']['o_currency']);?>
                </div>
            </div>
        </div>
    </div>

    <br>
    <fieldset class="fieldset white">
        <legend>REPORT TOTAL</legend>
        <div class="row">
            <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">

                <tbody>
                <tr>
                    <td>Total orders</td>
                    <td><?php echo $tpl['total_orders']?></td>
                </tr>
                <tr>
                    <td>Total orders confirmed</td>
                    <td><?php echo $tpl['total_orders_confirmed']?></td>
                </tr>
                <tr>
                    <td>Total products ordered</td>
                    <td><?php echo $tpl['total_products_ordered']?></td>
                </tr>
                <tr>
                    <td>Total tax</td>
                    <td><?php echo pjUtil::formatCurrencySign(number_format($tpl['total_tax'], 2), $tpl['option_arr']['o_currency']);?></td>
                </tr>
                <tr>
                    <td>Total discount</td>
                    <td><?php echo pjUtil::formatCurrencySign(number_format($tpl['total_discount'], 2), $tpl['option_arr']['o_currency']);?></td>
                </tr>
                <tr>
                    <td>Total tip</td>
                    <td><?php echo pjUtil::formatCurrencySign(number_format($tpl['total_tip'], 2), $tpl['option_arr']['o_currency']);?></td>
                </tr>
                <tr>
                    <td>Total amount (Sales)</td>
                    <td><?php echo pjUtil::formatCurrencySign(number_format($tpl['total_amount'], 2), $tpl['option_arr']['o_currency']);?></td>
                </tr>
                </tbody>
            </table>
        </div>
    </fieldset>


    <br>
    <fieldset class="fieldset white">
        <legend>TRANSACTION REPORT</legend>
        <div class="row">
            <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">
                <thead>
                <th>Status</th>
                <th style="width: 20%;">Total ordered</th>
                <th style="width: 35%;">Total amount</th>
                </thead>
                <tbody>
                <?php
                foreach($tpl['transaction_arr'] as $k => $v)
                {
                    ?>
                    <tr>
                        <td><?php echo pjSanitize::html($v['status']);?></td>
                        <td><?php echo (int) $v['total_ordered'];?></td>
                        <td><?php echo pjUtil::formatCurrencySign(number_format( (float)$v['total_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>
        </div>
    </fieldset>

    <br>
    <fieldset class="fieldset white">
        <legend>CATEGORY REPORT</legend>
        <div class="row">
            <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">
                <thead>
                <th>Category</th>
                <th style="width: 20%;">Products ordered</th>
                <th style="width: 35%;">Total amount</th>
                </thead>
                <tbody>
                <?php
                foreach($tpl['category_arr'] as $k => $v)
                {
                    ?>
                    <tr>
                        <td><?php echo pjSanitize::html($v['name']);?></td>
                        <td><?php echo (int) $v['total_ordered'];?></td>
                        <td><?php echo pjUtil::formatCurrencySign(number_format( (float)$v['total_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>
        </div>
    </fieldset>

    <br>
    <fieldset class="fieldset white">
        <legend>PRODUCT REPORT</legend>
        <div class="row">
            <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">
                <thead>
                <th>Product</th>
                <th style="width: 20%;">Quanlity</th>
                <th style="width: 35%;">Total amount</th>
                </thead>
                <tbody>
                <?php
                foreach($tpl['product_arr'] as $k => $v)
                {
                    ?>
                    <tr>
                        <td><?php echo pjSanitize::html($v['name']);?></td>
                        <td><?php echo (int) $v['total_ordered'];?></td>
                        <td><?php echo pjUtil::formatCurrencySign(number_format( (float)$v['total_amount'], 2 ),  $tpl['option_arr']['o_currency']);?></td>
                    </tr>
                    <?php
                }
                ?>
                </tbody>
            </table>
        </div>
    </fieldset>
</div>

<style>
    .row{
        width: 100%;
    }

    .col{
        width: 25%;
        float: left;
    }

    .row:after{
        content: "";
        display: table;
        clear: both;
    }

    .panel{
        margin: 10px;
        border: 1px gray solid;
        border-radius: 5px;
    }

    .panel-heading{
        padding: 10px;
        font-weight: bold;
        font-size: 12px;
        border-radius: 5px 5px 0px 0px;
    }

    .panel-body{
        padding: 10px;
        font-size: 20px;
        text-align: center;
    }

    .white {
        background-color: #fff;
        border: solid 1px #ccc;
        color: #000 !important;
    }
    .fieldset {
        background-color: #FFFFFF;
        border: 1px solid #CCCCCC;
        border-radius: 5px 5px 5px 5px;
        -moz-border-radius: 5px;
        -webkit-border-radius: 5px;
        padding: 10px;
        margin-bottom: 12px;
    }

    .fieldset legend {
        background-color: #003366;
        border-radius: 3px;
        -moz-border-radius: 3px;
        -webkit-border-radius: 3px;
        color: #FFFFFF;
        padding: 2px 5px;
        width: 250px;
    }

    .pj-table {
        border-collapse: separate;
        border: none;
        border-left: solid 1px #e4e4e4;
        border-top: solid 1px #e4e4e4;
        color: #222;
        font: normal 12px/16px Arial, Verdana, sans-serif;
    }

    .pj-table th {
        background-color: #f7f7f7;
        border-left: solid 1px #fff;
        border-top: solid 1px #fff;
        border-right: solid 1px #e5e2e2;
        border-bottom: solid 1px #e5e2e2;
        font-weight: bold;
        padding: 6px 5px;
        empty-cells: show;
    }

    .pj-table td {
        border: solid 1px #ccc;
        border-left: solid 1px #fff;
        border-top: solid 1px #fff;
        border-right: solid 1px #e5e2e2;
        border-bottom: solid 1px #e5e2e2;
        padding: 7px 5px;
        empty-cells: show;
    }

    #container_normal{
        margin: auto;
    }
</style>

