<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminLocations&amp;action=pjActionIndex"><?php __('menuLocations'); ?></a></li>
		</ul>
	</div>
	<?php
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/menu_location.php';
	?>	
	<div id="tabs">
		<ul>
			<li><a href="#tabs-1"><?php __('lblUpdate', false, true); ?></a></li>
		</ul>
		<div id="tabs-1">
			<?php
			$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
			$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
			
			$business = $tpl['arr']['is_dayoff'] == 'T' ? 'none' : NULL;
			$show_period = 'false';
			if((strpos($tpl['option_arr']['o_time_format'], 'a') > -1 || strpos($tpl['option_arr']['o_time_format'], 'A') > -1))
			{
				$show_period = 'true';
			}
			$period_am = 'am';
			$period_pm = 'pm';
			if(strpos($tpl['option_arr']['o_time_format'], 'A') > -1)
			{
				$period_am = 'AM';
				$period_pm = 'PM';
			}	
			
			$default_from = '08:00:00';
			$default_to = '22:00:00';
			$default_from = date('H:i', strtotime($default_from));
			$default_to = date('H:i', strtotime($default_to));
			if($show_period == 'true')
			{
				if(strpos($tpl['option_arr']['o_time_format'], 'A') > -1)
				{
					$default_from = date('h:i A', strtotime($default_from));
					$default_to = date('h:i A', strtotime($default_to));
				}else{
					$default_from = date('h:i a', strtotime($default_from));
					$default_to = date('h:i a', strtotime($default_to));
				}
			}
			?>
			<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminTime&amp;action=pjActionIndex" method="post" class="form pj-form" id="frmTimeCustom">
				<input type="hidden" name="custom_time" value="1" />
				<input type="hidden" name="location_id" value="<?php echo $tpl['arr']['location_id'];?>" />
				<p>
					<label class="title"><?php __('lblDate'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" name="date" id="date" class="pj-form-field pointer w80 datepick required" value="<?php echo pjUtil::formatDate($tpl['arr']['date'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblType'); ?></label>
					<span class="inline_block">
						<select name="type" id="type" class="pj-form-field required">
							<?php
							foreach (__('types', true, false) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['type'] == $k ? ' selected="selected"' : null;?>><?php echo stripslashes($v); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				
				<div>
					<label class="title">&nbsp;</label>
					<div class="float_left">
						<p class="business" style="display: <?php echo $business; ?>">
							<label class="title w130"><?php __('lblStartTime'); ?></label>
							<label class="title w170"><?php __('lblEndTime'); ?></label>
						</p>
						<div class="pjLocationCutomWTWrap">
							<?php foreach ($tpl['wt_arr'] as $val) { 
								$start_time = date($tpl['option_arr']['o_time_format'], strtotime($val['date'] . ' ' . $val['start_time']));
								$end_time = date($tpl['option_arr']['o_time_format'], strtotime($val['date'] . ' ' . $val['end_time']));
								?>
								<div class="pjLocationCustomWT business" style="display: <?php echo $business; ?>">
									<span class="inline_block w130">
										<input name="start[]" id="start_<?php echo $val['id'];?>" value="<?php echo $start_time;?>" class="pj-timepicker pj-form-field w100 required"/>
									</span>
									
									<span class="inline_block w170">
										<input name="end[]" id="end_<?php echo $val['id'];?>" value="<?php echo $end_time;?>" class="pj-timepicker pj-form-field w100 required"/>
										<span class="inline_block">
											<a href="javascript:void(0);" class="pj-delete-custom-hour">&nbsp;</a>
										</span>
									</span>
								</div>
							<?php } ?>
						</div>
					</div>
					<br class="clear_both">
				</div>	
				
				<p class="business" style="display: <?php echo $business; ?>">
					<label class="title">&nbsp;</label>
					<span class="inline_block">
						<input type="button" value="<?php __('lblAddHours'); ?>" class="pj-button pj-add-custom-hours" />
					</span>
				</p>
								
				<p>
					<label class="title"><?php __('lblIsDayOff'); ?></label>
					<span class="left"><input type="checkbox" name="is_dayoff" id="is_dayoff" value="T"<?php echo $tpl['arr']['is_dayoff'] == 'T' ? ' checked="checked"' : NULL; ?> /></span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
				</p>
			</form>
		</div>
	</div>
	<?php
}
?>

<div class="pjLocationCustomWTClone" style="display: none;">
	<div class="pjLocationCustomWT business">
		<span class="inline_block w130">
			<input name="start[]" id="start_{INDEX}" value="<?php echo $default_from;?>" class="pj-timepicker_{INDEX} pj-form-field w100"/>
		</span>
		
		<span class="inline_block w170">
			<input name="end[]" id="end_{INDEX}" value="<?php echo $default_to;?>" class="pj-timepicker_{INDEX} pj-form-field w100"/>
			<span class="inline_block">
				<a href="javascript:void(0);" class="pj-delete-custom-hour">&nbsp;</a>
			</span>
		</span>
	</div>
</div>

<script type="text/javascript">
var myLabel = myLabel || {};
myLabel.date = "<?php __('lblDate', false, true); ?>";
myLabel.type = "<?php __('lblType', false, true); ?>";
myLabel.validate_time = "<?php __('lblValidateTime', false, true); ?>";
myLabel.start_time = "<?php __('lblStartTime', false, true); ?>";
myLabel.end_time = "<?php __('lblEndTime', false, true); ?>";
myLabel.is_day_off = "<?php __('lblIsDayOff', false, true); ?>";
myLabel.showperiod = <?php echo $show_period; ?>;
myLabel.showPeriodLabels = <?php echo $show_period; ?>;
myLabel.amPmText = ["<?php echo $period_am;?>","<?php echo $period_pm;?>"];
</script>