<?php
if (true) {
    if (isset($tpl['order']) && isset($tpl['kiosk']) && isset($tpl['printerInfo']) && isset($tpl['setting'])) {
        $order = $tpl['order'];
        $kiosk = $tpl['kiosk'];
        $printerInfo = $tpl['printerInfo'];
        $setting = $tpl['setting'];

        /*Print for Customer*/
        if ($printerInfo['location'] == 'C') {
            buildXMLCustomer($order, $kiosk, $printerInfo, $setting, $tpl);
        }

        /*Print for Kitchen*/
        if ($printerInfo['location'] == 'K') {
            buildXMLKitchen($order, $kiosk, $printerInfo, $setting, $tpl);
        }

    }
}


function buildXMLCustomer($order, $kiosk, $printerInfo, $setting, $tpl)
{
    $o_printer_copies = 1;
    $PrintRequestInfo = new SimpleXMLElement('<PrintRequestInfo/>');
    $countItems = 0;

    /*List item - header*/
    $itemHeader = new pjPrinterItem();
    $itemHeader->setQty("Qty");
    $itemHeader->setName("Item");
    $itemHeader->setPrice("Price");
    $itemHeader->setTotal("Total");
    $items[] = $itemHeader;

    $products = json_decode(json_decode($order['data'], true), true);
    foreach ($products as $key => $value) {
        $item = new pjPrinterItem();
        $item->setName($value['name']);

        $check = false;
        if ($value['set_different_sizes'] === 'T') {
            /*Prices*/
            $price_arr = [];
            foreach ($value['price_arr'] as $k => $v) {
                if ($v['QTY'] > 0) {
                    $price = [];
                    $price['qty'] = $v['QTY'].' x';
                    $price['name'] = $v['price_name'];
                    $price['price'] = pjUtil::formatCurrencySign(number_format($v['price'], 2), $tpl['option_arr']['o_currency']);
                    $price['total'] = pjUtil::formatCurrencySign(number_format((float)$v['price'] * $v['QTY'], 2), $tpl['option_arr']['o_currency']);
                    $price_arr[] = $price;

                    $countItems += $v['QTY'];
                }
            }
            $item->setPrices($price_arr);
            $check = true;
        } else {
            if ($value['QTY'] > 0) {
                $item->setQty($value['QTY'].' x');
                $item->setPrice(pjUtil::formatCurrencySign(number_format($value['price'], 2), $tpl['option_arr']['o_currency']));
                $item->setTotal(pjUtil::formatCurrencySign(number_format($value['TOTAL'], 2), $tpl['option_arr']['o_currency']));

                $countItems += $value['QTY'];
                $check = true;
            }
        }

        /*If item has price*/
        if ($check) {
            /*Group*/
            $group_arr = [];
            foreach ($value['group_arr'] as $k => $v) {
                $group_arr[] = $v['group_name'] . ': ' . $v['group_item_arr'][$v['SELECTED']]['group_item_name'];
            }
            $item->setGroups($group_arr);

            /*Modifier*/
            $modifier_arr = [];
            foreach ($value['modifier_arr'] as $k => $v) {
                $check = false;
                foreach ($v['modifier_item_arr'] as $kk => $vv) {
                    if ($vv['CHECKED']) {
                        $check = true;
                    }
                }

                if ($check) {
                    $modifier = [];
                    $modifier['name'] = $v['modifier_name'];
                    foreach ($v['modifier_item_arr'] as $kk => $vv) {
                        if ($vv['CHECKED']) {
                            $detail = [];
                            $detail['name'] = $vv['modifier_item_name'];
                            $detail['price'] = pjUtil::formatCurrencySign(number_format($vv['price'], 2), $tpl['option_arr']['o_currency']);
                            $modifier['list'][] = $detail;
                        }
                    }
                    $modifier_arr[] = $modifier;
                }
            }
            $item->setModifiers($modifier_arr);

            /*Extra*/
            $extra_arr = [];
            foreach ($value['extra_arr'] as $k => $v) {
                if ($v['QTY'] > 0) {
                    $extra = [];
                    $extra['qty'] = $v['QTY'];
                    $extra['name'] = $v['name'];
                    $extra['price'] = pjUtil::formatCurrencySign(number_format($v['price'], 2), $tpl['option_arr']['o_currency']);
                    $extra['total'] = pjUtil::formatCurrencySign(number_format((float)$v['price'] * $v['QTY'], 2), $tpl['option_arr']['o_currency']);
                    $extra_arr[] = $extra;
                }
            }
            $item->setExtras($extra_arr);


            /*Combo*/
            $combo_arr = [];
            foreach ($value['combo_arr'] as $k => $v) {
                $check = false;
                foreach ($v['lst_products'] as $kk => $vv) {
                    if ($vv['CHECKED']) {
                        $check = true;
                    }
                }

                if ($check) {
                    $combo = [];
                    $combo['name'] = $v['name'];
                    foreach ($v['lst_products'] as $kk => $vv) {
                        if ($vv['CHECKED']) {
                            $detail = [];
                            $detail['name'] = $vv['name'];
                            $combo['list'][] = $detail;
                        }
                    }
                    $combo_arr[] = $combo;
                }
            }
            $item->setCombos($combo_arr);

            $items[] = $item;
        }
    }

    /*Restaurant*/
    $restaurant = pjRestaurantModel::factory()->find($kiosk['rid'])->getData();
    $restaurant_languages = pjMultiLangModel::factory()->getMultiLang($restaurant['id'], 'pjRestaurant');

    /*Body xml*/
    foreach (range(1, $o_printer_copies) as $idx) {
        $ePOSPrint = $PrintRequestInfo->addChild('ePOSPrint');
        $Parameter = $ePOSPrint->addChild('Parameter');
        $Parameter->addChild('devid', $tpl['device_id']);
        $Parameter->addChild('timeout', "10000");

        $PrintData = $ePOSPrint->addChild('PrintData');
        $epos_print = $PrintData->addChild('epos-print');
        $epos_print->addAttribute('xmlns', 'http://www.epson-pos.com/schemas/2011/03/epos-print');
        $epos_print->addChild('text')->addAttribute('smooth', 'true');
        $epos_print->addChild('text')->addAttribute('align', 'center');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');

        /*Shop name*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '2');
        $wh->addAttribute('height', '2');

        if ($kiosk['pre_receipt_name'] == 'On') {
            $epos_print->addChild('text', $restaurant_languages[1]['name']);
        } else {
            $epos_print->addChild('text', $restaurant_languages[1]['name']);
        }
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Address*/
        if (isset($setting['restaurant']) && isset($setting['restaurant']['address'])) {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text', $setting['restaurant']['address']);
            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Hotline*/
        if (isset($setting['restaurant']) && isset($setting['restaurant']['phone'])) {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text', $setting['restaurant']['phone']);
            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Dashed*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text', '------------------------------------------------');
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Customer number*/
        if(isset($order['tent'])) {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('smooth', 'false');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text', 'Tent Number:');
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('smooth', 'false');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text', $order['tent']);
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Order number*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text')->addAttribute('smooth', 'false');
        $epos_print->addChild('text')->addAttribute('align', 'center');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text', 'Order Number:');
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text')->addAttribute('smooth', 'false');
        $epos_print->addChild('text')->addAttribute('align', 'center');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text', $order['numberOrder']);
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Customer phone*/
        if (isset($order['phone']) && strlen($order['phone']) > 0) {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('smooth', 'false');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text', 'Customer Phone:');
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('smooth', 'false');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text', htmlspecialchars($order['phone']));
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Notes*/
        if (isset($order['note']) && strlen($order['note']) > 0) {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('smooth', 'false');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text', 'Notes:');
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('smooth', 'false');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text', $order['note']);
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Kiosk ID - Datetime*/
        $ks = "KS: " . $kiosk['id'];
        $date_time = date('m/d/Y H:i', strtotime($order['createdTime']));
        $epos_print->addChild('text')->addAttribute('smooth', 'false');
        $epos_print->addChild('text')->addAttribute('align', 'left');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text', $ks . str_pad("", (48 - strlen(utf8_decode($ks . $date_time))), " ", STR_PAD_LEFT) . $date_time);
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Dashed*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text', '------------------------------------------------');
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /* Items */
        foreach ($items as $item) {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('align', 'left');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text')->addAttribute('smooth', 'true');
            $epos_print->addChild('text')->addAttribute('em', 'false');

            $item->resetWith();

            /*Product name*/
            $splitRows = $item->splitRow($item->getName(), $item->getNameCols() - 2);

            $epos_print->addChild('text', $item->getQty()
                . str_pad("", ($item->getQtyCols() - strlen(utf8_decode($item->getQty()))), " ", STR_PAD_RIGHT)
                . $splitRows[0]
                . str_pad("", ($item->getNameCols() - strlen(utf8_decode($splitRows[0]))), " ", STR_PAD_RIGHT)
                . $item->getPrice()
                . str_pad("", ($item->getPriceCols() - strlen(utf8_decode($item->getPrice()))), " ", STR_PAD_RIGHT)
                . $item->getTotal());
            $epos_print->addChild('feed')->addAttribute('line', '1');

            if (count($splitRows) > 1) {
                for ($i = 1; $i < count($splitRows); $i++) {
                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "" . $splitRows[$i]);
                    $epos_print->addChild('feed')->addAttribute('line', '1');
                }
            }

            /*Price arr*/
            if (count($item->getPrices()) > 0) {
                foreach ($item->getPrices() as $key => $value) {
                    $splitRows = $item->splitRow($value['name'], $item->getNameCols() - 2);
                    $epos_print->addChild('text', $value['qty']
                        . str_pad("", ($item->getQtyCols() - strlen(utf8_decode($value['qty']))), " ", STR_PAD_RIGHT)
                        . $splitRows[0]
                        . str_pad("", ($item->getNameCols() - strlen(utf8_decode($splitRows[0]))), " ", STR_PAD_RIGHT)
                        . $value['price']
                        . str_pad("", ($item->getPriceCols() - strlen(utf8_decode($value['price']))), " ", STR_PAD_RIGHT)
                        . $value['total']);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    if (count($splitRows) > 1) {
                        for ($i = 1; $i < count($splitRows); $i++) {
                            $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "" . $splitRows[$i]);
                            $epos_print->addChild('feed')->addAttribute('line', '1');
                        }
                    }
                }
            }

            /*Group arr*/
            if (count($item->getGroups()) > 0) {
                foreach ($item->getGroups() as $key => $value) {
                    $splitRows = $item->splitRow($value, $item->getNameCols());

                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "* " . $splitRows[0]);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    if (count($splitRows) > 1) {
                        for ($i = 1; $i < count($splitRows); $i++) {
                            $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "" . $splitRows[$i]);
                            $epos_print->addChild('feed')->addAttribute('line', '1');
                        }
                    }
                }
            }

            /*Modifier arr*/
            if (count($item->getModifiers()) > 0) {
                foreach ($item->getModifiers() as $key => $value) {
                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "* " . $value['name']);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    foreach ($value['list'] as $k => $v) {
                        $splitRows = $item->splitRow("+ " . $v['name'], $item->getNameCols() - 2);

                        $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT)
                            . "  " . $splitRows[0]
                            . str_pad("", ($item->getNameCols() - strlen(utf8_decode("  " . $splitRows[0]))), " ", STR_PAD_RIGHT)
                            . str_pad("", $item->getPriceCols(), " ", STR_PAD_RIGHT)
                            . $v['price']);
                        $epos_print->addChild('feed')->addAttribute('line', '1');


                        if (count($splitRows) > 1) {
                            for ($i = 1; $i < count($splitRows); $i++) {
                                $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "  " . $splitRows[$i]);
                                $epos_print->addChild('feed')->addAttribute('line', '1');
                            }
                        }
                    }
                }
            }

            /*Extra arr*/
            if (count($item->getExtras()) > 0) {
                foreach ($item->getExtras() as $key => $value) {
                    $strlen = "" . $value['qty'] . " x " . $value['name'];
                    $splitRows = $item->splitRow($strlen, $item->getNameCols() - 2);

                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT)
                        . $splitRows[0]
                        . str_pad("", ($item->getNameCols() - strlen(utf8_decode($splitRows[0]))), " ", STR_PAD_RIGHT)
                        . $value['price']
                        . str_pad("", $item->getPriceCols() - strlen(utf8_decode($value['price'])), " ", STR_PAD_RIGHT)
                        . $value['total']);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    if (count($splitRows) > 1) {
                        for ($i = 1; $i < count($splitRows); $i++) {
                            $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "" . $splitRows[$i]);
                            $epos_print->addChild('feed')->addAttribute('line', '1');
                        }
                    }
                }
            }

            /*Combo arr*/
            if (count($item->getCombos()) > 0) {
                foreach ($item->getCombos() as $key => $value) {
                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "* " . $value['name']);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    foreach ($value['list'] as $k => $v) {
                        $splitRows = $item->splitRow("+ " . $v['name'], $item->getNameCols() - 2);

                        $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT)
                            . "  " . $splitRows[0]
                            . str_pad("", ($item->getNameCols() - strlen(utf8_decode("  " . $splitRows[0]))), " ", STR_PAD_RIGHT)
                            . str_pad("", $item->getPriceCols(), " ", STR_PAD_RIGHT)
                            );
                        $epos_print->addChild('feed')->addAttribute('line', '1');

                        if (count($splitRows) > 1) {
                            for ($i = 1; $i < count($splitRows); $i++) {
                                $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "  " . $splitRows[$i]);
                                $epos_print->addChild('feed')->addAttribute('line', '1');
                            }
                        }
                    }
                }
            }

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('align', 'left');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text', '------------------------------------------------');
            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Summary*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text')->addAttribute('smooth', 'true');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text')->addAttribute('em', 'false');

        $epos_print->addChild('text', $countItems . ' total items');
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $epos_print->addChild('text', 'Sub total: ' . pjUtil::formatCurrencySign(number_format($order['subTotal'], 2), $tpl['option_arr']['o_currency']));
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $epos_print->addChild('text', 'Discount: ' . pjUtil::formatCurrencySign(number_format($order['discount'], 2), $tpl['option_arr']['o_currency']));
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $epos_print->addChild('text', 'Tax: ' . pjUtil::formatCurrencySign(number_format($order['tax'], 2), $tpl['option_arr']['o_currency']));
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $epos_print->addChild('text', 'Tip: ' . pjUtil::formatCurrencySign(number_format($order['tip'], 2), $tpl['option_arr']['o_currency']));
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '2');
        $wh->addAttribute('height', '2');
        $epos_print->addChild('text')->addAttribute('em', 'true');
        $epos_print->addChild('text', 'Total: ' . pjUtil::formatCurrencySign(number_format($order['totalPrice'], 2), $tpl['option_arr']['o_currency']));
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Footer*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text')->addAttribute('align', 'left');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text', '------------------------------------------------');
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*PAID*/
        if (strlen($order['transactionId']) && $order['status'] == 'Approved') {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('smooth', 'true');
            $epos_print->addChild('text')->addAttribute('align', 'left');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text')->addAttribute('em', 'false');
            $epos_print->addChild('text', 'PAID');
            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Payment status*/
        if(isset($order['status'])) {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('smooth', 'true');
            $epos_print->addChild('text')->addAttribute('align', 'left');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text')->addAttribute('em', 'false');
            $epos_print->addChild('text', 'Payment Status: ' . $order['status']);
            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Credit card*/
        $extra = json_decode(json_decode($order['extra'], true), true);
        if(count($extra)>0){
            /*Auth code*/
            if(isset($extra['authcode'])){
                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('text')->addAttribute('smooth', 'true');
                $epos_print->addChild('text')->addAttribute('align', 'left');
                $epos_print->addChild('text')->addAttribute('font', 'font_a');
                $epos_print->addChild('text')->addAttribute('em', 'false');
                $epos_print->addChild('text', 'Auth Code: '.$extra['authcode']);
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }

            /*Transaction ID*/
            if(isset($extra['transactionid'])){
                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('text')->addAttribute('smooth', 'true');
                $epos_print->addChild('text')->addAttribute('align', 'left');
                $epos_print->addChild('text')->addAttribute('font', 'font_a');
                $epos_print->addChild('text')->addAttribute('em', 'false');
                $epos_print->addChild('text', 'Transaction ID: '.$extra['transactionid']);
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }

            /*Payment type*/
            if(isset($extra['emv_application_label'])) {
                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('text')->addAttribute('smooth', 'true');
                $epos_print->addChild('text')->addAttribute('align', 'left');
                $epos_print->addChild('text')->addAttribute('font', 'font_a');
                $epos_print->addChild('text')->addAttribute('em', 'false');
                $epos_print->addChild('text', 'Payment Type: '.explode(" ", $extra['emv_application_label'])[0]);
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }

            /*Card number*/
            if(isset($extra['cc_number'])){
                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('text')->addAttribute('smooth', 'true');
                $epos_print->addChild('text')->addAttribute('align', 'left');
                $epos_print->addChild('text')->addAttribute('font', 'font_a');
                $epos_print->addChild('text')->addAttribute('em', 'false');
                $epos_print->addChild('text', 'CC Number: '.$extra['cc_number']);
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }
        }

        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Powered*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text')->addAttribute('smooth', 'true');
        $epos_print->addChild('text')->addAttribute('align', 'center');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text')->addAttribute('em', 'false');
        $epos_print->addChild('text', 'Powered by CSL Technology');
        $epos_print->addChild('feed')->addAttribute('line', '1');


        /*Cut*/
        $epos_print->addChild('feed')->addAttribute('line', '1');
        $epos_print->addChild('cut')->addAttribute('type', 'feed');
    }
    echo $PrintRequestInfo->asXML();
}

function buildXMLKitchen($order, $kiosk, $printerInfo, $setting, $tpl)
{
    $o_printer_copies = 1;
    $PrintRequestInfo = new SimpleXMLElement('<PrintRequestInfo/>');
    $countItems = 0;
    $countItemsStation = 0;

    /*Chi tiết danh sách mặt hàng*/
    $itemHeader = new pjPrinterItem();
    $itemHeader->setQty("Qty");
    $itemHeader->setName("Item");
    $items[] = $itemHeader;

    $products = json_decode(json_decode($order['data'], true), true);
    foreach ($products as $key => $value) {
        $item = new pjPrinterItem();
        $item->setName($value['name']);
        if (isset($value['pre_name']) && strlen($value['pre_name']) > 0) {
            $item->setName($value['pre_name']);
        }

        $countTmp = 0;
        $check = false;
        if ($value['set_different_sizes'] === 'T') {
            $price_arr = [];
            foreach ($value['price_arr'] as $k => $v) {
                if ($v['QTY'] > 0) {
                    $price = [];
                    $price['qty'] = $v['QTY'].' x';
                    $price['name'] = $v['price_name'];
                    $price['price'] = pjUtil::formatCurrencySign(number_format($v['price'], 2), $tpl['option_arr']['o_currency']);
                    $price['total'] = pjUtil::formatCurrencySign(number_format((float)$v['price'] * $v['QTY'], 2), $tpl['option_arr']['o_currency']);
                    $price_arr[] = $price;

                    /*Count total items*/
                    $countItems += $v['QTY'];
                    $countTmp += $v['QTY'];
                }
            }
            $item->setPrices($price_arr);

            $check = true;
        } else {
            if ($value['QTY'] > 0) {
                $item->setQty($value['QTY'].' x');
                $item->setPrice(pjUtil::formatCurrencySign(number_format($value['price'], 2), $tpl['option_arr']['o_currency']));
                $item->setTotal(pjUtil::formatCurrencySign(number_format($value['TOTAL'], 2), $tpl['option_arr']['o_currency']));

                /*Count total items*/
                $countItems += $value['QTY'];
                $countTmp = $value['QTY'];

                $check = true;
            }
        }

        /*Kiểm tra printer*/
        if ($check) {
            $printers = $value['printers'];
            if (count($printers) > 0) {
                $check = false;
                if (in_array($printerInfo['id'], $printers)) {
                    $check = true;
                }
            }
        }

        if ($check) {
            $countItemsStation += $countTmp;

            /*Group*/
            $group_arr = [];
            foreach ($value['group_arr'] as $k => $v) {
                $group_arr[] = $v['group_name'] . ': ' . $v['group_item_arr'][$v['SELECTED']]['group_item_name'];
            }
            $item->setGroups($group_arr);

            /*Modifier*/
            $modifier_arr = [];
            foreach ($value['modifier_arr'] as $k => $v) {
                $check = false;
                foreach ($v['modifier_item_arr'] as $kk => $vv) {
                    if ($vv['CHECKED']) {
                        $check = true;
                    }
                }

                if ($check) {
                    $modifier = [];
                    $modifier['name'] = $v['modifier_name'];
                    foreach ($v['modifier_item_arr'] as $kk => $vv) {
                        if ($vv['CHECKED']) {
                            $detail = [];
                            $detail['name'] = $vv['modifier_item_name'];
                            $detail['price'] = pjUtil::formatCurrencySign(number_format($vv['price'], 2), $tpl['option_arr']['o_currency']);
                            $modifier['list'][] = $detail;
                        }
                    }
                    $modifier_arr[] = $modifier;
                }
            }
            $item->setModifiers($modifier_arr);

            /*Extra*/
            $extra_arr = [];
            foreach ($value['extra_arr'] as $k => $v) {
                if ($v['QTY'] > 0) {
                    $extra = [];
                    $extra['qty'] = $v['QTY'];
                    $extra['name'] = $v['name'];
                    $extra['price'] = pjUtil::formatCurrencySign(number_format($v['price'], 2), $tpl['option_arr']['o_currency']);
                    $extra['total'] = pjUtil::formatCurrencySign(number_format((float)$v['price'] * $v['QTY'], 2), $tpl['option_arr']['o_currency']);
                    $extra_arr[] = $extra;
                }
            }
            $item->setExtras($extra_arr);

            /*Combo*/
            $combo_arr = [];
            foreach ($value['combo_arr'] as $k => $v) {
                $check = false;
                foreach ($v['lst_products'] as $kk => $vv) {
                    if ($vv['CHECKED']) {
                        $check = true;
                    }
                }

                if ($check) {
                    $combo = [];
                    $combo['name'] = $v['name'];
                    foreach ($v['lst_products'] as $kk => $vv) {
                        if ($vv['CHECKED']) {
                            $detail = [];
                            $detail['name'] = $vv['name'];
                            $combo['list'][] = $detail;
                        }
                    }
                    $combo_arr[] = $combo;
                }
            }
            $item->setCombos($combo_arr);

            $items[] = $item;
        }
    }

    /*Body xml*/
    foreach (range(1, $o_printer_copies) as $idx) {
        $ePOSPrint = $PrintRequestInfo->addChild('ePOSPrint');
        $Parameter = $ePOSPrint->addChild('Parameter');
        $Parameter->addChild('devid', $tpl['device_id']);
        $Parameter->addChild('timeout', "10000");

        $PrintData = $ePOSPrint->addChild('PrintData');
        $epos_print = $PrintData->addChild('epos-print');
        $epos_print->addAttribute('xmlns', 'http://www.epson-pos.com/schemas/2011/03/epos-print');
        $epos_print->addChild('text')->addAttribute('smooth', 'true');
        $epos_print->addChild('text')->addAttribute('align', 'center');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');

        /*Shop name*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '2');
        $wh->addAttribute('height', '2');
        if ($kiosk['pre_receipt_name'] == 'On') {
            $epos_print->addChild('text', $kiosk['name']);
        }else {
            if(isset($order['type'])){
                if($order['type']=='Togo' || $order['type']=='togo'){
                    $epos_print->addChild('text', 'Take out');
                }else {
                    $epos_print->addChild('text', $order['type']);
                }
            }else {
                $epos_print->addChild('text', "Kitchen Station");
            }
        }
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Dashed*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text', '------------------------------------------------');
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Customer number*/
        if(isset($order['tent'])) {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('smooth', 'true');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text')->addAttribute('em', 'false');
            $epos_print->addChild('text', 'Tent Number:');
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '2');
            $wh->addAttribute('height', '2');
            $epos_print->addChild('text')->addAttribute('smooth', 'true');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text')->addAttribute('em', 'true');
            $epos_print->addChild('text', $order['tent']);
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Order number*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text')->addAttribute('smooth', 'true');
        $epos_print->addChild('text')->addAttribute('align', 'center');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text')->addAttribute('em', 'false');
        $epos_print->addChild('text', 'Order Number:');
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '2');
        $wh->addAttribute('height', '2');
        $epos_print->addChild('text')->addAttribute('smooth', 'true');
        $epos_print->addChild('text')->addAttribute('align', 'center');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text')->addAttribute('em', 'true');
        $epos_print->addChild('text', $order['numberOrder']);
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Total items*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text')->addAttribute('smooth', 'true');
        $epos_print->addChild('text')->addAttribute('align', 'center');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text')->addAttribute('em', 'false');
        $epos_print->addChild('text', "Total Items:");
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '2');
        $wh->addAttribute('height', '2');
        $epos_print->addChild('text')->addAttribute('smooth', 'true');
        $epos_print->addChild('text')->addAttribute('align', 'center');
        $epos_print->addChild('text')->addAttribute('font', 'font_a');
        $epos_print->addChild('text')->addAttribute('em', 'true');
        $epos_print->addChild('text', $countItemsStation . "/" . $countItems . " items");
        $epos_print->addChild('feed')->addAttribute('line', '1');

        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Notes*/
        if (isset($order['note']) && strlen($order['note']) > 0) {
            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text')->addAttribute('smooth', 'true');
            $epos_print->addChild('text')->addAttribute('em', 'false');
            $epos_print->addChild('text', 'Notes:');
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '2');
            $wh->addAttribute('height', '2');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text')->addAttribute('smooth', 'true');
            $epos_print->addChild('text')->addAttribute('em', 'true');
            $epos_print->addChild('text', $order['note']);
            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Dashed*/
        $wh = $epos_print->addChild('text');
        $wh->addAttribute('width', '1');
        $wh->addAttribute('height', '1');
        $epos_print->addChild('text')->addAttribute('smooth', 'true');
        $epos_print->addChild('text')->addAttribute('em', 'false');
        $epos_print->addChild('text', '------------------------------------------------');
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /* Items */
        $first = true;
        foreach ($items as $item) {
            $size = 2;
            $item->resetWidthForKitchen($size);

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', $size);
            $wh->addAttribute('height', $size);
            $epos_print->addChild('text')->addAttribute('align', 'left');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text')->addAttribute('smooth', 'true');
            $epos_print->addChild('text')->addAttribute('em', 'false');

            /*Product name*/
            $splitRows = $item->splitRow($item->getName(), $item->getNameCols() / $size);

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', $size);
            $wh->addAttribute('height', $size);
            $epos_print->addChild('text', $item->getQty() . str_pad("", ($item->getQtyCols() - strlen(utf8_decode($item->getQty()))), " ", STR_PAD_RIGHT) . $splitRows[0]);
            $epos_print->addChild('feed')->addAttribute('line', '1');

            if (count($splitRows) > 1) {
                for ($i = 1; $i < count($splitRows); $i++) {
                    $wh = $epos_print->addChild('text');
                    $wh->addAttribute('width', $size);
                    $wh->addAttribute('height', $size);
                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "" . $splitRows[$i]);
                    $epos_print->addChild('feed')->addAttribute('line', '1');
                }
            }

            if ($first == false) {
                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }
            $first = false;

            /*Price arr*/
            if (count($item->getPrices()) > 0) {
                foreach ($item->getPrices() as $key => $value) {
                    $splitRows = $item->splitRow($value['name'], $item->getNameCols() / $size);

                    $wh = $epos_print->addChild('text');
                    $wh->addAttribute('width', $size);
                    $wh->addAttribute('height', $size);
                    $epos_print->addChild('text', $value['qty'] . str_pad("", ($item->getQtyCols() - strlen(utf8_decode($value['qty']))), " ", STR_PAD_RIGHT) . $splitRows[0]);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    if (count($splitRows) > 1) {
                        for ($i = 1; $i < count($splitRows); $i++) {
                            $wh = $epos_print->addChild('text');
                            $wh->addAttribute('width', $size);
                            $wh->addAttribute('height', $size);
                            $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "" . $splitRows[$i]);
                            $epos_print->addChild('feed')->addAttribute('line', '1');
                        }
                    }
                }

                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }

            /*Group arr*/
            if (count($item->getGroups()) > 0) {
                foreach ($item->getGroups() as $key => $value) {
                    $splitRows = $item->splitRow($value, $item->getNameCols() / $size);

                    $wh = $epos_print->addChild('text');
                    $wh->addAttribute('width', $size);
                    $wh->addAttribute('height', $size);
                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "* " . $splitRows[0]);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    if (count($splitRows) > 1) {
                        for ($i = 1; $i < count($splitRows); $i++) {
                            $wh = $epos_print->addChild('text');
                            $wh->addAttribute('width', $size);
                            $wh->addAttribute('height', $size);
                            $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "" . $splitRows[$i]);
                            $epos_print->addChild('feed')->addAttribute('line', '1');
                        }
                    }
                }

                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }

            /*Modifier arr*/
            if (count($item->getModifiers()) > 0) {
                foreach ($item->getModifiers() as $key => $value) {
                    $wh = $epos_print->addChild('text');
                    $wh->addAttribute('width', $size);
                    $wh->addAttribute('height', $size);
                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "* " . $value['name']);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    foreach ($value['list'] as $k => $v) {
                        $splitRows = $item->splitRow("+ " . $v['name'], $item->getNameCols() / $size);

                        $wh = $epos_print->addChild('text');
                        $wh->addAttribute('width', $size);
                        $wh->addAttribute('height', $size);
                        $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "  " . $splitRows[0]);
                        $epos_print->addChild('feed')->addAttribute('line', '1');

                        if (count($splitRows) > 1) {
                            for ($i = 1; $i < count($splitRows); $i++) {
                                $wh = $epos_print->addChild('text');
                                $wh->addAttribute('width', $size);
                                $wh->addAttribute('height', $size);
                                $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "  " . $splitRows[$i]);
                                $epos_print->addChild('feed')->addAttribute('line', '1');
                            }
                        }
                    }
                }

                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }

            /*Extra arr*/
            if (count($item->getExtras()) > 0) {
                foreach ($item->getExtras() as $key => $value) {
                    $strlen = "" . $value['qty'] . " x " . $value['name'];
                    $splitRows = $item->splitRow($strlen, $item->getNameCols() / $size);

                    $wh = $epos_print->addChild('text');
                    $wh->addAttribute('width', $size);
                    $wh->addAttribute('height', $size);
                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . $splitRows[0]);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    if (count($splitRows) > 1) {
                        for ($i = 1; $i < count($splitRows); $i++) {
                            $wh = $epos_print->addChild('text');
                            $wh->addAttribute('width', $size);
                            $wh->addAttribute('height', $size);
                            $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "" . $splitRows[$i]);
                            $epos_print->addChild('feed')->addAttribute('line', '1');
                        }
                    }
                }

                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }

            /*Combo arr*/
            if (count($item->getCombos()) > 0) {
                foreach ($item->getCombos() as $key => $value) {
                    $wh = $epos_print->addChild('text');
                    $wh->addAttribute('width', $size);
                    $wh->addAttribute('height', $size);
                    $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "* " . $value['name']);
                    $epos_print->addChild('feed')->addAttribute('line', '1');

                    foreach ($value['list'] as $k => $v) {
                        $splitRows = $item->splitRow("+ " . $v['name'], $item->getNameCols() / $size);

                        $wh = $epos_print->addChild('text');
                        $wh->addAttribute('width', $size);
                        $wh->addAttribute('height', $size);
                        $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "  " . $splitRows[0]);
                        $epos_print->addChild('feed')->addAttribute('line', '1');

                        if (count($splitRows) > 1) {
                            for ($i = 1; $i < count($splitRows); $i++) {
                                $wh = $epos_print->addChild('text');
                                $wh->addAttribute('width', $size);
                                $wh->addAttribute('height', $size);
                                $epos_print->addChild('text', str_pad(" ", $item->getQtyCols(), " ", STR_PAD_RIGHT) . "  " . $splitRows[$i]);
                                $epos_print->addChild('feed')->addAttribute('line', '1');
                            }
                        }
                    }
                }

                $wh = $epos_print->addChild('text');
                $wh->addAttribute('width', '1');
                $wh->addAttribute('height', '1');
                $epos_print->addChild('feed')->addAttribute('line', '1');
            }

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('align', 'left');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text', '------------------------------------------------');
            $epos_print->addChild('feed')->addAttribute('line', '1');
        }
        $epos_print->addChild('feed')->addAttribute('line', '1');

        /*Warning made on another stattion*/
        if ($countItems != $countItemsStation) {
            $epos_print->addChild('feed')->addAttribute('line', '1');

            $wh = $epos_print->addChild('text');
            $wh->addAttribute('width', '1');
            $wh->addAttribute('height', '1');
            $epos_print->addChild('text')->addAttribute('align', 'center');
            $epos_print->addChild('text')->addAttribute('font', 'font_a');
            $epos_print->addChild('text')->addAttribute('smooth', 'true');
            $epos_print->addChild('text')->addAttribute('em', 'true');
            $epos_print->addChild('text', "(An) other item(s) made on other station(s)");
            $epos_print->addChild('feed')->addAttribute('line', '1');
        }

        /*Cut*/
        $epos_print->addChild('feed')->addAttribute('line', '1');
        $epos_print->addChild('cut')->addAttribute('type', 'feed');
    }
    echo $PrintRequestInfo->asXML();
}
