var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		
		function setInstall()
		{
			var clone = $('#pj_install_clone').text(),
				locale = $('#install_locale').length > 0 ? $('#install_locale').val() : '';
			
			if(locale == '')
			{
				clone = clone.replace(/\{LOCALE\}/g, '');
			}else{
				clone = clone.replace(/\{LOCALE\}/g, '&locale=' + locale);
			}
			$('#install_code').val(clone);
			$('.pj_preview_install').each(function(){
				var rel = $(this).attr('rel');
				if(locale == '')
				{
					rel = rel.replace(/\{LOCALE\}/g, '');
				}else{
					rel = rel.replace(/\{LOCALE\}/g, '&locale=' + locale);
				}
				$(this).attr('href', rel);
			});
		}
		
		if($('#install_code').length > 0)
		{
			setInstall();
		}
		
		if($('#frmNotification').length > 0)
		{
			var value = $('#client_email_notify').val();
			$('.boxClient' + value).show();
			
			var value = $('#admin_email_notify').val();
			$('.boxAdmin' + value).show();
		}
		
		$("#content").on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_paypal']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxPaypal").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxPaypal").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_authorize']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxAuthorize").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxAuthorize").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_bank']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxBankAccount").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxBankAccount").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_usaepay']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxUSAePay").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxUSAePay").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_nmipay']", function (e) { /*Khuetech add nmipay */
			switch ($("option:selected", this).val()) {
				case 'Yes|No::No':
					$(".boxNMIPay").hide();
					break;
				case 'Yes|No::Yes':
					$(".boxNMIPay").show();
					break;
			}
		}).on("change", "select[name='value-enum-o_allow_service_fee']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxServiceFee").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxServiceFee").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_catering']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxCatering").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxCatering").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_email_confirmation']", function (e) {
			switch ($("option:selected", this).val()) {
			case '0|1::0':
				$(".boxClientConfirmation").hide();
				break;
			case '0|1::1':
				$(".boxClientConfirmation").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_email_payment']", function (e) {
			switch ($("option:selected", this).val()) {
			case '0|1::0':
				$(".boxClientPayment").hide();
				break;
			case '0|1::1':
				$(".boxClientPayment").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_email_cancel']", function (e) {
			switch ($("option:selected", this).val()) {
			case '0|1::0':
				$(".boxClientCancel").hide();
				break;
			case '0|1::1':
				$(".boxClientCancel").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_admin_email_confirmation']", function (e) {
			switch ($("option:selected", this).val()) {
			case '0|1::0':
				$(".boxAdminConfirmation").hide();
				break;
			case '0|1::1':
				$(".boxAdminConfirmation").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_admin_email_payment']", function (e) {
			switch ($("option:selected", this).val()) {
			case '0|1::0':
				$(".boxAdminPayment").hide();
				break;
			case '0|1::1':
				$(".boxAdminPayment").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_admin_email_cancel']", function (e) {
			switch ($("option:selected", this).val()) {
			case '0|1::0':
				$(".boxAdminCancel").hide();
				break;
			case '0|1::1':
				$(".boxAdminCancel").show();
				break;
			}
		}).on("change", ".pj-install-config", function (e) {
			setInstall();
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme'),
				href = $('#pj_preview_install').attr('href');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
					setInstall();
				}
			});
		}).on("change", "#client_email_notify", function (e) {
			var value = $(this).val();
			$('.boxClient').hide();
			$('.boxClient' + value).show();
		}).on("change", "#admin_email_notify", function (e) {
			var value = $(this).val();
			$('.boxAdmin').hide();
			$('.boxAdmin' + value).show();
		}).on("change", "select[name='value-enum-o_allow_delivery_doordash']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxDoorDash").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxDoorDash").show();
				break;
			}
		});
		
		if ($('#frmNotification').length > 0) 
		{
			tinymce.init({
			    selector: "textarea.mceEditor",
			    theme: "modern",
			    width: 500,
			    relative_urls: false,
			    remove_script_host : false,
			    convert_urls : true,
			    plugins: [
			         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
			         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
			         "save table contextmenu directionality emoticons template paste textcolor"
			   ],
			   toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons"
			 });
		}
	});
})(jQuery_1_8_2);