<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjLocationWTModel extends pjAppModel
{
	protected $primaryKey = 'id';
	
	protected $table = 'locations_wt';
	
	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'location_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'type', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'day', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'start_time', 'type' => 'time', 'default' => ':NULL'),
		array('name' => 'end_time', 'type' => 'time', 'default' => ':NULL')
	);
	
	public static function factory($attr=array())
	{
		return new pjLocationWTModel($attr);
	}
	
	public function initWT($location_id)
	{
		$pjLocationWTModel = pjLocationWTModel::factory();
	        
        $data = array();
        $type_arr = array(
        	'p' => 'pickup',
        	'd' => 'delivery'
        );
        $w_days = array(
			'monday',
			'tuesday',
			'wednesday',
			'thursday',
			'friday',
			'saturday',
			'sunday'
		);
        $arr = pjWorkingTimeModel::factory()->where('t1.location_id', $location_id)->findAll()->getData();	        
        foreach($arr as $val)
        {
        	foreach ($type_arr as $k => $v) {
        		foreach ($w_days as $day) {
		            if ($val[$k.'_'.$day.'_dayoff'] == 'F') {
		            	$data[$val['location_id']][$v][$day] = array(
			            	'start_time' => $val[$k.'_'.$day.'_from'],
			            	'end_time' => $val[$k.'_'.$day.'_to']
		            	);
		            }
        		}
        	}
        }
        if ($data) {
        	$pjLocationWTModel->begin();
	        foreach ($data as $location_id => $val) {
	        	foreach ($val as $type => $days){
	        		foreach ($days as $day => $time) {
	        			$pjLocationWTModel
							->reset()
							->set('location_id', $location_id)
							->set('day', $day)
							->set('start_time', $time['start_time'])
							->set('end_time', $time['end_time'])
							->set('type', $type)
							->insert();
	        		}
	        	}
	        }
	        $pjLocationWTModel->commit();
        }
	}
}
?>