<?php

class pjPrinterItem{
    private $qty;
    private $name;
    private $price;
    private $total;

    private $prices=[];
    private $groups=[];
    private $modifiers=[];
    private $extras=[];
    private $combos=[];

    private $width=48;
    private $qtyCols=7;
    private $priceCols=8;
    private $totalCols=8;
    private $nameCols=0;

    public function __construct(){
        $this->resetWith();
    }

    public function splitRow($strlen, $length=27){
        $result=[];
        $letters=explode(" ", $strlen);
        $row="";
        foreach($letters as $key=>$value){
            if(strlen($row." ".$value)<=$length){
                $row.=" ".$value;
            }else{
                $result[]=trim($row);
                $row=$value;
            }
        }
        $result[]=trim($row);
        return $result;
    }

    public function resetWith(){
        $this->nameCols = $this->width - ($this->qtyCols +  $this->priceCols + $this->totalCols);
    }

    public function resetWidthForKitchen($size=1){
        $this->nameCols = $this->width - ($this->qtyCols*$size);
    }

    /**
     * @param mixed $qty
     * @return pjPrinterItem
     */
    public function setQty($qty)
    {
        $this->qty = $qty;
        return $this;
    }

    /**
     * @param mixed $name
     * @return pjPrinterItem
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @param mixed $price
     * @return pjPrinterItem
     */
    public function setPrice($price)
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @param mixed $total
     * @return pjPrinterItem
     */
    public function setTotal($total)
    {
        $this->total = $total;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getQty()
    {
        return $this->qty;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return mixed
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @return mixed
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @return int
     */
    public function getWidth(): int
    {
        return $this->width;
    }

    /**
     * @param int $width
     * @return pjPrinterItem
     */
    public function setWidth(int $width): pjPrinterItem
    {
        $this->width = $width;
        return $this;
    }

    /**
     * @return int
     */
    public function getQtyCols(): int
    {
        return $this->qtyCols;
    }

    /**
     * @param int $qtyCols
     * @return pjPrinterItem
     */
    public function setQtyCols(int $qtyCols): pjPrinterItem
    {
        $this->qtyCols = $qtyCols;
        return $this;
    }

    /**
     * @return int
     */
    public function getPriceCols(): int
    {
        return $this->priceCols;
    }

    /**
     * @param int $priceCols
     * @return pjPrinterItem
     */
    public function setPriceCols(int $priceCols): pjPrinterItem
    {
        $this->priceCols = $priceCols;
        return $this;
    }

    /**
     * @return int
     */
    public function getTotalCols(): int
    {
        return $this->totalCols;
    }

    /**
     * @param int $totalCols
     * @return pjPrinterItem
     */
    public function setTotalCols(int $totalCols): pjPrinterItem
    {
        $this->totalCols = $totalCols;
        return $this;
    }

    /**
     * @return int
     */
    public function getNameCols(): int
    {
        return $this->nameCols;
    }

    /**
     * @param int $nameCols
     * @return pjPrinterItem
     */
    public function setNameCols(int $nameCols): pjPrinterItem
    {
        $this->nameCols = $nameCols;
        return $this;
    }

    /**
     * @return array
     */
    public function getGroups(): array
    {
        return $this->groups;
    }

    /**
     * @param array $groups
     * @return pjPrinterItem
     */
    public function setGroups(array $groups): pjPrinterItem
    {
        $this->groups = $groups;
        return $this;
    }

    /**
     * @return array
     */
    public function getModifiers(): array
    {
        return $this->modifiers;
    }

    /**
     * @param array $modifiers
     * @return pjPrinterItem
     */
    public function setModifiers(array $modifiers): pjPrinterItem
    {
        $this->modifiers = $modifiers;
        return $this;
    }

    /**
     * @return array
     */
    public function getExtras(): array
    {
        return $this->extras;
    }

    /**
     * @param array $extras
     * @return pjPrinterItem
     */
    public function setExtras(array $extras): pjPrinterItem
    {
        $this->extras = $extras;
        return $this;
    }

    /**
     * @return array
     */
    public function getPrices(): array
    {
        return $this->prices;
    }

    /**
     * @param array $prices
     * @return pjPrinterItem
     */
    public function setPrices(array $prices): pjPrinterItem
    {
        $this->prices = $prices;
        return $this;
    }

    /**
     * @return array
     */
    public function getCombos()
    {
        return $this->combos;
    }

    /**
     * @param array $combos
     */
    public function setCombos($combos)
    {
        $this->combos = $combos;
    }


}