<?php
if (isset($tpl['status'])) {
  $status = __('status', true);
  switch ($tpl['status']) {
    case 2:
      pjUtil::printNotice(NULL, $status[2]);
      break;
  }
  exit;
}

include_once("tabs.php");

?>

<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
        <li class="ui-state-default ui-corner-top ui-tabs-active">
            <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionCustomProducts">Custom Products</a>
        </li>
        <li class="ui-state-default ui-corner-top ui-tabs-active">
            <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionCustomExtras">Custom Extras</a>
        </li>
        <li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active">
            <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionCustomModifiers">Custom Modifiers</a>
        </li>
    </ul>
</div>

<?php
pjUtil::printNotice("Custom Modifiers", "Custom Pre-name (multi-languages) and Printers for Kitchen, ... for each modifiers and items");
?>

<div class="align_middle" style="margin-bottom: 5px;">
  <label id="quickly-printers" style="line-height: 30px;">
    - Quickly Printers:
    <a href="javascript:void(0)" onclick="checkAllPrinter(true);" style="color: green;">Check All</a>
    <?php if(count($tpl['printers'])>1) { ?>
      :<?php foreach($tpl['printers'] as $k=>$printer) { ?>
        <a href="javascript:void(0)" style="margin-right: 3px;" onclick="checkAllPrinterById('<?php echo $printer['id']; ?>', true);"><?php echo $printer['pre_name']; ?></a>
      <?php } ?>
    <?php } ?>
    <span>/</span>
    <a href="javascript:void(0)" onclick="checkAllPrinter(false);" style="color: darkred;">Uncheck All</a>
  </label>
</div>

<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjKiosk&amp;action=pjActionCustomModifiers" method="post" class="form pj-form">
  <input type="hidden" name="update" value="1"/>
  <table class="pj-table" style="width: 100%; margin-bottom: 12px;" cellspacing="0" cellpadding="0">
    <thead>
      <tr style="font-weight: bold;">
        <td>ID</td>
        <td>Modifier name (Main)</td>
        <td>Option name (Items)</td>
        <td style="width: 150px;">Printers in Kitchen</td>
        <td style="width: 30px;">Action</td>
      </tr>
    </thead>
    <tbody>
    <?php foreach($tpl['modifiers'] as $key=> $modifier) { ?>
      <tr>
        <td>
          <input type="hidden" name="modifier_ids[<?php echo $modifier['id']; ?>]" value="<?php echo $modifier['id']; ?>">
          <?php echo $modifier['id']; ?>
        </td>
        <td style="vertical-align: top;">
          <div><?php echo $modifier['name']; ?></div>
          <div><textarea class="pj-form-field w200" rows="2" name="pre_names[<?php echo $modifier['id']; ?>]"><?php echo $modifier['pre_name']; ?></textarea></div>
        </td>
        <td>
            <?php foreach($modifier['item_arr'] as $k=> $v) { ?>
                <div><?php echo $v['name']; ?></div>
                <textarea class="pj-form-field w200" rows="2" name="pre_item_names[<?php echo $modifier['id']; ?>][<?php echo $v['id']; ?>]"><?php echo $v['pre_name']; ?></textarea>
            <?php } ?>
        </td>
        <td class="select-printers">
          <?php foreach($tpl['printers'] as $k=>$printer) { ?>
          <label style="display: flex; cursor: pointer; margin-bottom: 5px;"><input type="checkbox" class="radio" location="<?php echo $printer['location'];?>" printer_id="<?php echo $printer['id'];?>" value="1" name="printers_id[<?php echo $modifier['id']; ?>][<?php echo $printer['id']; ?>]"  <?php echo (in_array($printer['id'], $modifier['printers']))?'checked':''; ?> />&nbsp;<?php echo $printer['pre_name']; ?></label>
          <?php } ?>
          <a onclick="checkAll(this, true)" style="text-decoration: underline; color: green; cursor: pointer;">Check All</a> / <a style="text-decoration: underline; color: darkred; cursor: pointer;" onclick="checkAll(this, false)">Uncheck All</a>
        </td>
        <td><a href="index.php?controller=pjAdminModifiers&action=pjActionUpdate&id=<?php echo $modifier['id']; ?>" target="_blank">Edit</a></td>
      </tr>
    <?php } ?>
    </tbody>
  </table>

  <script>
    function checkAll(me, value){
      $(me).parent().find("input").prop("checked", value);
    }

    function checkAllPrinter(value){
      $(".select-printers").find("input").prop("checked", value);
    }

    function checkAllPrinterByLocation(location, value){
      $(".select-printers").find("input[location="+location+"]").prop("checked", value);
    }

    function checkAllPrinterById(id, value){
      $(".select-printers").find("input[printer_id="+id+"]").prop("checked", value);
    }
  </script>
  <span class="inline_block">
    <input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
    <input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjKiosk&action=pjActionKioskIndex';" />
  </span>
</form>
