<?php
$kiosk = $tpl['kiosk'];
$transaction = $tpl['detail'];
if (!isset($transaction)) {
    exit;
}

$restaurant = pjRestaurantModel::factory()->find($tpl['detail']['rid'])->getData();
$restaurant_languages = pjMultiLangModel::factory()->getMultiLang($restaurant['id'], 'pjRestaurant');
?>

<div id="receipt">
    <div style="padding: 15px;">
        <div align="center">
            <h1 style="margin-bottom: 0px;"><?php echo ($kiosk['pre_receipt_name'] == 'On') ? $kiosk['name'] : $restaurant_languages[1]['name']; ?></h1>
            <div align="center"><?php echo $restaurant['address']; ?><br><?php echo $restaurant['phone']; ?></div>
            <hr>
            <p>Order Number: <br><?php echo $transaction['numberOrder']; ?></p>

            <?php if (isset($transaction['phone'])): ?>
                <p>Customer Phone: <br><?php echo $transaction['phone']; ?></p>
            <?php endif; ?>

            <?php if (isset($transaction['note'])): ?>
                <p>Note: <br><?php echo $transaction['note']; ?></p>
            <?php endif; ?>
        </div>
        <br>
        <div style="display: inline-block; width: 100%;">
            <div style="float: left">KS: <?php echo $kiosk['id']; ?></div>
            <div style="float: right"><?php echo date('m/d/Y H:i', strtotime($transaction['createdTime'])); ?></div>
        </div>
        <hr>
        <table class="pj-table" width="100%">
            <thead>
            <tr style="">
                <td style="width: 35px;">Qty</td>
                <td style="">Item</td>
                <td style="width: 60px;">Price</td>
                <td style="">Total</td>
            </tr>
            </thead>
            <tbody>
            <?php
            echo '<tr><td colspan="4" class="line"></td></tr>';

            $json = $transaction['data'];
            $products = json_decode(json_decode($json, true), true);
            $countItems = 0;
            foreach ($products as $key => $value) {
                $check = false;

                /*Product name*/
                if ($value['set_different_sizes'] === 'T') {
                    echo '<tr>';
                    echo '<td></td>';
                    echo '<td>' . $value['name'] . '</td>';
                    echo '<td></td>';
                    echo '<td></td>';
                    echo '</tr>';

                    foreach ($value['price_arr'] as $k => $v) {
                        if ($v['QTY'] > 0) {
                            echo '<tr>';
                            echo '<td>' . $v['QTY'] . ' x </td>';
                            echo '<td>' . $v['price_name'] . '</td>';
                            echo '<td>' . pjUtil::formatCurrencySign(number_format($v['price'], 2), $tpl['option_arr']['o_currency']) . '</td>';
                            echo '<td>' . pjUtil::formatCurrencySign(number_format($v['QTY'] * $v['price'], 2), $tpl['option_arr']['o_currency']) . '</td>';
                            echo '</tr>';
                            $countItems += $value['QTY'];
                        }
                    }

                    $check = true;
                } else if ($value['QTY'] > 0) {
                    echo '<tr>';
                    echo '<td>' . $value['QTY'] . ' x </td>';
                    echo '<td>' . $value['name'] . '</td>';
                    echo '<td>' . pjUtil::formatCurrencySign(number_format($value['price'], 2), $tpl['option_arr']['o_currency']) . '</td>';
                    echo '<td>' . pjUtil::formatCurrencySign(number_format($value['TOTAL'], 2), $tpl['option_arr']['o_currency']) . '</td>';
                    echo '</tr>';
                    $countItems += $value['QTY'];
                    $check = true;
                }

                /*Group*/
                foreach ($value['group_arr'] as $k => $v) {
                    echo '<tr>';
                    echo '<td></td>';
                    echo '<td>* ' . $v['group_name'] . ': ' . $v['group_item_arr'][$v['SELECTED']]['group_item_name'] . '</td>';
                    echo '<td></td>';
                    echo '<td></td>';
                    echo '</tr>';
                }

                /*Modifier*/
                foreach ($value['modifier_arr'] as $k => $v) {
                    $check = false;
                    foreach ($v['modifier_item_arr'] as $kk => $vv) {
                        if ($vv['CHECKED']) {
                            $check = true;
                        }
                    }
                    if ($check) {
                        echo '<tr>';
                        echo '<td></td>';
                        echo '<td>* ' . $v['modifier_name'] . ':</td>';
                        echo '<td></td>';
                        echo '<td></td>';
                        echo '</tr>';

                        foreach ($v['modifier_item_arr'] as $kk => $vv) {
                            if ($vv['CHECKED']) {
                                echo '<tr>';
                                echo '<td></td>';
                                echo '<td>&nbsp;&nbsp;+ ' . $vv['modifier_item_name'] . ':</td>';
                                echo '<td>' . pjUtil::formatCurrencySign(number_format($vv['price'], 2), $tpl['option_arr']['o_currency']) . '</td>';
                                echo '<td>' . pjUtil::formatCurrencySign(number_format($vv['price'], 2), $tpl['option_arr']['o_currency']) . '</td>';
                                echo '</tr>';
                            }
                        }
                    }
                }

                /*Extra*/
                foreach ($value['extra_arr'] as $k => $v) {
                    if ($v['QTY'] > 0) {
                        echo '<tr>';
                        echo '<td></td>';
                        echo '<td>* ' . $v['QTY'] . ' x ' . $v['name'] . '</td>';
                        echo '<td>' . pjUtil::formatCurrencySign(number_format($v['price'], 2), $tpl['option_arr']['o_currency']) . '</td>';
                        echo '<td>' . pjUtil::formatCurrencySign(number_format($v['QTY'] * $v['price'], 2), $tpl['option_arr']['o_currency']) . '</td>';
                        echo '</tr>';
                    }
                }

                /*End 1 row*/
                if ($check) {
                    echo '<tr><td colspan="4" class="line"></td></tr>';
                }
            }
            ?>
            <tr>
                <td colspan="4" style="text-align: left;">
                    <div style="line-height: 30px;">
                        <div><?php echo $countItems; ?> total items</div>
                        <div>
                            Subtotal: <?php echo pjUtil::formatCurrencySign(number_format($transaction['subTotal'], 2), $tpl['option_arr']['o_currency']); ?></div>
                        <div>
                            Discount: <?php echo pjUtil::formatCurrencySign(number_format($transaction['discount'], 2), $tpl['option_arr']['o_currency']); ?></div>
                        <div>
                            Tax: <?php echo pjUtil::formatCurrencySign(number_format($transaction['tax'], 2), $tpl['option_arr']['o_currency']); ?></div>
                        <div>
                            Tip: <?php echo pjUtil::formatCurrencySign(number_format($transaction['tip'], 2), $tpl['option_arr']['o_currency']); ?></div>
                        <div>
                            <b style="font-size: 120%;">Total: <?php echo pjUtil::formatCurrencySign(number_format($transaction['totalPrice'], 2), $tpl['option_arr']['o_currency']); ?></b>
                        </div>
                    </div>
                </td>
            </tr>
            </tbody>
        </table>

        <hr>
        <div style="padding: 5px; line-height: 30px;">
            <?php if (strlen($transaction['transactionId']) && $transaction['status'] == 'Approved'): ?>
                <div>PAID</div>
            <?php endif; ?>

            <?php if (isset($transaction['status'])): ?>
                <div>Payment Status: <?php echo $transaction['status']; ?></div>
            <?php endif; ?>

            <?php
            $extra = json_decode(json_decode($transaction['extra'], true), true);
            if (count($extra) > 0) {
                if (isset($extra['authcode'])) echo '<div>Auth Code: ' . $extra['authcode'] . '</div>';
                if (isset($extra['transactionid'])) echo '<div>Transaction ID: ' . $extra['transactionid'] . '</div>';
                if (isset($extra['emv_application_label'])) echo '<div>Payment Type: ' . explode(" ", $extra['emv_application_label'])[0]. '</div>';
                if (isset($extra['cc_number'])) echo '<div>CC Number: ' . $extra['cc_number'] . '</div>';
            } ?>
        </div>
        <br>
        <div align="center"><b>Powered by CSL Technology</b></div>
    </div>
</div>

<style>
    body {
        font-family: sans-serif;
        zoom: 200%;
    }

    #receipt {
        width: 100%;
        max-width: 500px;
        box-shadow: 0px 0px 8px 1px #d3d3d3;
        margin: auto;
    }

    hr {
        border-style: dashed;
    }

    table {

    }

    table tr {

    }

    .line {
        border-bottom: 1px gray dashed;
    }

    table tr td {
        line-height: 30px;
    }
</style>
