var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var validator,
			$frmCreateOrder = $('#frmCreateOrder'),
			$frmUpdateOrder = $('#frmUpdateOrder'),
			$dialogReminderEmail = $("#dialogReminderEmail"),
			$dialogConfirm = $("#dialogConfirm"),
			$dialogPrintToRemotePrinter = $("#dialogPrintToRemotePrinter"),			
			$dialogSendConfirmedOrderSms = $("#dialogSendConfirmedOrderSms"),
			$dialogSendReadyForPickupSms = $("#dialogSendReadyForPickupSms"),			
			dialog = ($.fn.dialog !== undefined),
			datepicker = ($.fn.datepicker !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			validate = ($.fn.validate !== undefined),
			chosen = ($.fn.chosen !== undefined),
			spinner = ($.fn.spinner !== undefined),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			};
	
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		if (chosen) {
			$("#c_country").chosen();
			$("#d_country_id").chosen();
			if($frmCreateOrder.length > 0 || $frmUpdateOrder.length > 0)
			{
				$("#client_id").chosen();
			}
		}		
		if ($frmCreateOrder.length > 0 || $frmUpdateOrder.length > 0) 
		{
			$.validator.addMethod('pickupTime',
			    function (value, element) {
					if($(element).attr('data-wt') == 'open')
					{
						return true;
					}else{
						return false;
					}
			    }
			);
			$.validator.addMethod('deliveryTime',
			    function (value, element) {
					if($(element).attr('data-wt') == 'open')
					{
						return true;
					}else{
						return false;
					}
			    }
			);
				
			$frmCreateOrder.validate({
				rules: {
					"p_dt":{
						required: function(){
							if($('#type').val() == 'pickup')
							{
								return true;
							}else{
								return false;
							}
						},
						pickupTime: true
					},
					"p_location_id":{
						required: function(){
							if($('#type').val() == 'pickup')
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"d_dt":{
						required: function(){
							if($('#type').val() == 'delivery')
							{
								return true;
							}else{
								return false;
							}
						},
						deliveryTime: true
					},
					"d_location_id":{
						required: function(){
							if($('#type').val() == 'delivery')
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"d_address_1":{
						required: function(){
							if($('#type').val() == 'delivery' && $('#d_address_1').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"d_address_2":{
						required: function(){
							if($('#type').val() == 'delivery' && $('#d_address_2').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"d_city":{
						required: function(){
							if($('#type').val() == 'delivery' && $('#d_city').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"d_state":{
						required: function(){
							if($('#type').val() == 'delivery' && $('#d_state').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"d_zip":{
						required: function(){
							if($('#type').val() == 'delivery' && $('#d_zip').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"d_country_id":{
						required: function(){
							if($('#type').val() == 'delivery' && $('#d_country_id').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"d_notes":{
						required: function(){
							if($('#type').val() == 'delivery' && $('#d_notes').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"ca_dt":{
						required: function(){
							if($('#type').val() == 'catering')
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"ca_location_id":{
						required: function(){
							if($('#type').val() == 'catering')
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"ca_address_1":{
						required: function(){
							if($('#type').val() == 'catering' && $('#ca_address_1').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"ca_address_2":{
						required: function(){
							if($('#type').val() == 'catering' && $('#ca_address_2').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"ca_city":{
						required: function(){
							if($('#type').val() == 'catering' && $('#ca_city').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"ca_state":{
						required: function(){
							if($('#type').val() == 'catering' && $('#ca_state').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"ca_zip":{
						required: function(){
							if($('#type').val() == 'catering' && $('#ca_zip').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"ca_country_id":{
						required: function(){
							if($('#type').val() == 'catering' && $('#ca_country_id').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					},
					"ca_notes":{
						required: function(){
							if($('#type').val() == 'catering' && $('#ca_notes').hasClass('fdRequired'))
							{
								return true;
							}else{
								return false;
							}
						}
					}
				},
				messages:{
					"p_dt":{
						pickupTime: myLabel.restaurant_closed
					},
					"d_dt":{
						deliveryTime: myLabel.restaurant_closed
					}
				},
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'd_dt' || element.attr('name') == 'p_dt' || element.attr('name') == 'client_id')
					{
						error.insertAfter(element.parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
				    if (validator.numberOfInvalids()) {
				    	var index = $(validator.errorList[0].element, this).closest("div[id^='tabs-']").index();
				    	if ($tabs.length > 0 && tabs && index !== -1) {
				    		$tabs.tabs(tOpt).tabs("option", "active", index-1);
				    	}
				    };
				},
				submitHandler: function(form){
					var valid = true;
					$('#fdOrderList').find("tbody.main-body > tr.fdLine").each(function() {
						var index = $(this).attr('data-index'),
							$product = $('#fdProduct_' + index),
							$price = $('#fdPrice_' + index);
						
						if($product.val() == '')
						{
							$product.addClass('fdError');
							valid = false;
						}else{
							$product.removeClass('fdError');
						}
						if($price.val() == '')
						{
							$price.addClass('fdError');
							valid = false;
						}else{
							$price.removeClass('fdError');
						}
					});
					if(valid == true)
					{
						form.submit();
					}else{
						if ($tabs.length > 0 && tabs) 
						{
							$tabs.tabs(tOpt).tabs("option", "active", 0);
						}
					}
				}
			});
			$frmUpdateOrder.validate({
				rules: {
					"p_dt":{
						required: function(){
							if($('#type').val() == 'pickup')
							{
								return true;
							}else{
								return false;
							}
						},
						pickupTime: true
					},
					"d_dt":{
						required: function(){
							if($('#type').val() == 'delivery')
							{
								return true;
							}else{
								return false;
							}
						},
						deliveryTime: true
					}
				},
				messages:{
					"p_dt":{
						pickupTime: myLabel.restaurant_closed
					},
					"d_dt":{
						deliveryTime: myLabel.restaurant_closed
					}
				},
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'd_dt' || element.attr('name') == 'p_dt' || element.attr('name') == 'client_id')
					{
						error.insertAfter(element.parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				submitHandler: function(form){
					var valid = true;
					$('#fdOrderList').find("tbody.main-body > tr.fdLine").each(function() {
						var index = $(this).attr('data-index'),
							$product = $('#fdProduct_' + index),
							$price = $('#fdPrice_' + index);
						
						if($product.val() == '')
						{
							$product.addClass('fdError');
							valid = false;
						}else{
							$product.removeClass('fdError');
						}
						if($price.val() == '')
						{
							$price.addClass('fdError');
							valid = false;
						}else{
							$price.removeClass('fdError');
						}
					});
					if(valid == true)
					{
						form.submit();
					}
				}
			});
			
			$('#fdOrderList').find(".pj-field-count").spinner({
				min: 1,
				stop: function(e, ui){
					if($('#fdOrderList').find("tbody.main-body > tr").length > 0)
					{
						calPrice();
					}
				}
			});
			if($('#fdOrderList').find("tbody.main-body > tr").length > 0)
			{
				calPrice();
				$('#fdOrderList').show();
			}
		}
		
		function validatePickupTime()
		{
			var $frm = $frmCreateOrder;
			if($frmUpdateOrder.length > 0)
			{
				$frm = $frmUpdateOrder;
			}
			$.ajax({
				type: 'POST',
				async: false, 
				url: "index.php?controller=pjAdminOrders&action=pjActionCheckPickup",
				data: {
					type: function(){ return $frm.find("select[name='type']").val(); },
					p_location_id: function(){ return $frm.find("select[name='p_location_id']").val(); },
					p_dt: function(){ return $frm.find("input[name='p_dt']").val(); }
				},
				success: function(data){
					if(data == 'false')
					{
						$frm.find("input[name='p_dt']").attr('data-wt', 'closed').valid();
					}else{
						$frm.find("input[name='p_dt']").attr('data-wt', 'open').valid();
					}
				}
			});
		}
		function validateDeliveryTime()
		{
			var $frm = $frmCreateOrder;
			if($frmUpdateOrder.length > 0)
			{
				$frm = $frmUpdateOrder;
			}
			$.ajax({
				type: 'POST',
				async: false, 
				url: "index.php?controller=pjAdminOrders&action=pjActionCheckDelivery",
				data: {
					type: function(){ return $frm.find("select[name='type']").val(); },
					d_location_id: function(){ return $frm.find("select[name='d_location_id']").val(); },
					d_dt: function(){ return $frm.find("input[name='d_dt']").val(); }
				},
				success: function(data){
					if(data == 'false')
					{
						$frm.find("input[name='d_dt']").attr('data-wt', 'closed').valid();
					}else{
						$frm.find("input[name='d_dt']").attr('data-wt', 'open').valid();
					}
				}
			});
		}
		function formatType(val, obj) {			
			if(val == 'pickup')
			{
				return '<span class="label-status fd-type-pickup">' + myLabel.pickup + '</span>';
			} else if(val == 'delivery'){
				return '<span class="label-status fd-type-delivery">' + myLabel.delivery + '</span>';
			} else {
				return '<span class="label-status fd-type-catering">' + myLabel.catering + '</span>';
			}
		}
		
                
        if (typeof pjGrid !== 'undefined' && pjGrid.isManager) {
            if ($("#grid").length > 0 && datagrid) {
                var $grid = $("#grid").datagrid({
                    buttons: [{type: "edit", url: "index.php?controller=pjAdminOrders&action=pjActionUpdate&id={:id}"},
                                     ],
                    columns: [
                              {text: myLabel.name, type: "text", sortable: false, width:120},
                              {text: myLabel.date_time, type: "text", sortable: false, editable: false, width:120},
                              {text: myLabel.total, type: "text", sortable: false, editable: false, width:70},
                              {text: myLabel.type, type: "text", sortable: false, editable: false, width: 70, renderer: formatType},
                              {text: myLabel.delivery_status, type: "text", sortable: false, editable: false, width: 100},
                              {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, options: [
                                                                                                         {label: myLabel.pending, value: "pending"}, 
                                                                                                         {label: myLabel.confirmed, value: "confirmed"},
                                                                                                         {label: myLabel.cancelled, value: "cancelled"}
                                                                                                         ], applyClass: "pj-status"}],
                    dataUrl: "index.php?controller=pjAdminOrders&action=pjActionGetOrder" + pjGrid.queryString,
                    dataType: "json",
                    fields: ['client_name', 'datetime', 'total', 'type', 'delivery_status', 'status'],
                    paginator: {
                            actions: [
                               {text: myLabel.exported, url: "index.php?controller=pjAdminOrders&action=pjActionExportOrder", ajax: false}
                            ],
                            gotoPage: true,
                            paginate: true,
                            total: true,
                            rowCount: true
                    },
                    saveUrl: "index.php?controller=pjAdminOrders&action=pjActionSaveOrder&id={:id}",
                    select: {
                            field: "id",
                            name: "record[]"
                    }
                });
            }
        }
        else {
            if ($("#grid").length > 0 && datagrid) {
                var $grid = $("#grid").datagrid({
                    buttons: [{type: "edit", url: "index.php?controller=pjAdminOrders&action=pjActionUpdate&id={:id}"},
                              {type: "delete", url: "index.php?controller=pjAdminOrders&action=pjActionDeleteOrder&id={:id}"}
                                     ],
                    columns: [
                              {text: myLabel.name, type: "text", sortable: false, width:120},
                              {text: myLabel.date_time, type: "text", sortable: false, editable: false, width:120},
                              {text: myLabel.total, type: "text", sortable: false, editable: false, width:70},
                              {text: myLabel.type, type: "text", sortable: false, editable: false, width: 70, renderer: formatType},
                              {text: myLabel.delivery_status, type: "text", sortable: false, editable: false, width: 100},
                              {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, options: [
                                                                                                         {label: myLabel.pending, value: "pending"}, 
                                                                                                         {label: myLabel.confirmed, value: "confirmed"},
                                                                                                         {label: myLabel.cancelled, value: "cancelled"}
                                                                                                         ], applyClass: "pj-status"}],
                    dataUrl: "index.php?controller=pjAdminOrders&action=pjActionGetOrder" + pjGrid.queryString,
                    dataType: "json",
                    fields: ['client_name', 'datetime', 'total', 'type', 'delivery_status', 'status'],
                    paginator: {
                            actions: [
                               {text: myLabel.delete_selected, url: "index.php?controller=pjAdminOrders&action=pjActionDeleteOrderBulk", render: true, confirmation: myLabel.delete_confirmation},
                               {text: myLabel.exported, url: "index.php?controller=pjAdminOrders&action=pjActionExportOrder", ajax: false}
                            ],
                            gotoPage: true,
                            paginate: true,
                            total: true,
                            rowCount: true
                    },
                    saveUrl: "index.php?controller=pjAdminOrders&action=pjActionSaveOrder&id={:id}",
                    select: {
                            field: "id",
                            name: "record[]"
                    }
                });
            }
        }       
				
		$(document).on("focusin", ".datepick", function (e) {
			var $this = $(this);
			$this.datepicker({
				firstDay: $this.attr("rel"),
				dateFormat: $this.attr("rev"),
				onSelect: function (dateText, inst) {
					
				}
			});
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				if(!$dp.is('[disabled=disabled]'))
				{
					$dp.trigger("focusin").datepicker("show");
				}
			}
		}).on("focusin", ".datetimepick", function (e) {
			var $this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev"),
					timeFormat: $this.attr("lang"),
					stepMinute: 5,
					onClose: function(){
						if($this.attr('name') == 'p_dt')
						{
							validatePickupTime();
						}
						if($this.attr('name') == 'd_dt')
						{
							validateDeliveryTime();
						}
					}
			};
			$(this).datetimepicker($.extend(o, custom));
			
		}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
			e.stopPropagation();
			$(".pj-form-filter-advanced").toggle();
		}).on("submit", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var obj = {},
				$this = $(this),
				arr = $this.serializeArray(),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
				obj[arr[i].name] = arr[i].value;
			}
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminOrders&action=pjActionGetOrder", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("reset", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(".pj-button-detailed").trigger("click");
		}).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				all: "",
				status: "",
				q: "",
				type: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminOrders&action=pjActionGetOrder", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminOrders&action=pjActionGetOrder", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val(),
				type: $this.find("select[name='type']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminOrders&action=pjActionGetOrder", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("change", "#payment_method", function (e) {
			switch ($("option:selected", this).val()) {
				case 'creditcard':
					$(".boxCC").show();
					break;
				default:
					$(".boxCC").hide();
			}
		}).on("click", "#btnAddProduct", function (e) {
			var index = Math.ceil(Math.random() * 999999),
				$clone = $("#boxProductClone").find("tbody").html();
			$clone = $clone.replace(/\{INDEX\}/g, 'new_' + index);
			$('#fdOrderList').find("tbody.main-body").append($clone);
			$('#fdOrderList').find(".pj-field-count").spinner({
				min: 1,
				stop: function(e, ui){
					if($('#fdOrderList').find("tbody.main-body > tr").length > 0)
					{
						calPrice();
					}
				}
			});
			$('#fdOrderList').show();
		}).on("click", ".pj-remove-product", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).closest(".fdLine").remove();
			if($('#fdOrderList').find("tbody.main-body > tr").length == 0)
			{
				$('#fdOrderList').hide();
			}else{
				calPrice();
			}
			return false;
		}).on("click", ".pj-add-extra", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				product_id = $("option:selected", $this.parentsUntil(".opBox").find("select[name^='product_id']")).val();
			if(product_id != '')
			{
				$.get("index.php?controller=pjAdminOrders&action=pjActionGetExtras", {
					product_id: product_id,
					index: $this.attr("data-index")
				}).done(function (data) {
					$(data).appendTo($this.siblings(".pj-extra-table").find("tbody"));
					$this.siblings(".pj-extra-table").find(".pj-field-count").spinner({
						min: 1,
						stop: function(e, ui){
							if($('#fdOrderList').find("tbody.main-body > tr").length > 0)
							{
								calPrice();
							}
						}
					});
				});
			}
			return false;
		}).on("click", ".pj-remove-extra", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).parent().parent().remove();
			calPrice();
			return false;
		}).on("change", ".fdProduct", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				index = $this.attr("data-index"),
				option = $('option:selected', this).attr('data-extra');
			$('.fdExtraBusiness_'+index).hide();
			$.get("index.php?controller=pjAdminOrders&action=pjActionGetPrices", {
				product_id: $this.val(),
				index: index
			}).done(function (data) {
				$("#fdPriceTD_" + index).html(data);
				$('#fdExtraTable_' + index).find("tbody").html("");
				if($this.val() != '')
				{
					$('.business-' + index).show();
				}else{
					$('.business-' + index).hide();
				}
				if(option == '0')
				{
					$('.fdExtraNA_' + index).show();
				}else{
					$('.fdExtraButton_' + index).show();
				}
				calPrice();
			});
			
			$.get("index.php?controller=pjAdminOrders&action=pjActionGetProductGroups", {
				product_id: $this.val(),
				index: index
			}).done(function (data) {
				$('.fdProductGroupsContainer-' + index).html(data);
			});
			
			$.get("index.php?controller=pjAdminOrders&action=pjActionGetProductModifiers", {
				product_id: $this.val(),
				index: index
			}).done(function (data) {
				$('.fdProductModifiersContainer-' + index).html(data);
			});
			return false;
		}).on("change", "#type", function (e) {
			switch ($("option:selected", this).val()) {
			case 'pickup':
				$(".delivery").hide();
				$(".catering").hide();
				$(".pickup").show();
				break;
			case 'delivery':
				$(".delivery").show();
				$(".pickup").hide();
				$(".catering").hide();
				break;
			case 'catering':
				$(".delivery").hide();
				$(".pickup").hide();
				$(".catering").show();
				break;
			default:
				$(".delivery, .pickup, .catering").hide();
			}
		}).on("change", "#tip_option", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $tip_option = $(this).val();
			if ($tip_option == 0) {
				$('.pjTipPercentage').hide();
				$('.pjTipAmount').hide();
			} else if ($tip_option == 1) {
				$('.pjTipPercentage').show();
				$('.pjTipAmount').show();
				$('#tip_amount').attr('readonly', true);
			} else if ($tip_option == 2) {
				$('.pjTipPercentage').hide();
				$('.pjTipAmount').show();
				$('#tip_amount').attr('readonly', false);
			}
		}).on("click", "#btnCalc", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if($('#fdOrderList').find("tbody.main-body > tr").length > 0)
			{
				$.post("index.php?controller=pjAdminOrders&action=pjActionGetTotal", $(this).closest("form").serialize()).done(function (data) {
					if(data.price != 'NULL')
					{
						$("#price").val(data.price).valid();
						$("#price_delivery").val(data.delivery);
						$("#discount").val(data.discount);
						$("#subtotal").val(data.subtotal);
						$("#tax").val(data.tax);
						$("#service_fee").val(data.service_fee);
						$("#catering_fee").val(data.catering_fee);
						$("#total").val(data.total);
						$("#tip_amount").val(data.tip_amount);
						$("#dasher_tip_amount").val(data.dasher_tip_amount);
						$("#external_delivery_id").val(data.external_delivery_id);
					}
				});
			}
		}).on("change", "#client_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if($(this).val() != '')
			{
				$('#pjFdEditClient').css('display', 'block');
				var href = $('#pjFdEditClient').attr('data-href');
				href = href.replace("{ID}", $(this).val());
				$('#pjFdEditClient').attr('href', href);
				$.get("index.php?controller=pjAdminOrders&action=pjActionGetClient&id=" + $(this).val()).done(function (data) {
					if($('#c_title').length > 0)
					{
						$('#c_title').val(data.c_title).valid();
					}
					if($('#c_email').length > 0)
					{
						$('#c_email').val(data.c_email).valid();
					}
					if($('#c_name').length > 0)
					{
						$('#c_name').val(data.c_name).valid();
					}
					if($('#c_phone').length > 0)
					{
						$('#c_phone').val(data.c_phone).valid();
					}
					if($('#c_address_2').length > 0)
					{
						$('#c_address_2').val(data.c_address_2).valid();
					}
					if($('#c_address_1').length > 0)
					{
						$('#c_address_1').val(data.c_address_1).valid();
					}
					if($('#c_city').length > 0)
					{
						$('#c_city').val(data.c_city).valid();
					}
					if($('#c_state').length > 0)
					{
						$('#c_state').val(data.c_state).valid();
					}
					if($('#c_zip').length > 0)
					{
						$('#c_zip').val(data.c_zip).valid();
					}
					if($('#c_country').length > 0)
					{
						$('#c_country').val(data.c_country).trigger("liszt:updated").valid();
					}
					if($('#type').val() == 'delivery')
					{
						if( ($('#d_address_1').length > 0 && $('#d_address_1').val() != '') ||
							($('#d_address_2').length > 0 && $('#d_address_2').val() != '') ||
							($('#d_city').length > 0 && $('#d_city').val() != '') ||
							($('#d_state').length > 0 && $('#d_state').val() != '') ||
							($('#d_zip').length > 0 && $('#d_zip').val() != '') ||
							($('#d_country_id').length > 0 && $('#d_country_id').val() != ''))
						{
							if ($dialogConfirm.length > 0 && dialog) {
								$dialogConfirm.dialog({
									modal: true,
									resizable: false,
									draggable: false,
									autoOpen: false,
									width: 400,
									buttons: (function () {
										var buttons = {};
										buttons[fdApp.locale.button.ok] = function () {
											$dialogConfirm.dialog("close");
											if($('#d_address_1').length > 0)
											{
												$('#d_address_1').val(data.c_address_1).valid();
											}
											if($('#d_address_2').length > 0)
											{
												$('#d_address_2').val(data.c_address_2).valid();
											}
											if($('#d_city').length > 0)
											{
												$('#d_city').val(data.c_city).valid();
											}
											if($('#d_state').length > 0)
											{
												$('#d_state').val(data.c_state).valid();
											}
											if($('#d_zip').length > 0)
											{
												$('#d_zip').val(data.c_zip).valid();
											}
											if($('#d_country_id').length > 0)
											{
												$('#d_country_id').val(data.c_country).trigger("liszt:updated").valid();
											}
										};
										
										return buttons;
									})()
								});
							}
							$dialogConfirm.dialog('open');
						}else{
							if($('#d_address_1').length > 0)
							{
								$('#d_address_1').val(data.c_address_1).valid();
							}
							if($('#d_address_2').length > 0)
							{
								$('#d_address_2').val(data.c_address_2).valid();
							}
							if($('#d_city').length > 0)
							{
								$('#d_city').val(data.c_city).valid();
							}
							if($('#d_state').length > 0)
							{
								$('#d_state').val(data.c_state).valid();
							}
							if($('#d_zip').length > 0)
							{
								$('#d_zip').val(data.c_zip).valid();
							}
							if($('#d_country_id').length > 0)
							{
								$('#d_country_id').val(data.c_country).trigger("liszt:updated").valid();
							}
						}
					}
				});
			}else{
				$('#pjFdEditClient').css('display', 'none');
			}
			
		}).on("change", ".fdSize", function (e) {
			calPrice();
		}).on("change", ".fdExtra", function (e) {
			calPrice();		
		}).on("change", ".pj-field-count", function (e) {
			calPrice();
		}).on("click", ".fdModifierItem", function (e) {
			calPrice();		
		}).on("click", "#btnEmail", function (e) {
			if ($dialogReminderEmail.length > 0 && dialog) {
				$dialogReminderEmail.data("id", $(this).data("id")).dialog("open");
			}
		}).on("change", "#filter_type", function (e) {
			$('.frm-filter').submit();
		}).on("click", ".pjFdOpenClientTab", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$("#tabs").tabs("option", "active", 1);
		}).on("click", "#btnPrintToRemotePrinter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogPrintToRemotePrinter.length > 0 && dialog) {
				$dialogPrintToRemotePrinter.data("id", $(this).data("id")).data("type", $(this).data("type")).dialog("open");
			}
		}).on("click", "#btnRePrintToRemotePrinter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogPrintToRemotePrinter.length > 0 && dialog) {
				$dialogPrintToRemotePrinter.data("id", $(this).data("id")).data("type", $(this).data("type")).dialog("open");
			}
		}).on("click", "#btnSendConfirmedOrderSms", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogSendConfirmedOrderSms.length > 0 && dialog) {
				$dialogSendConfirmedOrderSms.data("id", $(this).data("id")).dialog("open");
			}
		}).on("click", "#btnSendReadyForPickupSms", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogSendReadyForPickupSms.length > 0 && dialog) {
				$dialogSendReadyForPickupSms.data("id", $(this).data("id")).dialog("open");
			}
		});
		
		if ($dialogPrintToRemotePrinter.length > 0 && dialog) {
			$dialogPrintToRemotePrinter.dialog({
				modal: true,
				resizable: false,
				draggable: false,
				autoOpen: false,
				width: 400,
				buttons: (function () {
					var buttons = {};
					buttons[fdApp.locale.button.send] = function () {
						$.post("index.php?controller=pjAdminOrders&action=pjActionSendToRemotePrinter", {
							"send": 1,
							"id": $dialogPrintToRemotePrinter.data("id"),
							"type": $dialogPrintToRemotePrinter.data("type")
						}).done(function (data) {
							$dialogPrintToRemotePrinter.dialog("close");
						});
					};
					buttons[fdApp.locale.button.cancel] = function () {
						$dialogPrintToRemotePrinter.dialog("close");
					};
					return buttons;
				})()
			});
		}
		
		if ($dialogSendConfirmedOrderSms.length > 0 && dialog) {
			$dialogSendConfirmedOrderSms.dialog({
				modal: true,
				resizable: false,
				draggable: false,
				autoOpen: false,
				width: 400,
				buttons: (function () {
					var buttons = {};
					buttons[myLabel.btnSmsToOwner] = function () {
						$.post("index.php?controller=pjAdminOrders&action=pjActionSendConfirmedOrderSms", {
							"send": 1,
							"recipient": 'owner',
							"id": $dialogSendConfirmedOrderSms.data("id")
						}).done(function (data) {
							$dialogSendConfirmedOrderSms.dialog("close");
						});
					};
					buttons[myLabel.btnSmsToCustomer] = function () {
						$.post("index.php?controller=pjAdminOrders&action=pjActionSendConfirmedOrderSms", {
							"send": 1,
							"recipient": 'customer',
							"id": $dialogSendConfirmedOrderSms.data("id")
						}).done(function (data) {
							$dialogSendConfirmedOrderSms.dialog("close");
						});
					};
					buttons[fdApp.locale.button.cancel] = function () {
						$dialogSendConfirmedOrderSms.dialog("close");
					};
					return buttons;
				})()
			});
		}	
		
		if ($dialogSendReadyForPickupSms.length > 0 && dialog) {
			$dialogSendReadyForPickupSms.dialog({
				modal: true,
				resizable: false,
				draggable: false,
				autoOpen: false,
				width: 400,
				buttons: (function () {
					var buttons = {};
					buttons[fdApp.locale.button.send] = function () {
						$.post("index.php?controller=pjAdminOrders&action=pjActionSendReadyForPickupSms", {
							"send": 1,
							"id": $dialogSendReadyForPickupSms.data("id")
						}).done(function (data) {
							$dialogSendReadyForPickupSms.dialog("close");
						});
					};
					buttons[fdApp.locale.button.cancel] = function () {
						$dialogSendReadyForPickupSms.dialog("close");
					};
					return buttons;
				})()
			});
		}
		
		if ($dialogReminderEmail.length > 0 && dialog) {
			$dialogReminderEmail.dialog({
				modal: true,
				resizable: false,
				draggable: false,
				autoOpen: false,
				width: 660,
				open: function () {
					$dialogReminderEmail.html("");
					$.get("index.php?controller=pjAdminOrders&action=pjActionReminderEmail", {
						"id": $dialogReminderEmail.data("id")
					}).done(function (data) {
						$dialogReminderEmail.html(data);
						tinymce.init({
							relative_urls : false,
						    contextmenu: false,
						    selector: 'textarea#confirm_message',
						    theme: "modern",
						    width: 600,
						    height: 300,
						    plugins: [
						         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
						         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
						         "save table contextmenu directionality emoticons template paste textcolor"
						    ],
						    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",
						    image_advtab: true,
						    menubar: "file edit insert view table tools"
						});
						if (tinymce.editors.length > 0) 
						{							
							tinymce.execCommand('mceAddEditor',true, "confirm_message");
						}
						validator = $dialogReminderEmail.find("form").validate({
							errorPlacement: function (error, element) {
								error.insertAfter(element.parent());
							},
							errorClass: "error_clean"
						});
						$dialogReminderEmail.dialog("option", "position", "center");
					});
				},
				close: function () {
					if (tinymce.editors.length > 0) 
					{
				        tinymce.execCommand('mceRemoveEditor',true, "confirm_message");
				    }
					fdApp.enableButtons.call(null, $dialogReminderEmail);
				},
				buttons: (function () {
					var buttons = {};
					buttons[fdApp.locale.button.send] = function () {
						if (validator.form()) {
							fdApp.disableButtons.call(null, $dialogReminderEmail);
							$.post("index.php?controller=pjAdminOrders&action=pjActionReminderEmail", $dialogReminderEmail.find("form").serialize()).done(function (data) {
								if (data.status == "OK") {
									if (tinymce.editors.length > 0) 
									{
								        tinymce.execCommand('mceRemoveEditor',true, "confirm_message");
								    }
									$dialogReminderEmail.dialog("close");
									noty({text: data.text, type: "success"});
								} else {
									noty({text: data.text, type: "error"});
									fdApp.enableButtons.call(null, $dialogReminderEmail);
								}
							});
						}
					};
					buttons[fdApp.locale.button.cancel] = function () {
						if (tinymce.editors.length > 0) 
						{
							tinymce.execCommand('mceRemoveEditor',true, "confirm_message");
					    }
						$dialogReminderEmail.dialog("close");
					};
					
					return buttons;
				})()
			});
		}
		
		function calPrice()
		{			
			$('#fdOrderList').find("tbody.main-body > tr.fdLine").each(function() {
				var total = 0,
					total_format = '',
					index = $(this).attr('data-index'),
					product = $('#fdProduct_' + index).val(),
					price_element = $('#fdPrice_' + index),
					product_qty = parseInt($('#fdProductQty_' + index).val(), 10),
					price = 0;
				
				var element_type = price_element.attr('data-type');
				if(element_type == 'input')
				{
					price = parseFloat(price_element.val());
				}else{
					price = parseFloat($('option:selected', price_element).attr('data-price'), 10);
				}
				if(price > 0 && product_qty > 0)
				{
					total += parseFloat(price) * product_qty;
					$('.fdExtra_' + index).each(function() {
						var extra_index = $(this).attr('data-index'),
							extra = $(this).val(),
							extra_qty = parseInt($('#fdExtraQty_' + extra_index).val(), 10);
						
						if(extra != '' && extra_qty > 0)
						{
							var extra_price = parseFloat($('option:selected', this).attr('data-price'), 10);
							if(extra_price > 0)
							{
								total += extra_price * extra_qty;
							}
						}
					});
					
					$('.fdModifierItem_' + index).each(function() {
						if (this.checked) {
							var item_price = parseFloat($(this).attr('data-price'), 10);
							if(item_price > 0)
							{
								total += item_price;
							}
						}
					});
				}
				total_format = formatCurrency(total, myLabel.currency, '');
				$('#fdTotalPrice_' + index).html(total_format);
			});
			
		}
		
		function formatCurrency(price, currency, separator)
		{
			var format = '---';
			switch (currency)
			{
				case 'USD':
					format = "$" + separator + price.toFixed(2);
					break;
				case 'GBP':
					format = "&pound;" + separator  + price.toFixed(2);
					break;
				case 'EUR':
					format = "&euro;" + separator  + price.toFixed(2);
					break;
				case 'JPY':
					format = "&yen;" + separator  + price.toFixed(2);
					break;
				case 'AUD':
				case 'CAD':
				case 'NZD':
				case 'CHF':
				case 'HKD':
				case 'SGD':
				case 'SEK':
				case 'DKK':
				case 'PLN':
					format = price.toFixed(2) + separator  + currency;
					break;
				case 'NOK':
				case 'HUF':
				case 'CZK':
				case 'ILS':
				case 'MXN':
					format = currency + separator  + price.toFixed(2);
					break;
				default:
					format = price.toFixed(2) + separator  + currency;
					break;
			}
			return format;
		}
	});
})(jQuery_1_8_2);